/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.mcontrol.MobFilterSort;
import kd.bos.filter.mcontrol.MobSortColumn;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobFilterSortInitEvent
extends EventObject {
    private static final long serialVersionUID = 8955285317453656778L;
    transient List<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
    transient List<MobSortColumn> sortColumns = new ArrayList<MobSortColumn>();
    private HashMap<String, List<FilterColumn>> innerFilterColumnMap = new HashMap();
    private HashMap<String, List<MobSortColumn>> innerMobSortColumnMap = new HashMap();
    private transient MobFilterSort mobFilterSort;

    public MobFilterSortInitEvent(Object source) {
        super(source);
    }

    public MobFilterSortInitEvent(Object source, List<FilterColumn> filterColumns, List<MobSortColumn> sortColumns) {
        super(source);
        this.mobFilterSort = (MobFilterSort)source;
        for (FilterColumn filterColumn : filterColumns) {
            this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        }
        for (MobSortColumn mobSortColumn : sortColumns) {
            this.putInnerMobSortColumn(mobSortColumn.getFieldName(), mobSortColumn);
        }
    }

    public List<FilterColumn> getFilterColumns() {
        return this.filterColumns;
    }

    public List<MobSortColumn> getSortColumns() {
        return this.sortColumns;
    }

    public FilterColumn getFilterColumn(String fieldName) {
        List<FilterColumn> innerFilterColumns = this.innerFilterColumnMap.get(fieldName);
        if (innerFilterColumns != null && !innerFilterColumns.isEmpty()) {
            return innerFilterColumns.get(0);
        }
        return null;
    }

    public List<FilterColumn> getFilterColumns(String fieldName) {
        return this.innerFilterColumnMap.get(fieldName);
    }

    private void putInnerFilterColumn(String fieldName, FilterColumn filterColumn) {
        List<FilterColumn> innerFilterColumns;
        if (this.innerFilterColumnMap.get(fieldName) == null) {
            innerFilterColumns = new ArrayList<FilterColumn>();
            innerFilterColumns.add(filterColumn);
        } else {
            innerFilterColumns = this.innerFilterColumnMap.get(fieldName);
        }
        this.innerFilterColumnMap.put(fieldName, innerFilterColumns);
    }

    private void putInnerMobSortColumn(String fieldName, MobSortColumn mobSortColumn) {
        List<MobSortColumn> innerMobSortColumns;
        if (this.innerMobSortColumnMap.get(fieldName) == null) {
            innerMobSortColumns = new ArrayList<MobSortColumn>();
            innerMobSortColumns.add(mobSortColumn);
        } else {
            innerMobSortColumns = this.innerMobSortColumnMap.get(fieldName);
        }
        this.innerMobSortColumnMap.put(fieldName, innerMobSortColumns);
    }

    public void addFilterColumn(FilterColumn filterColumn) {
        this.putInnerFilterColumn(filterColumn.getFieldName(), filterColumn);
        this.filterColumns.add(filterColumn);
        this.mobFilterSort.getItems().add(filterColumn);
        filterColumn.setParentViewKey(this.mobFilterSort.getKey());
        filterColumn.setView(this.mobFilterSort.getView());
        if (filterColumn.getEntityType() == null) {
            filterColumn.setEntityType(this.mobFilterSort.getEntityType());
        }
        filterColumn.setContext(this.mobFilterSort.getContext());
        filterColumn.initProperties();
    }

    public void addSortColumn(MobSortColumn mobSortColumn) {
        this.putInnerMobSortColumn(mobSortColumn.getFieldName(), mobSortColumn);
        this.sortColumns.add(mobSortColumn);
        this.mobFilterSort.getItems().add(mobSortColumn);
        mobSortColumn.setView(this.mobFilterSort.getView());
        if (mobSortColumn.getEntityType() == null) {
            mobSortColumn.setEntityType(this.mobFilterSort.getEntityType());
        }
        mobSortColumn.setContext(this.mobFilterSort.getContext());
        mobSortColumn.initProperties();
    }
}

