/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ListVisible;
import kd.bos.form.TotalType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.MergeListColumn;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BeforeCreateListColumnsArgs
extends EventObject {
    private static final long serialVersionUID = 1L;
    transient List<IListColumn> listColumns;
    transient List<ListColumnGroup> listGroupColumns;
    transient Map<String, IListColumn> listColumnsMap = new HashMap<String, IListColumn>();
    transient List<MergeListColumn> mergeListColumns = new ArrayList<MergeListColumn>();
    transient List<DynamicTextListColumn> dynamicTextListColumns = new ArrayList<DynamicTextListColumn>();
    transient Set<String> editableColumnKeys = new HashSet<String>();
    transient String totalType;

    public BeforeCreateListColumnsArgs(Object source) {
        super(source);
    }

    public BeforeCreateListColumnsArgs(Object source, List<IListColumn> listColumns) {
        super(source);
        this.listColumns = listColumns;
    }

    @KSMethod
    public List<IListColumn> getListColumns() {
        return this.listColumns;
    }

    @KSMethod
    public void setListColumns(List<IListColumn> listColumns) {
        this.listColumns = listColumns;
    }

    @KSMethod
    public List<ListColumnGroup> getListGroupColumns() {
        return this.listGroupColumns;
    }

    @KSMethod
    public void setListGroupColumns(List<ListColumnGroup> listGroupColumns) {
        this.listGroupColumns = listGroupColumns;
    }

    public BeforeCreateListColumnsArgs(Object source, List<IListColumn> listColumns, List<ListColumnGroup> listGroupColumns) {
        super(source);
        this.listColumns = listColumns;
        this.listGroupColumns = listGroupColumns;
        this.initInnerColumnsMap();
    }

    private void addColumn(IListColumn listColumn) {
        if (listColumn instanceof MergeListColumn) {
            this.mergeListColumns.add((MergeListColumn)listColumn);
        } else if (listColumn instanceof DynamicTextListColumn) {
            this.dynamicTextListColumns.add((DynamicTextListColumn)listColumn);
        } else if (StringUtils.isNotEmpty((CharSequence)listColumn.getListFieldKey())) {
            this.listColumnsMap.put(listColumn.getListFieldKey(), listColumn);
        }
    }

    private void initInnerColumnsMap() {
        for (IListColumn listColumn : this.listColumns) {
            this.addColumn(listColumn);
        }
    }

    @KSMethod
    public List<MergeListColumn> getMergeListColumns() {
        return this.mergeListColumns;
    }

    @KSMethod
    public List<DynamicTextListColumn> getDynamicTextListColumns() {
        return this.dynamicTextListColumns;
    }

    @KSMethod
    public IListColumn getListColumn(String fieldName) {
        return this.listColumnsMap.get(fieldName);
    }

    @KSMethod
    public void addListColumn(IListColumn listColumn) {
        this.addColumn(listColumn);
        if (listColumn instanceof ListColumn && StringUtils.isNotEmpty((CharSequence)listColumn.getListFieldKey()) && StringUtils.isNotBlank((CharSequence)listColumn.getParentViewKey())) {
            for (ListColumnGroup listColumnGroup : this.listGroupColumns) {
                if (!listColumn.getParentViewKey().equals(listColumnGroup.getKey())) continue;
                listColumnGroup.getItems().add((Control)listColumn);
                listColumn.setParent((Container)listColumnGroup);
            }
        }
        this.listColumns.add(listColumn);
    }

    @KSMethod
    public void addListColumnGroup(String key, LocaleString name, String parentViewKey) {
        ListColumnGroup listColumnGroup = new ListColumnGroup();
        listColumnGroup.setKey(key);
        listColumnGroup.setName(name);
        this.addListColumnGroup(listColumnGroup);
    }

    @KSMethod
    public void addListColumnGroup(ListColumnGroup listColumnGroup) {
        listColumnGroup.setVisible(ListVisible.DEFAULT.getVisible() | ListVisible.INIT.getVisible() | ListVisible.LOOKUP.getVisible());
        this.listGroupColumns.add(listColumnGroup);
    }

    public Set<String> getEditableColumnKeys() {
        return this.editableColumnKeys;
    }

    public void addEditableColumnKey(String ... editableColumnKey) {
        this.editableColumnKeys.addAll(Arrays.asList(editableColumnKey));
    }

    public String getTotalType() {
        return this.totalType;
    }

    public void setTotalType(String totalType) {
        TotalType totalTypeEnum = TotalType.createTotalType((String)totalType);
        if (totalTypeEnum != null) {
            this.totalType = totalTypeEnum.getValue();
        }
    }
}

