/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.FormatFieldData;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.field.format.FieldFormatContext;
import kd.bos.form.field.format.FieldFormatResult;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.column.ListTemplateTextColumnDesc;
import kd.bos.list.column.TemplateTextItem;
import kd.bos.permission.api.FieldControlRule;

public class FieldFormatHandler {
    FieldFormatContext formatContext;
    private static final String FORMAT = "%s:%s";
    Map<String, FlexValueFormatter> flexFormaterMap = new HashMap<String, FlexValueFormatter>();
    EntityType entityType;

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public FieldFormatHandler(FieldFormatContext formatContext) {
        this.formatContext = formatContext;
    }

    /*
     * WARNING - void declaration
     */
    public FieldFormatResult formatRow(DynamicObject dr, AbstractColumnDesc col, FieldControlRule fieldControlRule, List<Object> row) {
        void var9_19;
        ArrayList<OperationColItem> exportValueDesc;
        col.setFormaType(0);
        Object value = col.getValue(dr);
        if (col instanceof TimeColumnDesc && !this.isForExport() && !(value instanceof Object[])) {
            col.getFormatParams().put("columntype", "listcolumn");
            value = col.getValue(dr);
        }
        if (this.isForExport()) {
            col.setFormaType(2);
            exportValueDesc = col.getValue(dr);
        } else {
            exportValueDesc = value;
        }
        if (col instanceof FlexColumnDesc) {
            void var9_11;
            FlexColumnDesc flexColumnDesc = (FlexColumnDesc)col;
            String flexColName = flexColumnDesc.getFieldProp().getName();
            FlexValueFormatter flexValueFormatter = this.flexFormaterMap.get(flexColName);
            if (flexValueFormatter == null) {
                FlexValueFormatter flexValueFormatter2 = new FlexValueFormatter(this.formatContext, flexColName);
                this.flexFormaterMap.put(flexColName, flexValueFormatter2);
            }
            value = this.isForQing() ? FlexValueFormatUtils.getQingValue((DynamicObject)dr, (FlexProp)((FlexProp)flexColumnDesc.getFieldProp()), (String)flexColumnDesc.getBasePropKey()) : var9_11.getListDisplayValue(dr, (FlexProp)flexColumnDesc.getFieldProp(), flexColumnDesc.getBasePropKey());
        } else if (col instanceof ListOperationColumnDesc) {
            ArrayList<OperationColItem> operationColItems = new ArrayList<OperationColItem>(10);
            for (OperationColItem operationColItem : ((ListOperationColumnDesc)col).getItems()) {
                OperationColItem newOperationColItem = new OperationColItem(operationColItem);
                operationColItems.add(newOperationColItem);
            }
            value = operationColItems;
        } else if (col instanceof ListTemplateTextColumnDesc) {
            TemplateTextItem templateTextItem = ((ListTemplateTextColumnDesc)col).getTemplateTextItem();
            value = templateTextItem;
        }
        Map keyMap = this.formatContext.getKeyFields();
        if (fieldControlRule != null && !keyMap.containsKey(col.getFieldKey()) && (this.isContainFieldKey(fieldControlRule.getCanNotReadFields(), col.getFieldKey()) || this.isContainFieldKey(fieldControlRule.getCanNotReadFields(), this.getRealFieldKey(col)))) {
            if (value instanceof Object[]) {
                Object[] val = value;
                val[1] = "******";
                val[0] = "******";
                value = val;
            } else {
                value = "******";
            }
        }
        PackageDataEvent packageDataEvent = new PackageDataEvent((Object)col, dr, value);
        for (Consumer consumer : this.formatContext.getPackageDataListeners()) {
            consumer.accept(packageDataEvent);
        }
        if (packageDataEvent.isCancel()) {
            return new FieldFormatResult(null, true);
        }
        Object var9_15 = null;
        if (col instanceof ListOperationColumnDesc) {
            List items = (List)value;
            Object bindingOperationColItems = ((ListOperationColumnDesc)col).getBindingOperationColItems(items);
            row.add(bindingOperationColItems);
        } else if (col instanceof ListTemplateTextColumnDesc) {
            String text = null;
            TemplateTextItem templateTextItem = (TemplateTextItem)packageDataEvent.getFormatValue();
            if (templateTextItem != null) {
                String tem = templateTextItem.getTem();
                List<Map<String, Object>> data = templateTextItem.getData();
                text = FieldFormatHandler.render(tem, data);
            }
            row.add(packageDataEvent.getFormatValue());
            if (this.isForExport()) {
                FormatFieldData formatFieldData = new FormatFieldData(col.getFieldKey(), (Object)text);
                formatFieldData.setFieldValueDesc(exportValueDesc);
            }
        } else {
            row.add(packageDataEvent.getFormatValue());
            if (this.isForExport()) {
                FormatFieldData formatFieldData = new FormatFieldData(col.getFieldKey(), packageDataEvent.getFormatValue());
                formatFieldData.setFieldValueDesc(exportValueDesc);
            }
        }
        FieldFormatResult result = new FieldFormatResult((FormatFieldData)var9_19, false);
        result.setNoLinkKey(packageDataEvent.getNoLinkKey());
        return result;
    }

    private boolean isContainFieldKey(Set<String> set, String fieldKey) {
        for (String s : set) {
            if (!s.equalsIgnoreCase(fieldKey)) continue;
            return true;
        }
        return false;
    }

    private boolean isForExport() {
        return this.formatContext.isForExport();
    }

    private boolean isForQing() {
        return this.formatContext.isForQing();
    }

    private static String render(String template, List<Map<String, Object>> data) {
        String regex = "\\#\\{(.+?)\\}";
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        if (data == null || data.size() == 0) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(template);
        block0: while (matcher.find()) {
            String name = matcher.group(1);
            for (Map<String, Object> map : data) {
                String key = (String)map.get("key");
                if (!name.equals(key)) continue;
                String value = map.get("text") + "";
                matcher.appendReplacement(sb, value);
                continue block0;
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String getRealFieldKey(AbstractColumnDesc desc) {
        String fieldKey = desc.getFieldKey();
        if (this.entityType instanceof QueryEntityType) {
            QueryEntityType qet = (QueryEntityType)this.entityType;
            String[] fieldStr = fieldKey.split("\\.");
            if (fieldStr.length == 1) {
                return fieldStr[0];
            }
            List entitys = qet.getJoinEntitys();
            if (!this.isSubEntityField(entitys, fieldStr[0])) {
                if (fieldStr.length >= 3) {
                    return fieldStr[0] + "." + fieldStr[1];
                }
                return fieldStr[0];
            }
            if (fieldStr.length >= 4) {
                return fieldStr[0] + "." + fieldStr[1] + "." + fieldStr[2];
            }
            return fieldStr[0] + "." + fieldStr[1];
        }
        StringTokenizer tokens = new StringTokenizer(fieldKey, "\\.");
        return tokens.nextToken();
    }

    private boolean isSubEntityField(List<JoinEntity> entitys, String entityNumber) {
        for (JoinEntity entity : entitys) {
            if (!entityNumber.equals(entity.getEntityName()) && !entityNumber.equals(entity.getAlias())) continue;
            return true;
        }
        return false;
    }
}

