/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.func;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.func.IFuncParamEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class FunctionSettingPlug
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String Key_TreeViewFuncs = "tvfunctions";
    private static final String Key_FSParameter = "fs_parameter";
    private static final String Key_LableFuncName = "lblfuncname";
    private static final String Key_LableFuncDesc = "lblfuncdesc";
    private static final String Key_LableReturnType = "lblreturntype";
    private static final String Key_LableFuncParam = "lblfuncparam";
    private static final String Key_TxtFuncDesc = "funcdesc";
    private static final String Key_btnOK = "btnok";
    private static final String Key_SearchFunc = "searchfunc";
    private static final String Pre_GroupNode = "grup.";
    private static final String Pre_FuncNode = "func.";
    private static final String CacheKey_ChildPageId = "childpageid";
    private static final String CacheKey_FuncName = "funcname";
    private static final String CacheKey_FuncList = "funclist";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String APPCACHE_PARAMSETTING = "bos_function_paramsetting";
    private List<TreeNode> funcList;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeViewFuncs);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(Key_SearchFunc);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initFuncsTree();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((Label)this.getView().getControl(Key_LableFuncName)).setText(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570", (String)"FunctionSettingPlug_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        ((Label)this.getView().getControl(Key_LableFuncDesc)).setText("");
        ((Label)this.getView().getControl(Key_LableReturnType)).setText("");
        ((Label)this.getView().getControl(Key_LableFuncParam)).setText("");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)Key_btnOK, (CharSequence)source.getKey())) {
            this.returnDataToParent();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = String.valueOf(evt.getNodeId());
        if (!nodeId.startsWith(Pre_FuncNode)) {
            return;
        }
        String funcName = nodeId.substring(Pre_FuncNode.length());
        if (StringUtils.equals((CharSequence)funcName, (CharSequence)this.getPageCache().get(CacheKey_FuncName))) {
            return;
        }
        this.showFuncParameterPage(funcName);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)APPCACHE_PARAMSETTING)) {
            FormViewPluginProxy plugInProxy;
            IFuncParamEditor paramEditor = null;
            String funcSetting = "";
            String childPageId = e.getEventArgs();
            IFormView childView = null;
            if (StringUtils.isNotBlank((CharSequence)childPageId) && (childView = this.getView().getView(childPageId)) != null && (plugInProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class)) != null) {
                for (IFormPlugin plugin : plugInProxy.getPlugIns()) {
                    if (!(plugin instanceof IFuncParamEditor)) continue;
                    paramEditor = (IFuncParamEditor)plugin;
                    break;
                }
            }
            if (paramEditor != null) {
                HashMap<String, String> result = new HashMap<String, String>(3);
                StringBuilder sBuilder = new StringBuilder();
                if (!paramEditor.checkSetting(sBuilder).booleanValue()) {
                    result.put("msg", sBuilder.toString());
                } else {
                    result.put("setting", paramEditor.getSetting());
                }
                AppCache.get((String)"bos").put(this.buildAppCacheKey_Param(childPageId), (Object)SerializationUtils.toJsonString(result));
            }
        }
    }

    private String buildAppCacheKey_Param(String childPageId) {
        return "bos_function_paramsetting." + childPageId;
    }

    private void fireCustomEvent(String childPageId) {
        IFormView childView = this.getView().getViewNoPlugin(childPageId);
        if (childView == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("methodName", "customEvent");
        ArrayList<String> args = new ArrayList<String>(3);
        args.add("");
        args.add(APPCACHE_PARAMSETTING);
        args.add(childPageId);
        params.put("args", args);
        ArrayList<HashMap<String, Object>> paramsList = new ArrayList<HashMap<String, Object>>(1);
        paramsList.add(params);
        String paramsStr = SerializationUtils.toJsonString(paramsList);
        String appId = childView.getFormShowParameter().getServiceAppId();
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        service.invoke("kd.bos.service.ServiceFactory", "FormService", "batchInvokeAction", new Object[]{this.getView().getPageId(), paramsStr});
    }

    private void returnDataToParent() {
        String funcName = this.getPageCache().get(CacheKey_FuncName);
        if (StringUtils.isBlank((CharSequence)funcName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570\u3002", (String)"FunctionSettingPlug_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        String funcSetting = "";
        String childPageId = this.getPageCache().get(CacheKey_ChildPageId);
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            this.fireCustomEvent(childPageId);
            String cacheKey = this.buildAppCacheKey_Param(childPageId);
            IAppCache appCache = AppCache.get((String)"bos");
            String customEventResultStr = (String)appCache.get(cacheKey, String.class);
            appCache.remove(cacheKey);
            if (StringUtils.isNotBlank((CharSequence)customEventResultStr)) {
                Map customEventResult = (Map)SerializationUtils.fromJsonString((String)customEventResultStr, Map.class);
                String msg = (String)customEventResult.get("msg");
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                String setting = (String)customEventResult.get("setting");
                if (StringUtils.isNotBlank((CharSequence)setting)) {
                    funcSetting = setting;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)funcSetting)) {
            FunctionTypes functionTypes = this.getFunctionTypes();
            FunctionType functionType = null;
            for (FunctionType item : functionTypes.getFunctionTypes()) {
                if (!StringUtils.equals((CharSequence)funcName, (CharSequence)item.getId())) continue;
                functionType = item;
                break;
            }
            if (functionType != null) {
                funcSetting = functionType.getDef();
            }
        }
        this.getView().returnDataToParent((Object)funcSetting);
        this.getView().close();
    }

    private void initFuncsTree() {
        String rootId = "root";
        TreeNode root = new TreeNode();
        root.setId(rootId);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8\u51fd\u6570 ", (String)"FunctionSettingPlug_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        LinkedHashMap<String, TreeNode> funcGroups = new LinkedHashMap<String, TreeNode>(16);
        FunctionTypes functionTypes = this.getFunctionTypes();
        functionTypes.getFunctionGroups().sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        for (FunctionGroup funcGroup : functionTypes.getFunctionGroups()) {
            if (!funcGroup.isVisible()) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(Pre_GroupNode + funcGroup.getId());
            treeNode.setText(funcGroup.getName().toString());
            treeNode.setIsOpened(true);
            treeNode.setChildren(new ArrayList());
            treeNode.setParentid(rootId);
            funcGroups.put(funcGroup.getId(), treeNode);
        }
        functionTypes.getFunctionTypes().sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        for (Object funcType : functionTypes.getFunctionTypes()) {
            if (StringUtils.isBlank((CharSequence)funcType.getGroupId()) || !funcGroups.containsKey(funcType.getGroupId())) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(Pre_FuncNode + funcType.getId());
            treeNode.setText(funcType.getName().toString());
            ((TreeNode)funcGroups.get(funcType.getGroupId())).addChild(treeNode);
        }
        ArrayList<TreeNode> funcList = new ArrayList<TreeNode>(16);
        for (Map.Entry entry : funcGroups.entrySet()) {
            if (((TreeNode)entry.getValue()).getChildren().size() <= 0) continue;
            root.addChild((TreeNode)entry.getValue());
            funcList.addAll(((TreeNode)entry.getValue()).getChildren());
        }
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeViewFuncs);
        tree.addNode(root);
        tree.setRootVisible(false);
        this.setFuncList(funcList);
    }

    private void showFuncParameterPage(String funcName) {
        String childPageId = this.getPageCache().get(CacheKey_ChildPageId);
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            IFormView childView = this.getView().getViewNoPlugin(childPageId);
            if (childView != null) {
                childView.close();
                this.getView().sendFormAction(childView);
            }
            this.getPageCache().remove(CacheKey_ChildPageId);
        }
        FunctionTypes functionTypes = this.getFunctionTypes();
        FunctionType functionType = null;
        for (FunctionType item : functionTypes.getFunctionTypes()) {
            if (!StringUtils.equals((CharSequence)funcName, (CharSequence)item.getId())) continue;
            functionType = item;
            break;
        }
        if (functionType != null) {
            ((Label)this.getView().getControl(Key_LableFuncName)).setText(functionType.getDef());
            ((Label)this.getView().getControl(Key_LableFuncDesc)).setText(functionType.getDesc().getLocaleValue());
            if (this.getModel().getProperty(Key_TxtFuncDesc) != null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_LableFuncDesc});
                this.getModel().setValue(Key_TxtFuncDesc, (Object)this.addNewLine(functionType.getDesc().getLocaleValue()));
            }
            ((Label)this.getView().getControl(Key_LableReturnType)).setText(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a%s", (String)"FunctionSettingPlug_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), functionType.getReturnType()));
            if (StringUtils.isBlank((CharSequence)functionType.getSettingFormId())) {
                ((Label)this.getView().getControl(Key_LableFuncParam)).setText(ResManager.loadKDString((String)"\u51fd\u6570\u53c2\u6570\uff1a\u65e0", (String)"FunctionSettingPlug_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(functionType.getSettingFormId());
                showParameter.setShowTitle(false);
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(Key_FSParameter);
                StyleCss css = new StyleCss();
                css.setWidth("450");
                css.setHeight("210");
                showParameter.getOpenStyle().setInlineStyleCss(css);
                showParameter.getCustomParams().put("funcid", funcName);
                showParameter.setCustomParam("entityItems", this.getView().getFormShowParameter().getCustomParam("entityItems"));
                showParameter.setCustomParam("entitynumber", this.getView().getFormShowParameter().getCustomParam("entitynumber"));
                this.getView().showForm(showParameter);
                this.getPageCache().put(CacheKey_ChildPageId, showParameter.getPageId());
                ((Label)this.getView().getControl(Key_LableFuncParam)).setText(ResManager.loadKDString((String)"\u51fd\u6570\u53c2\u6570\uff1a", (String)"FunctionSettingPlug_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            }
        }
        this.getPageCache().put(CacheKey_FuncName, funcName);
    }

    private String addNewLine(String desc) {
        ArrayList<String> descLines = new ArrayList<String>(10);
        String temp = desc;
        int index = temp.indexOf("\\n");
        while (index > 0) {
            descLines.add(temp.substring(0, index));
            temp = index < temp.length() - 2 ? temp.substring(index + 2) : "";
            index = temp.indexOf("\\n");
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            descLines.add(temp);
        }
        return StringUtils.join((Object[])descLines.toArray(), (char)'\n');
    }

    private FunctionTypes getFunctionTypes() {
        String xmlFuncs = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isNotBlank((CharSequence)xmlFuncs)) {
            FunctionTypes functionTypes = FunctionTypes.get((String)xmlFuncs);
            return functionTypes;
        }
        return FunctionTypes.get();
    }

    private List<TreeNode> getFuncList() {
        if (this.funcList != null) {
            return this.funcList;
        }
        String strFuncList = this.getPageCache().get(CacheKey_FuncList);
        if (StringUtils.isBlank((CharSequence)strFuncList)) {
            return new ArrayList<TreeNode>(0);
        }
        this.funcList = SerializationUtils.fromJsonStringToList((String)strFuncList, TreeNode.class);
        return this.funcList;
    }

    private void setFuncList(List<TreeNode> funcList) {
        String strFuncList = SerializationUtils.toJsonString(funcList);
        this.getPageCache().put(CacheKey_FuncList, strFuncList);
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchFunc, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchFunc, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }

    private List<String> doSearchList(String searchText) {
        List<TreeNode> funcList = this.getFuncList();
        ArrayList<String> searchList = new ArrayList<String>(4);
        for (TreeNode node : funcList) {
            if (!this.contains(node.getId(), searchText)) continue;
            searchList.add(node.getId().substring(Pre_FuncNode.length()));
        }
        for (TreeNode node : funcList) {
            if (!this.contains(node.getText(), searchText)) continue;
            searchList.add(node.getText());
        }
        return searchList;
    }

    private void doSearch(String searchText) {
        int i;
        TreeNode node2;
        List<TreeNode> funcList = this.getFuncList();
        TreeView treeView = (TreeView)this.getView().getControl(Key_TreeViewFuncs);
        String currFunc = treeView.getTreeState().getFocusNodeId();
        int beginIndex = 0;
        if (currFunc != null) {
            if (StringUtils.equals((CharSequence)"root", (CharSequence)currFunc)) {
                beginIndex = 0;
            } else {
                for (TreeNode node2 : funcList) {
                    ++beginIndex;
                    if (!StringUtils.equals((CharSequence)node2.getParentid(), (CharSequence)currFunc) && !StringUtils.equals((CharSequence)node2.getId(), (CharSequence)currFunc)) continue;
                    break;
                }
            }
        }
        for (i = beginIndex; i < funcList.size(); ++i) {
            node2 = funcList.get(i);
            if (!this.isSearchNode(node2, searchText)) continue;
            treeView.focusNode(node2);
            treeView.treeNodeClick(null, node2.getId());
            return;
        }
        for (i = 0; i < beginIndex; ++i) {
            node2 = funcList.get(i);
            if (!this.isSearchNode(node2, searchText)) continue;
            treeView.focusNode(node2);
            treeView.treeNodeClick(null, node2.getId());
            return;
        }
    }

    private boolean isSearchNode(TreeNode node, String searchText) {
        if (this.contains(node.getId().substring(Pre_FuncNode.length()), searchText)) {
            return true;
        }
        return this.contains(node.getText(), searchText);
    }

    private boolean contains(String str, String find) {
        if (str == null || find == null) {
            return false;
        }
        String str_lower = str.toLowerCase();
        String find_lower = find.toLowerCase();
        return str_lower.contains(find_lower);
    }
}

