/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IMobileBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.YzjShareDataModel;
import kd.bos.entity.datamodel.YzjSocialShareDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.MapUtils;

@SdkPublic
public class YzjContextMenuClickPlugin
extends AbstractFormPlugin
implements IFormPlugin {
    private static final String GROUP_NAME = "groupName";
    private static final String BUSINESS_TYPE = "businessType";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CELL_CONTENT = "cellContent";
    private static final String CALL_BACK_URL = "callBackUrl";
    private static final String THUMB_DATA = "thumbData";
    private static final String SHARE_TYPE = "shareType";
    private static final String APP_NAME = "appName";
    private static final String LIGHT_APP_ID = "lightAppId";
    private static final String SHARED_OBJECT = "sharedObject";
    private static final String SELECTED = "selected";
    private static final String YZJ_GROUP_ID = "yzjGroupId";
    private static final String PKID = " pkid=";
    private static final String WEBPAGE_URL = "webpageUrl";
    private static final String APP_ID = "appId";
    private static final String FORMID = " formid=";
    private static final String YZJ_SHARE_DATA = "yzjShareData";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String YZJ_CONTEXT_MENU_CLICK_PLUGIN_2 = "YzjContextMenuClickPlugin_2";
    private static final String YZJ_CONTEXT_MENU_CLICK_PLUGIN_1 = "YzjContextMenuClickPlugin_1";
    private static final String KD_BOS_LOGIN_YUNZHIJIA_YUNZHIJIA_UTILS = "kd.bos.login.yunzhijia.YunzhijiaUtils";
    private static final String USER_NAME = "userName";
    private static final String GROUP_ID = "groupId";
    private static final String BUSINESS_KEY = "businessKey";
    private static final String ASSIGN_GROUP_OWNER = "assignGroupOwner";
    private static final String OPEN_ID = "openId";
    private static final String DRAFT = "draft";
    private static final String YZJ_SOCIAL_SHARE_DATA = "yzjSocialShareData";
    private static final String SHARE_WAY = "shareWay";
    private static final String DESCRIPTION = "description";
    private static final String SHARE_CONTENT = "shareContent";
    private static Log log = LogFactory.getLog(YzjContextMenuClickPlugin.class);
    private static String shareType = "4";
    private String appId = System.getProperty("YZJAppID");
    private String appName = System.getProperty("YZJAppName");
    private String lightAppId = this.appId;
    private static String thumbData = "iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MDBDQjBDRTUwOTk2MTFFNUEwRDQ4MDhFOTkyODQ4RkIiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MDBDQjBDRTYwOTk2MTFFNUEwRDQ4MDhFOTkyODQ4RkIiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDowMENCMENFMzA5OTYxMUU1QTBENDgwOEU5OTI4NDhGQiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDowMENCMENFNDA5OTYxMUU1QTBENDgwOEU5OTI4NDhGQiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PhU99ZkAAAYBSURBVHja7FtpbFRVFP46FSildKMLbVlsCy0BREpKqAXFpSBWjWBCiNG4RFxjosaoVeKSGKv+MGiUPwLRGI0JGlzQRptiJUaFVKAIlZYihdrSBULbKV3oNp7j7TjvDtPp4hvm8Xq+5Dbv3vfmzpvz3fOdc5eGuFwuoCh1LoA3qeRRiYQgkHBSKaFSgPya6hDXd1dmUmUvlWixzSVFK5UcB/0pFOMHBWzzQseg7AiCg9UO0fygIsIhNgguhAAhQAgQCAFCgEAIEAIEQoAQIBAChACBECAECIQAIUAgBAgBAiFACBAIAUKAQAiwJ64ISK+Jq4HUB4GoRUBo2OVrnf5uoO0wULMNaCoOyFfw2VCXqT1mPg+kP2q/oVqzFThaaHEJSsyzp/EZqQ8pz7Y0Aakb7S3YAfh95hLAmm9nRC+yOAGhk22eM06SNFTSUH8oShWLigcIAQIhQAgQBCUI59fY32ImJxriASJBQoBACJAgPP7gGgDO7QPOlAItB4HOU0DPOWrvJ6tMBcJnApHzgbjlQMIqapsiBJiCgV7g78+AE1uBrjrfz/S1A84/Van7Qi0yzlgPpD9m+uuYuyNm9TS0lUb6H88C5/8a2+dDw4H+TvGAMaH2U6DiVZKYvrH3YbLxxw8BJz4AKt/w4f+Ug8QuI43PI63PJd2freSGN+O7asljyoHGHyhO/KRiRgBgfwk6vQsof5Kjrt6ecCMw7wUgYs7wfbQfA6reApp/lDR0VODM5nCBbvwQcvqFrwPZ20dmfMbUDPX84s2m74rZW4IqXtZ1OyQUWLJFP93AWVHDLnXux1kJ9LaoNDQiQ53ySFnn2WpNXgtMjAf2b1QyJRLkBy2/A7+t19tYctIe9tTP/gwceUl5ylCYlADMJyKTbjXI2tcka0+JBPnFyY/0etwK3fh1O4CyB/wbn3GhGTj4hJo3uJF8h06IEOCdLnaRpJQYHZ1Gf4HBO/ZTbHhRzXpHCs6imnd76pnPKUkTAnzJzwHS9gueeswSIHKBew2CYsMruvE5sM4lSVlZCqypAq7fA2Q8oyZenrULJVfufsNnUSZ1w2UQhH+lwNV6SF1HLwZyvxxsX6fybL/tV1P7V6P/TmeFXk9c5bk+s0e/75gILPuESMr2tLFx55DsxK8E9m5QHsXobgDq6X1mbhjs92YvT7OiB7iN/+91+SivD43tO7vq9Xp0lue6uVS/l/aIbnwjoq4iz3habzPOBXiAiAT5QK9Tr09ONswNTur3Utb67yv5tovnFv/1O8NiBPhaKzGOrpFcxy713T4ahHpNloyTp74O/V7YdP99hSXpdePnTTiKaW4MYPmYlqu3XfO572eHas/Z8f/fY0KUl0e0UT4fP5jXx+n3uhuBKWlD98W6b8TE2KE9LegeULPdGhIUka7XjcvP3ie464cJ8qe/9YoLhs931lqMAA5Q1e8GnwBv6Wop81xPX6NWQd3glVKeNftC2xH6PZv1tqRbfPdrmSBc/Q7NMO+jaf4vprjomMCSYvQCXhF15/18L+l2w1oQ5fX77lHv3UEBeqBHBdrj7+kpKGNaji6xDUUWWwuyMnglM3kw4+G9X55vjEZCWPtzd6o9A3e84z4kDR0hqt5Wo9ttzKUfeow5rPFjgOxtnufZm46+JmtBo0L8tfRrJ+gytfwbYPa9erumD2SelDuBFUX6ZO74+2q5wwSMDwmadTewkEdsiO/7LEmcQPD/BPecpTSWPCRyHpBw08XzhFMfq71luISAkRn/LrUDZjQ+B16WEW2xbRjwxg1vS5qcatt7R4wnZAu8Rj7P1nkfgDMeXnDj8z7+/pufiWr8HjhGMaTD/A0ne3sA7/9eV0x6n+pZRii7X8/7efuRpSYmSwVZrvO2ZHcT4KR5QNNutSkTqFe0vQTxEcOsLWop4sDj6nCWlcbIuJkHWBRyOloIEAIEQoAQIBAChACBECAECIQAIUAgBAgBAiFACBAIAUKAQAiwPwFOMUPQcJ4JKBE7BA3FTMAmKq1ii0sOtvkmB/JrKukih8pOKu1il4CjfdDWOWz7fwQYAACxsutLQS74AAAAAElFTkSuQmCC";
    private Map<String, Object> rtnArg = new HashMap<String, Object>();
    private String callBackUrl = "";
    private static String shareWay = "buluo";
    private static String socialShareType = "3";
    private static final String CHATTYPE = "chattype";

    private static String getYzjGroupId1() {
        StringBuilder sb = new StringBuilder();
        return sb.append("getShareDataFromPlugin.getShareDataFromPlugin: ").append(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5206\u4eab\uff1a\u5355\u51fb\u5206\u4eab\u63d2\u4ef6\u5206\u652f\u4e91\u4e4b\u5bb6yzjGroupId\uff1a", (String)"YzjContextMenuClickPlugin_16", (String)BOS_FORM_CORE, (Object[])new Object[0])).toString();
    }

    private static String getCallBackUrl1() {
        StringBuilder sb = new StringBuilder();
        return sb.append("getShareDataFromPlugin.getShareDataFromPlugin: ").append(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5206\u4eab\uff1a\u5355\u51fb\u8f7b\u5e94\u7528\u5206\u4eab\u63d2\u4ef6\u5206\u652fcallBackUrl\uff1a", (String)"YzjContextMenuClickPlugin_12", (String)BOS_FORM_CORE, (Object[])new Object[0])).toString();
    }

    private static String getWebpageUrl1() {
        StringBuilder sb = new StringBuilder();
        return sb.append("getShareDataFromPlugin.getShareDataFromPlugin: ").append(ResManager.loadKDString((String)"\u5355\u51fb\u8f7b\u5e94\u7528\u5206\u4eab\u63d2\u4ef6\u5206\u652fwebpageUrl\uff1a", (String)"YzjContextMenuClickPlugin_13", (String)BOS_FORM_CORE, (Object[])new Object[0])).toString();
    }

    private static String getBillNumber() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a[%s]\u7684\u5355\u636e", (String)"YzjContextMenuClickPlugin_14", (String)BOS_FORM_CORE, (Object[])new Object[0]);
    }

    private static String getWebpageUrl2() {
        StringBuilder sb = new StringBuilder();
        return sb.append("getSocialShareDataFromPlugin: ").append(ResManager.loadKDString((String)"\u5355\u51fb\u8f7b\u5e94\u7528\u5206\u4eab\u63d2\u4ef6\u5206\u652fwebpageUrl\uff1a", (String)"YzjContextMenuClickPlugin_15", (String)BOS_FORM_CORE, (Object[])new Object[0])).toString();
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        log.info("--------log\u4e91\u4e4b\u5bb6contextMenuClick.ItemKey\uff1a" + e.getItemKey());
        if (e.getItemKey().toLowerCase(Locale.ENGLISH).equals("chat")) {
            HashMap<String, Object> arg = new HashMap<String, Object>();
            try {
                this.sendChatData("chat", arg);
            }
            catch (InterruptedException e1) {
                log.error(e1.getMessage());
            }
        } else if (e.getItemKey().toLowerCase(Locale.ENGLISH).equals("socialShare")) {
            this.sendSocialShareData();
        } else if (e.getItemKey().toLowerCase(Locale.ENGLISH).equals("addCalendarEvent")) {
            this.sendSocialShareData();
        } else if (e.getItemKey().toLowerCase(Locale.ENGLISH).equals("share")) {
            this.sendShareData();
        }
    }

    private Map<String, Object> getShareDataFromPlugin(Map<String, Object> mShareData) {
        String content = "";
        String webpageUrl = "";
        String cellContent = "";
        String sharedObject = "";
        String yzjGroupId = "";
        String title = mShareData.get(TITLE).toString();
        List listSelected = new ArrayList();
        content = mShareData.get(CONTENT).toString();
        webpageUrl = mShareData.get(WEBPAGE_URL).toString();
        cellContent = mShareData.get(CELL_CONTENT).toString();
        sharedObject = mShareData.get(SHARED_OBJECT) == null ? "all" : mShareData.get(SHARED_OBJECT).toString();
        String formid = mShareData.get("formid").toString();
        String pkid = "";
        if (mShareData.get("pkid") != null) {
            pkid = mShareData.get("pkid").toString();
        }
        yzjGroupId = this.getGroupId(formid, pkid);
        String callBackUrl = "";
        if (mShareData.get(CALL_BACK_URL) != null) {
            callBackUrl = mShareData.get(CALL_BACK_URL).toString();
        }
        HashMap<String, Object> arg = new HashMap<String, Object>();
        String phtoto = "";
        if (mShareData.get(THUMB_DATA) != null) {
            phtoto = mShareData.get(THUMB_DATA).toString();
        }
        arg.put(SHARE_TYPE, shareType);
        Object paramAppId = mShareData.get(APP_ID);
        if (StringUtils.isNotBlank((Object)paramAppId)) {
            this.appId = paramAppId.toString();
        }
        arg.put(APP_ID, this.appId);
        Object paramAppName = mShareData.get(APP_NAME);
        if (StringUtils.isNotBlank((Object)paramAppName)) {
            this.appName = paramAppName.toString();
        }
        arg.put(APP_NAME, this.appName);
        Object paramLightAppId = mShareData.get(LIGHT_APP_ID);
        if (StringUtils.isNotBlank((Object)paramLightAppId)) {
            this.lightAppId = paramLightAppId.toString();
        }
        if (StringUtils.isBlank((CharSequence)this.lightAppId)) {
            this.lightAppId = this.appId;
        }
        arg.put(LIGHT_APP_ID, this.lightAppId);
        arg.put(TITLE, title);
        arg.put(CONTENT, content);
        arg.put(THUMB_DATA, phtoto);
        if (mShareData.get(SELECTED) instanceof List) {
            log.info("getShareDataFromPlugin.getShareDataFromPlugin\uff1a\u5355\u51fb\u8f7b\u5e94\u7528\u5206\u4eab\u63d2\u4ef6\u5206\u652fselected\uff1a" + mShareData.get(SELECTED));
            listSelected = (List)mShareData.get(SELECTED);
            arg.put(SELECTED, listSelected);
        } else {
            arg.put(SELECTED, mShareData.get(SELECTED).toString());
        }
        arg.put(WEBPAGE_URL, webpageUrl);
        arg.put(CELL_CONTENT, cellContent);
        arg.put(SHARED_OBJECT, sharedObject);
        arg.put(CALL_BACK_URL, callBackUrl);
        arg.put(YZJ_GROUP_ID, yzjGroupId);
        if (mShareData.get("chat") == null) {
            arg.put("toChat", true);
        } else {
            arg.put("toChat", Boolean.parseBoolean(mShareData.get("chat").toString()));
        }
        log.info(YzjContextMenuClickPlugin.getYzjGroupId1() + yzjGroupId + FORMID + formid + PKID + pkid + " " + YzjContextMenuClickPlugin.getCallBackUrl1() + callBackUrl + " " + YzjContextMenuClickPlugin.getWebpageUrl1() + webpageUrl);
        return arg;
    }

    private Map<String, Object> getShareDataFromPlugin() {
        String content = "";
        String webpageUrl = "";
        String cellContent = "";
        String sharedObject = "";
        String yzjGroupId = "";
        List listSelected = new ArrayList();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String sYzjShareData = pageCache.get(YZJ_SHARE_DATA);
        YzjShareDataModel yzjShareDataModel = (YzjShareDataModel)SerializationUtils.fromJsonString((String)sYzjShareData, YzjShareDataModel.class);
        String title = yzjShareDataModel.getTitle();
        listSelected = yzjShareDataModel.getSelected();
        title = yzjShareDataModel.getTitle();
        content = yzjShareDataModel.getcontent();
        webpageUrl = yzjShareDataModel.getWebpageUrl();
        cellContent = yzjShareDataModel.getCellContent();
        sharedObject = "all";
        yzjGroupId = "";
        String formid = yzjShareDataModel.getFormid();
        String pkid = yzjShareDataModel.getPkId();
        yzjGroupId = this.getGroupId(formid, pkid);
        String callBackUrl = yzjShareDataModel.getCallBackUrl();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put(SHARE_TYPE, shareType);
        arg.put(APP_ID, this.appId);
        arg.put(APP_NAME, this.appName);
        arg.put(LIGHT_APP_ID, this.lightAppId);
        arg.put(TITLE, title);
        arg.put(CONTENT, content);
        arg.put(THUMB_DATA, thumbData);
        if (!StringUtils.isBlank(listSelected) && listSelected != null && listSelected.size() > 0) {
            arg.put(SELECTED, listSelected);
        }
        arg.put(WEBPAGE_URL, webpageUrl);
        arg.put(CELL_CONTENT, cellContent);
        arg.put(SHARED_OBJECT, sharedObject);
        arg.put(CALL_BACK_URL, callBackUrl);
        arg.put(YZJ_GROUP_ID, yzjGroupId);
        log.info(YzjContextMenuClickPlugin.getYzjGroupId1() + yzjGroupId + FORMID + formid + PKID + pkid + " " + YzjContextMenuClickPlugin.getCallBackUrl1() + callBackUrl + " " + YzjContextMenuClickPlugin.getWebpageUrl1() + webpageUrl);
        return arg;
    }

    private Map<String, Object> getShareDataGeneral() {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        String title = this.getView().getFormShowParameter().getFormConfig().getCaption().toString();
        String content = null;
        String webpageUrl = null;
        String cellContent = null;
        String sharedObject = null;
        String yzjGroupId = null;
        List listSelected = new ArrayList();
        String strSQL = "";
        strSQL = "SELECT FOpenid FROM (SELECT FOpenid FROM t_sec_user  ORDER BY FOpenid )WHERE ROWNUM <= 3  ORDER BY FOpenid ";
        Object[] params = new SqlParameter[0];
        if (params.length > 0) {
            listSelected = (List)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> list = new ArrayList<String>();
                    try {
                        if (rs.next()) {
                            list.add(rs.getString("FOpenId"));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return list;
                }
            });
            String billNoField = "";
            String billNo = "";
            if (model.getDataEntityType() instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)model.getDataEntityType();
                billNoField = billEntityType.getBillNo();
                billNo = (String)model.getValue(billNoField);
            }
            String formUrl = this.getShareUrl("", "");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                billNo = ResManager.loadKDString((String)"\u7a7a", (String)"YzjContextMenuClickPlugin_0", (String)BOS_FORM_CORE, (Object[])new Object[0]);
            }
            content = String.format(ResManager.loadKDString((String)YzjContextMenuClickPlugin.getBillNumber(), (String)YZJ_CONTEXT_MENU_CLICK_PLUGIN_1, (String)BOS_FORM_CORE, (Object[])new Object[0]), billNo);
            webpageUrl = formUrl;
            cellContent = String.format(ResManager.loadKDString((String)YzjContextMenuClickPlugin.getBillNumber(), (String)YZJ_CONTEXT_MENU_CLICK_PLUGIN_1, (String)BOS_FORM_CORE, (Object[])new Object[0]), billNo);
            sharedObject = "all";
            yzjGroupId = "";
            this.callBackUrl = this.getCallBackUrl();
            HashMap<String, Object> arg = new HashMap<String, Object>();
            arg.put(SHARE_TYPE, shareType);
            arg.put(APP_ID, this.appId);
            arg.put(APP_NAME, this.appName);
            arg.put(LIGHT_APP_ID, this.lightAppId);
            arg.put(TITLE, title);
            arg.put(CONTENT, content);
            arg.put(THUMB_DATA, thumbData);
            arg.put(SELECTED, listSelected);
            arg.put(WEBPAGE_URL, webpageUrl);
            arg.put(CELL_CONTENT, cellContent);
            arg.put(SHARED_OBJECT, sharedObject);
            arg.put(CALL_BACK_URL, this.callBackUrl);
            arg.put(YZJ_GROUP_ID, yzjGroupId);
            Date d1 = new Date();
            d1.getTime();
            log.info("Start requesting YZJ, start time: " + d1.toString() + " getShareDataGeneral\uff1aClick Light App to share the content URL of another branch:" + webpageUrl + " getShareDataFromPlugin.getShareDataFromPlugin\uff1aYZJ Sharing: Click the Light Application Sharing plug-in branch yzjGroupId: " + yzjGroupId + " " + YzjContextMenuClickPlugin.getCallBackUrl1() + this.callBackUrl);
            return arg;
        }
        return null;
    }

    private Map<String, Object> getShareDataOther() {
        String content = "";
        String webpageUrl = "";
        String cellContent = "";
        String sharedObject = "all";
        String formUrl = this.getShareUrl("", "");
        content = this.appName;
        cellContent = this.appName;
        String title = this.appName;
        this.callBackUrl = "";
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put(SHARE_TYPE, shareType);
        arg.put(APP_ID, this.appId);
        arg.put(APP_NAME, this.appName);
        arg.put(LIGHT_APP_ID, this.lightAppId);
        arg.put(TITLE, title);
        arg.put(CONTENT, content);
        arg.put(THUMB_DATA, "");
        arg.put(WEBPAGE_URL, formUrl);
        arg.put(CELL_CONTENT, cellContent);
        arg.put(SHARED_OBJECT, sharedObject);
        arg.put(CALL_BACK_URL, this.callBackUrl);
        arg.put(YZJ_GROUP_ID, "");
        return arg;
    }

    private String getShareUrl(String formid, String pkid) {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (formid == null || StringUtils.isBlank((CharSequence)formid)) {
            formid = this.getView().getFormShowParameter().getFormId();
            pkid = !StringUtils.isBlank((Object)showParameter.getPkId()) ? showParameter.getPkId().toString() : "";
        }
        String formUrl = "";
        RequestContext requestContext = RequestContext.get();
        String clientUrl = requestContext.getClientUrl();
        int last = clientUrl.lastIndexOf("/form/invokeAction.do");
        if (last <= 0) {
            last = clientUrl.lastIndexOf("/form/batchInvokeAction.do");
        }
        if (last > 0) {
            clientUrl = clientUrl.substring(0, last);
            formUrl = clientUrl + "/mobile.html?ierpanchor=form/" + formid;
            if (!"".equals(pkid) && !StringUtils.isBlank((CharSequence)pkid)) {
                formUrl = formUrl + "/?pkId=" + pkid;
            }
        }
        log.info("    @@@\u5355\u636e\u5206\u4eab\u7684URL:" + formUrl);
        return formUrl;
    }

    private String getCallBackUrl() {
        RequestContext requestContext;
        String clientUrl;
        int last;
        String formid = this.getView().getFormShowParameter().getFormId();
        String callBackUrl = "";
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String pkid = "";
        if (!StringUtils.isBlank((Object)showParameter.getPkId())) {
            pkid = showParameter.getPkId().toString();
        }
        if ((last = (clientUrl = (requestContext = RequestContext.get()).getClientUrl()).lastIndexOf("/form/invokeAction.do")) <= 0) {
            last = clientUrl.lastIndexOf("/form/batchInvokeAction.do");
        }
        if (last > 0) {
            clientUrl = clientUrl.substring(0, last);
            callBackUrl = clientUrl + "/auth/yzjChatCallbackAction.do?";
            if (!"".equals(pkid) && !StringUtils.isBlank((CharSequence)pkid)) {
                callBackUrl = callBackUrl + "&pkid=" + pkid;
            }
            if (!"".equals(formid) && !StringUtils.isBlank((CharSequence)formid)) {
                callBackUrl = callBackUrl + "&formId=" + formid;
            }
        }
        return callBackUrl;
    }

    private void sendShareData() {
        if (this.getView() instanceof IMobileBillView || this.getView() instanceof IMobileView) {
            log.debug("--------\u6b63\u5728\u51c6\u5907\u5206\u4eab\u5230\u4e91\u4e4b\u5bb6\u7684\u4fe1\u606f...");
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String sYzjShareData = pageCache.get(YZJ_SHARE_DATA);
            log.info("--------\u4e91\u4e4b\u5bb6\u5206\u4eab\u63d2\u4ef6sYzjShareData=" + sYzjShareData);
            this.rtnArg = !StringUtils.isBlank((CharSequence)sYzjShareData) ? this.getShareDataFromPlugin() : this.getShareDataGeneral();
            if (this.rtnArg != null) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("shareToYZJ", this.rtnArg);
                log.info("--------\u4e91\u4e4b\u5bb6\u5206\u4eab\u5b8c\u6bd5\uff01");
            }
        } else {
            this.rtnArg = this.getShareDataOther();
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("shareToYZJ", this.rtnArg);
            log.info("--------\u4e91\u4e4b\u5bb6\u5206\u4eab\u5176\u4ed6\u5355\u636e\u5b8c\u6bd5\uff01");
        }
    }

    private String getCreatedChatGoupId(Map<String, String> mpUser) {
        try {
            Map group;
            String groupId;
            ArrayList<Map<String, String>> chatUsers = new ArrayList<Map<String, String>>();
            chatUsers.add(mpUser);
            String clazzName = KD_BOS_LOGIN_YUNZHIJIA_YUNZHIJIA_UTILS;
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("getImGroupIdByOpenIds", Map.class, List.class);
            HashMap<String, String> curUser = new HashMap<String, String>();
            String tenantId = RequestContext.get().getTenantId();
            curUser.put("tenantId", tenantId);
            curUser.put("userId", RequestContext.get().getUserId());
            curUser.put(USER_NAME, RequestContext.get().getUserName());
            curUser.put("userOpenId", RequestContext.get().getUserOpenId());
            curUser.put(GROUP_NAME, mpUser.get(GROUP_NAME));
            if (mpUser.get(BUSINESS_TYPE) != null) {
                curUser.put(BUSINESS_TYPE, mpUser.get(BUSINESS_TYPE));
            }
            String string = groupId = MapUtils.isNotEmpty((Map)(group = (Map)method.invoke(clazz.newInstance(), curUser, chatUsers))) ? group.get(GROUP_ID).toString() : "";
            if (StringUtils.isEmpty((CharSequence)groupId) && null != this.getView()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u8d77\u6c9f\u901a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"YzjContextMenuClickPlugin_11", (String)BOS_FORM_CORE, (Object[])new Object[0]), MessageBoxOptions.OK);
            }
            return groupId;
        }
        catch (Exception ex) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u4e4b\u5bb6\u804a\u5929\u7fa4\u7ec4\u5931\u8d25.%s", (String)"YzjContextMenuClickPlugin_3", (String)BOS_FORM_CORE, (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private boolean addUserToChatGroup(List<String> openIds, String groupId, String groupName, String businessType) {
        try {
            String clazzName = KD_BOS_LOGIN_YUNZHIJIA_YUNZHIJIA_UTILS;
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("addUserToChatGroup", Map.class, List.class, String.class);
            HashMap<String, String> curUser = new HashMap<String, String>();
            String tenantId = RequestContext.get().getTenantId();
            curUser.put("tenantId", tenantId);
            curUser.put("userId", RequestContext.get().getUserId());
            curUser.put(USER_NAME, RequestContext.get().getUserName());
            curUser.put("userOpenId", RequestContext.get().getUserOpenId());
            curUser.put(GROUP_NAME, groupName);
            if (businessType != null) {
                curUser.put(BUSINESS_TYPE, businessType);
            }
            boolean suc = (Boolean)method.invoke(clazz.newInstance(), curUser, openIds, groupId);
            return suc;
        }
        catch (Exception ex) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458\u5230\u804a\u5929\u7fa4\u7ec4\u5931\u8d25", (String)"YzjContextMenuClickPlugin_4", (String)BOS_FORM_CORE, (Object[])new Object[0]), ex.getMessage());
            return false;
        }
    }

    private void sendChatData(String type, Map<String, Object> mData) throws InterruptedException {
        Object businessType;
        Object groupName;
        Object oid;
        RequestContext requestContext = RequestContext.get();
        log.info(String.format("sendChatData, mData: %s", SerializationUtils.toJsonString(mData)));
        HashMap<String, Object> arg = new HashMap<String, Object>();
        Boolean isNeedDefault = true;
        if (!"".equals(mData.get(OPEN_ID)) && mData.get(OPEN_ID) != null) {
            arg.put(OPEN_ID, mData.get(OPEN_ID));
            isNeedDefault = false;
        } else if (!"".equals(mData.get(GROUP_ID)) && mData.get(GROUP_ID) != null) {
            isNeedDefault = false;
            arg.put(GROUP_ID, mData.get(GROUP_ID));
        }
        if (!"".equals(mData.get("oid")) && mData.get("oid") != null) {
            arg.put("oid", mData.get("oid"));
            isNeedDefault = false;
        }
        if (isNeedDefault.booleanValue()) {
            arg.put("oid", requestContext.getUserOpenId());
        }
        if (!"".equals(mData.get(DRAFT)) && mData.get(DRAFT) != null) {
            arg.put(DRAFT, mData.get(DRAFT));
        }
        if (StringUtils.isNotBlank(oid = arg.get("oid")) && !arg.containsKey(OPEN_ID)) {
            arg.put(OPEN_ID, oid);
        }
        if (StringUtils.isNotBlank((Object)(groupName = mData.get(GROUP_NAME))) && !arg.containsKey(GROUP_NAME)) {
            arg.put(GROUP_NAME, groupName);
        }
        if (StringUtils.isNotBlank((Object)(businessType = mData.get(BUSINESS_TYPE))) && !arg.containsKey(BUSINESS_TYPE)) {
            arg.put(BUSINESS_TYPE, businessType);
        }
        if ("chat_pc".equals(type.toLowerCase(Locale.ENGLISH))) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("chatToYZJ_PC", arg);
        } else {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("chat", arg);
        }
    }

    private String createAndChat(String type, Map<String, Object> mData) {
        String businessType;
        String groupId = null;
        if (mData == null) {
            return groupId;
        }
        HashMap<String, String> mUser = new HashMap<String, String>();
        String groupName = mData.get(GROUP_NAME) != null ? mData.get(GROUP_NAME).toString() : "";
        String string = businessType = mData.get(BUSINESS_TYPE) != null ? mData.get(BUSINESS_TYPE).toString() : "";
        if (mData.get(OPEN_ID) != null) {
            HashMap<String, Object> mChat;
            String OId = mData.get(OPEN_ID).toString();
            if (!OId.contains(",")) {
                mChat = new HashMap<String, Object>();
                mChat.put(DRAFT, mData.get(DRAFT));
                if (mData.get(GROUP_ID) != null) {
                    mChat.put(OPEN_ID, mData.get(OPEN_ID).toString());
                    groupId = mData.get(GROUP_ID).toString();
                    ArrayList<String> openIds = new ArrayList<String>();
                    openIds.add(OId);
                    boolean addSuc = this.addUserToChatGroup(openIds, groupId, groupName, businessType);
                    mChat.put(GROUP_ID, groupId);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage());
                    }
                } else {
                    mChat.put("oid", mData.get(OPEN_ID).toString());
                }
                try {
                    this.sendChatData(type, mChat);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
            }
            if (OId.contains(",")) {
                if (mData.get(GROUP_ID) != null) {
                    groupId = mData.get(GROUP_ID).toString();
                    String openId = mData.get(OPEN_ID).toString().trim();
                    if (openId.lastIndexOf(",") == openId.length() - 1) {
                        openId = openId.substring(0, openId.length() - 1);
                    }
                    boolean e = this.addUserToChatGroup(Arrays.asList(openId.split(",")), groupId, groupName, businessType);
                } else {
                    mUser.put(OPEN_ID, mData.get(OPEN_ID).toString());
                    mUser.put(USER_NAME, mData.get(USER_NAME) != null ? mData.get(USER_NAME).toString() : "");
                    mUser.put(BUSINESS_KEY, mData.get(BUSINESS_KEY) != null ? mData.get(BUSINESS_KEY).toString() : "");
                    mUser.put(ASSIGN_GROUP_OWNER, mData.get(ASSIGN_GROUP_OWNER) != null ? mData.get(ASSIGN_GROUP_OWNER).toString() : "true");
                    mUser.put(GROUP_NAME, groupName);
                    mUser.put(BUSINESS_TYPE, businessType);
                    groupId = this.getCreatedChatGoupId(mUser);
                }
                if (StringUtils.isNotEmpty((CharSequence)groupId)) {
                    mChat = new HashMap();
                    mChat.put(GROUP_ID, groupId);
                    mChat.put(DRAFT, mData.get(DRAFT));
                    try {
                        this.sendChatData(type, mChat);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        if (mData.get(OPEN_ID) == null) {
            groupId = mData.get(GROUP_ID).toString();
            if (!"".equals(groupId) || groupId == null) {
                return groupId;
            }
            HashMap<String, Object> mChat = new HashMap<String, Object>();
            mChat.put(GROUP_ID, groupId);
            mChat.put(DRAFT, mData.get(DRAFT));
            try {
                this.sendChatData(type, mChat);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)businessType)) {
            mData.put(BUSINESS_TYPE, businessType);
        }
        this.setYzjChatGroupTheme(groupId, mData);
        return groupId;
    }

    private void setYzjChatGroupTheme(String groupId, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)groupId) || StringUtils.isBlank((Object)params.get(CONTENT)) || StringUtils.isBlank((Object)params.get(TITLE))) {
            return;
        }
        try {
            ThreadPools.executeOnceIncludeRequestContext((String)"Thread-SetYzjChatGroupTheme", () -> {
                try {
                    Class<?> clazz = Class.forName(KD_BOS_LOGIN_YUNZHIJIA_YUNZHIJIA_UTILS);
                    Method method = clazz.getMethod("setYzjChatGroupTheme", String.class, Map.class);
                    method.invoke(clazz.newInstance(), groupId, params);
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ebf\u7a0b\u5f02\u6b65\u8bbe\u7f6e\u7fa4\u7ec4\u4e3b\u9898\u5931\u8d25", (String)"YzjContextMenuClickPlugin_17", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to add YZJ chat group topic, group id is\u3010" + groupId + "\u3011.", (Throwable)e);
        }
    }

    private void sendSocialShareData() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String sYzjShareData = pageCache.get(YZJ_SOCIAL_SHARE_DATA);
        log.info(String.format("sYzjShareData: %s", sYzjShareData));
        this.rtnArg = !StringUtils.isBlank((CharSequence)sYzjShareData) ? this.getSocialShareDataFromPlugin() : this.getSocialShareDataGeneral();
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("socialShare", this.rtnArg);
    }

    private Map<String, Object> getSocialShareDataGeneral() {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        String title = this.getView().getFormShowParameter().getFormConfig().getCaption().toString();
        String content = "";
        String webpageUrl = "";
        String billNoField = "";
        String billNo = "";
        if (model.getDataEntityType() instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)model.getDataEntityType();
            billNoField = billEntityType.getBillNo();
            billNo = (String)model.getValue(billNoField);
        }
        String formUrl = this.getShareUrl("", "");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            billNo = ResManager.loadKDString((String)"\u7a7a", (String)"YzjContextMenuClickPlugin_0", (String)BOS_FORM_CORE, (Object[])new Object[0]);
        }
        content = String.format(ResManager.loadKDString((String)YzjContextMenuClickPlugin.getBillNumber(), (String)YZJ_CONTEXT_MENU_CLICK_PLUGIN_1, (String)BOS_FORM_CORE, (Object[])new Object[0]), billNo);
        webpageUrl = formUrl;
        HashMap<String, Object> arg = new HashMap<String, Object>();
        HashMap<String, String> shareContent = new HashMap<String, String>();
        arg.put(SHARE_TYPE, socialShareType);
        arg.put(SHARE_WAY, shareWay);
        shareContent.put(TITLE, title);
        shareContent.put(DESCRIPTION, content);
        shareContent.put(THUMB_DATA, thumbData);
        shareContent.put(WEBPAGE_URL, webpageUrl);
        arg.put(SHARE_CONTENT, shareContent);
        Date d1 = new Date();
        d1.getTime();
        log.info("Start requesting YZJ,start time\uff1a" + d1.toString() + " sendSocialShareData\uff1aYZJ shared to the colleague circle common\uff1a" + shareContent);
        return arg;
    }

    private Map<String, Object> getSocialShareDataFromPlugin() {
        String webpageUrl = "";
        String description = "";
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String sYzjShareData = pageCache.get(YZJ_SOCIAL_SHARE_DATA);
        YzjSocialShareDataModel yzjShareDataModel = (YzjSocialShareDataModel)SerializationUtils.fromJsonString((String)sYzjShareData, YzjSocialShareDataModel.class);
        ArrayList sContent = yzjShareDataModel.getShareContent();
        if (sContent != null && sContent.size() > 0) {
            YzjSocialShareDataModel.ShareContent sc = (YzjSocialShareDataModel.ShareContent)sContent.get(0);
            String title = sc.getTitle();
            webpageUrl = sc.getWebpageUrl();
            description = sc.getDescription();
            HashMap<String, Object> arg = new HashMap<String, Object>();
            HashMap<String, String> shareContent = new HashMap<String, String>();
            arg.put(SHARE_TYPE, socialShareType);
            arg.put(SHARE_WAY, shareWay);
            shareContent.put(TITLE, title);
            shareContent.put(DESCRIPTION, description);
            shareContent.put(THUMB_DATA, thumbData);
            shareContent.put(WEBPAGE_URL, webpageUrl);
            log.info(YzjContextMenuClickPlugin.getWebpageUrl2() + webpageUrl);
            arg.put(SHARE_CONTENT, shareContent);
            return arg;
        }
        return null;
    }

    private Map<String, Object> getSocialShareDataFromPlugin(Map<String, Object> mSocialData) {
        String webpageUrl = "";
        String description = "";
        String title = mSocialData.get(TITLE).toString();
        webpageUrl = mSocialData.get(WEBPAGE_URL).toString();
        description = mSocialData.get(DESCRIPTION).toString();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        HashMap<String, String> shareContent = new HashMap<String, String>();
        arg.put(SHARE_TYPE, socialShareType);
        arg.put(SHARE_WAY, shareWay);
        shareContent.put(TITLE, title);
        shareContent.put(DESCRIPTION, description);
        shareContent.put(THUMB_DATA, thumbData);
        shareContent.put(WEBPAGE_URL, webpageUrl);
        log.info(YzjContextMenuClickPlugin.getWebpageUrl2() + webpageUrl);
        arg.put(SHARE_CONTENT, shareContent);
        return arg;
    }

    private String getGroupId(String formid, String pkid) {
        String strSQL = "";
        strSQL = "SELECT FGROUPID FROM T_BAS_BILLYZJGROUP Where FFORMID='" + formid + "' AND FPKID='" + pkid + "'  ORDER BY FGROUPID ";
        List listSelected = new ArrayList();
        Object[] params = new SqlParameter[]{};
        String groupid = "";
        listSelected = (List)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>();
                try {
                    if (rs.next()) {
                        list.add(rs.getString("FGROUPID"));
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            }
        });
        if (!StringUtils.isBlank(listSelected) && listSelected != null && listSelected.size() > 0) {
            groupid = (String)listSelected.get(0);
        }
        return groupid;
    }

    public void addCalendarEvent(Map<String, Object> mCalendarData) {
        log.info("--------\u751f\u6210\u65e5\u5386\u63d2\u4ef6\u5f00\u59cb\uff01");
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("addCalendarEvent", mCalendarData);
    }

    public void yzjInterface(String sApiName, Map<String, Object> mData) {
        String chat = "chat";
        switch (sApiName) {
            case "addCalendarEvent": {
                this.addCalendarEvent(mData);
                break;
            }
            case "chat": {
                if (mData.get(CHATTYPE) != null && "".equals(mData.get(CHATTYPE).toString())) {
                    chat = mData.get(CHATTYPE).toString();
                }
                try {
                    this.sendChatData(chat, mData);
                }
                catch (InterruptedException e1) {
                    log.error(e1.getMessage());
                }
                break;
            }
            case "chat_pc": {
                if (mData.get(CHATTYPE) != null && !"".equals((String)mData.get(CHATTYPE))) {
                    chat = (String)mData.get(CHATTYPE);
                }
                try {
                    this.sendChatData(chat, mData);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
                break;
            }
            case "createAndChat": {
                if (mData.get(CHATTYPE) != null && !"".equals((String)mData.get(CHATTYPE))) {
                    chat = (String)mData.get(CHATTYPE);
                }
                String groupid = this.createAndChat(chat, mData);
                break;
            }
            case "share": {
                Map<String, Object> rtnArg = this.getShareDataFromPlugin(mData);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("shareToYZJ", rtnArg);
                break;
            }
            case "socialShare": {
                Map<String, Object> rtn = this.getSocialShareDataFromPlugin(mData);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("socialShare", rtn);
                break;
            }
            case "addUserToChatGroup": {
                break;
            }
        }
    }

    public Map<String, String> yzjInterfaceWithRerurn(String sApiName, Map<String, Object> mData) {
        HashMap<String, String> rtnData = null;
        String chat = "chat";
        switch (sApiName) {
            case "createAndChat": {
                if (mData.get(CHATTYPE) != null && !"".equals((String)mData.get(CHATTYPE))) {
                    chat = (String)mData.get(CHATTYPE);
                }
                String groupid = this.createAndChat(chat, mData);
                rtnData = new HashMap<String, String>();
                rtnData.put(GROUP_ID, groupid);
                return rtnData;
            }
        }
        return null;
    }

    private Map<String, Object> getShareDataFromPluginNew() {
        String content = null;
        String webpageUrl = null;
        String cellContent = null;
        String sharedObject = null;
        String yzjGroupId = null;
        String title = null;
        List listSelected = new ArrayList();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String sYzjShareData = pageCache.get(YZJ_SHARE_DATA);
        YzjShareDataModel yzjShareDataModel = (YzjShareDataModel)SerializationUtils.fromJsonString((String)sYzjShareData, YzjShareDataModel.class);
        if (!this.checkShareDataValide(yzjShareDataModel).booleanValue()) {
            return null;
        }
        title = yzjShareDataModel.getTitle();
        listSelected = yzjShareDataModel.getSelected();
        content = yzjShareDataModel.getcontent();
        webpageUrl = yzjShareDataModel.getWebpageUrl();
        String formid = yzjShareDataModel.getFormid();
        String pkid = yzjShareDataModel.getPkId();
        if (webpageUrl == null || StringUtils.isBlank((CharSequence)webpageUrl)) {
            webpageUrl = this.getShareUrl(formid, pkid);
        }
        cellContent = yzjShareDataModel.getCellContent();
        sharedObject = yzjShareDataModel.getCellContent();
        if (sharedObject == null || StringUtils.isBlank((CharSequence)sharedObject)) {
            sharedObject = "all";
        }
        yzjGroupId = "";
        if (formid != null && !StringUtils.isBlank((CharSequence)formid)) {
            yzjGroupId = this.getGroupId(formid, pkid);
        }
        String callBackUrl = yzjShareDataModel.getCallBackUrl();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put(SHARE_TYPE, shareType);
        arg.put(APP_ID, this.appId);
        arg.put(APP_NAME, this.appName);
        arg.put(LIGHT_APP_ID, this.lightAppId);
        arg.put(TITLE, title);
        arg.put(CONTENT, content);
        arg.put(THUMB_DATA, thumbData);
        if (!StringUtils.isBlank(listSelected) && listSelected != null && listSelected.size() > 0) {
            arg.put(SELECTED, listSelected);
        }
        arg.put(WEBPAGE_URL, webpageUrl);
        arg.put(CELL_CONTENT, cellContent);
        arg.put(SHARED_OBJECT, sharedObject);
        arg.put(CALL_BACK_URL, callBackUrl);
        arg.put(YZJ_GROUP_ID, yzjGroupId);
        log.info(YzjContextMenuClickPlugin.getYzjGroupId1() + yzjGroupId + FORMID + formid + PKID + pkid + " " + YzjContextMenuClickPlugin.getCallBackUrl1() + callBackUrl + " " + YzjContextMenuClickPlugin.getWebpageUrl1() + webpageUrl);
        return arg;
    }

    private Boolean checkShareDataValide(YzjShareDataModel yzjShareDataModel) {
        if (yzjShareDataModel.getTitle() == null || "".equals(yzjShareDataModel.getTitle())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570title\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_5", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        if (yzjShareDataModel.getcontent() == null || "".equals(yzjShareDataModel.getcontent())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570content\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_6", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        if (yzjShareDataModel.getCellContent() == null || "".equals(yzjShareDataModel.getCellContent())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570cellContent\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_7", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        if ((yzjShareDataModel.getFormid() == null || "".equals(yzjShareDataModel.getFormid())) && (yzjShareDataModel.getWebpageUrl() == null || "".equals(yzjShareDataModel.getWebpageUrl()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"formid\u4e0ewebpageUrl\u5fc5\u987b\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_8", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        if (yzjShareDataModel.getPkId() != null && !"".equals(yzjShareDataModel.getPkId()) && (yzjShareDataModel.getFormid() == null || "".equals(yzjShareDataModel.getFormid()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"pkid\u4e0d\u4e3a\u7a7a\u65f6\uff0cformid\u5fc5\u987b\u4e5f\u4e0d\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_9", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getSocialShareDataFromPluginNew() {
        String webpageUrl = "";
        String description = "";
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String sYzjShareData = pageCache.get(YZJ_SOCIAL_SHARE_DATA);
        YzjSocialShareDataModel yzjShareDataModel = (YzjSocialShareDataModel)SerializationUtils.fromJsonString((String)sYzjShareData, YzjSocialShareDataModel.class);
        ArrayList sContent = yzjShareDataModel.getShareContent();
        if (sContent != null && sContent.size() > 0) {
            YzjSocialShareDataModel.ShareContent sc = (YzjSocialShareDataModel.ShareContent)sContent.get(0);
            String title = sc.getTitle();
            title = sc.getTitle();
            webpageUrl = sc.getWebpageUrl();
            description = sc.getDescription();
            HashMap<String, Object> arg = new HashMap<String, Object>();
            HashMap<String, String> shareContent = new HashMap<String, String>();
            arg.put(SHARE_TYPE, socialShareType);
            arg.put(SHARE_WAY, shareWay);
            shareContent.put(TITLE, title);
            shareContent.put(DESCRIPTION, description);
            shareContent.put(THUMB_DATA, thumbData);
            shareContent.put(WEBPAGE_URL, webpageUrl);
            log.info(YzjContextMenuClickPlugin.getWebpageUrl2() + webpageUrl);
            arg.put(SHARE_CONTENT, shareContent);
            return arg;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean checkSocialShareDataValide(YzjSocialShareDataModel yzjShareDataModel) {
        ArrayList sContent = yzjShareDataModel.getShareContent();
        if (sContent != null) {
            if (sContent.size() > 0) {
                YzjSocialShareDataModel.ShareContent sc = (YzjSocialShareDataModel.ShareContent)sContent.get(0);
                if (sc.getTitle() != null && !"".equals(sc.getTitle())) return true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570title\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_5", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return false;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570ShareContent\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_10", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570ShareContent\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"YzjContextMenuClickPlugin_10", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        return false;
    }
}

