/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.LongProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AbstractList
extends Control {
    private static final String SEARCH_TEXT = "searchText";
    private ListState listState;
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();
    protected List<ListSelectedListener> selectlisteners = new ArrayList<ListSelectedListener>();

    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    public ListState getEntryState() {
        if (this.listState == null) {
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            HashMap<String, Object> state = (HashMap<String, Object>)proxy.getViewState(this.getKey());
            if (state == null) {
                state = new HashMap<String, Object>(0);
            }
            this.listState = new ListState(this.getKey(), state);
        }
        return this.listState;
    }

    public void addListSelectedListener(ListSelectedListener listener) {
        this.selectlisteners.add(listener);
    }

    @SdkInternal
    public void endSelect(List<Object> params) {
        ListSelectedRowCollection listSelectedRows;
        EndSelectEvent evt = new EndSelectEvent((Object)this);
        if (!params.isEmpty()) {
            listSelectedRows = this.getSelectedRows(params);
        } else {
            listSelectedRows = new ListSelectedRowCollection();
            listSelectedRows.setClearFlag(true);
        }
        evt.setData((Object)listSelectedRows);
        for (ListSelectedListener l : this.selectlisteners) {
            l.endSelect(evt);
        }
    }

    @SdkInternal
    protected ListSelectedRow getListSelectedRow(Object pkValue, EntityType entityType) {
        Object newPkValue = pkValue;
        if (entityType.getPrimaryKey() instanceof LongProp) {
            newPkValue = Long.parseLong(pkValue.toString());
        }
        return new ListSelectedRow(newPkValue, Boolean.valueOf(entityType.getPrimaryKey() instanceof LongProp));
    }

    @SdkInternal
    protected ListSelectedRowCollection getSelectedRows(List<Object> pkList) {
        boolean isMulti;
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Object isMultiObject = this.getView().getFormShowParameter().getCustomParam("isMulti");
        boolean bl = isMulti = isMultiObject == null ? false : (Boolean)isMultiObject;
        if (isMulti) {
            for (Object pkValue : pkList) {
                listSelectedRows.add((Object)this.getListSelectedRow(pkValue, (EntityType)entityType));
            }
        } else {
            listSelectedRows.add((Object)this.getListSelectedRow(pkList.get(0), (EntityType)entityType));
        }
        return listSelectedRows;
    }

    @SdkInternal
    public static class ListState {
        private String key;
        private Map<String, Object> state;

        public final String getKey() {
            return this.key;
        }

        public ListState(String key, Map<String, Object> state) {
            this.key = key;
            this.state = state;
        }

        public final String getSearchText() {
            if (this.state == null || !this.state.containsKey(AbstractList.SEARCH_TEXT)) {
                return "";
            }
            return (String)this.state.get(AbstractList.SEARCH_TEXT);
        }

        public void putSearchText(String searchText) {
            this.state.put(AbstractList.SEARCH_TEXT, searchText);
        }
    }
}

