/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumnContext;
import kd.bos.list.SeqColumnType;
import kd.bos.list.ViewCommonUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractListContainerColumn
extends Container
implements IListColumn {
    private static final String DEFAULT = "default";
    private static final String EDITOR = "editor";
    private static final String TEXT_ALIGN = "textAlign";
    private static final String CONSTANT_VISIBLE = "visible";
    private static final String LIST_FIELD_KEY = "listFieldKey";
    private static final String FIXED = "fixed";
    private static final String IS_HEADER_FIELD = "isHeaderField";
    private static final String CLASS = "class";
    private static final String CONSTANT_CAPTION = "caption";
    private static final String ENTITY_CAPTION = "entityCaption";
    private boolean is_HeaderField = true;
    private Container parent;
    private int seq;
    private int visible = 11;
    private boolean is_Fixed;
    private String parentViewKey;
    private LocaleString caption;
    private LocaleString width;
    private String foreColor;
    private String backColor;
    private int fontSize = 12;
    private String textAlign = "default";
    private String entityName;
    private LocaleString entityCaption;
    private Map<String, Object> userConfigColumnSettings;
    private List<String> blackFields = new ArrayList<String>();
    private ListColumnContext listColumnContext;
    private String tableHeaderCellBackColor;
    Map<String, Map<String, Object>> decimalFieldMap = new HashMap<String, Map<String, Object>>();

    public void setContext(ListColumnContext listColumnContext) {
        this.listColumnContext = listColumnContext;
    }

    public ListColumnContext getContext() {
        return this.listColumnContext;
    }

    @SimplePropertyAttribute(name="TableHeaderCellBackColor")
    public String getTableHeaderCellBackColor() {
        return this.tableHeaderCellBackColor;
    }

    public void setTableHeaderCellBackColor(String tableHeaderCellBackColor) {
        this.tableHeaderCellBackColor = tableHeaderCellBackColor;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public String getParentViewKey() {
        return this.parentViewKey;
    }

    public void setParentViewKey(String parentViewKey) {
        this.parentViewKey = parentViewKey;
    }

    public SortType getSortType() {
        return null;
    }

    public String getOrder() {
        return null;
    }

    public void setOrder(String order) {
    }

    public SeqColumnType getSeqColType() {
        return null;
    }

    public String getSeqColumnType() {
        return null;
    }

    public void setSeqColumnType(String seqColumnType) {
    }

    public String getClassName() {
        return null;
    }

    public void setClassName(String className) {
    }

    public String getFieldName() {
        return null;
    }

    public void setFieldName(String fieldName) {
    }

    @SimplePropertyAttribute(name="Fixed")
    public boolean isFixed() {
        return this.is_Fixed;
    }

    public void setFixed(boolean isFixed) {
        this.is_Fixed = isFixed;
    }

    @SimplePropertyAttribute
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isHyperlink() {
        return false;
    }

    public void setHyperlink(boolean isHyperlink) {
    }

    @SimplePropertyAttribute
    public LocaleString getCaption() {
        return this.caption;
    }

    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute
    public String getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    @SimplePropertyAttribute
    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    @SimplePropertyAttribute
    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getListFieldKey() {
        return this.key;
    }

    public void setListFieldKey(String strRealKey) {
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="11")
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    @SdkInternal
    protected String getBizType() {
        return "text";
    }

    public int getColType() {
        return 1;
    }

    public Map<String, Map<String, Object>> getDecimalFieldMap() {
        return this.decimalFieldMap;
    }

    public void setDecimalFieldMap(Map<String, Map<String, Object>> decimalFieldMap) {
        this.decimalFieldMap = decimalFieldMap;
    }

    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        map.put("entity", this.getEntityName());
        return map;
    }

    public Map<String, Object> createColumn(MainEntityType entityType) {
        HashMap<String, Object> column = new HashMap<String, Object>();
        column.put("entity", this.getEntityName());
        column.put("dataIndex", StringUtils.isNotBlank((CharSequence)this.getListFieldKey()) ? this.getListFieldKey().replace('.', '_') : this.getKey());
        column.put("coltype", this.getColType());
        column.put("header", this.getCaption());
        if (this.isInvisible()) {
            column.put("vi", 0);
        } else {
            column.put("vi", this.getUserVisible());
        }
        column.put("w", this.getWidth());
        if (!DEFAULT.equals(this.getTextAlign())) {
            column.put("text-align", this.getTextAlign());
        }
        if (this.getUserFixed()) {
            column.put("isFixed", this.getUserFixed());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTableHeaderCellBackColor())) {
            column.put("thcb", this.getTableHeaderCellBackColor());
        }
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", this.getBizType());
        if (StringUtils.isNotBlank((CharSequence)this.getForeColor())) {
            editor.put("fc", this.getForeColor());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBackColor())) {
            editor.put("bc", this.getBackColor());
        }
        if (this.getFontSize() != 12) {
            editor.put("fs", this.getFontSize());
        }
        column.put(EDITOR, editor);
        return column;
    }

    @SdkInternal
    protected List<Object> createColumns(MainEntityType entityType, Map<String, Map<String, Object>> decimalFieldMap) {
        ArrayList<Object> cols = new ArrayList<Object>(10);
        for (Control item : this.getItems()) {
            IListColumn col = (IListColumn)item;
            col.setParent(this.getParent());
            col.setContext(new ListColumnContext(this.getContext().getCanNotReadFields(), this.getContext().getBlackFields(), this.getContext().isSingleOrgMode()));
            col.setParentViewKey(this.getParentViewKey());
            if (col instanceof Control) {
                ((Control)col).setView(this.getView());
            }
            Map column = col.createColumn(entityType);
            FilterField filterField = FilterField.create((MainEntityType)entityType, (String)col.getListFieldKey());
            if (filterField != null) {
                Map editor = (Map)column.get(EDITOR);
                if (filterField.getFieldProp() instanceof ComboProp) {
                    ViewCommonUtil.setComboListColumnEditor(col, (ComboProp)filterField.getFieldProp(), (Map<String, Object>)editor, filterField.getLatestParent());
                }
                if (filterField.getFieldProp() instanceof DecimalProp) {
                    ViewCommonUtil.setDecimalColumnEditor(col, filterField.getFieldProp(), column);
                    ViewCommonUtil.createDecimalEditor(column, (Map)column.get(EDITOR), decimalFieldMap);
                }
            }
            cols.add(column);
        }
        return cols;
    }

    public void setEntityName(String name) {
        this.entityName = name;
    }

    public void setEntityCaption(LocaleString entityCaption) {
        this.entityCaption = entityCaption;
    }

    public LocaleString getEntityCaption() {
        return this.entityCaption;
    }

    public void setHeaderField(boolean isHeaderField) {
        this.is_HeaderField = isHeaderField;
    }

    public boolean isHeaderField() {
        return this.is_HeaderField;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Map<String, Object> getUserConfigColumnSettings() {
        return this.userConfigColumnSettings;
    }

    public void setUserConfigColumnSettings(Map<String, Object> userConfigColumnSettings) {
        this.userConfigColumnSettings = userConfigColumnSettings;
    }

    public List<String> getBlackFields() {
        return this.blackFields;
    }

    public void setBlackFields(List<String> blackFields) {
        this.blackFields = blackFields;
    }

    public boolean isColumnOrderAndFilter() {
        return false;
    }

    public void setColumnOrderAndFilter(boolean columnOrderAndFilter) {
    }

    public boolean isColumnOrder() {
        return false;
    }

    public void setColumnOrder(boolean columnOrder) {
    }

    public boolean isColumnFilter() {
        return false;
    }

    public void setColumnFilter(boolean columnFilter) {
    }
}

