/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AbstractTreeListView
implements ITreeListView,
TreeNodeClickListener {
    protected ITreeModel treeModel;
    protected IListView view;
    protected TreeView treeview;
    protected TreeNode root;
    private List<TreeNodeClickListener> treeNodeClickListeners = new ArrayList<TreeNodeClickListener>();

    public void addTreeNodeClickListener(TreeNodeClickListener treeNodeClickListener) {
        this.treeNodeClickListeners.add(treeNodeClickListener);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public void initialize(IListView view, TreeView tv) {
        this.view = view;
        this.treeview = tv;
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void refresh() {
    }

    public void refreshTreeView() {
    }

    public TreeView getTreeView() {
        return this.treeview;
    }

    protected void clearCurrentListSelectdRowCache() {
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        pageCache.put("currentListSelectedRowCollection", null);
    }

    public ITreeModel getTreeModel() {
        return this.treeModel;
    }

    public void refreshTreeNode(String nodeId) {
        this.refreshTreeNode(nodeId, true);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.treeModel.setCurrentNodeId(e.getNodeId());
        for (TreeNodeClickListener treeNodeClickListener : this.treeNodeClickListeners) {
            treeNodeClickListener.treeNodeClick(e);
        }
        if (this.treeModel.isNodeClickExpand()) {
            this.treeview.expand(e.getNodeId().toString());
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        this.treeModel.setCurrentNodeId(e.getNodeId());
        String nodeId = (String)e.getNodeId();
        TreeNode node = this.root.getTreeNode(nodeId, 100);
        if (node != null) {
            if (node.isExpend()) {
                this.treeview.collapse(nodeId);
                node.setExpend(false);
            } else {
                this.treeview.expand(nodeId);
                node.setExpend(true);
            }
        }
        this.treeModel.setRoot(this.root);
    }

    public void focusRootNode() {
        if (this.root == null) {
            return;
        }
        this.treeModel.setCurrentNodeId((Object)this.root.getId());
        this.treeview.focusNode(this.root);
    }

    public void refreshTreeNode(String nodeId, boolean isRefreshBillList) {
    }
}

