/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.CityORMUtil;
import kd.bos.list.AbstractList;
import kd.bos.list.CityListUtil;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CityList
extends AbstractList {
    private static final Log logger = LogFactory.getLog(CityList.class);
    protected List<ListSelectedListener> listeners = new ArrayList<ListSelectedListener>();

    @Override
    public void addListSelectedListener(ListSelectedListener listener) {
        this.listeners.add(listener);
    }

    public void itemSelect() {
        ItemSelectEvent evt = new ItemSelectEvent((Object)this);
        for (ListSelectedListener l : this.listeners) {
            l.itemSelect(evt);
        }
    }

    @Override
    public void endSelect(List<Object> params) {
        EndSelectEvent evt = new EndSelectEvent((Object)this);
        if (!params.isEmpty()) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows(params);
            evt.setData((Object)listSelectedRows);
        }
        for (ListSelectedListener l : this.listeners) {
            l.endSelect(evt);
        }
    }

    public void countrySelected(ArrayList<Long> countryId) {
        boolean i = false;
        long cId = 0L;
        cId = Long.parseLong(String.valueOf(countryId.get(0)));
        Map citys = CityORMUtil.requestCityList((Long)cId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (citys.size() > 0) {
            proxy.invokeControlMethod(this.getKey(), "responseCityList", new Object[]{citys});
        }
    }

    public void getCityData(Map<String, Object> args) {
        boolean isDomestic = (Boolean)args.get("isDomestic");
        boolean isFirst = (Boolean)args.get("isFirst");
        int dataPerPage = (Integer)args.get("dataPerPage");
        String gr = args.get("gr") == null ? "" : (String)args.get("gr");
        String lastCityId = args.get("lastCityId") == null ? "" : (String)args.get("lastCityId");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        List<Map<String, Object>> cityData = CityListUtil.getCityData(isDomestic, isFirst, dataPerPage, gr, lastCityId);
        resultMap.put("isDomestic", isDomestic);
        resultMap.put("isFirst", isFirst);
        resultMap.put("cityData", cityData);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setCityData", new Object[]{resultMap});
    }

    public void onSearch(String keyword, String timestamp) {
        List<Map<String, Object>> cityData = CityListUtil.getSearchData(keyword);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("searchText", keyword);
        resultMap.put("timestamp", timestamp);
        resultMap.put("result", cityData);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setSearchResult", new Object[]{resultMap});
    }

    public void getHotCities(Map<String, Object> args) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        boolean isDomestic = (Boolean)args.get("isDomestic");
        List<Map<String, Object>> cityData = CityListUtil.getHotCityData(isDomestic, false, new ArrayList<Long>());
        resultMap.put("isDomestic", isDomestic);
        resultMap.put("hc", cityData);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setHotCities", new Object[]{resultMap});
    }

    public void getFreqCities(Map<String, Object> args) {
        ArrayList<Long> freqCitiesList = new ArrayList<Long>();
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(5);
        boolean isDomestic = (Boolean)args.get("isDomestic");
        List freqCities = (List)args.get("freqCities");
        if (freqCities != null) {
            freqCities.forEach(val -> {
                try {
                    freqCitiesList.add(Long.parseLong((String)val.get("id")));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            });
        }
        List<Map<String, Object>> cityData = CityListUtil.getHotCityData(isDomestic, true, freqCitiesList);
        resultMap.put("isDomestic", Boolean.valueOf(isDomestic));
        HashSet<String> commonCityIdSet = new HashSet<String>(16);
        HashMap<String, Object> commonCityMap = new HashMap<String, Object>(16);
        for (Map<String, Object> map : cityData) {
            commonCityIdSet.add((String)map.get("id"));
            commonCityMap.put((String)map.get("id"), map.get("name"));
        }
        ArrayList<Map> freqCitiesMapList = new ArrayList<Map>();
        if (freqCities != null) {
            for (Map map : freqCities) {
                try {
                    String id = (String)map.get("id");
                    if (!commonCityIdSet.contains(id)) continue;
                    map.put("name", commonCityMap.get(id));
                    freqCitiesMapList.add(map);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
        resultMap.put("fc", freqCitiesMapList);
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.invokeControlMethod(this.getKey(), "setFreqCities", new Object[]{resultMap});
    }
}

