/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.list.ListColumn;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DecimalListColumn
extends ListColumn {
    private int summary;
    private String mask;
    private String displayFormatString;
    private boolean noDisplayScaleZero;
    private boolean mobNoDisplayScaleZero = Boolean.FALSE;
    private boolean zeroShow;

    @SimplePropertyAttribute
    public boolean isNoDisplayScaleZero() {
        return this.noDisplayScaleZero;
    }

    public void setNoDisplayScaleZero(boolean noDisplayScaleZero) {
        this.noDisplayScaleZero = noDisplayScaleZero;
    }

    @SimplePropertyAttribute(name="MobNoDisplayScaleZero")
    @DefaultValueAttribute(value="false")
    public boolean isMobNoDisplayScaleZero() {
        return this.mobNoDisplayScaleZero;
    }

    public void setMobNoDisplayScaleZero(boolean mobNoDisplayScaleZero) {
        this.mobNoDisplayScaleZero = mobNoDisplayScaleZero;
    }

    @SimplePropertyAttribute
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    @SimplePropertyAttribute
    public String getDisplayFormatString() {
        return this.displayFormatString;
    }

    public void setDisplayFormatString(String displayFormatString) {
        this.displayFormatString = displayFormatString;
    }

    @SimplePropertyAttribute
    public int getSummary() {
        return this.summary;
    }

    public void setSummary(int summary) {
        this.summary = summary;
    }

    @SimplePropertyAttribute
    public boolean isZeroShow() {
        return this.zeroShow;
    }

    public void setZeroShow(boolean zeroShow) {
        this.zeroShow = zeroShow;
    }

    @Override
    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map<String, Object> column = super.createColumn(entityType);
        if (this.getSummary() != 0) {
            column.put("sum", this.getSummary());
        }
        if (this.isNoDisplayScaleZero()) {
            column.put("sz", this.isNoDisplayScaleZero());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getMask())) {
            column.put("mask", this.getMask());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getDisplayFormatString())) {
            column.put("df", this.getDisplayFormatString());
        }
        if (this.isZeroShow()) {
            column.put("zs", this.isZeroShow());
        }
        return column;
    }

    public int getColType() {
        return 2;
    }

    @Override
    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        super.addFieldSet(fieldSet, entityType, withoutDetailEntry, isListShowParameter, isLookUp);
        if (withoutDetailEntry && this.srcFieldProp != null && this.srcFieldProp.getParent() instanceof EntryType) {
            return;
        }
        ListField listField = fieldSet.get(this.getFieldKey());
        if (StringUtils.isEmpty((CharSequence)listField.getMask()) && StringUtils.isNotEmpty((CharSequence)this.mask)) {
            listField.setMask(this.mask);
        }
        if (StringUtils.isEmpty((CharSequence)listField.getDisplayFormatString()) && StringUtils.isNotEmpty((CharSequence)this.displayFormatString)) {
            listField.setDisplayFormatString(this.displayFormatString);
        }
        Boolean userListColumnsVisible = null;
        Map userConfigColumnSettings = this.getUserConfigColumnSettings();
        if (userConfigColumnSettings != null) {
            int visibleValue = Integer.parseInt(userConfigColumnSettings.get("visible").toString());
            userListColumnsVisible = this.getListColumnVisible(isListShowParameter, isLookUp, visibleValue);
        }
        if ((listField.isVisible() && userListColumnsVisible == null || userListColumnsVisible != null && userListColumnsVisible.booleanValue()) && listField.getSummary() == 0 && this.summary != 0 && !(this.srcFieldProp instanceof ExchangeRateProp)) {
            listField.setSummary(this.summary);
        }
        listField.setZeroShow(this.isZeroShow());
        listField.setMobNoDisplayScaleZero(this.isMobNoDisplayScaleZero());
        if (this.srcFieldProp instanceof DecimalProp) {
            FilterField ctrlField;
            DecimalProp prop = (DecimalProp)this.srcFieldProp;
            String controlPropName = prop.getControlPropName();
            if (StringUtils.isNotBlank((CharSequence)controlPropName) && !fieldSet.containsKey(controlPropName) && (ctrlField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)controlPropName)) != null) {
                this.addControlField(fieldSet, ctrlField.getSrcFieldProp(), controlPropName, ctrlField.getFullFieldName());
                if (this.srcFieldProp instanceof QtyProp && ctrlField.getSrcFieldProp() instanceof UnitProp && FmtInfoUtils.applyMaterialPrecision()) {
                    this.addQtyMaterialField(fieldSet, (MainEntityType)entityType, (UnitProp)ctrlField.getSrcFieldProp());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                ListField controlListField = fieldSet.get(controlPropName);
                listField.setControlField(controlListField);
            }
        }
    }

    private void addQtyMaterialField(Map<String, ListField> fieldSet, MainEntityType entityType, UnitProp unitProp) {
        FilterField materielField;
        String materielKey = unitProp.getMaterielField();
        if (StringUtils.isNotBlank((CharSequence)materielKey) && !fieldSet.containsKey(materielKey) && (materielField = FilterField.create((MainEntityType)entityType, (String)materielKey)) != null) {
            this.addControlField(fieldSet, materielField.getSrcFieldProp(), materielKey, materielField.getFullFieldName());
        }
    }
}

