/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterTools;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Container;
import kd.bos.list.BillList;
import kd.bos.list.IListChild;
import kd.bos.list.ViewCommonUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListCardView
extends Container
implements IListChild {
    private static final String TOOLBAR_LOCATION = "tl";
    private static final String ITEMS = "items";
    private static final String ORG_DATA_INDEX = "orgDataIndex";
    private static final String EDITOR = "editor";
    private final String TYPE = "type";
    private final String STORE = "st";
    private int visible;
    private boolean paginationHide;
    private String toolbarLocation = "-1";
    private boolean showNoDataTip = true;
    private String pageType = "";
    private Map<String, Object> clientMeta;
    private BillList parent;

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    @SimplePropertyAttribute(name="PaginationHide")
    public boolean isPaginationHide() {
        return this.paginationHide;
    }

    public void setPaginationHide(boolean paginationHide) {
        this.paginationHide = paginationHide;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    @SimplePropertyAttribute(name="ShowNoDataTip")
    @DefaultValueAttribute(value="true")
    public boolean isShowNoDataTip() {
        return this.showNoDataTip;
    }

    public void setShowNoDataTip(boolean showNoDataTip) {
        this.showNoDataTip = showNoDataTip;
    }

    public void bindData(BindingContext bctx) {
        if (this.clientMeta != null) {
            this.updateControlMeta();
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            this.extendMetadata((List)this.clientMeta.get(ITEMS), this.parent.getListModel().getProvider());
            SingleOrgContextHelper.createCardSingleOrgContext(this, (List)this.clientMeta.get(ITEMS));
            clientViewProxy.preInvokeControlMethod(this.getKey(), "createCardView", new Object[]{this.clientMeta});
            List list = (List)this.clientMeta.get(ITEMS);
        } else {
            this.metaDataFormat();
        }
    }

    private void metaDataFormat() {
        IListModel listModel = this.parent.getListModel();
        NumberFormatProvider numberFormatProvider = listModel.getProvider().getQueryResult().getNumberFormatProvider();
        String primaryKey = String.format("%s.%s", this.parent.getEntityType().getName(), this.parent.getEntityType().getPrimaryKey().getName());
        for (ListField listField : listModel.getProvider().getListFields()) {
            if (!listField.isClient()) continue;
            this.setColumnProperty(listField.getListFieldKey(), "dataIndex", listField.getListFieldKey().toLowerCase().replace('.', '_'));
            if (listField.isSeq() || primaryKey.equalsIgnoreCase(listField.getListFieldKey())) {
                this.setColumnProperty(listField.getListFieldKey(), "entity", this.parent.getEntityType().getName());
                continue;
            }
            this.formatByField(numberFormatProvider, listField);
        }
    }

    private void formatByField(NumberFormatProvider numberFormatProvider, ListField listField) {
        FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.parent.getEntityType()), (String)listField.getListFieldKey());
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.parent.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), listField.getListFieldKey(), "FIELDNOTEXISTS000018")});
        }
        this.setColumnProperty(listField.getListFieldKey().toLowerCase().replace('.', '_'), "entity", filterField.getEntityKey());
        HashMap<String, Object> editor = new HashMap<String, Object>(4);
        if (filterField.getFieldProp() instanceof DecimalProp) {
            editor.put("type", "number");
            if (numberFormatProvider.getDecimalFieldMap().get(listField.getListFieldKey()) != null) {
                Map colType = (Map)numberFormatProvider.getDecimalFieldMap().get(listField.getListFieldKey());
                editor.put("nt", colType.get("nt"));
                editor.put("sf", colType.get("sf"));
            }
        } else if (filterField.getFieldProp() instanceof DateTimeProp) {
            editor.put("type", "datetime");
            if (filterField.getFieldProp() instanceof DateProp) {
                editor.put("type", "date");
            }
        } else if (filterField.getFieldProp() instanceof ComboProp) {
            editor.put("type", ((ComboProp)filterField.getFieldProp()).getClientType());
        }
        this.doDesen(filterField, editor);
        if (!editor.isEmpty()) {
            this.setColumnProperty(listField.getListFieldKey().toLowerCase().replace('.', '_'), EDITOR, editor);
        }
    }

    public void setColumnProperty(String fieldKey, String propertyName, Object value) {
        this.clientViewProxy.invokeControlMethod(this.key, "setCardFieldProp", new Object[]{fieldKey, propertyName, value});
    }

    public Map<String, Object> createClientConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.visible);
        }
        map.put("phide", this.paginationHide);
        map.put("type", "cardview");
        if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
            map.put(TOOLBAR_LOCATION, this.toolbarLocation);
        }
        map.put("pt", this.getPageType());
        if (!this.showNoDataTip) {
            map.put("shownodatatip", this.showNoDataTip);
        }
        return map;
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    @SimplePropertyAttribute
    public Map<String, Object> getClientMeta() {
        return this.clientMeta;
    }

    public void setClientMeta(Map<String, Object> clientMeta) {
        this.clientMeta = clientMeta;
    }

    @Override
    public void setParent(BillList parent) {
        this.parent = parent;
    }

    private void extendMetadata(List<Map<String, Object>> items, IListDataProvider provider) {
        if (items == null) {
            return;
        }
        NumberFormatProvider numberFormatProvider = provider.getQueryResult().getNumberFormatProvider();
        for (Map<String, Object> item : items) {
            String key = item.get(ORG_DATA_INDEX) != null ? (String)item.get(ORG_DATA_INDEX) : (String)item.get("dataIndex");
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                boolean isSeq = false;
                for (ListField listField : provider.getListFields()) {
                    if (!key.equalsIgnoreCase(listField.getListFieldKey()) || !listField.isSeq()) continue;
                    isSeq = true;
                    break;
                }
                if (isSeq) {
                    item.put("entity", this.parent.getEntityType().getName());
                } else {
                    this.extendByField(numberFormatProvider, item, key);
                }
                item.put("dataIndex", key.toLowerCase().replace('.', '_'));
                item.put(ORG_DATA_INDEX, key.toLowerCase());
            }
            this.extendMetadata((List)item.get(ITEMS), provider);
        }
    }

    private void extendByField(NumberFormatProvider numberFormatProvider, Map<String, Object> item, String key) {
        FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.parent.getEntityType()), (String)key);
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.parent.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), key, "FIELDNOTEXISTS000019")});
        }
        item.put("entity", filterField.getEntityKey());
        HashMap<String, Object> fieldEditor = new HashMap<String, Object>(4);
        if (numberFormatProvider != null && numberFormatProvider.getDecimalFieldMap().get(key) != null) {
            Map colType = (Map)numberFormatProvider.getDecimalFieldMap().get(key);
            fieldEditor.put("nt", colType.get("nt"));
            fieldEditor.put("sf", colType.get("sf"));
            fieldEditor.put("fieldstyle", Boolean.parseBoolean(item.get("sti").toString()) ? 0 : 1);
        }
        HashMap<String, Object> editor = (HashMap<String, Object>)item.get(EDITOR);
        if (filterField.getFieldProp() instanceof DecimalProp) {
            fieldEditor.put("type", "number");
        } else if (filterField.getFieldProp() instanceof DateTimeProp) {
            fieldEditor.put("type", "datetime");
            if (filterField.getFieldProp() instanceof DateProp) {
                fieldEditor.put("type", "date");
            }
        } else if (filterField.getFieldProp() instanceof ComboProp) {
            this.setComboEditor(item, (ComboProp)filterField.getFieldProp(), key, filterField.getLatestParent());
        } else if (filterField.getFieldProp() instanceof TimeProp) {
            fieldEditor.put("type", "time");
        }
        this.doDesen(filterField, fieldEditor);
        if (editor != null) {
            editor.putAll(fieldEditor);
        } else {
            editor = fieldEditor;
        }
        item.put(EDITOR, editor);
    }

    private void doDesen(FilterField filterField, Map<String, Object> fieldEditor) {
        String operateType = "LIST";
        IDataEntityProperty thisFieldProp = PrivacyCenterTools.isDesensitized((FilterField)filterField, (String)operateType);
        if (thisFieldProp != null) {
            String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)thisFieldProp, (String)operateType, null);
            boolean canShowDetail = false;
            if ("CLICKVIEW".equals(strategy)) {
                canShowDetail = true;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
            map.put("isprivacy", true);
            map.put("canshowdetail", canShowDetail);
            fieldEditor.put("privacy", map);
        }
    }

    private void setComboEditor(Map<String, Object> column, ComboProp combo, String listFieldKey, IDataEntityProperty srcFieldProp) {
        Map editor = (Map)column.get(EDITOR);
        String dataIndex = (String)column.get("dataIndex");
        int showStyle = column.get("showStyle") == null ? 0 : (Integer)column.get("showStyle");
        boolean isShowTitle = true;
        if (column.get("sti") != null) {
            isShowTitle = Boolean.parseBoolean(column.get("sti").toString());
        }
        Map<String, Object> createComboEditor = this.createComboEditor(combo, dataIndex, showStyle, isShowTitle, editor, srcFieldProp);
        column.put(EDITOR, createComboEditor);
    }

    private Map<String, Object> createComboEditor(ComboProp combo, String dataIndex, int showStyle, boolean isShowTitle, Map<String, Object> editor, IDataEntityProperty srcFieldProp) {
        Map<String, Object> toCreateEditor = null;
        int fieldStyle = isShowTitle ? 0 : 1;
        toCreateEditor = editor == null ? new HashMap<String, Object>() : editor;
        ViewCommonUtil.setComboListColumnEditor(showStyle, combo, toCreateEditor, srcFieldProp);
        this.setComboEditor(showStyle, fieldStyle, dataIndex, toCreateEditor);
        return toCreateEditor;
    }

    private void setComboEditor(int showStyle, int fieldStyle, String key, Map<String, Object> editor) {
        String s = key.substring(key.lastIndexOf(95) + 1);
        editor.put("s", s);
        editor.put("fieldstyle", fieldStyle);
        editor.put("showStyle", showStyle);
        List comboItems = (List)editor.get("st");
        switch (showStyle) {
            case 0: {
                for (List item : comboItems) {
                    item.set(2, null);
                }
                break;
            }
            case 1: {
                for (List item : comboItems) {
                    item.set(1, null);
                }
                break;
            }
        }
    }
}

