/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IBasedataField;
import kd.bos.filter.ListColumnCompareHelper;
import kd.bos.list.IListColumnConfig;

public class ListFlexDimension
implements IListColumnConfig {
    private static final String DEFAULT = "default";
    private String listFieldKey;
    private String fieldName;
    private String entityName;
    private final LocaleString caption;
    private String type = "text";
    private int seq;
    private int visible = 11;
    private String displayProp = null;
    private Map<String, Object> userConfigColumnSettings;

    public ListFlexDimension(IDataEntityProperty dataEntityProperty, String fieldName, String entityName, LocaleString caption, String type) {
        this.listFieldKey = dataEntityProperty.getName();
        if (dataEntityProperty instanceof IBasedataField) {
            this.displayProp = ((IBasedataField)dataEntityProperty).getDisplayProp();
        }
        this.fieldName = fieldName;
        this.entityName = entityName;
        this.caption = caption;
        this.type = type;
    }

    Map<String, Object> createColumn(MainEntityType entityType, Map<String, FilterField> filterFields, boolean isColumnFilter, Map<String, List<CompareType>> fieldCompareTypeMap) {
        HashMap<String, Object> column = new HashMap<String, Object>(16);
        column.put("entity", this.entityName);
        column.put("dataIndex", this.listFieldKey);
        column.put("header", this.caption);
        column.put("fieldName", this.fieldName);
        column.put("vi", this.getUserVisible());
        if (!DEFAULT.equals(this.getTextAlign())) {
            column.put("text-align", this.getTextAlign());
        }
        if (this.getUserFixed()) {
            column.put("isFixed", this.getUserFixed());
        }
        HashMap<String, String> editor = new HashMap<String, String>();
        editor.put("type", this.type);
        if (this.displayProp != null) {
            editor.put("dsp", this.displayProp);
        }
        column.put("editor", editor);
        column.put("sort", false);
        column.put("filter", isColumnFilter);
        FilterField filterField = filterFields.get(this.fieldName);
        if (isColumnFilter && filterField != null) {
            ArrayList<String> excludeCompareIds = new ArrayList<String>();
            excludeCompareIds.add("58");
            excludeCompareIds.add("803");
            excludeCompareIds.add("106");
            excludeCompareIds.add("83");
            excludeCompareIds.add("114");
            excludeCompareIds.add("801");
            excludeCompareIds.add("37");
            excludeCompareIds.add("806");
            excludeCompareIds.add("1103");
            excludeCompareIds.add("9");
            excludeCompareIds.add("807");
            excludeCompareIds.add("1104");
            ListColumnCompareHelper.setColumnCompareOperators((FilterField)filterField, column, fieldCompareTypeMap, (String)this.fieldName, (String)"text", null, null, excludeCompareIds, (boolean)false);
        }
        return column;
    }

    void setSeq(int seq) {
        this.seq = seq;
    }

    int getSeq() {
        return this.seq;
    }

    public String getListFieldKey() {
        return this.listFieldKey;
    }

    public LocaleString getCaption() {
        return this.caption;
    }

    public void setTextAlign(String textAlign) {
    }

    public String getTextAlign() {
        return DEFAULT;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    public int getVisible() {
        return this.visible;
    }

    public void setFixed(boolean isFixed) {
    }

    public boolean isFixed() {
        return false;
    }

    public void setUserConfigColumnSettings(Map<String, Object> userConfigColumnSetting) {
        this.userConfigColumnSettings = userConfigColumnSetting;
    }

    public Map<String, Object> getUserConfigColumnSettings() {
        return this.userConfigColumnSettings;
    }

    public boolean isHeaderField() {
        return false;
    }

    public LocaleString getEntityCaption() {
        return null;
    }
}

