/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.form.control.Control;
import kd.bos.form.events.ListColumnCompareTypesSetListener;
import kd.bos.list.AbstractListContainerColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.permission.api.FieldControlRule;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MergeListColumn
extends AbstractListContainerColumn {
    private String parentViewKey;
    private LocaleString caption;
    private boolean noDisplayScaleZero;
    private String sortFilterField;
    private List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners = new ArrayList<ListColumnCompareTypesSetListener>();

    public List<ListColumnCompareTypesSetListener> getListColumnCompareTypesSetListeners() {
        return this.listColumnCompareTypesSetListeners;
    }

    public void setListColumnCompareTypesSetListeners(List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners) {
        this.listColumnCompareTypesSetListeners = listColumnCompareTypesSetListeners;
    }

    @SdkInternal
    @SimplePropertyAttribute
    public String getSortFilterField() {
        return this.sortFilterField;
    }

    @SdkInternal
    public void setSortFilterField(String sortFilterField) {
        this.sortFilterField = sortFilterField;
    }

    @Override
    public String getParentViewKey() {
        return this.parentViewKey;
    }

    @Override
    public void setParentViewKey(String parentViewKey) {
        this.parentViewKey = parentViewKey;
    }

    @Override
    @SimplePropertyAttribute
    public LocaleString getCaption() {
        return this.caption;
    }

    public boolean isNoDisplayScaleZero() {
        return this.noDisplayScaleZero;
    }

    public void setNoDisplayScaleZero(boolean noDisplayScaleZero) {
        this.noDisplayScaleZero = noDisplayScaleZero;
    }

    @Override
    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @Override
    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map<String, Object> ctl = super.createColumn(entityType);
        List columns = this.getItems();
        for (Control col : columns) {
            if (col instanceof DecimalListColumn) {
                ((DecimalListColumn)col).setNoDisplayScaleZero(this.isNoDisplayScaleZero());
                continue;
            }
            if (!(col instanceof ListColumn) || !((ListColumn)col).getListFieldKey().equals(this.getSortFilterField())) continue;
            ((ListColumn)col).setListColumnCompareTypesSetListeners(this.listColumnCompareTypesSetListeners);
        }
        ctl.put("items", this.createColumns(entityType, this.decimalFieldMap));
        ctl.put("sff", StringUtils.isNotBlank((CharSequence)this.getSortFilterField()) ? this.getSortFilterField().replace('.', '_') : "");
        ctl.put("filter", StringUtils.isNotBlank((CharSequence)this.getSortFilterField()));
        ctl.put("sort", StringUtils.isNotBlank((CharSequence)this.getSortFilterField()));
        return ctl;
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        for (Control item : this.getItems()) {
            IListColumn listColumn = (IListColumn)item;
            listColumn.setContext(this.getContext());
            listColumn.addFieldSet(fieldSet, entityType, withoutDetailEntry, isListShowParameter, isLookUp);
            if (!StringUtils.isBlank((CharSequence)this.getEntityName())) continue;
            this.setHeaderField(listColumn.isHeaderField());
            this.setEntityName(listColumn.getEntityName());
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.setHeaderField(true);
            this.setEntityName(entityType.getName());
        }
        ArrayList listFields = new ArrayList();
        DynamicTextListField dynamicTextListField = new DynamicTextListField(this.getKey(), listFields, "");
        fieldSet.put(this.getKey(), (ListField)dynamicTextListField);
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        for (Control mergeControl : this.getItems()) {
            if (!(mergeControl instanceof IListColumn)) continue;
            IListColumn mergeColumn = (IListColumn)mergeControl;
            if (!fieldControlRule.getCanNotReadFields().contains(mergeColumn.getListFieldKey().split("\\.")[0])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getBizType() {
        return "combinedField";
    }

    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        return new ArrayList<Map<String, Object>>(0);
    }
}

