/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.list.AbstractList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MulBdPermUtil;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobF7SelectedList
extends AbstractList {
    private static final String MOB_F7_SELECTED_LIST_0 = "MobF7SelectedList_0";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String ADD_ITEMS = "addItems";
    private static final String REMOVE_ITEM = "removeItem";
    protected List<F7SelectedListRemoveListener> f7SelectedListRemoveListeners = new ArrayList<F7SelectedListRemoveListener>();

    public void addF7SelectedListRemoveListener(F7SelectedListRemoveListener listener) {
        this.f7SelectedListRemoveListeners.add(listener);
    }

    public void addItems(List<Object> items) {
        ArrayList<Object> pks = new ArrayList<Object>(items.size());
        for (Object row : items) {
            pks.add(((Map)row).get("id"));
        }
        IFormView formView = this.getView().getParentView();
        this.getView().getFormShowParameter().setCustomParam("originFieldKey", formView.getFormShowParameter().getCustomParam("originFieldKey"));
        String parentFormId = formView.getFormShowParameter().getParentFormId();
        if (parentFormId.endsWith("_mob")) {
            FormConfig mobileConfig = FormMetadataCache.getFormConfig((String)parentFormId);
            parentFormId = mobileConfig.getEntityTypeId();
        }
        this.getView().getFormShowParameter().setCustomParam("originUseOrg", (Object)((ListShowParameter)formView.getFormShowParameter()).getUseOrgId());
        this.getView().getFormShowParameter().setCustomParam("originFormId", (Object)parentFormId);
        MulBdPermUtil.setAuthorizedData(this.getView(), this.getKey(), pks);
        this.clientViewProxy.invokeControlMethod(this.getKey(), ADD_ITEMS, new Object[]{items});
    }

    public void removeItem(Object param) {
        try {
            for (F7SelectedListRemoveListener clickListener : this.f7SelectedListRemoveListeners) {
                F7SelectedListRemoveEvent evt = new F7SelectedListRemoveEvent((Object)this, param);
                clickListener.RemoveClick(evt);
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), REMOVE_ITEM, new Object[]{param});
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)MOB_F7_SELECTED_LIST_0, (String)BOS_FORM_CORE, (Object[])new Object[0]), e.getMessage()));
        }
    }

    @SdkInternal
    public void onClose() {
        this.view.close();
    }
}

