/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;

public final class QueryBuilderSelectFields {
    private EntityType entityType;

    public QueryBuilderSelectFields(EntityType entityType) {
        this.entityType = entityType;
    }

    String getPropName(ListField listField) {
        IDataEntityProperty srcFieldProp = this.getSrcFieldProp(listField);
        return this.getPropName(listField, srcFieldProp);
    }

    public String getPropName(ListField listField, IDataEntityProperty srcFieldProp) {
        String propName;
        if (srcFieldProp instanceof ISimpleProperty) {
            propName = listField.getFieldName();
        } else if (srcFieldProp instanceof IComplexProperty) {
            propName = FilterField.buildPropORMFullName((IDataEntityProperty)srcFieldProp);
            propName = this.getQueryEntityTypePropName(listField, propName);
        } else if (srcFieldProp instanceof ICollectionProperty) {
            propName = FilterField.buildPropORMFullName((IDataEntityProperty)srcFieldProp);
            propName = this.getQueryEntityTypePropName(listField, propName);
        } else {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%2$s", (String)"QueryBuilderFactory_1", (String)"bos-form-mvc", (Object[])new Object[0]), listField.getFieldName(), "FIELDNOTEXISTS000021")});
        }
        return propName;
    }

    private String getQueryEntityTypePropName(ListField listField, String propName) {
        int i = listField.getListFieldKey().indexOf(propName);
        if (this.entityType instanceof QueryEntityType && i > -1) {
            propName = listField.getListFieldKey().substring(0, i) + propName;
        }
        return propName;
    }

    public IDataEntityProperty getSrcFieldProp(ListField listField) {
        Object srcFieldProp = listField.isSeq() ? new DynamicSimpleProperty(listField.getFieldName(), Integer.class, (Object)0) : QueryBuilderSelectFields.getSelectProp(this.entityType, listField.getFieldName());
        if (QueryBuilderSelectFields.isNotValidField(listField, srcFieldProp)) {
            return null;
        }
        return srcFieldProp;
    }

    public static boolean isNotValidField(ListField listField, IDataEntityProperty srcFieldProp) {
        return srcFieldProp == null || StringUtils.isEmpty((CharSequence)srcFieldProp.getAlias()) && !listField.isSeq() || srcFieldProp.getParent() instanceof EntryType && StringUtils.isEmpty((CharSequence)srcFieldProp.getParent().getAlias()) || srcFieldProp.getParent() != null && srcFieldProp.getParent().getParent() != null && srcFieldProp.getParent().getParent() instanceof EntryType && StringUtils.isEmpty((CharSequence)srcFieldProp.getParent().getParent().getAlias());
    }

    public static IDataEntityProperty getSelectProp(EntityType dt, String key) {
        Object prop;
        String[] keys = key.split("\\.");
        if (keys.length > 1) {
            prop = dt.findProperty(keys[0]);
            if (prop instanceof EntryProp) {
                if ((prop = (IDataEntityProperty)((ICollectionProperty)prop).getItemType().getProperties().get((Object)keys[1])) instanceof SubEntryProp) {
                    prop = (IDataEntityProperty)((SubEntryProp)prop).getItemType().getProperties().get((Object)keys[2]);
                }
            } else if (prop instanceof JoinProperty) {
                MainEntityType mainEntityType = (MainEntityType)((JoinProperty)prop).getDynamicComplexPropertyType();
                if ((prop = mainEntityType.findProperty(keys[1])) instanceof BasedataProp) {
                    prop = (IDataEntityProperty)((BasedataProp)prop).getComplexType().getProperties().get((Object)keys[2]);
                } else if (prop instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)prop;
                    EntryType entryType = (EntryType)entryProp.getDynamicCollectionItemPropertyType();
                    prop = "id".equals(keys[2]) ? mainEntityType.findProperty(entryType.getName() + ".id") : entryType.findProperty(keys[2]);
                }
            }
            if (prop == null) {
                prop = dt.findProperty(key);
            }
        } else {
            prop = dt.getPrimaryKey().getName().equals(key) ? dt.getPrimaryKey() : dt.findProperty(key);
        }
        return prop;
    }
}

