/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.plugin;

import java.util.function.Consumer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.ListExpandEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.ListRowFilterEvent;
import kd.bos.list.events.SetCellFieldValueArgs;
import kd.bos.list.events.SetCellsDataEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractListViewPluginProxy
extends FormViewPluginProxy {
    public static final String TOOLBARID = "toolbarap";
    private static final String SPAN_TYPE_PLUGIN = "plugin";

    private void invokeListMethod(Consumer<IFormPlugin> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IFormPlugin pl : this.plugIns) {
            if (!this.isNotOverride(pl.getClass(), methodName, parameterTypes) || !(pl instanceof IListPlugin)) continue;
            consumer.accept(pl);
        }
    }

    public void fireBeforeShowBill(BeforeShowBillFormEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeShowBill"), (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                ((IListPlugin)plugin).beforeShowBill(e);
            }
        }, "beforeShowBill", BeforeShowBillFormEvent.class);
    }

    public void fireBillClosedCallBack(BillClosedCallBackEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".billClosedCallBack"));){
                ((IListPlugin)plugin).billClosedCallBack(e);
            }
        }, "billClosedCallBack", BillClosedCallBackEvent.class);
    }

    public void fireBeforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeCreateListDataProvider"));){
                ((IListPlugin)plugin).beforeCreateListDataProvider(args);
            }
        }, "beforeCreateListDataProvider", BeforeCreateListDataProviderArgs.class);
    }

    public void fireBeforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeCreateListColumns"));){
                ((IListPlugin)plugin).beforeCreateListColumns(args);
            }
        }, "beforeCreateListColumns", BeforeCreateListColumnsArgs.class);
    }

    public void fireBillListHyperLinkClick(HyperLinkClickArgs args) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".billListHyperLinkClick"));){
                ((IListPlugin)plugin).billListHyperLinkClick(args);
            }
        }, "billListHyperLinkClick", HyperLinkClickArgs.class);
    }

    public void fireSetFilter(SetFilterEvent args) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".setFilter"));){
                ((IListPlugin)plugin).setFilter(args);
            }
        }, "setFilter", SetFilterEvent.class);
    }

    public void fireListRowClick(ListRowClickEvent evt) {
        this.invokeMethod(plugin -> {
            if (plugin instanceof ListRowClickListener) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".listRowClick"));){
                    ((ListRowClickListener)plugin).listRowClick(evt);
                }
            }
        }, "listRowClick", new Class[]{ListRowClickEvent.class});
    }

    public void fireBeforePackageData(BeforePackageDataEvent evt) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforePackageData"));){
                ((IListPlugin)plugin).beforePackageData(evt);
            }
        }, "beforePackageData", BeforePackageDataEvent.class);
    }

    public void firePackageData(PackageDataEvent evt) {
        this.invokeListMethod(plugin -> ((IListPlugin)plugin).packageData(evt), "packageData", PackageDataEvent.class);
    }

    public void fireChat(ChatEvent evt) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".chat"));){
                ((IListPlugin)plugin).chat(evt);
            }
        }, "chat", ChatEvent.class);
    }

    public void fireListExpandClick(ListExpandEvent evt) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".expandClick"));){
                ((IListPlugin)plugin).expandClick(evt);
            }
        }, "expandClick", ListExpandEvent.class);
    }

    public void fireListHyperLinkClick(ListHyperLinkClickEvent evt) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".hyperLinkClick"));){
                ((IListPlugin)plugin).hyperLinkClick(evt);
            }
        }, "hyperLinkClick", ListHyperLinkClickEvent.class);
    }

    public void fireToolbarItemClick() {
        this.fireToolbarItemClick(TOOLBARID);
    }

    public void fireToolbarItemClick(String key) {
        this.invokeMethod(plugin -> {
            if (plugin instanceof AbstractListPlugin) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".addItemClickListeners"));){
                    ((AbstractListPlugin)plugin).addItemClickListeners(new String[]{key});
                }
            }
        }, "addItemClickListeners", new Class[]{String.class});
    }

    public void fireCellFieldValue(SetCellFieldValueArgs args) {
        this.invokeListMethod(plugin -> ((IListPlugin)plugin).setCellFieldValue(args), "setCellFieldValue", SetCellFieldValueArgs.class);
    }

    public void fireBeforeQueryOfExport(BeforeQueryOfExportEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeQueryOfExport"));){
                ((IListPlugin)plugin).beforeQueryOfExport(e);
            }
        }, "beforeQueryOfExport", BeforeQueryOfExportEvent.class);
    }

    public void fireAfterQueryOfExport(AfterQueryOfExportEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterQueryOfExport"));){
                ((IListPlugin)plugin).afterQueryOfExport(e);
            }
        }, "afterQueryOfExport", AfterQueryOfExportEvent.class);
    }

    public void fireBeforeExportFile(BeforeExportFileEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".beforeExportFile"));){
                ((IListPlugin)plugin).beforeExportFile(e);
            }
        }, "beforeExportFile", BeforeExportFileEvent.class);
    }

    public void fireAfterExportFile(ExportFileEvent e) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".afterExportFile"));){
                ((IListPlugin)plugin).afterExportFile(e);
            }
        }, "afterExportFile", ExportFileEvent.class);
    }

    public void fireBeforeDesensitive(SensitiveArgs args) {
        this.invokeListMethod(plugin -> ((IListPlugin)plugin).beforeDesensitive(args), "beforeDesensitive", SensitiveArgs.class);
    }

    public void fireListRowFilter(ListRowFilterEvent evt) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".listRowFilter"));){
                ((IListPlugin)plugin).listRowFilter(evt);
            }
        }, "listRowFilter", ListRowFilterEvent.class);
    }

    public void fireSetCellsData(SetCellsDataEvent event) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getPluginName() + ".setCellsData"));){
                ((IListPlugin)plugin).setCellsData(event);
            }
        }, "setCellsData", SetCellsDataEvent.class);
    }

    public void fireBillListGetEntityTypeListener(GetEntityTypeEventArgs args) {
        this.invokeListMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(plugin.getClass().getName() + ".billListGetEntityType"));){
                ((IListPlugin)plugin).billListGetEntityType(args);
            }
        }, "fireBillListGetEntityType", GetEntityTypeEventArgs.class);
    }
}

