/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareCategory;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.container.Container;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.filter.FilterColumnAp;

public abstract class CustomFilterColumnAp
extends FilterColumnAp {
    private boolean multi = true;
    private boolean commonFilterColumn = false;
    private boolean mustInput;
    private String defValue;
    private static Map<String, FieldProp> fieldProps = new HashMap<String, FieldProp>();

    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="true")
    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean isMulti) {
        this.multi = isMulti;
    }

    @SimplePropertyAttribute(name="MustInput")
    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean value) {
        this.mustInput = value;
    }

    public boolean isCommonFilterColumn() {
        return this.commonFilterColumn;
    }

    public void setCommonFilterColumn(boolean isCommonFilterColumn) {
        this.commonFilterColumn = isCommonFilterColumn;
    }

    @Override
    protected FilterColumn createRuntimeControl() {
        return this.commonFilterColumn ? new CommonFilterColumn() : new SchemeFilterColumn();
    }

    @Override
    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        if (this.isCommonFilterColumn()) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)ctl;
            filterColumn.setType(this.getType());
            filterColumn.setFieldName(StringUtils.isBlank((CharSequence)this.getFieldName()) ? this.getKey() : this.getFieldName());
            filterColumn.setMustInput(this.mustInput);
            filterColumn.setMulti(this.multi);
            filterColumn.setDefValue(this.defValue);
        } else {
            SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)ctl;
            schemeFilterColumn.setType(this.getType());
            schemeFilterColumn.setFieldName(StringUtils.isBlank((CharSequence)this.getFieldName()) ? this.getKey() : this.getFieldName());
        }
    }

    public static List<CompareType> getCompareTypeList(String type) {
        FieldProp fieldProp = fieldProps.get(type);
        if (fieldProp == null) {
            return null;
        }
        for (CompareCategory compareCategory : FilterMetadata.get().getCompareCategories()) {
            if (!compareCategory.getId().equalsIgnoreCase(fieldProp.getCompareGroupID())) continue;
            List compareTypeList = compareCategory.getCompareTypes();
            ArrayList<CompareType> compareTypes = new ArrayList<CompareType>(10);
            for (CompareType compareType : compareTypeList) {
                CompareType rCompareType = new CompareType();
                rCompareType.setId(compareType.getId());
                rCompareType.setName(compareType.getName());
                rCompareType.setNeedInput(compareType.isNeedInput());
                rCompareType.setInputCtlType(compareType.getInputCtlType());
                compareTypes.add(rCompareType);
            }
            return compareTypes;
        }
        return null;
    }

    public abstract Field<?> createField();

    protected void setFieldProp(Field<?> field) {
        field.setKey(this.getKey());
        field.setId(this.getId());
        field.setName(this.getName());
    }

    protected abstract String getType();

    static {
        fieldProps.put("enum", (FieldProp)new TextProp());
        fieldProps.put("text", (FieldProp)new TextProp());
        fieldProps.put("number", (FieldProp)new DecimalProp());
        fieldProps.put("date", (FieldProp)new DateProp());
        fieldProps.put("basedata", (FieldProp)new LongProp());
    }
}

