/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.list;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.MulCurrencyField;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.container.Container;
import kd.bos.list.BillList;
import kd.bos.list.FieldSort;
import kd.bos.list.MulCurrencyFields;
import kd.bos.list.SummaryFieldIds;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.IBillListAp;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.metadata.list.ListRuntimeMetaBuilder;
import kd.bos.metadata.list.MergeListColumnAp;
import kd.bos.metadata.list.QingViewAp;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillListAp
extends ContainerAp<BillList>
implements IBillListAp {
    public static final String GENLISTID = "_BillList_";
    private static final String ENTITYDESIGN_TABLE = "T_META_ENTITYDESIGN";
    private static final String HAS_FILTER = "hasFilter";
    public static final String BOS_METADATA = "bos-metadata";
    private String queryType = "0";
    private boolean defaultOrder = true;
    private List<FieldSort> sortSetting = new ArrayList<FieldSort>();
    private boolean selectedAll = true;
    private transient FilterCondition filter;
    private String summaryFieldId;
    private SummaryFieldIds summaryFieldIds;
    private boolean hasFilter = false;
    private boolean multi = true;
    private int pageRow = 20;
    private String defaultView;
    private MulCurrencyFields mulCurrencyFields;
    private String entityId;
    private Tips ctlTips;
    private LocaleString busyTip;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    @SimplePropertyAttribute(name="DefaultOrder")
    @DefaultValueAttribute(value="true")
    public boolean isDefaultOrder() {
        return this.defaultOrder;
    }

    public void setDefaultOrder(boolean defaultOrder) {
        this.defaultOrder = defaultOrder;
    }

    @CollectionPropertyAttribute(name="SortSetting", collectionItemPropertyType=FieldSort.class)
    public List<FieldSort> getSortSetting() {
        return this.sortSetting;
    }

    public void setSortSetting(List<FieldSort> sortSetting) {
        this.sortSetting = sortSetting;
    }

    @SimplePropertyAttribute(name="SelectedAll")
    @DefaultValueAttribute(value="true")
    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    public void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    @ComplexPropertyAttribute
    public FilterCondition getFilter() {
        return this.filter;
    }

    public void setFilter(FilterCondition filter) {
        this.filter = filter;
    }

    @SimplePropertyAttribute
    public String getSummaryFieldId() {
        return this.summaryFieldId;
    }

    public void setSummaryFieldId(String summaryFieldId) {
        this.summaryFieldId = summaryFieldId;
    }

    @ComplexPropertyAttribute
    public SummaryFieldIds getSummaryFieldIds() {
        return this.summaryFieldIds;
    }

    public void setSummaryFieldIds(SummaryFieldIds summaryFieldIds) {
        this.summaryFieldIds = summaryFieldIds;
    }

    @SimplePropertyAttribute(name="HasFilter")
    @DefaultValueAttribute(value="false")
    public boolean isHasFilter() {
        return this.hasFilter;
    }

    public void setHasFilter(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="true")
    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="20")
    public int getPageRow() {
        return this.pageRow;
    }

    public void setPageRow(int pageRow) {
        this.pageRow = pageRow;
    }

    @SimplePropertyAttribute
    public String getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public BillList createRuntimeControl() {
        return new BillList();
    }

    @ComplexPropertyAttribute
    public MulCurrencyFields getMulCurrencyFields() {
        return this.mulCurrencyFields;
    }

    public void setMulCurrencyFields(MulCurrencyFields mulCurrencyFields) {
        this.mulCurrencyFields = mulCurrencyFields;
    }

    protected void setRuntimeSimpleProperties(Container ctl) {
        this.checkDeletedField();
        if (this.getMulCurrencyFields() != null) {
            List<MulCurrencyField> mulCurrencyFieldsList = this.getMulCurrencyFields().getMulCurrencyFields();
            ArrayList<MulCurrencyField> finalMulCurrencyFieldsList = new ArrayList<MulCurrencyField>(mulCurrencyFieldsList.size());
            for (MulCurrencyField mulCurrencyField : mulCurrencyFieldsList) {
                Field fieldByKey;
                if (mulCurrencyField.getFieldName() == null || !((fieldByKey = this.formMetadata.getEntityMetadata().getFieldByKey(mulCurrencyField.getFieldName())) instanceof AmountField) || fieldByKey.getControlField() == null) continue;
                finalMulCurrencyFieldsList.add(mulCurrencyField);
            }
            this.getMulCurrencyFields().setMulCurrencyFields(finalMulCurrencyFieldsList);
        }
        super.setRuntimeSimpleProperties(ctl);
        BillList billList = (BillList)ctl;
        if (this.entityId != null) {
            billList.setEntityId(MetadataDao.getEntityNumberById((String)this.entityId));
        }
        billList.setPageRow(this.pageRow);
        if (StringUtils.isNotBlank((CharSequence)this.defaultView) && this.formMetadata.getItem(this.defaultView) != null) {
            ControlAp item = this.formMetadata.getItem(this.defaultView);
            billList.setDefaultView(item.getKey());
        }
        if (this.hasFilter) {
            billList.setHasFilter(this.hasFilter);
        }
        if (this.getCtlTips() != null) {
            billList.setCtlTips(this.getCtlTips());
        }
        billList.setFilter(this.getFilter());
        billList.setSummaryFieldId(this.getSummaryFieldId());
        billList.setSummaryFieldIds(this.getSummaryFieldIds());
        billList.setMulti(this.isMulti());
        billList.setSelectedAll(this.isSelectedAll());
        billList.setQueryType(this.getQueryType());
        billList.setDefaultOrder(this.isDefaultOrder());
        billList.setSortSetting(this.getSortSetting());
        billList.setMulCurrencyFields(this.getMulCurrencyFields());
    }

    @SimplePropertyAttribute
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getBusyTip() {
        return this.busyTip;
    }

    public void setBusyTip(LocaleString busyTip) {
        this.busyTip = busyTip;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        ctl.put("type", "advgrid");
        ctl.put("rk", "rk");
        ctl.put("seq", "fseq");
        if (!this.isMulti()) {
            ctl.put("ismul", false);
        }
        ctl.put("defv", this.getDefaultView());
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (this.hasFilter) {
            ctl.put(HAS_FILTER, this.hasFilter);
        }
        if (this.getBusyTip() != null) {
            ctl.put("busyTip", this.getBusyTip());
        }
        return ctl;
    }

    private String getEntityNumberById(String id) {
        String sql = String.format("select FNumber from %s where FId = ? ", ENTITYDESIGN_TABLE);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        String val = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String sFdata = null;
                try {
                    if (rs.next()) {
                        sFdata = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return sFdata;
            }
        });
        if (StringUtils.isBlank((CharSequence)val)) {
            val = "";
        }
        return val;
    }

    private void checkDeletedField() {
        HashSet<String> errorMsg = new HashSet<String>();
        ArrayList<String> listFieldIds = new ArrayList<String>();
        for (ControlAp viewAp : this.getItems()) {
            if (!(viewAp instanceof ListGridViewAp) || viewAp instanceof QingViewAp) continue;
            for (ControlAp ap : ((ListGridViewAp)viewAp).getItems()) {
                if (ap instanceof ListColumnAp) {
                    listFieldIds.add(((ListColumnAp)ap).getListFieldId());
                    continue;
                }
                if (!(ap instanceof MergeListColumnAp) && !(ap instanceof ListColumnGroupAp)) continue;
                this.traverseGetSubControl((ContainerAp)ap, listFieldIds);
            }
        }
        HashMap baseDataFieldRef = new HashMap();
        for (FieldSort fieldSort : this.getSortSetting()) {
            boolean isDeleted = true;
            for (String listField : listFieldIds) {
                if (!listField.equals(fieldSort.getFieldName())) continue;
                isDeleted = false;
                break;
            }
            if (!isDeleted) continue;
            String fieldName = fieldSort.getFieldName();
            String[] fieldNameArray = fieldName.split("\\.");
            if (fieldNameArray.length > 1) {
                StringBuilder fullFieldName = new StringBuilder();
                if (baseDataFieldRef.containsKey(fieldName)) {
                    fullFieldName.append(baseDataFieldRef.get(fieldName));
                } else {
                    BasedataField basedataField = (BasedataField)this.formMetadata.getEntityMetadata().getFieldByKey(fieldNameArray[0]);
                    List entityTreeNodes = basedataField.createEntityTreeNodes(true, fieldNameArray.length);
                    for (Map entityTreeNode : entityTreeNodes) {
                        baseDataFieldRef.put(entityTreeNode.get("Id").toString(), entityTreeNode.get("Name"));
                    }
                    fullFieldName.append(baseDataFieldRef.get(fieldName));
                }
                fullFieldName.insert(0, ResManager.loadKDString((String)"\u201c", (String)"Sign_0", (String)BOS_METADATA, (Object[])new Object[0]));
                fullFieldName.append(fieldName);
                fullFieldName.append(ResManager.loadKDString((String)"\u201d", (String)"Sign_1", (String)BOS_METADATA, (Object[])new Object[0]));
                errorMsg.add(fullFieldName.toString());
                continue;
            }
            Field fieldByKey = this.formMetadata.getEntityMetadata().getFieldByKey(fieldName);
            errorMsg.add(ResManager.loadKDString((String)"\u201c", (String)"Sign_0", (String)BOS_METADATA, (Object[])new Object[0]) + fieldByKey.getName() + fieldName + ResManager.loadKDString((String)"\u201d", (String)"Sign_1", (String)BOS_METADATA, (Object[])new Object[0]));
        }
        if (!errorMsg.isEmpty()) {
            this.formMetadata.getEntityMetadata().addError(new ErrorInfo(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010\u6392\u5e8f\u8bbe\u7f6e\u3011\u4e2d\u5220\u9664\u8be5\u5b57\u6bb5\u3002", (String)"BillListAp_0", (String)BOS_METADATA, (Object[])new Object[0]), String.join((CharSequence)ResManager.loadKDString((String)"\u3001", (String)"Sign_2", (String)BOS_METADATA, (Object[])new Object[0]), errorMsg))));
        }
    }

    private void traverseGetSubControl(ContainerAp<?> containerAp, List<String> listFieldIds) {
        for (ControlAp subControlAp : containerAp.getItems()) {
            if (subControlAp instanceof MergeListColumnAp || subControlAp instanceof ListColumnGroupAp) {
                this.traverseGetSubControl((ContainerAp)subControlAp, listFieldIds);
                continue;
            }
            if (!(subControlAp instanceof ListColumnAp)) continue;
            listFieldIds.add(((ListColumnAp)subControlAp).getListFieldId());
        }
    }

    public void buildList(FormMetadata ownerMeta, FormMetadata listMeta, List<RuntimeFormMeta> metas, String runtimeVersion) {
        ListRuntimeMetaBuilder.buildList(ownerMeta, listMeta, metas, runtimeVersion);
    }

    public void buildMobList(FormMetadata ownerMeta, FormMetadata listMeta, List<RuntimeFormMeta> metas, String runtimeVersion) {
        ListRuntimeMetaBuilder.buildMobList(ownerMeta, listMeta, metas, runtimeVersion);
    }
}

