/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.rule.ClientBR;
import kd.bos.entity.rule.RuleUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.ListColumn;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.ICardRowPanelAp;
import kd.bos.metadata.form.rule.ClientRule;
import kd.bos.metadata.list.ListColumnAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CardRowPanelAp
extends ContainerAp<Container>
implements ICardRowPanelAp {
    private String direction = "row";
    private boolean wrap = true;
    private String imgBKFieldId;
    private boolean showSelector;
    private int selectStyle;
    @Deprecated
    private boolean pointerCursor;
    private List<ClientRule> clientRules = new ArrayList<ClientRule>();

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="row")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @SimplePropertyAttribute(name="Wrap")
    @DefaultValueAttribute(value="true")
    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean warp) {
        this.wrap = warp;
    }

    @SimplePropertyAttribute
    public String getBKImgFieldId() {
        return this.imgBKFieldId;
    }

    public void setBKImgFieldId(String imgFieldId) {
        this.imgBKFieldId = imgFieldId;
    }

    @SimplePropertyAttribute(name="ShowSelector")
    public boolean isShowSelector() {
        return this.showSelector;
    }

    public void setShowSelector(boolean isshowSelector) {
        this.showSelector = isshowSelector;
    }

    @SimplePropertyAttribute(name="SelectStyle")
    public int getSelectStyle() {
        return this.selectStyle;
    }

    public void setSelectStyle(int selectStyle) {
        this.selectStyle = selectStyle;
    }

    @Deprecated
    @SimplePropertyAttribute(name="PointerCursor")
    public boolean isPointerCursor() {
        return this.pointerCursor;
    }

    @Deprecated
    public void setPointerCursor(boolean pointerCursor) {
        this.pointerCursor = pointerCursor;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ClientRule.class)
    public List<ClientRule> getClientRules() {
        return this.clientRules;
    }

    public void setClientRules(List<ClientRule> clientRules) {
        this.clientRules = clientRules;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        ctl.put("type", "cardrowpanel");
        ctl.put("dr", this.direction);
        ctl.put("wr", this.wrap);
        if (StringUtils.isNotBlank((CharSequence)this.getBKImgFieldId())) {
            ctl.put("bkimgfield", this.getBKImgFieldId().toLowerCase());
        }
        if (this.isShowSelector()) {
            ctl.put("showsel", true);
        }
        if (this.selectStyle > 1) {
            ctl.put("selectstyle", this.selectStyle);
        }
        if (this.isPointerCursor()) {
            ctl.put("pointercursor", true);
        }
        if (this.clientRules != null && !this.clientRules.isEmpty()) {
            ArrayList<Map> rules = new ArrayList<Map>();
            Map<String, String> feildIds = this.getListFieldIds();
            for (ClientRule rule : this.clientRules) {
                rules.add(RuleUtils.parseRules((ClientBR)rule.buildEntityRule(null), feildIds));
            }
            ctl.put("rules", SerializationUtils.toJsonString(rules));
        }
        return ctl;
    }

    protected void buildRuntimeChildControls(Container ctl) {
        super.buildRuntimeChildControls(ctl);
        if (StringUtils.isNotBlank((CharSequence)this.getBKImgFieldId())) {
            this.addColumn(ctl, this.getBKImgFieldId().toLowerCase(Locale.ENGLISH));
        }
        String[] cols = this.getExtraColumns(this.clientRules);
        Container panel = this.getColumnContainer(ctl);
        if (cols != null && cols.length > 0) {
            for (int i = 0; i < cols.length; ++i) {
                this.addColumn(panel, cols[i]);
            }
        }
    }

    private Container getColumnContainer(Container panel) {
        for (Control ctl : panel.getItems()) {
            if (!(ctl instanceof Container)) continue;
            return (Container)ctl;
        }
        Container c = new Container();
        panel.getItems().add(c);
        return c;
    }

    String[] getExtraColumns(List<ClientRule> rules) {
        HashSet<String> cols = new HashSet<String>();
        if (rules != null && !rules.isEmpty()) {
            for (int i = 0; i < rules.size(); ++i) {
                ClientRule rule = rules.get(i);
                String cond = rule.getPreCondition();
                String[] vars = RuleUtils.getConditionFields((String)cond);
                for (int j = 0; j < vars.length; ++j) {
                    cols.add(vars[j]);
                }
            }
        }
        return cols.toArray(new String[cols.size()]);
    }

    void addColumn(Container list, String fld) {
        for (Control ctl : list.getItems()) {
            if (!ctl.getKey().equals(fld)) continue;
            return;
        }
        ListColumn listColumn = new ListColumn();
        listColumn.setListFieldKey(fld);
        listColumn.setKey(fld);
        list.getItems().add(listColumn);
    }

    private Map<String, String> getListFieldIds() {
        FormMetadata formMeta = this.formMetadata;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        List controlAps = formMeta.getItems();
        for (ControlAp ap : controlAps) {
            if (!(ap instanceof ListColumnAp)) continue;
            ListColumnAp listColumnAp = (ListColumnAp)ap;
            keyMap.put(listColumnAp.getKey(), listColumnAp.getListFieldId());
        }
        return keyMap;
    }
}

