/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.list.ListCardView;
import kd.bos.metadata.entity.commonfield.LongPressItem;
import kd.bos.metadata.form.ContainerAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListCardViewAp
extends ContainerAp<ListCardView> {
    public static final String GENLISTID = "cardview";
    private boolean paginationHide;
    private boolean pullRefresh;
    private int layoutStyle = 1;
    private boolean pointer;
    private String direction = "row";
    private boolean wrap = true;
    private String toolbarLocation = "-1";
    private boolean showNoDataTip = true;
    private List<LongPressItem> longPressItems = new ArrayList<LongPressItem>();
    private String pageType = "";

    @CollectionPropertyAttribute(collectionItemPropertyType=LongPressItem.class, name="LongPressOperation")
    public List<LongPressItem> getLongPressItems() {
        return this.longPressItems;
    }

    public void setLongPressItems(List<LongPressItem> longPressItems) {
        this.longPressItems = longPressItems;
    }

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="row")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @SimplePropertyAttribute(name="Wrap")
    @DefaultValueAttribute(value="true")
    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean warp) {
        this.wrap = warp;
    }

    @SimplePropertyAttribute(name="Pointer")
    public boolean isPointer() {
        return this.pointer;
    }

    public void setPointer(boolean pointer) {
        this.pointer = pointer;
    }

    @SimplePropertyAttribute(name="PaginationHide")
    public boolean isPaginationHide() {
        return this.paginationHide;
    }

    public void setPaginationHide(boolean paginationHide) {
        this.paginationHide = paginationHide;
    }

    @SimplePropertyAttribute(name="PullRefresh")
    public boolean isPullRefresh() {
        return this.pullRefresh;
    }

    public void setPullRefresh(boolean pullRefresh) {
        this.pullRefresh = pullRefresh;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default,lookup,init,new,edit,view,submit,audit")
    public String getVisible() {
        return this.visible;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    public void setVisible(String visible) {
        this.visible = visible == null ? "default,lookup,init,new,edit,view,submit,audit" : visible;
    }

    public ListCardViewAp() {
        this.visible = "default,lookup,init,new,edit,view,submit,audit";
    }

    @SimplePropertyAttribute
    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    public void setLayoutStyle(int cols) {
        this.layoutStyle = cols;
    }

    @SimplePropertyAttribute(name="ShowNoDataTip")
    @DefaultValueAttribute(value="true")
    public boolean isShowNoDataTip() {
        return this.showNoDataTip;
    }

    public void setShowNoDataTip(boolean showNoDataTip) {
        this.showNoDataTip = showNoDataTip;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        ctl.put("type", GENLISTID);
        ctl.put("cardtype", "listcard");
        ctl.put("phide", this.paginationHide);
        ctl.put("rk", "rk");
        ctl.put("ls", this.layoutStyle);
        ctl.put("pt", this.getPageType());
        if (this.pullRefresh) {
            ctl.put("pr", this.pullRefresh);
        }
        ctl.put("dr", this.direction);
        ctl.put("wr", this.wrap);
        if (this.pointer) {
            ctl.put("point", this.pointer);
        }
        if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
            ctl.put("tl", this.toolbarLocation);
        }
        if (!this.showNoDataTip) {
            ctl.put("shownodatatip", this.showNoDataTip);
        }
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            ctl.put("vi", this.getVisibleValue());
        }
        List<LongPressItem> items = this.getLongPressItems();
        ArrayList<Map> list = new ArrayList<Map>(items.size());
        for (LongPressItem item : items) {
            Map control = item.createControl();
            list.add(control);
        }
        ctl.put("longPressInvokeAction", list);
        return ctl;
    }

    public ListCardView createRuntimeControl() {
        return new ListCardView();
    }

    protected void setRuntimeSimpleProperties(Container ctl) {
        ListCardView cardView;
        super.setRuntimeSimpleProperties(ctl);
        if (StringUtils.equals((CharSequence)GENLISTID, (CharSequence)this.getKey())) {
            cardView = (ListCardView)ctl;
            cardView.setClientMeta(this.createControl());
        }
        cardView = (ListCardView)ctl;
        cardView.setVisible(this.getVisibleValue());
        cardView.setPaginationHide(this.isPaginationHide());
        cardView.setPageType(this.getPageType());
        cardView.setShowNoDataTip(this.isShowNoDataTip());
    }
}

