/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.rule.ClientBR;
import kd.bos.form.container.Container;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.metadata.entity.rule.BizRuleAction;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.metadata.form.rule.ClientRule;
import kd.bos.metadata.report.IReportListAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportListAp
extends EntryAp
implements IReportListAp {
    private String ReportPlugin;
    private String ReportSumMeta;
    private String DataSource;
    private String RowBackColor;
    private boolean showSeq = true;
    private String columnWidthStyle;
    private boolean showSelChexkbox;
    private QueryDataSource QueryDataSource;
    private int pageRows = 200;
    private boolean selectedAll = false;
    private boolean colFilter = false;
    private boolean colSort = false;
    private List<ClientRule> clientRules = new ArrayList<ClientRule>();
    private String rowHeight;
    private String maxRowHeight;
    private boolean autoRowHeight;
    private List<Plugin> reportPluginExt = new ArrayList<Plugin>();
    private List<Map<String, String>> initField;

    @SimplePropertyAttribute(name="ColumnWidthStyle")
    public String getColumnWidthStyle() {
        return this.columnWidthStyle;
    }

    public void setColumnWidthStyle(String columnWidthStyle) {
        this.columnWidthStyle = columnWidthStyle;
    }

    @KSMethod
    @SimplePropertyAttribute(name="PageRows")
    @DefaultValueAttribute(value="200")
    public int getPageRows() {
        return this.pageRows;
    }

    @KSMethod
    public void setPageRows(int pageRows) {
        this.pageRows = pageRows;
    }

    @ComplexPropertyAttribute(name="QueryDataSource")
    public QueryDataSource getQueryDataSource() {
        return this.QueryDataSource;
    }

    public void setQueryDataSource(QueryDataSource queryDataSource) {
        this.QueryDataSource = queryDataSource;
    }

    @SimplePropertyAttribute(name="ShowSelChexkbox")
    public boolean isShowSelChexkbox() {
        return this.showSelChexkbox;
    }

    public void setShowSelChexkbox(boolean showSelChexkbox) {
        this.showSelChexkbox = showSelChexkbox;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ClientRule.class)
    public List<ClientRule> getClientRules() {
        return this.clientRules;
    }

    public void setClientRules(List<ClientRule> clientRules) {
        this.clientRules = clientRules;
    }

    @SimplePropertyAttribute
    public String getReportPlugin() {
        return this.ReportPlugin;
    }

    public void setReportPlugin(String reportPlugin) {
        this.ReportPlugin = reportPlugin;
    }

    @SimplePropertyAttribute
    public String getReportSumMeta() {
        return this.ReportSumMeta;
    }

    public void setReportSumMeta(String reportSumMeta) {
        this.ReportSumMeta = reportSumMeta;
    }

    @SimplePropertyAttribute
    public String getDataSource() {
        return this.DataSource;
    }

    public void setDataSource(String dataSource) {
        this.DataSource = dataSource;
    }

    @SimplePropertyAttribute
    public String getRowBackColor() {
        return this.RowBackColor;
    }

    public void setRowBackColor(String rowBackColor) {
        this.RowBackColor = rowBackColor;
    }

    @SimplePropertyAttribute(name="ShowSeq")
    @DefaultValueAttribute(value="true")
    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @SimplePropertyAttribute(name="SelectedAll")
    @DefaultValueAttribute(value="false")
    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    public void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    @SimplePropertyAttribute(name="ColFilter", displayName="supports column header filtering")
    public boolean isColFilter() {
        return this.colFilter;
    }

    public void setColFilter(boolean colFilter) {
        this.colFilter = colFilter;
    }

    @SimplePropertyAttribute(name="ColSort", displayName="supports column header sorting")
    public boolean isColSort() {
        return this.colSort;
    }

    public void setColSort(boolean colSort) {
        this.colSort = colSort;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        ctl.put("type", "grid");
        ctl.put("rk", "rk");
        ctl.put("seq", "fseq");
        if (this.isShowSelChexkbox()) {
            ctl.put("selchexkbox", true);
        }
        ctl.put("gridtype", "VIRTUALVIEWGRID");
        if (!this.isAutoRowHeight()) {
            ctl.put("rh", this.getRowHeight());
        }
        ctl.put("arh", this.isAutoRowHeight());
        if (this.isAutoRowHeight() && StringUtils.isNotBlank((CharSequence)this.getMaxRowHeight())) {
            ctl.put("mrh", this.getMaxRowHeight());
        }
        if (this.isSelectedAll()) {
            ctl.put("selallrow", this.isSelectedAll());
        }
        if (this.getTitleFontSize() != 12) {
            ctl.put("tfs", this.getTitleFontSize());
        }
        if (this.isTitleAutoWrap()) {
            ctl.put("taw", this.isTitleAutoWrap());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getColumnWidthStyle())) {
            ctl.put("columnWidthStyle", this.getColumnWidthStyle());
        }
        return ctl;
    }

    protected void createChildControls(Map<String, Object> ctl) {
    }

    @SimplePropertyAttribute
    public String getRowHeight() {
        if (StringUtils.isEmpty((CharSequence)this.rowHeight)) {
            return "38px";
        }
        return this.rowHeight;
    }

    @SimplePropertyAttribute(name="AutoRowHeight")
    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
    }

    public void setRowHeight(String rowHeight) {
        this.rowHeight = rowHeight;
    }

    @SimplePropertyAttribute
    public String getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(String maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    protected ReportList createRuntimeControl() {
        return new ReportList();
    }

    protected void setRuntimeSimpleProperties(Container ctl) {
        super.setRuntimeSimpleProperties(ctl);
        ReportList reportList = (ReportList)ctl;
        reportList.setReportPluginClassName(this.getReportPlugin());
        reportList.setInitField(this.getInitField());
        reportList.setShowSeq(this.isShowSeq());
        reportList.setDataSource(this.getDataSource());
        reportList.setDataSourceId(this.getQueryDataSource() == null ? "" : this.getQueryDataSource().getDataSourceId());
        ArrayList<ClientBR> eRules = new ArrayList<ClientBR>();
        for (ClientRule rule : this.clientRules) {
            if (!rule.getTrueActions().isEmpty()) {
                rule.setGroupName(((BizRuleAction)rule.getTrueActions().get(0)).getGroupName());
            }
            eRules.add(rule.buildEntityRule(this.getEntryId()));
        }
        reportList.setClientRules(eRules);
        reportList.setPageRows(this.getPageRows());
        reportList.setPageRow(this.getPageRows());
        reportList.setSplitPage(this.isSplitPage());
        reportList.setColFilter(this.isColFilter());
        reportList.setColSort(this.isColSort());
        reportList.setFreezeList(this.handleFreezeList(this.getFreezeList()));
        if (StringUtils.isNotBlank((CharSequence)this.getColumnWidthStyle())) {
            reportList.setColumnWidthStyle(this.getColumnWidthStyle());
        }
        ArrayList<kd.bos.entity.plugin.Plugin> plugins = new ArrayList<kd.bos.entity.plugin.Plugin>();
        for (Plugin p : this.reportPluginExt) {
            if (!p.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(p.getClassName());
            pl.setType(p.getType());
            pl.setScriptNumber(p.getScriptNumber());
            pl.setRowKey(p.getRowKey());
            plugins.add(pl);
        }
        Collections.sort(plugins, new /* Unavailable Anonymous Inner Class!! */);
        reportList.setReportExtPlugins(plugins);
        reportList.setInitField(this.getInitField());
    }

    protected void buildRuntimeChildControls(Container ctl) {
        ReportList rp = (ReportList)ctl;
        List<AbstractReportColumn> columns = rp.getColumns();
        HashMap<String, String> fieldkeyNameMap = new HashMap<String, String>();
        HashMap<ReportColumn, String> numberColumns = new HashMap<ReportColumn, String>();
        boolean isQueryDataSource = StringUtils.isBlank((CharSequence)this.getReportPlugin()) && !StringUtils.isBlank((Object)this.getQueryDataSource());
        ThreadCache.put((Object)"isQueryDataSource", (Object)isQueryDataSource);
        ReportColumnFactory.setQueryDataSource((boolean)isQueryDataSource);
        for (ControlAp controlAp : this.getItems()) {
            if (controlAp.isHidden()) continue;
            if (controlAp instanceof EntryFieldAp) {
                columns.add((AbstractReportColumn)this.createColumn((EntryFieldAp)controlAp, fieldkeyNameMap, numberColumns));
                continue;
            }
            if (controlAp instanceof EntryFieldGroupAp) {
                columns.add((AbstractReportColumn)this.createColumnGroup((EntryFieldGroupAp)controlAp, fieldkeyNameMap, numberColumns));
                continue;
            }
            if (!(controlAp instanceof OperationColumnAp)) continue;
            columns.add(this.createOperationColumn((OperationColumnAp)controlAp));
        }
        for (Map.Entry entry : numberColumns.entrySet()) {
            ReportColumn column = (ReportColumn)entry.getKey();
            if (StringUtils.equals((CharSequence)"amount", (CharSequence)column.getFieldType()) || StringUtils.equals((CharSequence)"price", (CharSequence)column.getFieldType())) {
                column.setCurrencyField((String)fieldkeyNameMap.get(entry.getValue()));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"qty", (CharSequence)column.getFieldType())) continue;
            column.setMeasureUnitField((String)fieldkeyNameMap.get(entry.getValue()));
        }
    }

    private void setRefOrg(Field<?> f, ReportColumn column) {
        if (f instanceof OrgField) {
            column.setRefOrg(true);
            column.setOrgFuncs(((OrgField)f).getOrgFuncs());
        } else {
            BasedataPropField basePropField;
            BasedataField controlField;
            String controlKey = null;
            if (f instanceof BasedataField && !(f instanceof ItemClassField)) {
                BasedataField basedataField = (BasedataField)f;
                if (basedataField.getRefBaseEntityMeta() != null) {
                    controlKey = basedataField.getRefBaseEntityMeta().getKey();
                }
            } else if (f instanceof MulBasedataField) {
                MainEntityType enityType;
                MulBasedataField mulBasedataField = (MulBasedataField)f;
                if (mulBasedataField.getBaseEntityId() != null && (enityType = EntityMetadataCache.getDataEntityTypeById((String)mulBasedataField.getBaseEntityId())) != null) {
                    controlKey = enityType.getName();
                }
            } else if (f instanceof BasedataPropField && (controlField = (BasedataField)(basePropField = (BasedataPropField)f).getControlField()) != null && controlField.getRefBaseEntityMeta() != null) {
                controlKey = controlField.getRefBaseEntityMeta().getKey();
            }
            if (StringUtils.equals((CharSequence)"bos_org", controlKey)) {
                column.setRefOrg(true);
            }
        }
    }

    private ReportColumn createColumn(EntryFieldAp field, Map<String, String> fieldkeyNameMap, Map<ReportColumn, String> numberColumns) {
        Field f = field.getField();
        ReportColumn column = ReportColumnFactory.createReportColumnBuilder((EntryFieldAp)field);
        fieldkeyNameMap.put(field.getId(), column.getFieldKey());
        if (f instanceof AmountField) {
            numberColumns.put(column, ((AmountField)f).getCurrencyFieldId());
        } else if (f instanceof PriceField) {
            numberColumns.put(column, ((PriceField)f).getCurrencyFieldId());
        } else if (f instanceof QtyField) {
            numberColumns.put(column, ((QtyField)f).getUnitFieldId());
        }
        this.setRefOrg(f, column);
        return column;
    }

    private ReportOperationColumn createOperationColumn(OperationColumnAp operationColumnAp) {
        ReportOperationColumn column = new ReportOperationColumn();
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign(operationColumnAp.getTextAlign());
        column.setOperationColItems(operationColumnAp.getOperationColItems());
        column.setCaption(operationColumnAp.getName());
        column.setWidth(operationColumnAp.getWidth());
        column.setOperationColumnShowStyle(operationColumnAp.getOperationColumnShowStyle());
        column.setFieldKey(operationColumnAp.getKey());
        column.setTableHeaderCellBackColor(operationColumnAp.getTableHeaderCellBackColor());
        column.setHide(StringUtils.isEmpty((CharSequence)operationColumnAp.getVisible()));
        style.setForeColor(operationColumnAp.getForeColor());
        style.setBackColor(operationColumnAp.getBackColor());
        style.setRadius(operationColumnAp.getRadius());
        style.setFontSize(operationColumnAp.getFontSize());
        return column;
    }

    private ReportColumnGroup createColumnGroup(EntryFieldGroupAp field, Map<String, String> fieldkeyNameMap, Map<ReportColumn, String> numberColumns) {
        ReportColumnGroup column = new ReportColumnGroup();
        column.setCaption(field.getName());
        column.setMerge(field.isMerge());
        column.setFieldKey(field.getKey());
        column.setTextAlign(field.getTextAlign());
        column.setGroupCollapsible(field.isGroupCollapsible());
        column.setGroupDefaultCollapse(field.isGroupDefaultCollapse());
        column.setCtlTips(field.getCtlTips());
        column.setTableHeaderCellBackColor(field.getTableHeaderCellBackColor());
        for (ControlAp item : field.getItems()) {
            if (item.isHidden()) continue;
            if (item instanceof EntryFieldAp) {
                column.getChildren().add(this.createColumn((EntryFieldAp)item, fieldkeyNameMap, numberColumns));
                continue;
            }
            if (!(item instanceof EntryFieldGroupAp)) continue;
            column.getChildren().add(this.createColumnGroup((EntryFieldGroupAp)item, fieldkeyNameMap, numberColumns));
        }
        return column;
    }

    private List<Map<String, String>> handleFreezeList(List<Map<String, String>> freezeList) {
        ArrayList<Map<String, String>> newFreezeList = new ArrayList<Map<String, String>>(this.getItems().size());
        if (!CollectionUtils.isEmpty(freezeList)) {
            Map<String, Map> listMap = freezeList.stream().collect(Collectors.toMap(x -> (String)x.get("freezelistkey") + "_" + (String)x.get("listname"), v -> v, (k, v) -> v));
            for (ControlAp item : this.getItems()) {
                Map<String, String> map = new HashMap<String, String>(1);
                String key = item.getKey() + "_" + item.getName().toString();
                if (listMap.containsKey(key)) {
                    map = listMap.get(key);
                } else {
                    map.put("freezelistkey", item.getKey());
                    map.put("listname", String.valueOf(item.getName()));
                    map.put("isfreeze", "false");
                }
                newFreezeList.add(map);
            }
        }
        return newFreezeList;
    }

    @CollectionPropertyAttribute(name="ReportPluginExt", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getRreportPluginExt() {
        return this.reportPluginExt;
    }

    public void setRreportPluginExt(List<Plugin> reportPluginExt) {
        this.reportPluginExt = reportPluginExt;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getInitField() {
        return this.initField;
    }

    public void setInitField(List<Map<String, String>> initField) {
        this.initField = initField;
    }
}

