/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.IReportTreeModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.report.AbstractReportTreeModel;
import kd.bos.report.IReportView;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportTree
extends TreeView {
    private String BaseEntityId;
    private String ReportPlugin;
    private AbstractReportTreeModel repotModel;
    private boolean LeafNodeQuery = true;

    @SimplePropertyAttribute
    public String getBaseEntityId() {
        return this.BaseEntityId;
    }

    public void setBaseEntityId(String baseEntityId) {
        this.BaseEntityId = baseEntityId;
    }

    @SimplePropertyAttribute
    public String getReportPlugin() {
        return this.ReportPlugin;
    }

    public void setReportPlugin(String reportPlugin) {
        this.ReportPlugin = reportPlugin;
    }

    @SimplePropertyAttribute(name="LeafNodeQuery")
    @DefaultValueAttribute(value="true")
    public boolean isLeafNodeQuery() {
        return this.LeafNodeQuery;
    }

    public void setLeafNodeQuery(boolean leafNodeQuery) {
        this.LeafNodeQuery = leafNodeQuery;
    }

    public void submitTask(ReportQueryParam repotParam) {
        AbstractReportTreeModel treeModel = this.getAbstractReportTreeModel();
        treeModel.submitTask(repotParam, null);
    }

    public void showData() {
        IReportTreeModel treeModel = this.getReportModel();
        this.addTreeNode(treeModel.getTreeModel());
    }

    public TreeNode getTreeNode(String nodeId) {
        TreeModel treeModel = this.getReportModel().getTreeModel();
        List<TreeNode> nodes = treeModel.getNodes();
        nodes = this.genTreeStructure(nodes);
        for (TreeNode node : nodes) {
            List pathNodes = node.getChildPathNodes(nodeId);
            if (pathNodes == null || pathNodes.isEmpty()) continue;
            return (TreeNode)pathNodes.get(pathNodes.size() - 1);
        }
        return null;
    }

    private void addTreeNode(TreeModel treeModel) {
        List<TreeNode> nodes = treeModel.getNodes();
        if (!(nodes = this.genTreeStructure(nodes)).isEmpty()) {
            this.deleteAllNodes();
            this.addNodes(nodes);
            TreeNode selectedNode = null;
            selectedNode = this.isLeafNodeQuery() ? this.getFirstChild(nodes.get(0)) : nodes.get(0);
            this.treeNodeClick(selectedNode.getParentid(), selectedNode.getId());
            this.focusNode(selectedNode);
        } else {
            this.deleteAllNodes();
        }
    }

    private List<TreeNode> genTreeStructure(List<TreeNode> nodes) {
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : nodes) {
            nodeMap.put(node.getId(), node);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodes) {
            if (node.getParentid() == null) {
                node.setParentid("");
                nodeList.add(node);
                continue;
            }
            TreeNode p = (TreeNode)nodeMap.get(node.getParentid());
            if (p == null) {
                node.setParentid("");
                nodeList.add(node);
                continue;
            }
            ArrayList<TreeNode> children = p.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                p.setChildren(children);
            }
            children.add(node);
        }
        return nodeList;
    }

    private TreeNode getFirstChild(TreeNode node) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            return node;
        }
        TreeNode n = (TreeNode)node.getChildren().get(0);
        return this.getFirstChild(n);
    }

    public IReportTreeModel getReportModel() {
        if (this.repotModel == null) {
            this.repotModel = (AbstractReportTreeModel)TypesContainer.createInstance((String)"kd.bos.mvc.report.ReportTreeModel");
            this.repotModel.setPageId(this.getView().getPageId());
            this.repotModel.setCtrlId(this.getKey());
            this.repotModel.setAsynQuery(this.isAsynQuery());
            this.repotModel.setPluginClassName(this.getReportPlugin());
            IDataModel model = this.getView().getModel();
            if (model != null) {
                MainEntityType itemType = model.getDataEntityType();
                this.repotModel.setEntityType(itemType);
            }
        }
        return this.repotModel;
    }

    private AbstractReportTreeModel getAbstractReportTreeModel() {
        return (AbstractReportTreeModel)this.getReportModel();
    }

    private boolean isAsynQuery() {
        IFormView view = this.getView();
        if (view instanceof IReportView) {
            return ((IReportView)view).isAsynQuery();
        }
        return false;
    }

    public void close() {
        this.getAbstractReportTreeModel().close();
    }
}

