/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.demo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class DemoBillReportListDataPlugin
extends AbstractReportListDataPlugin {
    private String TAG_NAME = "demo_rpt_bill";
    private String[] SELECTED_FIELD = new String[]{"billno", "billstatus", "createtime", "textfield", "decimalfield", "textareafield", "largetextfield", "mulilangtextfield", "datefield", "datetimefield", "checkboxfield", "combofield", "mulcombofield", "stepperfield", "materielfield", "amountfield", "basedatafield", "qtyfield", "unitfield"};
    private String[] SEARCH_FIELD = new String[]{"billnosearch", "billstatussearch", "createtimesearch", "textsearch", "decimalsearch", "textareasearch", "largetextsearch", "mulilangtextsearch", "datesearch", "datetimesearch", "checkboxsearch", "combosearch", "mulcombosearch", "steppersearch", "materielsearch", "amountsearch", "basedatasearch"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        ArrayList<QFilter> searchFilterList = new ArrayList<QFilter>();
        searchFilterList.addAll(this.getCommonFilterList(reportQueryParam));
        if (!CollectionUtils.isEmpty((Collection)reportQueryParam.getFilter().getHeadFilters())) {
            searchFilterList.addAll(reportQueryParam.getFilter().getHeadFilters());
        }
        ORM orm = ORM.create();
        String selectedField = this.stripChar(this.stripChar(Arrays.asList(this.SELECTED_FIELD).toString(), '['), ']');
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), this.TAG_NAME, selectedField, searchFilterList.toArray(new QFilter[0]), reportQueryParam.getSortInfo());
    }

    private String stripChar(String string, char c) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.charAt(0) == c ? "" : string;
        }
        int left = 0;
        int right = string.length();
        if (string.charAt(left) == c) {
            ++left;
        }
        if (string.charAt(right - 1) == c) {
            --right;
        }
        return string.substring(left, right);
    }

    private List<QFilter> getCommonFilterList(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> searchFilterList = new ArrayList<QFilter>();
        List filterItems = reportQueryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String cp;
            Object searchValue;
            int index = this.index(this.SEARCH_FIELD, filterItem.getPropName().split("_")[0]);
            if (index == -1) continue;
            if (filterItem.getValue() instanceof Date) {
                searchValue = filterItem.getValue();
            } else {
                Object object = searchValue = StringUtils.isBlank((String)filterItem.getString()) ? null : filterItem.getString();
            }
            if (searchValue == null || !StringUtils.isNotEmpty((String)searchValue.toString())) continue;
            if ("checkboxfield".equals(this.SELECTED_FIELD[index])) {
                cp = "in";
                searchValue = "true".equals(searchValue) ? Integer.valueOf(1) : Integer.valueOf(0);
            } else if ("createtime".equals(this.SELECTED_FIELD[index])) {
                if (filterItem.getPropName().endsWith("startdate")) {
                    cp = ">=";
                    searchValue = this.getStartTimeOfToday((Date)searchValue);
                } else {
                    cp = "<=";
                    searchValue = this.getLastTimeOfToday((Date)searchValue);
                }
            } else {
                cp = "=";
            }
            searchFilterList.add(new QFilter(this.SELECTED_FIELD[index], cp, searchValue));
        }
        return searchFilterList;
    }

    private int index(String[] arr, String str) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    private Date getStartTimeOfToday(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getLastTimeOfToday(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }
}

