/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportSysPublicParameter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.events.MergeColumnRule;
import kd.bos.report.events.ReportExportInitializeEvent;
import kd.bos.report.export.ExportDataFromCache;
import kd.bos.report.export.ExportDataProvider;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.report.proxy.ReportListProxy;
import kd.bos.util.CollectionUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AbstractReportExport {
    protected static final String BOS_FORM_CORE = "bos-form-core";
    protected static final String XLSX = ".xlsx";
    protected ReportList reportList;
    protected ReportListProxy reportListProxy;
    protected ExportDataProvider exportDataProvider;
    protected static final Log log = LogFactory.getLog(AbstractReportExport.class);
    protected ReportExportInitializeEvent exportInitializeEvent;
    protected int maxExportLimit;

    protected ReportListProxy getReportListProxy() {
        if (this.reportListProxy == null) {
            this.reportListProxy = this.reportList.getReportListProxy();
        }
        return this.reportListProxy;
    }

    protected void recurGroupColumnUserFormat(ReportColumnGroup column, FormatObject format) {
        List children = column.getChildren();
        if (children != null && !children.isEmpty()) {
            for (AbstractReportColumn col : children) {
                if (col instanceof ReportColumnGroup) {
                    this.recurGroupColumnUserFormat((ReportColumnGroup)col, format);
                    continue;
                }
                col.setUserFormat(format);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(formName + XLSX, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    protected String getFilename(String name) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        String fileName = name + "-" + currDateTime + "-" + userName;
        ArrayList<String> list = new ArrayList<String>();
        this.setExcelName(list);
        if (!list.isEmpty()) {
            if (((String)list.get(0)).length() > 150) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa\u7684\u6587\u4ef6\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7150\u4e2a\u5b57\u7b26\u3002", (String)"AbstractReportExport_0", (String)BOS_FORM_CORE, (Object[])new Object[0])});
            }
            fileName = (String)list.get(0);
        }
        return fileName;
    }

    protected void setExcelName(List<String> list) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setExcelName(list);
        }
    }

    protected String getExportFilePath(String fileName) {
        RequestContext ctx = RequestContext.getOrCreate();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String uuid = UUID.randomUUID().toString();
        return String.format("/%s/%s/%s/%s/%s/%s/%s", ctx.getTenantId(), ctx.getAccountId(), "reportExcel", dateStr, this.reportList.getView().getServiceAppId(this.reportList.getView().getPageId()), uuid, fileName);
    }

    /*
     * Exception decompiling
     */
    protected String writeFile2AttachmentFileService(SXSSFWorkbook wb, String fileName, String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String saveExportFileAsUrl(String fileName, List<String> urls, Boolean isWriteFileByRedis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveUrlsToDB(List<String> urls) {
        try {
            String tableName = "t_bas_report_files_path";
            Date date = new Date();
            ArrayList<SqlParameter[]> sqlParams = new ArrayList<SqlParameter[]>(urls.size());
            for (String url : urls) {
                RequestContext rc = RequestContext.get();
                SqlParameter[] params = new SqlParameter[6];
                long id = IDService.get().genLongId(rc.getAccountId(), tableName);
                params[0] = new SqlParameter(":FID", -5, (Object)id);
                params[1] = new SqlParameter(":FTENANTID", 12, (Object)rc.getTenantId());
                params[2] = new SqlParameter(":FACCOUNTID", 12, (Object)rc.getAccountId());
                params[3] = new SqlParameter(":FPATH", -9, (Object)url);
                params[4] = new SqlParameter(":FCREATORID", -5, (Object)rc.getCurrUserId());
                params[5] = new SqlParameter(":FCREATETIME", 93, (Object)date);
                sqlParams.add(params);
            }
            if (sqlParams.isEmpty()) {
                return;
            }
            try (TXHandle h = TX.notSupported((String)"reportExport");){
                String sql = String.format("INSERT INTO %s (FID,FTENANTID,FACCOUNTID,FPATH,FCREATORID,FCREATETIME) VALUES (?, ?, ?, ?, ?, ?) ", tableName);
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, sqlParams);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u63d2\u5165\u62a5\u8868\u6587\u4ef6\u8bb0\u5f55\u8868\u62a5\u9519\uff0c\u5171%s\u6761\u8bb0\u5f55\uff0c\u6587\u4ef6\u5730\u5740\u4e3a\uff1a%s", urls.size(), Arrays.toString(urls.toArray())), (Throwable)e);
        }
    }

    protected ExportDataProvider getExportDataProvider(AbstractReportListModel listModel) {
        if (this.exportDataProvider == null) {
            this.exportDataProvider = new ExportDataFromCache(listModel);
        }
        return this.exportDataProvider;
    }

    private String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    protected void exportInitialize() {
        List<MergeColumnRule> mergeColumnRule;
        this.exportInitializeEvent = new ReportExportInitializeEvent();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireExportInitialize(this.exportInitializeEvent);
        }
        if (CollectionUtils.isNotEmpty(mergeColumnRule = this.exportInitializeEvent.getMergeColumnRules())) {
            HashSet<String> allMergeColumns = new HashSet<String>(10);
            StringBuilder repeatMsg = new StringBuilder();
            Iterator<MergeColumnRule> iterator = mergeColumnRule.iterator();
            while (iterator.hasNext()) {
                MergeColumnRule rule = iterator.next();
                List<String> mergeColumns = rule.getMergeColumns();
                if (rule == null || CollectionUtils.isEmpty(mergeColumns)) {
                    iterator.remove();
                    continue;
                }
                for (String column : mergeColumns) {
                    if (allMergeColumns.contains(column)) {
                        repeatMsg.append(String.format("\"%s\"\u3001", column));
                        continue;
                    }
                    allMergeColumns.add(column);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)repeatMsg.toString())) {
                repeatMsg = repeatMsg.deleteCharAt(repeatMsg.length() - 1);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bfc\u51faExcel\u7684\u5408\u5e76\u89c4\u5219\u4e2d\uff0c\u5b57\u6bb5%s\u5b58\u5728\u591a\u4e2a\u5408\u5e76\u6761\u4ef6\uff0c\u4e3a\u907f\u514d\u51b2\u7a81\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u63d2\u4ef6\u3002", (String)"AbstractReportExport_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), repeatMsg));
            }
        }
    }

    protected void endExport(IExporter<AbstractReportColumn> exporter, int loopTimes) {
        exporter.setLoopTimes(loopTimes);
        exporter.endExport();
    }

    protected int getMaxExportSize(ReportResultLimit limit) {
        if (this.maxExportLimit == 0) {
            if (limit != null && limit.getLimitCount() != 0) {
                this.maxExportLimit = limit.getLimitCount() / 10000;
            }
            this.maxExportLimit = ReportSysPublicParameter.getMaxExportLimit();
        }
        int maxExportSize = this.maxExportLimit * 10000;
        ThreadCache.put((Object)"report_export_maxExportSize", (Object)maxExportSize);
        return maxExportSize;
    }

    protected boolean removeColumnNoReadFields(List<AbstractReportColumn> exportColumns) {
        boolean remove = false;
        Iterator<AbstractReportColumn> iterator = exportColumns.iterator();
        while (iterator.hasNext()) {
            ReportColumn reportColumn;
            AbstractReportColumn column = iterator.next();
            if (column instanceof ReportColumnGroup) {
                ReportColumnGroup group = (ReportColumnGroup)column;
                boolean removeChild = this.removeColumnNoReadFields(group.getChildren());
                boolean bl = remove = remove || removeChild;
                if (!removeChild || !group.getChildren().isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (!(column instanceof ReportColumn) || this.reportList.hasReadFieldRight((reportColumn = (ReportColumn)column).getFieldKey())) continue;
            iterator.remove();
            remove = true;
        }
        return remove;
    }

    String getPageId(String pageId) {
        String directExportExcel;
        if (StringUtils.isNotBlank((CharSequence)pageId) && StringUtils.isNotEmpty((CharSequence)(directExportExcel = this.reportList.getView().getPageCache().get("DirectExportExcel"))) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
            pageId = pageId + "_noQueryExport";
        }
        return pageId;
    }
}

