/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportSysPublicParameter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.export.ExportDataProvider;
import kd.bos.report.plugin.ReportViewPluginProxy;

public class ExportDataFromDataSet
implements ExportDataProvider {
    protected DataSet dataSet;
    private MainEntityType entityType;
    private String pageId;
    private String ctrlId;
    private List<ReportColumn> columns;
    protected int readCount = 0;
    protected boolean isExceededExportLimit = false;
    private ReportList reportList;
    private String sheetName;
    private int maxExportSize;
    private static final Log log = LogFactory.getLog(ExportDataFromDataSet.class);

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getCtrlId() {
        return this.ctrlId;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = StringUtils.isBlank((CharSequence)sheetName) ? "sheet1" : sheetName;
    }

    public ExportDataFromDataSet(DataSet dataSet, String sheetName, MainEntityType entityType, List<ReportColumn> columns, String pageId, String ctrlId, ReportList reportList) {
        this.dataSet = dataSet;
        this.setSheetName(sheetName);
        this.entityType = entityType;
        this.columns = columns;
        this.pageId = pageId;
        this.ctrlId = ctrlId;
        this.reportList = reportList;
    }

    @Override
    public DynamicObjectCollection getRowData(int startIndex, int length) {
        try {
            DynamicObjectType itemType = (DynamicObjectType)this.reportList.getReportListProxy().getReportPropUtil_createReportType().invoke(null, this.entityType, this.columns);
            List<Tuple<String, IDataEntityProperty>> propMap = this.buildPropMap(this.columns, this.dataSet, itemType);
            DynamicObjectCollection rowData = new DynamicObjectCollection(itemType, null);
            int start = 0;
            int seq = startIndex + 1;
            int exportedCount = this.readCount + 1;
            while (start < length && this.dataSet.hasNext()) {
                if (exportedCount > this.getMaxExportSize()) {
                    this.isExceededExportLimit = true;
                    break;
                }
                Row row = this.dataSet.next();
                DynamicObject obj = this.toDynamicObjectByColumns(row, itemType, propMap);
                obj.set("fseq", (Object)seq++);
                rowData.add((Object)obj);
                ++start;
                ++exportedCount;
            }
            BusinessDataReader.loadRefence((Object[])rowData.toArray((Object[])new DynamicObject[0]), (IDataEntityType)itemType);
            this.processRowData(rowData);
            this.readCount += rowData.size();
            return rowData;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
    }

    @Override
    public boolean isLast(int currentCount) {
        return this.isExceededExportLimit || !this.getDataSet().hasNext();
    }

    @Override
    public int getRowCount() {
        if (this.dataSet.hasNext()) {
            return this.readCount + 1000000;
        }
        return this.readCount;
    }

    @Override
    public boolean isExceededExportLimit() {
        return this.isExceededExportLimit;
    }

    @Override
    public boolean isWriteFileByRedis() {
        return false;
    }

    private List<Tuple<String, IDataEntityProperty>> buildPropMap(List<ReportColumn> columns, DataSet dataSet, DynamicObjectType dt) {
        Field[] fields = dataSet.getRowMeta().getFields();
        HashSet<String> columnDataSet = new HashSet<String>(fields.length);
        for (Field field : fields) {
            columnDataSet.add(field.getName().toLowerCase());
        }
        ArrayList<Tuple<String, IDataEntityProperty>> propMap = new ArrayList<Tuple<String, IDataEntityProperty>>(this.columns.size());
        for (ReportColumn column : columns) {
            DynamicProperty property;
            String key;
            String string = key = column.getDateIndex() == null ? column.getFieldKey() : column.getDateIndex();
            if (!columnDataSet.contains(key = key.toLowerCase()) || (property = dt.getProperty(column.getFieldKey())) == null) continue;
            if (property instanceof BasedataProp) {
                property = ((BasedataProp)property).getRefIdProp();
            }
            propMap.add((Tuple<String, IDataEntityProperty>)new Tuple((Object)key, (Object)property));
        }
        return propMap;
    }

    private DynamicObject toDynamicObjectByColumns(Row rowSet, DynamicObjectType itemType, List<Tuple<String, IDataEntityProperty>> propMap) {
        DynamicObject obj = new DynamicObject(itemType);
        obj.beginInit();
        for (Tuple<String, IDataEntityProperty> item : propMap) {
            Object value = rowSet.get((String)item.item1);
            if (value == null) continue;
            ((IDataEntityProperty)item.item2).setValueFast((Object)obj, value);
        }
        obj.endInit();
        return obj;
    }

    private void processRowData(DynamicObjectCollection pageData) {
        ReportQueryParam queryParam = this.reportList.getReportCache().getReportQueryParam(this.getPageId());
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireProcessRowData(this.getCtrlId(), pageData, queryParam);
        }
    }

    protected int getMaxExportSize() {
        if (this.maxExportSize == 0) {
            Object size = ThreadCache.get((Object)"report_export_maxExportSize");
            this.maxExportSize = size instanceof Integer ? (Integer)size : ReportSysPublicParameter.getMaxExportLimit() * 10000;
        }
        return this.maxExportSize;
    }
}

