/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FlexReportColumn;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.export.AbstractReportExport;
import kd.bos.report.export.ExportDataFromCache;
import kd.bos.report.export.ExportManager;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class LargeDataExcelExport
extends AbstractReportExport {
    public LargeDataExcelExport(ReportList reportList) {
        this.reportList = reportList;
    }

    @SdkInternal
    public String largeDataExportExcel() {
        this.exportInitialize();
        AbstractReportListModel listModel = this.reportList.getAbstractReportModel();
        ArrayList<AbstractReportColumn> originColumns = new ArrayList<AbstractReportColumn>();
        ReportByBatchTaskResult reportTaskResult = (ReportByBatchTaskResult)listModel.getReportTaskResult();
        List<AbstractReportColumn> columns = this.getReportListProxy().getColumnList(listModel);
        List<ReportColumn> cols = this.reportListProxy.getReportColumnList(columns, true);
        ArrayList<AbstractReportColumn> exportColumns = new ArrayList<AbstractReportColumn>();
        LinkedHashMap<String, AbstractReportColumn> originColumnMap = new LinkedHashMap<String, AbstractReportColumn>();
        FormatObject format = this.reportListProxy.getFormat();
        List<GridConfigurationRow> configRows = this.reportListProxy.getUserGridConfigRows();
        if (CollectionUtils.isEmpty(configRows)) {
            Map<String, String> initFieldMap = new HashMap();
            List<Map<String, String>> initFieldList = this.reportList.getInitField();
            if (!CollectionUtils.isEmpty(initFieldList)) {
                initFieldMap = this.initFieldListToMap(initFieldList);
            }
            if (!CollectionUtils.isEmpty((Map)initFieldMap)) {
                this.removeByInitField(columns, initFieldMap);
            }
        }
        for (AbstractReportColumn abstractReportColumn : columns) {
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn child : childrens) {
                    if (child instanceof ReportOperationColumn) continue;
                    if (child instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)child, format);
                        continue;
                    }
                    child.setUserFormat(format);
                }
            } else {
                abstractReportColumn.setUserFormat(format);
            }
            if (abstractReportColumn instanceof ReportColumn) {
                String fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
                originColumnMap.put(fieldKey, abstractReportColumn);
            } else if (abstractReportColumn instanceof ReportColumnGroup) {
                originColumnMap.put(((ReportColumnGroup)abstractReportColumn).getFieldKey(), abstractReportColumn);
            }
            originColumns.add(abstractReportColumn);
        }
        HashMap<String, AbstractReportColumn> allColumnMap = new HashMap<String, AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> parentColumnMap = new HashMap<String, AbstractReportColumn>();
        this.allColumnMap(originColumnMap, allColumnMap, parentColumnMap);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (configRows != null && !configRows.isEmpty()) {
            Iterator<GridConfigurationRow> configRowsIterator = configRows.iterator();
            while (configRowsIterator.hasNext()) {
                GridConfigurationRow row = configRowsIterator.next();
                map.put(row.getFieldKey(), row.isHide());
                if (!row.isHide()) {
                    if (!CollectionUtils.isEmpty((Collection)row.getChildren())) {
                        AbstractReportColumn abstractReportColumn = (AbstractReportColumn)originColumnMap.get(row.getFieldKey());
                        if (abstractReportColumn instanceof ReportColumnGroup) {
                            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)abstractReportColumn;
                            if (CollectionUtils.isEmpty((Collection)reportColumnGroup.getChildren())) continue;
                            if (!row.isHide() && this.isAllHide(row.getChildren(), allColumnMap)) {
                                configRowsIterator.remove();
                                originColumns.remove(originColumnMap.get(row.getFieldKey()));
                                continue;
                            }
                            this.dealMulGroup(row, allColumnMap, parentColumnMap);
                        } else if (abstractReportColumn instanceof FlexReportColumn) {
                            List configurationRowList = row.getChildren();
                            Iterator iterator = configurationRowList.iterator();
                            while (iterator.hasNext()) {
                                GridConfigurationRow configurationRow = (GridConfigurationRow)iterator.next();
                                if (!configurationRow.isHide()) continue;
                                iterator.remove();
                            }
                            if (row.getChildren().size() == 0) {
                                configRowsIterator.remove();
                                originColumns.remove(originColumnMap.get(row.getFieldKey()));
                                continue;
                            }
                        }
                    }
                } else {
                    configRowsIterator.remove();
                }
                AbstractReportColumn column = null;
                for (Map.Entry columnEntry : originColumnMap.entrySet()) {
                    Object fieldKey = this.reportList.getMergeMap().get(columnEntry.getKey()) == null ? columnEntry.getKey() : this.reportList.getMergeMap().get(columnEntry.getKey());
                    if (!Objects.equals(fieldKey, row.getFieldKey())) continue;
                    column = (AbstractReportColumn)columnEntry.getValue();
                    break;
                }
                if (column == null) continue;
                exportColumns.add(column);
                originColumns.remove(column);
            }
        }
        exportColumns.addAll(originColumns);
        this.removeColumnNoReadFields(exportColumns);
        int maxExportSize = this.getMaxExportSize(null);
        ThreadCache.put((Object)"bos_report_limit_type", (Object)"largeDataExport");
        int exportRowCount = 0;
        boolean isLast = false;
        int startIndex = 0;
        int batchCount = 0;
        ArrayList<String> urls = new ArrayList<String>(10);
        String title = this.reportList.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        String fileName = this.getFilename(title);
        this.exportDataProvider = new ExportDataFromCache(listModel);
        while (!isLast) {
            try {
                if (ExportManager.isStopExport(this.reportList.getView().getPageId(), this.reportList.getModel().getDataEntityType().getName())) {
                    return "";
                }
                String fileNameBatch = fileName;
                if (batchCount > 0) {
                    fileNameBatch = fileName + "_" + batchCount;
                }
                this.reportList.getReportCache().setProgress(listModel.getPageId(), 5);
                ReportBatchQueryInfo byBatchInfo = this.reportListProxy.getByBatchInfo();
                int maxExcelRows = byBatchInfo.getMaxExcelRowCountPerSheet();
                ThreeTuple<Boolean, String, Integer> r = this.largeDataExportExcelPerBatch(listModel, byBatchInfo, columns, cols, exportColumns, map, startIndex, maxExcelRows, exportRowCount, fileNameBatch);
                if (!((Boolean)r.item1).booleanValue()) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)r.item2))) {
                        throw new KDException((String)r.item2);
                    }
                    return "";
                }
                int lastRowCountExport = (Integer)r.item3;
                exportRowCount += lastRowCountExport;
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)r.item2))) {
                    urls.add((String)r.item2);
                }
                if (exportRowCount >= maxExportSize || reportTaskResult.getBatchLoadInfo().isAllBatchLoaded() && startIndex + lastRowCountExport >= reportTaskResult.getRowCount()) {
                    isLast = true;
                }
                startIndex += maxExcelRows;
                int total = reportTaskResult.getBatchLoadInfo().getEstimateTotalRowCount();
                if (total > 0) {
                    int progress = exportRowCount * 100 / total;
                    if (progress > 100) {
                        progress = 99;
                    }
                    if (isLast) {
                        progress = 99;
                    }
                    this.reportList.getReportCache().setProgress(listModel.getPageId(), progress);
                }
                ++batchCount;
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                isLast = true;
                log.error((Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        if (exportRowCount == 0) {
            this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u518d\u5c1d\u8bd5\u5bfc\u51fa\u3002", (String)"ReportList_0", (String)"bos-form-core", (Object[])new Object[0]));
            return "";
        }
        ReportResultLimit resultLimit = listModel.getReportCache().getReportResultLimit(this.getPageId(listModel.getPageId()), listModel.getCtrlId());
        if (this.exportDataProvider.isExceededExportLimit() || resultLimit != null && resultLimit.isExceedLimitCount()) {
            log.info("\u83b7\u53d6\u6570\u636e\u8d85\u8fc7\u9650\u5236\u884c\u6570\uff0climitCount={}", (Object)maxExportSize);
            this.reportList.getReportCache().setException(this.reportList.getView().getPageId(), new ReportException(ReportException.ShowType.SHOW_MESSAGE, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u51fa\u8d85\u884c\u6570\u4e0a\u9650\uff08%1$s\u4e07\u884c\uff09\uff0c\r\n%2$s\u4e07\u884c\u5185\u6570\u636e\u5bfc\u51fa\u6210\u529f\uff0c\u8d85\u51fa\u90e8\u5206\u672a\u5bfc\u51fa\u3002", (String)"DataExcelExport_0", (String)"bos-form-core", (Object[])new Object[0]), this.maxExportLimit, this.maxExportLimit)));
        }
        return this.saveExportFileAsUrl(fileName, urls, false);
    }

    private Map<String, String> initFieldListToMap(List<Map<String, String>> initFieldList) {
        HashMap<String, String> resMap = new HashMap<String, String>(initFieldList.size());
        for (Map<String, String> map : initFieldList) {
            resMap.put(map.get("fieldkey"), map.get("isvisible"));
        }
        return resMap;
    }

    private void removeByInitField(List<AbstractReportColumn> columns, Map<String, String> initFieldMap) {
        Iterator<AbstractReportColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String fieldKey;
            AbstractReportColumn column = iterator.next();
            if (column instanceof ReportColumnGroup) {
                this.removeByInitField(((ReportColumnGroup)column).getChildren(), initFieldMap);
                continue;
            }
            if (!(column instanceof ReportColumn) || !initFieldMap.containsKey(fieldKey = ((ReportColumn)column).getFieldKey()) || Boolean.parseBoolean(initFieldMap.get(fieldKey))) continue;
            iterator.remove();
        }
    }

    private boolean isAllHide(List<GridConfigurationRow> gridConfigurationRowList, Map<String, AbstractReportColumn> allColumnMap) {
        for (GridConfigurationRow row : gridConfigurationRowList) {
            AbstractReportColumn abstractReportColumn = allColumnMap.get(row.getFieldKey());
            if (abstractReportColumn instanceof ReportColumn && !row.isHide()) {
                return false;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup) || row.isHide()) continue;
            return this.isAllHide(row.getChildren(), allColumnMap);
        }
        return true;
    }

    private void dealMulGroup(GridConfigurationRow gridConfigurationRow, Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> parentColumnMap) {
        for (GridConfigurationRow row : gridConfigurationRow.getChildren()) {
            AbstractReportColumn abstractReportColumn;
            if (row.getChildren().size() == 0 && row.isHide()) {
                abstractReportColumn = originColumnMap.get(row.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                    continue;
                }
                if (!(abstractReportColumn instanceof ReportColumn)) continue;
                this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                continue;
            }
            if (row.getChildren().size() <= 0) continue;
            if (row.isHide()) {
                abstractReportColumn = originColumnMap.get(gridConfigurationRow.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                } else if (abstractReportColumn instanceof ReportColumn) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                }
            }
            this.dealMulGroup(row, originColumnMap, parentColumnMap);
        }
    }

    private void removeGroupChild(Map<String, AbstractReportColumn> parentColumnMap, AbstractReportColumn abstractReportColumn, GridConfigurationRow row) {
        String fieldKey = "";
        if (abstractReportColumn instanceof ReportColumn) {
            fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
        } else if (abstractReportColumn instanceof ReportColumnGroup) {
            fieldKey = row.getFieldKey();
        }
        ReportColumnGroup reportColumnGroup = (ReportColumnGroup)parentColumnMap.get(fieldKey);
        if (reportColumnGroup == null) {
            return;
        }
        List columnList = reportColumnGroup.getChildren();
        Iterator iterator1 = columnList.iterator();
        while (iterator1.hasNext()) {
            AbstractReportColumn abstractReportColumn1 = (AbstractReportColumn)iterator1.next();
            if (abstractReportColumn1 instanceof ReportColumn) {
                if (!((ReportColumn)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
                iterator1.remove();
                continue;
            }
            if (!(abstractReportColumn1 instanceof ReportColumnGroup) || !((ReportColumnGroup)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
            iterator1.remove();
        }
    }

    private void allColumnMap(Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> map, Map<String, AbstractReportColumn> parentColumnMap) {
        for (Map.Entry<String, AbstractReportColumn> entry : originColumnMap.entrySet()) {
            if (entry.getValue() instanceof ReportColumn) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof ReportColumnGroup)) continue;
            map.put(entry.getKey(), entry.getValue());
            HashMap<String, AbstractReportColumn> groupMap = new HashMap<String, AbstractReportColumn>();
            for (AbstractReportColumn column : ((ReportColumnGroup)entry.getValue()).getChildren()) {
                if (column instanceof ReportColumn) {
                    groupMap.put(((ReportColumn)column).getFieldKey(), column);
                    parentColumnMap.put(((ReportColumn)column).getFieldKey(), entry.getValue());
                    continue;
                }
                if (!(column instanceof ReportColumnGroup)) continue;
                groupMap.put(((ReportColumnGroup)column).getFieldKey(), column);
                parentColumnMap.put(((ReportColumnGroup)column).getFieldKey(), entry.getValue());
            }
            this.allColumnMap(groupMap, map, parentColumnMap);
        }
    }

    @SdkInternal
    protected ThreeTuple<Boolean, String, Integer> largeDataExportExcelPerBatch(AbstractReportListModel listModel, ReportBatchQueryInfo byBatchInfo, List<AbstractReportColumn> columns, List<ReportColumn> cols, List<AbstractReportColumn> exportColumns, Map<String, Boolean> map, int startIndex, int excelMaxrow, int exportedRowCount, String fileName) {
        try {
            int rowCount = 0;
            IExporter exporter = (IExporter)Class.forName(this.reportList.getExcelExporter()).newInstance();
            SXSSFWorkbook wb = new SXSSFWorkbook(-1);
            TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(){

                public File createTempFile(String prefix, String suffix) throws IOException {
                    return File.createTempFile(prefix, suffix);
                }
            });
            SXSSFSheet sheet = wb.createSheet("sheet1");
            exporter.setWb(wb);
            exporter.setCaption(this.reportList.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
            exporter.setSearchCondition(this.reportList.getView().getPageCache().get("searchCondition"));
            exporter.setMap(map);
            exporter.setSheetName("sheet1");
            exporter.setMergeColumnRules(this.exportInitializeEvent.getMergeColumnRules());
            int size = 10000;
            int times = excelMaxrow / size;
            boolean hasMod = false;
            if (excelMaxrow % size != 0) {
                ++times;
                hasMod = true;
            }
            exporter.setSize(size);
            boolean isFlexFieldSplit = false;
            ArrayList<AbstractReportColumn> flexSplitColumns = new ArrayList();
            for (int i = 0; i < times; ++i) {
                DynamicObjectCollection data;
                exporter.setLoopTimes(i);
                int rowSize = size;
                if (i == times - 1 && hasMod) {
                    rowSize = excelMaxrow - i * size;
                }
                if ((data = this.getExportDataProvider(listModel).getRowData(startIndex + i * size, rowSize)) == null || data.size() == 0) {
                    sheet.flushRows();
                    break;
                }
                NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)data, cols);
                listModel.preProcessExportData(exportColumns, data, numberFormatProvider);
                if (!isFlexFieldSplit) {
                    flexSplitColumns = (List)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)((Object)exportColumns))));
                    this.reportList.getFlexColumnSplitService().splitFlextColumn(flexSplitColumns);
                    exporter.setReportList(this.reportList);
                    isFlexFieldSplit = true;
                }
                exporter.export(flexSplitColumns, data, numberFormatProvider);
                rowCount += data.size();
                sheet.flushRows();
                IReportView reportView = (IReportView)this.reportList.getView();
                reportView.setProgress(exportedRowCount + i * size);
                if (data.size() < size) break;
            }
            this.endExport(exporter, times);
            String url = "";
            if (rowCount > 0) {
                if (this.getExportDataProvider(listModel).isWriteFileByRedis()) {
                    url = this.writeFile(wb, fileName);
                } else {
                    String path = this.getExportFilePath(fileName + ".xlsx");
                    url = this.writeFile2AttachmentFileService(wb, fileName + ".xlsx", path);
                }
            }
            wb.dispose();
            return new ThreeTuple((Object)true, (Object)url, (Object)rowCount);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                String sError = ResManager.loadKDString((String)"\u62a5\u8868\u5b57\u6bb5\u5168\u90e8\u9690\u85cf\u65f6\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"ReportList_2", (String)"bos-form-core", (Object[])new Object[0]);
                this.reportList.getView().showErrorNotification(sError);
                return new ThreeTuple((Object)false, null, (Object)0);
            }
            if (e.getErrorCode().equals((Object)BosErrorCode.paramError)) {
                this.reportList.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u5143\u683c\u5b57\u7b26\u8d85\u51faExcel\u9650\u5236\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"GridExcelExporter_2", (String)"bos-form-mvc", (Object[])new Object[0]));
                return new ThreeTuple((Object)false, null, (Object)0);
            }
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private boolean isExceedLimitCount() {
        AbstractReportListModel reportModel = this.reportList.getAbstractReportModel();
        ReportResultLimit limit = reportModel.getReportCache().getReportResultLimit(reportModel.getPageId(), reportModel.getCtrlId());
        if (limit != null) {
            return limit.isExceedLimitCount();
        }
        return false;
    }
}

