/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.export.AbstractReportExport;

public class NormalPdfExport
extends AbstractReportExport {
    public NormalPdfExport(ReportList reportList) {
        this.reportList = reportList;
    }

    public String exportPdf(PaperSetting info, Map<String, Object> columnSetting) {
        AbstractReportListModel listModel = this.reportList.getAbstractReportModel();
        if (listModel.getRowCount() == 0) {
            this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u518d\u5c1d\u8bd5\u5bfc\u51fa\u3002", (String)"ReportList_0", (String)"bos-form-core", (Object[])new Object[0]));
            return "";
        }
        DynamicObjectCollection data = listModel.getRowData(0, listModel.getRowCount());
        List<AbstractReportColumn> columns = this.getReportListProxy().getColumnList(listModel);
        List<ReportColumn> cols = this.reportListProxy.getReportColumnList(columns, true);
        NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)data, cols);
        ArrayList<AbstractReportColumn> exportColumns = new ArrayList<AbstractReportColumn>();
        FormatObject format = this.reportListProxy.getFormat();
        for (AbstractReportColumn abstractReportColumn : cols) {
            boolean isHidden;
            String fieldKey;
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn child : childrens) {
                    if (child instanceof ReportOperationColumn) continue;
                    if (child instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)child, format);
                        continue;
                    }
                    child.setUserFormat(format);
                }
            } else {
                abstractReportColumn.setUserFormat(format);
            }
            if (!this.reportList.hasReadFieldRight(fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey()) || (isHidden = this.isHiddenColumn(fieldKey, columnSetting))) continue;
            exportColumns.add(abstractReportColumn);
        }
        try {
            IExporter exporter = (IExporter)Class.forName(this.reportList.getPdfExporter()).newInstance();
            IFormView iFormView = this.reportList.getView();
            if (iFormView != null) {
                info.setAppId(iFormView.getFormShowParameter().getAppId());
            }
            return exporter.export(exportColumns, data, numberFormatProvider, info, columnSetting, this.removeHiddenColumn(exportColumns, columns, columnSetting));
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                this.reportList.getView().showErrorNotification(BosErrorCode.reportHeadEmpty.getMessage());
            }
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return "";
    }

    private boolean isHiddenColumn(String fieldKey, Map<String, Object> gridInfo) {
        Map columnVisible;
        boolean isHidden = false;
        if (gridInfo != null && (columnVisible = (Map)gridInfo.get("cv")) != null) {
            boolean visible;
            String replaceName = fieldKey;
            if (fieldKey.contains(".")) {
                replaceName = fieldKey.replace('.', '_');
            }
            if (columnVisible.containsKey(replaceName) && !(visible = ((Boolean)columnVisible.get(replaceName)).booleanValue())) {
                isHidden = true;
            }
        }
        return isHidden;
    }

    private List<AbstractReportColumn> removeHiddenColumn(List<AbstractReportColumn> exportColumns, List<AbstractReportColumn> rawColumns, Map<String, Object> columnSetting) {
        ArrayList<AbstractReportColumn> showColumns = new ArrayList<AbstractReportColumn>(10);
        for (AbstractReportColumn column : rawColumns) {
            String fieldKey = "";
            if (column instanceof ReportColumn) {
                fieldKey = ((ReportColumn)column).getFieldKey();
            } else if (column instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)column).getFieldKey();
            }
            boolean isHidden = this.isHiddenColumn2(fieldKey, columnSetting);
            if (!isHidden) {
                showColumns.add(column);
            }
            if (!(column instanceof ReportColumnGroup) || !isHidden) continue;
            ArrayList<AbstractReportColumn> children = new ArrayList<AbstractReportColumn>();
            this.initChildren((ReportColumnGroup)column, children);
            exportColumns.removeIf(o -> children.contains(o));
        }
        return showColumns;
    }

    private boolean isHiddenColumn2(String fieldKey, Map<String, Object> gridInfo) {
        Map columnVisible;
        boolean isHidden = false;
        if (gridInfo != null && (columnVisible = (Map)gridInfo.get("cv")) != null) {
            String replaceName = fieldKey;
            if (fieldKey.contains(".")) {
                replaceName = fieldKey.replace('.', '_');
            }
            if (columnVisible.containsKey(replaceName)) {
                boolean visible = (Boolean)columnVisible.get(replaceName);
                if (!visible) {
                    isHidden = true;
                }
            } else {
                isHidden = true;
            }
        }
        return isHidden;
    }

    private void initChildren(ReportColumnGroup reportColumnGroup, List<AbstractReportColumn> result) {
        if (!CollectionUtils.isEmpty((Collection)reportColumnGroup.getChildren())) {
            for (AbstractReportColumn temp : reportColumnGroup.getChildren()) {
                if (temp instanceof ReportColumnGroup) {
                    this.initChildren((ReportColumnGroup)temp, result);
                    continue;
                }
                result.add(temp);
            }
        }
    }
}

