/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.flex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FlexReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.report.ReportList;

public class FlexColumnSplitService {
    private Map<String, List<FlexProperty>> flexPropertiesMap = new HashMap<String, List<FlexProperty>>();
    private Map<String, List<FlexProperty>> allFlexPropertiesMap = new HashMap<String, List<FlexProperty>>();
    private MainEntityType entityType;
    private String callParam;
    private static final String FLEX_PARAM = "flexParam";
    private Map<String, FlexProperty> flexBaseFieldKeyMap = new HashMap<String, FlexProperty>();
    private List<String> flexFieldList = new ArrayList<String>();
    private ReportList reportList;
    Map<String, GridConfigurationRow> gridConfigMap = new HashMap<String, GridConfigurationRow>();
    private Map<String, String> flexMaxSizeShowMap = new HashMap<String, String>();
    private Map<String, Boolean> isDefaultSplitMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> flexFieldCanSplitMap = new HashMap<String, Boolean>();

    public String getCallParam() {
        return this.callParam;
    }

    public void setCallParam(String callParam) {
        this.callParam = callParam;
    }

    public Map<String, FlexProperty> getFlexBaseFieldKeyMap() {
        return this.flexBaseFieldKeyMap;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public List<String> getFlexFieldList() {
        return this.flexFieldList;
    }

    public void setReportList(ReportList reportList) {
        this.reportList = reportList;
    }

    public void init() {
        List<GridConfigurationRow> gridConfigRows = this.reportList.getReportListProxy().getUserGridConfigRows();
        this.findAllGroupField(gridConfigRows);
    }

    private void findAllGroupField(List<GridConfigurationRow> gridConfigRows) {
        for (GridConfigurationRow row : gridConfigRows) {
            if (row.getChildren().size() <= 0) continue;
            this.gridConfigMap.put(row.getFieldKey(), row);
            List children = row.getChildren();
            this.findAllGroupField(children);
        }
    }

    public void splitFlextColumn(List<AbstractReportColumn> columns) {
        Map<String, Integer> gridConfigRowMap = this.getGridConfigRowMap();
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (column instanceof ReportColumn) {
                ReportColumnGroup group;
                Map<String, Integer> map;
                ReportColumn reportColumn = (ReportColumn)column;
                if (!"flex".equals(reportColumn.getFieldType())) continue;
                if (!this.flexFieldList.contains(reportColumn.getFieldKey())) {
                    this.flexFieldList.add(reportColumn.getFieldKey());
                }
                if (!this.isNeedSplit(reportColumn, gridConfigRowMap)) continue;
                Integer flag = -1;
                List<GridConfigurationRow> gridConfigRows = this.reportList.getReportListProxy().getUserGridConfigRows();
                if (!CollectionUtils.isEmpty(gridConfigRows) && (flag = (map = gridConfigRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o))).get(reportColumn.getFieldKey())) != null && flag == 1) {
                    ReportColumnGroup group2 = this.split(reportColumn);
                    columns.set(i, (AbstractReportColumn)group2);
                    continue;
                }
                if (flag == null) {
                    group = this.split(reportColumn);
                    columns.set(i, (AbstractReportColumn)group);
                    continue;
                }
                if (flag != -1 || !this.isDefaultSplitMap.get(reportColumn.getFieldKey()).booleanValue()) continue;
                group = this.split(reportColumn);
                columns.set(i, (AbstractReportColumn)group);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup groupCol = (ReportColumnGroup)column;
            this.splitFlextColumn(groupCol.getChildren());
        }
    }

    public List<ReportColumn> flatFlextColumn(List<ReportColumn> columns) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>(10);
        Map<String, Integer> gridConfigRowMap = this.getGridConfigRowMap();
        for (ReportColumn column : columns) {
            if ("flex".equals(column.getFieldType())) {
                if (!this.flexFieldList.contains(column.getFieldKey())) {
                    this.flexFieldList.add(column.getFieldKey());
                }
                if (this.isNeedSplit(column, gridConfigRowMap)) {
                    List<ReportColumn> flexProps = this.flat(column);
                    list.addAll(flexProps);
                    continue;
                }
                list.add(column);
                continue;
            }
            list.add(column);
        }
        return list;
    }

    public List<Object> getFlexValue(ReportColumn flexColumn, FlexValueFormatter flexFormatter, DynamicObject dr, Map<String, Integer> gridConfigRowsMap) {
        ArrayList<Object> list = new ArrayList(10);
        if (!this.isNeedSplit(flexColumn, gridConfigRowsMap)) {
            Object obj = this.getOriginFlexFieldValue(flexColumn, flexFormatter, dr);
            list.add(obj);
            return list;
        }
        list = this.getSplitFieldValue(flexColumn, flexFormatter, dr);
        return list;
    }

    public Map<String, Object> getSplitFlexFieldValue(FlexProp flexProp, FlexValueFormatter flexFormatter, DynamicObject dr) {
        HashMap<String, Object> flexValues = new HashMap<String, Object>();
        Map<String, Integer> map = this.buildSplitFieldIndex(flexProp.getFlexTypeId());
        List<FlexProperty> flexProperties = this.flexPropertiesMap.get(String.valueOf(flexProp.getFlexTypeId()));
        Object flexVal = flexFormatter.getDisplayValueForReport(dr, flexProp, flexProp.getBasePropertyKey());
        if (!StringUtils.isBlank((Object)flexVal)) {
            ArrayList result = (ArrayList)flexVal;
            for (Object obj : result) {
                String[] val = String.valueOf(obj).split(":");
                Integer index = map.get(val[0]);
                if (index == null) continue;
                String flexBaseFieldKey = flexProp.getName() + "___" + flexProperties.get(index).getNumber();
                flexValues.put(flexBaseFieldKey, val[1]);
            }
        }
        return flexValues;
    }

    public String getFlexFieldKey(String flexSplitBaseKey) {
        return flexSplitBaseKey.split("___")[0];
    }

    public void clearFlexProperties() {
        this.flexPropertiesMap = new HashMap<String, List<FlexProperty>>();
        this.init();
    }

    private List<Object> getSplitFieldValue(ReportColumn flexColumn, FlexValueFormatter flexFormatter, DynamicObject dr) {
        FlexProp flexProp = (FlexProp)flexColumn.getFieldProperty();
        Map<String, Integer> map = this.buildSplitFieldIndex(flexProp.getFlexTypeId());
        Object[] array = new Object[map.size()];
        Object flexVal = flexFormatter.getDisplayValueForReport(dr, (FlexProp)flexColumn.getFieldProperty(), ((FlexProp)flexColumn.getFieldProperty()).getBasePropertyKey());
        if (!StringUtils.isBlank((Object)flexVal)) {
            ArrayList result = (ArrayList)flexVal;
            for (Object obj : result) {
                String[] val = String.valueOf(obj).split(":");
                Integer index = map.get(val[0]);
                if (index == null) continue;
                array[index.intValue()] = val[1];
            }
        }
        return Arrays.stream(array).collect(Collectors.toList());
    }

    private Map<String, Integer> buildSplitFieldIndex(int flexTypeId) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(16);
        List<FlexProperty> flexProperties = this.flexPropertiesMap.get(String.valueOf(flexTypeId));
        for (int i = 0; i < flexProperties.size(); ++i) {
            map.put(flexProperties.get(i).getGLName(), i);
        }
        return map;
    }

    private Object getOriginFlexFieldValue(ReportColumn flexColumn, FlexValueFormatter flexFormatter, DynamicObject dr) {
        Object list = flexFormatter.getDisplayValueForReport(dr, (FlexProp)flexColumn.getFieldProperty(), ((FlexProp)flexColumn.getFieldProperty()).getBasePropertyKey());
        Object object = list instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)list) : list;
        return object;
    }

    private List<ReportColumn> flat(ReportColumn reportColumn) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>(10);
        FlexProp flexProp = (FlexProp)reportColumn.getFieldProperty();
        if (flexProp == null) {
            flexProp = (FlexProp)this.entityType.getProperty(reportColumn.getFieldKey());
        }
        List<FlexProperty> flexProperties = this.getFlexProperties(flexProp.getFlexTypeId(), reportColumn.getFieldKey());
        for (FlexProperty property : flexProperties) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(reportColumn.getFieldKey() + "___" + property.getNumber());
            col.setFieldType(this.getReportType(property));
            col.setCaption(property.getName());
            this.flexBaseFieldKeyMap.put(reportColumn.getFieldKey() + "___" + property.getNumber(), property);
            list.add(col);
        }
        return list;
    }

    private ReportColumnGroup split(ReportColumn reportColumn) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(reportColumn.getFieldKey());
        group.setCaption(reportColumn.getCaption());
        FlexProp flexProp = (FlexProp)this.entityType.getProperty(reportColumn.getFieldKey());
        int count = 0;
        int maxSize = this.getMaxSize(reportColumn.getFieldKey());
        List<FlexProperty> flexProperties = "listFieldsControl".equals(this.getCallParam()) ? this.getAllFlexProperties(flexProp.getFlexTypeId()) : this.getFlexProperties(flexProp.getFlexTypeId(), reportColumn.getFieldKey());
        for (FlexProperty property : flexProperties) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(reportColumn.getFieldKey() + "___" + property.getNumber());
            col.setFieldType(this.getReportType(property));
            col.setCaption(property.getName());
            if (count >= maxSize) {
                col.setHide(true);
            }
            this.flexBaseFieldKeyMap.put(reportColumn.getFieldKey() + "___" + property.getNumber(), property);
            group.getChildren().add(col);
            ++count;
        }
        return group;
    }

    private String getReportType(FlexProperty property) {
        if ("1".equals(property.getValueType()) || "2".equals(property.getValueType())) {
            return "basedata";
        }
        if ("3".equals(property.getValueType())) {
            return "text";
        }
        return "text";
    }

    private List<FlexProperty> getAllFlexProperties(int flexType) {
        List flexProperties;
        String paramMapStr = this.reportList.getView().getPageCache().get(FLEX_PARAM);
        if (StringUtils.isNotEmpty((CharSequence)paramMapStr) && !StringUtils.equals((CharSequence)paramMapStr, (CharSequence)"null")) {
            flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexType);
            flexProperties = this.getFilterFlex(flexProperties, paramMapStr);
        } else {
            flexProperties = this.allFlexPropertiesMap.get(String.valueOf(flexType));
            if (flexProperties == null) {
                flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexType);
                this.allFlexPropertiesMap.put(String.valueOf(flexType), flexProperties);
            }
        }
        return flexProperties;
    }

    public List<FlexProperty> getAllFlexProperties(String fieldKey) {
        List flexProperties;
        FlexProp flexProp = (FlexProp)this.entityType.getProperty(fieldKey);
        int flexType = flexProp.getFlexTypeId();
        String paramMapStr = this.reportList.getView().getPageCache().get(FLEX_PARAM);
        if (StringUtils.isNotEmpty((CharSequence)paramMapStr) && !StringUtils.equals((CharSequence)paramMapStr, (CharSequence)"null")) {
            flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexType);
            flexProperties = this.getFilterFlex(flexProperties, paramMapStr);
        } else {
            flexProperties = this.allFlexPropertiesMap.get(String.valueOf(flexType));
            if (flexProperties == null) {
                flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexType);
                this.allFlexPropertiesMap.put(String.valueOf(flexType), flexProperties);
            }
        }
        return flexProperties;
    }

    public Map getFlexPropertiesSize() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<AbstractReportColumn> columnList = this.reportList.getColumns();
        for (AbstractReportColumn column : columnList) {
            if (!(column instanceof ReportColumn) || !"flex".equals(((ReportColumn)column).getFieldType())) continue;
            ReportColumn reportColumn = (ReportColumn)column;
            FlexProp flexProp = (FlexProp)reportColumn.getFieldProperty();
            if (flexProp == null) {
                flexProp = (FlexProp)this.entityType.getProperty(reportColumn.getFieldKey());
            }
            int flexType = flexProp.getFlexTypeId();
            List propertyList = FlexEntityMetaUtils.getFlexProperties((int)flexType);
            int size = propertyList.size();
            map.put(reportColumn.getFieldKey() + "," + reportColumn.getCaption().toString(), size);
        }
        return map;
    }

    public boolean isFlexType(String fieldKey) {
        if (this.reportList.getView().getPageCache().get("flexFieldCanSplitMap") == null) {
            return false;
        }
        Map flexFieldCanSplitMap = (Map)SerializationUtils.fromJsonString((String)this.reportList.getView().getPageCache().get("flexFieldCanSplitMap"), Map.class);
        if (CollectionUtils.isEmpty((Map)flexFieldCanSplitMap)) {
            return false;
        }
        return flexFieldCanSplitMap.containsKey(fieldKey);
    }

    private List<FlexProperty> getFlexProperties(int flexType, String fieldKey) {
        List<Object> flexProperties = this.flexPropertiesMap.get(String.valueOf(flexType));
        if (flexProperties == null) {
            flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexType);
            String paramMapStr = this.reportList.getView().getPageCache().get(FLEX_PARAM);
            if (StringUtils.isNotEmpty((CharSequence)paramMapStr) && !StringUtils.equals((CharSequence)paramMapStr, (CharSequence)"null")) {
                flexProperties = this.getFilterFlex(flexProperties, paramMapStr);
            }
            if (flexProperties.size() > this.getMaxSize(fieldKey)) {
                GridConfigurationRow row = this.gridConfigMap.get(fieldKey);
                if (row == null) {
                    flexProperties = flexProperties.subList(0, this.getMaxSize(fieldKey));
                } else {
                    ArrayList<FlexProperty> properties = new ArrayList<FlexProperty>();
                    block0: for (GridConfigurationRow child : row.getChildren()) {
                        if (child.isHide()) continue;
                        String flexName = child.getFieldKey().substring((fieldKey + "___").length());
                        for (FlexProperty flexProperty : flexProperties) {
                            if (!flexProperty.getNumber().equals(flexName)) continue;
                            properties.add(flexProperty);
                            continue block0;
                        }
                    }
                    flexProperties = properties.size() > this.getMaxSize(fieldKey) ? properties.subList(0, this.getMaxSize(fieldKey)) : properties;
                }
            }
            this.flexPropertiesMap.put(String.valueOf(flexType), flexProperties);
        } else if (flexProperties.size() > this.getMaxSize(fieldKey)) {
            flexProperties = flexProperties.subList(0, this.getMaxSize(fieldKey));
        }
        return flexProperties;
    }

    private List<FlexProperty> getFilterFlex(List<FlexProperty> flexProperties, String paramMap) {
        ArrayList<FlexProperty> filterFlexList = new ArrayList<FlexProperty>();
        List list = (List)SerializationUtils.fromJsonString((String)paramMap, List.class);
        for (FlexProperty flexProperty : flexProperties) {
            if (!list.contains(flexProperty.getFlexField())) continue;
            filterFlexList.add(flexProperty);
        }
        return filterFlexList;
    }

    public int getMaxSize(String fieldKey) {
        String maxSize = this.flexMaxSizeShowMap.get(fieldKey);
        int size = StringUtils.isEmpty((CharSequence)maxSize) ? 0 : Integer.parseInt(maxSize);
        List<GridConfigurationRow> gridConfigRows = this.reportList.getReportListProxy().getUserGridConfigRows();
        for (GridConfigurationRow row : gridConfigRows) {
            if (!StringUtils.equals((CharSequence)row.getFieldKey(), (CharSequence)fieldKey) || row.getLastFlexMaxSize() <= size) continue;
            size = row.getLastFlexMaxSize();
        }
        return size;
    }

    public boolean isNeedSplit(String fieldKey) {
        return this.flexFieldCanSplitMap.containsKey(fieldKey) && this.flexFieldCanSplitMap.get(fieldKey) != false;
    }

    private boolean isNeedSplit(ReportColumn column, Map<String, Integer> gridConfigRowMap) {
        FlexReportColumn flexReportColumn;
        if (column.isHide()) {
            return false;
        }
        Boolean canSplit = false;
        String flexMaxShow = "40";
        Boolean defaultSplit = false;
        Boolean closeAllSplitColumn = Boolean.parseBoolean(System.getProperty("is_need_close_all_splitcolumn", "false"));
        if (closeAllSplitColumn.booleanValue()) {
            canSplit = false;
        }
        if (column instanceof FlexReportColumn && (canSplit = Boolean.valueOf((flexReportColumn = (FlexReportColumn)column).isNeedSplit())).booleanValue()) {
            flexMaxShow = flexReportColumn.getFlexMaxShow();
            defaultSplit = flexReportColumn.isDefaultSplit();
            this.flexMaxSizeShowMap.put(column.getFieldKey(), flexMaxShow);
            this.isDefaultSplitMap.put(column.getFieldKey(), defaultSplit);
            this.reportList.getView().getPageCache().put("flexMaxSizeShowMap", SerializationUtils.toJsonString(this.flexMaxSizeShowMap));
            this.reportList.getView().getPageCache().put("isDefaultSplitMap", SerializationUtils.toJsonString(this.isDefaultSplitMap));
        }
        this.flexFieldCanSplitMap.put(column.getFieldKey(), canSplit);
        this.reportList.getView().getPageCache().put("flexFieldKeys", SerializationUtils.toJsonString(this.flexFieldList));
        this.reportList.getView().getPageCache().put("flexFieldCanSplitMap", SerializationUtils.toJsonString(this.flexFieldCanSplitMap));
        Integer flag = -1;
        if (!CollectionUtils.isEmpty(gridConfigRowMap)) {
            flag = gridConfigRowMap.get(column.getFieldKey());
        }
        Integer flexSplit = flag == null ? Integer.valueOf(-1) : flag;
        return canSplit != false && flexSplit == 1 || canSplit != false && defaultSplit != false && flexSplit == -1;
    }

    private Map<String, Integer> getGridConfigRowMap() {
        List<GridConfigurationRow> gridConfigRows = this.reportList.getReportListProxy().getUserGridConfigRows();
        Map<String, Integer> map = new HashMap<String, Integer>();
        if (!CollectionUtils.isEmpty(gridConfigRows)) {
            map = gridConfigRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
        }
        return map;
    }
}

