/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.report.processor.AbstractProcessor;
import kd.bos.report.processor.BasedataProcessor;
import kd.bos.report.processor.DateProcessor;
import kd.bos.report.processor.EnumProcessor;
import kd.bos.report.processor.IReportColumnProcessor;
import kd.bos.report.processor.NumberProcessor;
import kd.bos.report.processor.TextProcessor;

public class RefPropProcessor
extends AbstractProcessor {
    private IReportColumnProcessor innerProcessor;

    @Override
    public Map<String, Object> createFilterInfo() {
        IReportColumnProcessor processor = this.getOrCreaetInnerProcessor();
        if (processor != null) {
            return processor.createFilterInfo();
        }
        return super.createFilterInfo();
    }

    private IReportColumnProcessor getOrCreaetInnerProcessor() {
        ReportColumn col = this.getColumn();
        if (col != null && this.innerProcessor == null && col.getRefBasedataProp() != null && col.getFieldProperty() instanceof IBasedataField) {
            IDataEntityType bdType = ((IBasedataField)col.getFieldProperty()).getComplexType();
            if (!(bdType instanceof MainEntityType)) {
                return null;
            }
            IDataEntityProperty prop = (IDataEntityProperty)bdType.getProperties().get((Object)col.getDisplayProp());
            if (prop == null) {
                return null;
            }
            IReportColumnProcessor processor = null;
            if (!(prop instanceof IBasedataField)) {
                if (prop instanceof TextProp) {
                    processor = this.createTextProcessor();
                } else if (prop instanceof DecimalProp || prop instanceof DateTimeProp || prop instanceof ComboProp) {
                    // empty if block
                }
            }
            if (processor != null) {
                processor.setView(this.getView());
                processor.setFieldKey(this.getFieldKey());
                processor.setFieldType(this.getFieldType());
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)bdType), (String)prop.getName());
                processor.setFilterField(filterField);
                this.innerProcessor = processor;
            }
        }
        return this.innerProcessor;
    }

    @Override
    protected List<CompareType> getCompareTypes(List<CompareType> compareTypes) {
        return new ArrayList<CompareType>(0);
    }

    private IReportColumnProcessor createBasedataProcessor() {
        return new BasedataProcessor();
    }

    private IReportColumnProcessor createDateProcessor() {
        return new DateProcessor();
    }

    private IReportColumnProcessor createEnumProcessor() {
        return new EnumProcessor();
    }

    private IReportColumnProcessor createNumberProcessor() {
        return new NumberProcessor();
    }

    private IReportColumnProcessor createTextProcessor() {
        return new TextProcessor();
    }
}

