/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.summate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.events.SummaryEvent;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.sdk.annotation.SdkInternal;

public class ReportCalculateTotal {
    private IClientViewProxy clientViewProxy;
    private ReportList reportList;

    public ReportCalculateTotal(ReportList reportList, IClientViewProxy clientViewProxy) {
        this.reportList = reportList;
        this.clientViewProxy = clientViewProxy;
    }

    @SdkInternal
    public void getSumData() {
        ArrayList<SummaryEvent> summaryEvents = new ArrayList<SummaryEvent>(16);
        AbstractReportListModel model = this.reportList.getAbstractReportModel();
        Map<String, Object> summaryValueMap = model.getSummaryValueMap();
        for (String fieldKey : summaryValueMap.keySet()) {
            SummaryEvent summaryEvent = new SummaryEvent();
            summaryEvent.setColumnName(fieldKey);
            summaryEvents.add(summaryEvent);
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setFloatButtomData(summaryEvents);
        }
        HashMap<String, Object> formatSummaryValueMap = new HashMap<String, Object>(summaryEvents.size());
        for (SummaryEvent summaryEvent : summaryEvents) {
            formatSummaryValueMap.put(summaryEvent.getColumnName(), summaryEvent.getFormatSummaryValue());
        }
        if (!formatSummaryValueMap.isEmpty()) {
            this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "setFloatButtomData", new Object[]{formatSummaryValueMap});
            this.reportList.getView().getPageCache().put(String.format("%s:%s", "bottomData", this.reportList.getKey()), SerializationUtils.toJsonString(formatSummaryValueMap));
            this.reportList.getView().sendFormAction(this.reportList.getView());
            this.sendMessage(this.clientViewProxy.getActionResult());
        }
    }

    private void sendMessage(List<Object> actions) {
        String rootPageId = this.reportList.getView().getFormShowParameter().getRootPageId();
        RequestContext rc = RequestContext.get();
        List webSocketIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)rc.getGlobalSessionId());
        HashSet set = new HashSet(webSocketIds);
        if (StringUtils.isNotBlank((CharSequence)rootPageId) && set.contains(rootPageId)) {
            MsgSendFactory.getSender().send(rootPageId, SerializationUtils.toJsonString(actions));
        }
    }
}

