/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.systree;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.CloudMetadataCache;
import kd.bos.entity.NodeInfo;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

abstract class SystemTree {
    private static Log log = LogFactory.getLog(SystemTree.class);
    TreeNode rootNode = new TreeNode("", "rootNode", ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"AppTree_1", (String)"bos-kddm-core", (Object[])new Object[0]), (Object)"root");
    protected Map<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>();
    Map<String, String> deployAppIdNumMap = new HashMap<String, String>();
    boolean moveNullChilden = true;
    boolean includeDisable = false;
    private static final String REGION = "appmeta";
    private static final CacheConfigInfo info = new CacheConfigInfo();

    SystemTree() {
    }

    public void setMoveNullChilden(boolean moveNullChilden) {
        this.moveNullChilden = moveNullChilden;
    }

    public void setIncludeDisable(boolean includeDisable) {
        this.includeDisable = includeDisable;
    }

    public TreeNode initRootNode(String id, String text, Object data) {
        this.rootNode.setId(id);
        this.rootNode.setText(text);
        this.rootNode.setData(data);
        this.treeNodeMap.put(this.rootNode.getId(), this.rootNode);
        return this.rootNode;
    }

    public abstract TreeNode loadTree(BiFunction<String, NodeInfo, TreeNode> var1);

    TreeNode loadRootNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        TreeNode node;
        if (biFunction != null && (node = biFunction.apply(this.rootNode.getId(), null)) != null) {
            this.rootNode = node;
        }
        return this.rootNode;
    }

    void loadCloudNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        Map cloudInfoMap = CloudMetadataCache.getAllCloudInfo();
        for (NodeInfo cloudInfo : cloudInfoMap.values()) {
            TreeNode node = this.createTreeNode(this.rootNode.getId(), cloudInfo, biFunction);
            if (node == null) continue;
            this.rootNode.addChild(node);
        }
    }

    void loadAppNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        Map appMap = AppMetadataCache.getAllAppInfo();
        for (AppInfo appInfo : appMap.values()) {
            if (!this.includeDisable && (!appInfo.isVisible() || !appInfo.getDeployStatus().equals("2"))) continue;
            this.deployAppIdNumMap.put(appInfo.getId(), appInfo.getAppId());
            TreeNode parentNode = this.treeNodeMap.get(appInfo.getCloudId());
            if (parentNode != null) {
                TreeNode node = this.createTreeNode(parentNode.getId(), (NodeInfo)appInfo, biFunction);
                if (node == null) continue;
                parentNode.addChild(node);
                continue;
            }
            log.info("\u5e94\u7528{}\u5bf9\u5e94\u7684\u4e91{}\u4e0d\u5b58\u5728\u3002", (Object)appInfo.getAppId(), (Object)appInfo.getCloudId());
        }
    }

    TreeNode createTreeNode(String parentId, NodeInfo nodeInfo, BiFunction<String, NodeInfo, TreeNode> biFunction) {
        if (nodeInfo == null || nodeInfo.getName() == null) {
            return null;
        }
        TreeNode node = biFunction != null ? biFunction.apply(parentId, nodeInfo) : new TreeNode(parentId, nodeInfo.getId(), nodeInfo.getName().getLocaleValue(), (Object)nodeInfo.getNodeType());
        String nodeId = nodeInfo.getId();
        if (nodeInfo instanceof AppInfo) {
            nodeId = ((AppInfo)nodeInfo).getAppId();
        }
        this.treeNodeMap.put(nodeId, node);
        return node;
    }

    void removeNullChildNode(TreeNode node) {
        if (node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                TreeNode childNode = (TreeNode)it.next();
                if (childNode.getChildren() == null) {
                    it.remove();
                    continue;
                }
                this.removeNullChildNode(childNode);
            }
        }
    }

    private Collection<AppNodeInfo> loadDisableAppNode() {
        String sql = "SELECT A.FID,A.FMASTERID,FNUMBER,FBIZCLOUDID,FSEQ,A.FTYPE,B.FLOCALEID,B.FNAME,B.FDESCRIPTION FROM T_META_BIZAPP A INNER JOIN T_META_BIZAPP_L B ON A.FID = B.FID WHERE A.FVISIBLE = '0' ORDER BY A.FINHERITPATH ";
        return (Collection)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Collection<AppNodeInfo>>(){

            public Collection<AppNodeInfo> handle(ResultSet rs) throws Exception {
                HashMap<String, AppNodeInfo> disableAppMap = new HashMap<String, AppNodeInfo>(16);
                HashMap<String, String> disableAppIdNumberMap = new HashMap<String, String>();
                Map allRuntimeAppInfo = AppMetadataCache.getAllAppInfo();
                HashMap<String, AppInfo> runtimeAppIdMap = new HashMap<String, AppInfo>(allRuntimeAppInfo.size());
                for (AppInfo appInfo : allRuntimeAppInfo.values()) {
                    runtimeAppIdMap.put(appInfo.getId(), appInfo);
                }
                while (rs.next()) {
                    String id = rs.getString("FID");
                    String appId = rs.getString("FNUMBER");
                    String cloudId = rs.getString("FBIZCLOUDID");
                    short seq = rs.getShort("FSEQ");
                    String locale = rs.getString("FLOCALEID");
                    String name = rs.getString("FNAME");
                    String desc = rs.getString("FDESCRIPTION");
                    String type = rs.getString("FTYPE");
                    if (type.equals("2")) {
                        String masterId = rs.getString("FMASTERID");
                        String masterAppId = (String)disableAppIdNumberMap.get(masterId);
                        if (masterAppId == null) {
                            AppInfo appInfo = (AppInfo)runtimeAppIdMap.get(masterId);
                            if (appInfo == null) {
                                log.error("\u52a0\u8f7d\u5e94\u7528\u6811(SystemTree)\u4e0d\u53ef\u89c1\u7684\u6269\u5c55\u5e94\u7528{}\u65f6\uff0c\u5bf9\u5e94\u7684masterid\uff1a{}\u8fd0\u884c\u65f6\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (Object)appId, (Object)masterId);
                                continue;
                            }
                            SystemTree.this.fillLocale((NodeInfo)appInfo, locale, name, desc);
                            continue;
                        }
                        appId = masterAppId;
                    } else {
                        disableAppIdNumberMap.put(id, appId);
                    }
                    if (appId == null) continue;
                    AppNodeInfo nodeInfo = disableAppMap.computeIfAbsent(appId, k -> {
                        AppNodeInfo info = new AppNodeInfo();
                        info.setId((String)k);
                        info.setParentId(cloudId);
                        info.setSeq(seq);
                        LocaleString infoName = new LocaleString();
                        info.setName(infoName);
                        LocaleString infoDesc = new LocaleString();
                        info.setDescription(infoDesc);
                        disableAppMap.put((String)k, info);
                        return info;
                    });
                    SystemTree.this.fillLocale(nodeInfo, locale, name, desc);
                }
                return disableAppMap.values();
            }
        });
    }

    private void fillLocale(NodeInfo nodeInfo, String locale, String name, String desc) {
        LocaleString infoName = nodeInfo.getName();
        infoName.setItem(locale, (Object)name);
        LocaleString infoDesc = nodeInfo.getDescription();
        infoDesc.setItem(locale, (Object)desc);
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    private static String makeCacheKey() {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if ("defaultGroup".equals(appGroup)) {
            return "disableapp";
        }
        return String.format("%s_disableapp", appGroup);
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }

    private static class AppNodeInfo
    implements NodeInfo {
        private String id;
        private Short seq;
        private LocaleString name;
        private LocaleString description;
        private String parentId;

        private AppNodeInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getOrder() {
            return this.seq.shortValue();
        }

        public void setSeq(Short seq) {
            this.seq = seq;
        }

        public LocaleString getName() {
            return this.name;
        }

        public void setName(LocaleString name) {
            this.name = name;
        }

        public LocaleString getDescription() {
            return this.description;
        }

        public void setDescription(LocaleString description) {
            this.description = description;
        }

        public String getNodeType() {
            return "app";
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }
    }
}

