/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MCFile;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class ControlSchemaServiceHelper {
    private static final String FATTACHMENT_PANEL = "fattachmentpanel";
    private static Log logger = LogFactory.getLog(ControlSchemaServiceHelper.class);
    private static final String ATTACH_FILES = "fileInfos";
    private static final String QUERY_SQL = "SELECT FID FROM T_META_CTLSCHEMA WHERE FSCHEMAID IN (%s)";
    private static final String QUERY_BOS_ATTACHMENT = "SELECT FID FROM T_BAS_ATTACHMENT WHERE FBILLTYPE = 'ide_controlschema' AND FATTACHMENTPANEL = 'attachmentpanelap' AND FINTERID IN (%s)";

    public static void upload2FileServer(String fileName, String path, InputStream in) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, in);
        fileItem.setCreateNewFileWhenExists(true);
        service.upload(fileItem);
    }

    public static String getInsertSql(String schemaId) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)schemaId)) {
            HashSet<String> schemaIds = new HashSet<String>(1);
            schemaIds.add(schemaId);
            return ControlSchemaServiceHelper.getInsertSql(schemaIds);
        }
        return schemaId;
    }

    public static String getInsertSql(Set<String> schemaIds) {
        if (schemaIds != null && schemaIds.size() > 0) {
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            Map map = builder.genInsertSQLScript(DBRoute.meta, "T_META_CTLSCHEMA", "FID, FSCHEMAID, FPREVIEWIMG, FVERSION, FATTACHMENTCOUNT, FISVID, FMODULEID", "FSCHEMAID IN ('" + String.join((CharSequence)"','", schemaIds) + "')", "", "");
            String insertSql = (String)map.get("sql");
            String sql = String.format(QUERY_SQL, ControlSchemaServiceHelper.getPlaceholder(schemaIds));
            final HashSet fids = new HashSet();
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])schemaIds.toArray(), (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        fids.add(rs.getString(1));
                    }
                    return null;
                }
            });
            logger.info("\u751f\u6210\u65b9\u6848\u8868\u811a\u672c=" + insertSql);
            if (fids.isEmpty()) {
                return insertSql;
            }
            map = builder.genInsertSQLScript(DBRoute.meta, "T_META_CTLSCHEMA_L", "FPKID, FID, FLOCALEID, FSCHEMANAME", "FID IN ('" + String.join((CharSequence)"','", fids) + "')", "", "");
            String insertSql_l = (String)map.get("sql");
            logger.info("\u751f\u6210\u65b9\u6848\u591a\u8bed\u8a00\u8868\u811a\u672c=" + insertSql_l);
            return insertSql + insertSql_l;
        }
        return null;
    }

    public void upload2StaticFileServer(List<MCFile> data) throws Exception {
        WebClientFiles client = new WebClientFiles();
        client.setDcid(RequestContext.get().getAccountId());
        client.setIsv(ISVServiceHelper.getISVInfo().getId());
        client.setKeys(this.getUniqueId(ATTACH_FILES));
        client.setTenantId(RequestContext.get().getTenantId());
        client.setFiles(this.getListFile(data));
        LoginMCService.create().setWebClientFiles(client);
    }

    private static String getPlaceholder(Collection<String> schemaIds) {
        ArrayList<String> tempList = new ArrayList<String>(schemaIds);
        for (int i = 0; i < schemaIds.size(); ++i) {
            tempList.set(i, "?");
        }
        return String.join((CharSequence)",", tempList);
    }

    private List<File> getListFile(List<MCFile> data) {
        if (data != null) {
            ArrayList<File> listFile = new ArrayList<File>();
            data.forEach(item -> {
                File file = new File();
                file.setDestPath(item.getModuleId() + "/" + item.getSchemaId());
                file.setName(item.getName());
                file.setServerType("FS");
                file.setNeedUpdate(true);
                file.setFileServerPath(item.getUrl());
                listFile.add(file);
            });
            return listFile;
        }
        return Collections.EMPTY_LIST;
    }

    private String getUniqueId(String suffix) {
        return "_control_schema_" + RequestContext.get().getTenantId() + "_" + suffix;
    }

    @KSMethod
    public static List<Map<String, Object>> getAttachments(String formId, Object pkId, String attachKey) {
        QFilter[] filters;
        ORM orm;
        DynamicObjectCollection dynColl;
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (pkId != null) {
            Object object = pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        if (!(StringUtils.isBlank((Object)pkId) || pkId instanceof Long && (Long)pkId == 0L || (dynColl = (orm = ORM.create()).getByFilter("bos_attachment", filters = new QFilter[]{new QFilter("FInterID", "=", pkId), new QFilter("FBillType", "=", (Object)formId), new QFilter(FATTACHMENT_PANEL, "=", (Object)attachKey)}, "FNUMBER ASC")) == null || dynColl.isEmpty())) {
            ArrayList<DynamicObject> upd = new ArrayList<DynamicObject>();
            for (DynamicObject obj : dynColl) {
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("lastModified", obj.get("FModifyTime"));
                map.put("name", obj.getString("FAttachmentName"));
                map.put("size", Long.parseLong((String)obj.get("FATTACHMENTSIZE")));
                map.put("uid", obj.get("FNUMBER"));
                map.put("url", obj.getString("FFileId"));
                map.put("type", obj.get("FEXTNAME"));
                map.put("description", obj.get("fdescription"));
                map.put("status", "success");
                Object attachmentKey = obj.get(FATTACHMENT_PANEL);
                if (StringUtils.isBlank((Object)attachmentKey)) {
                    obj.set(FATTACHMENT_PANEL, (Object)attachKey);
                    upd.add(obj);
                }
                map.put(FATTACHMENT_PANEL, attachKey);
                Timestamp createdate = (Timestamp)obj.get("fcreatetime");
                if (createdate != null) {
                    map.put("createdate", createdate.getTime());
                }
                if ((creator = (DynamicObject)obj.get("FCREATEMEN")) != null) {
                    map.put("creator", creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                }
                data.add(map);
            }
            if (!upd.isEmpty()) {
                orm.update(upd);
            }
        }
        return data;
    }
}

