/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class UnitConvertHelper {
    private static final String FORMID_UNIT = "bd_measureunits";
    private static final String FORMID_MATERIAL = "bd_material";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String UNIT_CONVERT_HELPER_1 = "UnitConvertHelper_1";

    public static boolean isConvertable(QtyProp distQtyProp, QtyProp srcQtyProp, MainEntityType dt, StringBuilder errMsg) {
        if (distQtyProp == null || srcQtyProp == null) {
            errMsg.append(ResManager.loadKDString((String)"\u6839\u636e\u6570\u91cf\u5173\u8054\u7684\u5355\u4f4d\u81ea\u52a8\u76ee\u6807\u6570\u91cf\u4e1a\u52a1\u670d\u52a1\u4e2d\uff0c\u5bf9\u5e94\u6570\u91cf\u5b57\u6bb5\u5728\u5355\u636e\u4e2d\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u4fee\u6539", (String)"UnitConvertHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        if (!distQtyProp.getParent().equals(srcQtyProp.getParent())) {
            errMsg.append(ResManager.loadKDString((String)"\u6839\u636e\u6570\u91cf\u5173\u8054\u7684\u5355\u4f4d\u81ea\u52a8\u76ee\u6807\u6570\u91cf\u4e1a\u52a1\u670d\u52a1\u4e2d\uff0c\u5bf9\u5e94\u6570\u91cf\u5b57\u6bb5\u5728\u5355\u636e\u4e2d\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u4fee\u6539", (String)"UnitConvertHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        String distUnitPropName = distQtyProp.getControlPropName();
        String srcUnitPropName = srcQtyProp.getControlPropName();
        String distQtyDisplayName = distQtyProp.getDisplayName().getLocaleValue();
        String srcQtyDisplayName = srcQtyProp.getDisplayName().getLocaleValue();
        if (StringUtils.isBlank((CharSequence)distUnitPropName) || StringUtils.isBlank((CharSequence)srcUnitPropName)) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)UnitConvertHelper.get_NUMBER_FIELDS(), (String)UNIT_CONVERT_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(distQtyDisplayName).append(ResManager.loadKDString((String)" \u6216\u8005 ", (String)"UnitConvertHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(ResManager.loadKDString((String)UnitConvertHelper.get_NUMBER_FIELDS(), (String)UNIT_CONVERT_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(srcQtyDisplayName).append(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u5bf9\u5e94\u7684\u5355\u4f4d", (String)"UnitConvertHelper_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            errMsg.append((CharSequence)msg);
            return false;
        }
        Map allFields = dt.getAllFields();
        UnitProp distUnitProp = (UnitProp)allFields.get(distUnitPropName);
        UnitProp srcUnitProp = (UnitProp)allFields.get(srcUnitPropName);
        if (distUnitProp == null || srcUnitProp == null) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)UnitConvertHelper.get_NUMBER_FIELDS(), (String)UNIT_CONVERT_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(distQtyDisplayName).append(ResManager.loadKDString((String)" \u6216\u8005 ", (String)"UnitConvertHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(ResManager.loadKDString((String)UnitConvertHelper.get_NUMBER_FIELDS(), (String)UNIT_CONVERT_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append(srcQtyDisplayName).append(ResManager.loadKDString((String)" \u5173\u8054\u7684\u5355\u4f4d\u5b57\u6bb5\u4e0d\u5b58\u5728", (String)"UnitConvertHelper_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            errMsg.append((CharSequence)msg);
            return false;
        }
        if (!UnitConvertHelper.checkPropValid((IDataEntityProperty)distUnitProp, (IDataEntityProperty)distQtyProp) || !UnitConvertHelper.checkPropValid((IDataEntityProperty)srcUnitProp, (IDataEntityProperty)srcQtyProp)) {
            errMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u5fc5\u987b\u8981\u5728\u5355\u636e\u5934\u4e0a\uff0c\u6216\u8005\u548c\u6570\u91cf\u4f4d\u4e8e\u540c\u4e00\u5b9e\u4f53\u4e0a\u9762", (String)"UnitConvertHelper_5", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        String distMaterielName = distUnitProp.getMaterielField();
        String srcMaterielName = srcUnitProp.getMaterielField();
        if (StringUtils.isBlank((CharSequence)srcMaterielName) || StringUtils.isBlank((CharSequence)distMaterielName)) {
            return false;
        }
        if (!(allFields.get(srcMaterielName) instanceof MaterielProp)) {
            errMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u5b57\u6bb5\u6709\u8bef ", (String)"UnitConvertHelper_6", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        if (!Objects.equals(distMaterielName, srcMaterielName)) {
            errMsg.append(ResManager.loadKDString((String)"\u5173\u8054\u7684\u7269\u6599\u4e0d\u4e00\u81f4 ", (String)"UnitConvertHelper_7", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        MaterielProp materielProp = (MaterielProp)allFields.get(srcMaterielName);
        if (!UnitConvertHelper.checkPropValid((IDataEntityProperty)materielProp, (IDataEntityProperty)distUnitProp) || !UnitConvertHelper.checkPropValid((IDataEntityProperty)materielProp, (IDataEntityProperty)srcUnitProp)) {
            errMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u5fc5\u987b\u8981\u5355\u636e\u5934\u4e0a\uff0c\u6216\u8005\u548c\u5355\u4f4d\u4f4d\u4e8e\u540c\u4e00\u5b9e\u4f53\u4e0a\u9762", (String)"UnitConvertHelper_8", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Long getRelatedUnitId(QtyProp qtyProp, DynamicObject maindataPkg, int index) {
        UnitConvertHelper.checkMainDataPkg(maindataPkg);
        return (Long)UnitConvertHelper.getBasedataId(qtyProp.getRelatedUnit(), maindataPkg, index);
    }

    public static Long getRelatedUnitId(QtyProp qtyProp, IDataModel dataModel, int index) {
        return (Long)UnitConvertHelper.getBasedataId(qtyProp.getRelatedUnit(), dataModel, index);
    }

    public static Long getMaterialDataId(QtyProp prop, DynamicObject maindataPkg, int index) {
        UnitConvertHelper.checkMainDataPkg(maindataPkg);
        MaterielProp qtyRelatedMaterial = UnitConvertHelper.getQtyRelatedMaterial(prop, (MainEntityType)maindataPkg.getDataEntityType());
        return (Long)UnitConvertHelper.getBasedataId(qtyRelatedMaterial.getName(), maindataPkg, index);
    }

    public static Long getMaterialDataId(QtyProp prop, IDataModel dataModel, int index) {
        MaterielProp qtyRelatedMaterial = UnitConvertHelper.getQtyRelatedMaterial(prop, dataModel.getDataEntityType());
        if (qtyRelatedMaterial == null) {
            return 0L;
        }
        return (Long)UnitConvertHelper.getBasedataId(qtyRelatedMaterial.getName(), dataModel, index);
    }

    public static boolean convertQtyByNewUnit(IDataModel dataModel, QtyProp srcQtyProp, QtyProp distQtyProp, int rowIndex, StringBuilder errMsg) {
        Long srcUnitId = UnitConvertHelper.getRelatedUnitId(srcQtyProp, dataModel, rowIndex);
        Long distUnitId = UnitConvertHelper.getRelatedUnitId(distQtyProp, dataModel, rowIndex);
        return UnitConvertHelper.convertQtyByNewUnit(dataModel, srcQtyProp, distQtyProp, srcUnitId, distUnitId, rowIndex, errMsg);
    }

    public static boolean convertQtyByNewUnit(IDataModel dataModel, QtyProp srcQtyProp, QtyProp distQtyProp, Long srcUnitId, Long distUnitId, int rowIndex, StringBuilder errMsg) {
        Long materialDataId = UnitConvertHelper.getMaterialDataId(distQtyProp, dataModel, rowIndex);
        BigDecimal oldQty = BigDecimal.ZERO;
        oldQty = rowIndex > -1 ? (BigDecimal)dataModel.getValue(srcQtyProp.getName(), rowIndex) : (BigDecimal)dataModel.getValue(srcQtyProp.getName());
        BigDecimal newQty = UnitConvertHelper.calculateNewQty(oldQty, distUnitId, srcUnitId, materialDataId, errMsg);
        if (rowIndex > -1) {
            dataModel.setValue(distQtyProp.getName(), (Object)newQty, rowIndex);
        } else {
            dataModel.setValue(distQtyProp.getName(), (Object)newQty);
        }
        return false;
    }

    public static void convertQtyByNewUnit(IDataModel dataModel, QtyProp srcQtyProp, QtyProp distQtyProp, StringBuilder errMsg) {
        if (distQtyProp.getParent() instanceof EntryType) {
            int rowCount = dataModel.getEntryRowCount(srcQtyProp.getParent().getName());
            for (int i = 0; i < rowCount; ++i) {
                UnitConvertHelper.convertQtyByNewUnit(dataModel, srcQtyProp, distQtyProp, i, errMsg);
                if (errMsg.length() <= 0) {
                    continue;
                }
                break;
            }
        } else {
            UnitConvertHelper.convertQtyByNewUnit(dataModel, srcQtyProp, distQtyProp, -1, errMsg);
        }
    }

    public static void convertQtyByNewUnit(IDataModel dataModel, UnitProp unitProp, long newUnitId, long oldUnitId, int rowIndex, StringBuilder errMsg) {
        List qtyProps = unitProp.findRelatedQtyProps();
        boolean isConvertable = qtyProps.stream().allMatch(prop -> UnitConvertHelper.isConvertable(prop, prop, dataModel.getDataEntityType(), errMsg));
        if (isConvertable) {
            for (QtyProp qtyProp : qtyProps) {
                if (qtyProp.getParent().equals(unitProp.getParent())) {
                    UnitConvertHelper.convertQtyByNewUnit(dataModel, qtyProp, qtyProp, oldUnitId, newUnitId, rowIndex, errMsg);
                    continue;
                }
                int rowCount = dataModel.getEntryRowCount(qtyProp.getParent().getName());
                for (int i = 0; i < rowCount; ++i) {
                    UnitConvertHelper.convertQtyByNewUnit(dataModel, qtyProp, qtyProp, oldUnitId, newUnitId, i, errMsg);
                }
            }
        }
    }

    public static boolean convertQty(QtyProp srcQtyProp, QtyProp distQtyProp, IDataModel dataModel, StringBuilder errMsg) {
        if (UnitConvertHelper.isConvertable(distQtyProp, srcQtyProp, dataModel.getDataEntityType(), errMsg)) {
            if (distQtyProp.getParent() instanceof EntryType) {
                int rowCount = dataModel.getEntryRowCount(srcQtyProp.getParent().getName());
                for (int i = 0; i < rowCount; ++i) {
                    Long materialDataId = UnitConvertHelper.getMaterialDataId(distQtyProp, dataModel, i);
                    Long srcUnitId = UnitConvertHelper.getRelatedUnitId(srcQtyProp, dataModel, i);
                    Long distUnitId = UnitConvertHelper.getRelatedUnitId(distQtyProp, dataModel, i);
                    BigDecimal srcQty = (BigDecimal)dataModel.getValue(srcQtyProp.getName());
                    BigDecimal distQty = UnitConvertHelper.calculateNewQty(srcQty, distUnitId, srcUnitId, materialDataId, errMsg);
                    dataModel.setValue(distQtyProp.getName(), (Object)distQty);
                }
            } else {
                Long materialDataId = UnitConvertHelper.getMaterialDataId(distQtyProp, dataModel, -1);
                Long srcUnitId = UnitConvertHelper.getRelatedUnitId(srcQtyProp, dataModel, -1);
                Long distUnitId = UnitConvertHelper.getRelatedUnitId(distQtyProp, dataModel, -1);
                BigDecimal srcQty = (BigDecimal)dataModel.getValue(srcQtyProp.getName());
                BigDecimal distQty = UnitConvertHelper.calculateNewQty(srcQty, distUnitId, srcUnitId, materialDataId, errMsg);
                if (errMsg.length() == 0) {
                    dataModel.setValue(distQtyProp.getName(), (Object)distQty);
                }
            }
        }
        return errMsg.length() == 0;
    }

    public static BigDecimal calculateNewQty(BigDecimal srcQty, Long distUnitId, Long srcUnitId, Long materialId, StringBuilder errMsg) {
        BigDecimal newQty = BigDecimal.ZERO;
        if (srcQty != null) {
            try {
                if (BigDecimal.ZERO.compareTo(srcQty) == 0) {
                    return newQty;
                }
                DynamicObject muConv = BaseDataServiceHelper.getMUConv(materialId, srcUnitId, distUnitId);
                if (muConv != null) {
                    newQty = BaseDataServiceHelper.getDesmuCount(materialId, srcUnitId, srcQty, distUnitId);
                } else if (errMsg.length() == 0) {
                    errMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6362\u7b97\u7387\uff0c\u65e0\u6cd5\u6362\u7b97\uff0c\u8bf7\u786e\u8ba4\u6216\u6dfb\u52a0\u81f3\u6362\u7b97\u8868\u3002", (String)"UnitConvertHelper_9", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                ErrorCode unitConvertError = new ErrorCode("bos.unit_convert_error", ResManager.loadKDString((String)"\u5355\u4f4d\u6362\u7b97\u63a5\u53e3\u8c03\u7528\u65f6\u51fa\u73b0\u5f02\u5e38 , \u3010\u6e90\u5355\u4f4d\u3011\u540d\u79f0:\"%1$s\"  \u3010\u76ee\u6807\u5355\u4f4d\u3011\u540d\u79f0:\"%2$s\"  \u3010\u7269\u6599\u3011\u540d\u79f0\uff1a\"%3$s\"  \u3010\u6e90\u6570\u91cf\u3011\uff1a%4$s \u3002", (String)"UnitConvertHelper_13", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                throw new KDBizException((Throwable)e, unitConvertError, new Object[]{UnitConvertHelper.getBaseDataObjName(srcUnitId, FORMID_UNIT), UnitConvertHelper.getBaseDataObjName(distUnitId, FORMID_UNIT), UnitConvertHelper.getBaseDataObjName(materialId, FORMID_MATERIAL), srcQty});
            }
        }
        return newQty;
    }

    private static String getBaseDataObjName(Long id, String baseDataformId) {
        String name = "";
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataformId);
        Map<Object, DynamicObject> cacheData = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{id}, (DynamicObjectType)basedataEntityType);
        DynamicObject baseDataObj = cacheData.get(id);
        if (baseDataObj != null) {
            ILocaleString localeString = baseDataObj.getLocaleString(basedataEntityType.getNameProperty());
            name = localeString != null ? localeString.getLocaleValue() : "";
        }
        return name;
    }

    private static boolean checkPropValid(IDataEntityProperty prop1, IDataEntityProperty prop2) {
        return prop1.getParent().equals(prop2.getParent()) || prop1.getParent() instanceof MainEntityType;
    }

    private static Object getBasedataId(String basedataKey, DynamicObject mainDataPkg, int index) {
        IDataEntityType dataEntityType = mainDataPkg.getDataEntityType();
        MainEntityType dt = (MainEntityType)dataEntityType;
        DynamicObject baseDataObj = null;
        Map allFields = dt.getAllFields();
        IDataEntityProperty prop = (IDataEntityProperty)allFields.get(basedataKey);
        Objects.requireNonNull(prop, ResManager.loadKDString((String)"basedataKey \u5bf9\u5e94\u7684\u5c5e\u6027\u4e3a\u7a7a", (String)"UnitConvertHelper_11", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        if (prop.getParent() instanceof EntryType) {
            DynamicObjectCollection col = mainDataPkg.getDynamicObjectCollection(prop.getParent().getName());
            baseDataObj = (DynamicObject)((DynamicObject)col.get(index)).get(basedataKey);
        } else {
            baseDataObj = (DynamicObject)mainDataPkg.get(basedataKey);
        }
        return baseDataObj != null ? baseDataObj.getPkValue() : Long.valueOf(0L);
    }

    private static Object getBasedataId(String basedataKey, IDataModel dataModel, int index) {
        MainEntityType dataEntityType;
        MainEntityType dt = dataEntityType = dataModel.getDataEntityType();
        DynamicObject baseDataObj = null;
        Map allFields = dt.getAllFields();
        IDataEntityProperty prop = (IDataEntityProperty)allFields.get(basedataKey);
        Objects.requireNonNull(prop, ResManager.loadKDString((String)"basedataKey \u5bf9\u5e94\u7684\u5c5e\u6027\u4e3a\u7a7a", (String)"UnitConvertHelper_11", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        baseDataObj = prop.getParent() instanceof EntryType ? (DynamicObject)dataModel.getValue(basedataKey, index) : (DynamicObject)dataModel.getValue(basedataKey);
        if (prop instanceof MaterielProp && baseDataObj != null && baseDataObj.get("masterid") instanceof DynamicObject) {
            DynamicObject materialObj = (DynamicObject)baseDataObj.get("masterid");
            return materialObj.getPkValue() != null ? materialObj.getPkValue() : Long.valueOf(0L);
        }
        return baseDataObj != null ? baseDataObj.getPkValue() : Long.valueOf(0L);
    }

    private static MaterielProp getQtyRelatedMaterial(QtyProp qtyProp, MainEntityType dt) {
        Map allFields = dt.getAllFields();
        UnitProp unitProp = (UnitProp)allFields.get(qtyProp.getRelatedUnit());
        return (MaterielProp)allFields.get(unitProp.getMaterielField());
    }

    private static void checkMainDataPkg(DynamicObject mainDataPkg) {
        if (mainDataPkg.getDataEntityType() instanceof MainEntityType) {
            return;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%s:\u4e0d\u662f\u4e3b\u6570\u636e\u5305", (String)"UnitConvertHelper_12", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), mainDataPkg.toString()));
    }

    private static String get_NUMBER_FIELDS() {
        return ResManager.loadKDString((String)"\u6570\u91cf\u5b57\u6bb5\uff1a", (String)"UnitConvertHelper_14", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
    }
}

