/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class BaseDataRefrenceHelper {
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";

    public static boolean isRefrenced(BasedataEntityType baseEntityType, Object objId) {
        BaseDataRefrenceHelper.checkParameter(baseEntityType, objId);
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        checkRef.setDraftValidReference(true);
        return checkRef.isRefrenced(baseEntityType, objId);
    }

    public static boolean isRefrenced(String baseEntityTypeKey, Object objId) {
        BasedataEntityType entityType = BaseDataRefrenceHelper.checkParameter(baseEntityTypeKey, objId);
        return BaseDataRefrenceHelper.isRefrenced(entityType, objId);
    }

    public static Map<Object, BaseDataCheckRefrenceResult> checkRefrenced(String baseEntityTypeKey, Object[] objIds, Collection<String> ignoreRefEntityIds, Collection<String> checkRefEntityIds, OperateOption option) {
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityTypeKey);
        return BaseDataRefrenceHelper.checkRefrenced(entityType, objIds, ignoreRefEntityIds, checkRefEntityIds, option);
    }

    public static Map<Object, BaseDataCheckRefrenceResult> checkRefrenced(BasedataEntityType baseEntityType, Object[] objIds, Collection<String> ignoreRefEntityIds, Collection<String> checkRefEntityIds, OperateOption option) {
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        if (ignoreRefEntityIds != null) {
            checkRef.getIgnoreRefEntityIds().addAll(ignoreRefEntityIds);
        }
        if (checkRefEntityIds != null) {
            checkRef.getCheckRefEntityIds().addAll(checkRefEntityIds);
        }
        return checkRef.checkRef(baseEntityType, objIds);
    }

    public static List<BaseDataRefenceKey> getAllRefs(BasedataEntityType baseEntityType, Object objId) {
        BaseDataRefrenceHelper.checkParameter(baseEntityType, objId);
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        return checkRef.getAllRefs(baseEntityType, objId);
    }

    public static List<BaseDataRefenceKey> getAllRefs(String baseEntityTypeKey, Object objId) {
        BasedataEntityType entityType = BaseDataRefrenceHelper.checkParameter(baseEntityTypeKey, objId);
        return BaseDataRefrenceHelper.getAllRefs(entityType, objId);
    }

    private static void checkParameter(BasedataEntityType baseEntityType, Object objId) {
        if (baseEntityType == null || objId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull", (String)"BaseDataRefrenceHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
    }

    private static BasedataEntityType checkParameter(String baseEntityTypeKey, Object objId) {
        if (baseEntityTypeKey == null || objId == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull", (String)"BaseDataRefrenceHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
        MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityTypeKey);
        if (baseEntityType == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u7c7b\u578b\uff1a%s", (String)"BaseDataRefrenceHelper_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), baseEntityTypeKey));
        }
        if (!(baseEntityType instanceof BasedataEntityType)) {
            ErrorCode ec = new ErrorCode("BASE_DATA_CHECK", ResManager.loadKDString((String)"\u975e\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u4e0d\u80fd\u505a\u5f15\u7528\u68c0\u67e5\u3002", (String)"BaseDataRefrenceHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return (BasedataEntityType)baseEntityType;
    }
}

