/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.query.BasedataGroupManager;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.ExchangeRateService;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u57fa\u7840\u6570\u636e\u670d\u52a1")
public class BaseDataServiceHelper {
    private static final String CREATE_ORG = "createorg";
    private static final String MEASUREUNIT_ID = "measureunitid";
    private static final String MATERIAL_ID = "materialid";
    private static final String BD_MULTIMEASUREUNIT = "bd_multimeasureunit";
    private static final String CONVERT_TYPE = "converttype";
    private static final String DESMUID = "desmuid";
    private static final String SRCMUID = "srcmuid";
    private static final String DENOMINATOR = "denominator";
    private static final String BD_MATERIAL = "bd_material";
    private static final String NUMERATOR = "numerator";
    private static final String INTEGERFIELD = "integerfield";
    private static final String CONVERT_TYPE1 = "convertType";
    private static final String BASEUNIT = "baseunit";
    private static final String FCONVERT_TYPE = ":fconverttype";
    private static final String PRECISION = "precision";
    private static final String PLUGIN = "plugin";
    private static final String BD_CTRLASSISTDATATYPE = "bd_ctrlassistdatatype";
    private static final String THREAD_CACHE_KEY_UNIT_CONV = "bd_unit_convert_rate";
    private static Log logger = LogFactory.getLog(BaseDataServiceHelper.class);
    private static final String EXCHANGE_RATE = "exchangeRate";
    private static final String QUOTE_TYPE = "quoteType";
    public static final String defaultctrlstrategy_entityID = "bd_bddefctrlstrtgy";
    public static final String bdctrlstrtgy_entityID = "bd_bdctrlstrtgy";
    public static final String org_entityID = "bos_org";
    public static final String orgBiz_entityID = "bos_org_biz";
    public static final String managestrategy_createOrg = "2";
    public static final String managestrategy_cu = "1";
    public static final String ctrltype_assign = "D";
    public static final String ctrltype_share = "S";
    public static final String ctrlstrategy_cu_assign = "1";
    public static final String ctrlstrategy_cu_free_assign = "2";
    public static final String ctrlstrategy_ou_assign = "3";
    public static final String ctrlstrategy_ou_free_assign = "4";
    public static final String ctrlstrategy_global_share = "5";
    public static final String ctrlstrategy_cu_share = "6";
    public static final String ctrlstrategy_private = "7";
    public static final String baseDataUseRegSuffix = "UseReg";
    public static final String baseDataExcSuffix = "Exc";
    public static final String baseDataUseRangeSuffix = "_U";
    public static final String entityID_exchangeRate = "bd_exrate_tree";
    public static final String entityID_workCalendar = "bd_workcalendar";
    public static final String entityID_entityoporgview = "bd_entityoporgview";
    public static final String entityID_entitymeta = "bos_entitymeta";
    public static final String entityID_basedataview = "bd_basedataview";
    public static final String bos_user_entityID = "bos_user";
    private static final String ENTITY_BD_MEASURE_UNIT = "bd_measureunits";
    public static final String ExRate_CONVERT_MODE_DIRECT = "1";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "2";
    public static final String BD_ACCOUNTINGSYS = "bd_accountingsys";
    public static final String BD_ACCOUNTINGSYS_BASE = "bd_accountingsys_base";
    public static final String BD_ACCOUNTINGSYSVIEWSCH = "bd_accountingsysviewsch";
    public static final String DATA_STATUS = "status";
    public static final String DATA_STATUS_A = "A";
    public static final String DATA_STATUS_B = "B";
    public static final String DATA_STATUS_C = "C";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String MEASURE_UNIT_SELECT_FIELDS = "precision,precisionaccount";
    private static final String PRECISION_MODE_UP = "3";
    private static final String PRECISION_MODE_DOWN = "2";
    private static final String DATETYPE_WORKDAY = "1";
    private static final String DATETYPE_HALFRESTDAY = "2";
    private static final String DATETYPE_HOLIDAY = "3";
    private static final String DATETYPE_RESTDAY = "4";

    private static IBaseDataService getService() {
        return (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        BigDecimal exchangeRate = null;
        exchangeRate = BaseDataServiceHelper.getExchangeRate(exchangeTableID, sourceCurrencyID, targetCurrencyID, "1", date);
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BaseDataServiceHelper.getExchangeRate(exchangeTableID, targetCurrencyID, sourceCurrencyID, "2", date);
        }
        return exchangeRate;
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, String convertMode, Date date) {
        BigDecimal exchangeRate = null;
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("exctable", "=", (Object)exchangeTableID));
        filterList.add(new QFilter("orgcur", "=", (Object)sourceCurrencyID));
        filterList.add(new QFilter("cur", "=", (Object)targetCurrencyID));
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        if (date != null) {
            filterList.add(new QFilter("effectdate", "<=", (Object)date));
        }
        if (ExchangeRateService.isEnableExchangeRateExpiryDate(exchangeTableID)) {
            filterList.add(new QFilter("expirydate", ">=", (Object)date));
        }
        String selectFields = "id,excval,indirectexrate";
        String orderBys = "effectdate desc";
        DynamicObjectCollection list = orm.query(entityID_exchangeRate, selectFields, filterList.toArray(new QFilter[0]), orderBys, 1);
        if (list != null && !list.isEmpty()) {
            DynamicObject exchangeRateInfo = (DynamicObject)list.get(0);
            switch (convertMode) {
                case "1": {
                    exchangeRate = exchangeRateInfo.getBigDecimal("excval");
                    break;
                }
                case "2": {
                    exchangeRate = exchangeRateInfo.getBigDecimal("indirectexrate");
                    break;
                }
            }
        }
        return exchangeRate;
    }

    public static BigDecimal getExchangeRateByQuoteType(Long originalCurrency, Long targetCurrency, Long exchangeRateType, Date conversionDate, boolean quoteType) {
        return ExchangeRateService.getExchangeRateByQuoteType(originalCurrency, targetCurrency, exchangeRateType, conversionDate, quoteType);
    }

    public static Map<String, Object> getExchangeRateMap(Long originalCurrency, Long targetCurrency, Long exchangeRateType, Date conversionDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        boolean quoteType = ExchangeRateService.getRateConversionConfig(originalCurrency, targetCurrency, conversionDate);
        map.put(QUOTE_TYPE, quoteType);
        BigDecimal rate = ExchangeRateService.getExchangeRateByQuoteType(originalCurrency, targetCurrency, exchangeRateType, conversionDate, quoteType);
        map.put(EXCHANGE_RATE, rate);
        return map;
    }

    public static boolean getRateConversionConfig(Long originalCurrency, Long targetCurrency, Date conversionDate) {
        return ExchangeRateService.getRateConversionConfig(originalCurrency, targetCurrency, conversionDate);
    }

    public static boolean canModifyExchangeRate(Long exRateTableId) {
        return ExchangeRateService.canModifyExchangeRate(exRateTableId);
    }

    public static boolean isEnableIndirectRateConversion() {
        return ExchangeRateService.isEnableIndirectRateConversion();
    }

    public IOperationResult deleteFormGroup(Object[] ids, GroupProp prop) {
        BasedataGroupManager manager = new BasedataGroupManager();
        return manager.deleteFormGroup(ids, prop);
    }

    public boolean treeNodeUpdate(Object currentId, Object newParentId, GroupProp prop) {
        BasedataGroupManager manager = new BasedataGroupManager();
        return manager.treeNodeUpdate(currentId, newParentId, prop);
    }

    public DynamicObject getWorkCalendar(Long orgId) {
        return BaseDataServiceHelper.getWorkCalendarByOrg(orgId, false, null, new HashMap<String, String>(), new LinkedList<DynamicObject>(), null, null);
    }

    public static DynamicObject getWorkCalendar(Long orgId, Date startDate, Date endDate, Set<String> dateTypeSet) {
        DynamicObjectCollection dateentry;
        DynamicObject workCalendar = BaseDataServiceHelper.getWorkCalendarByOrg(orgId, false, null, new HashMap<String, String>(), new LinkedList<DynamicObject>(), startDate, endDate);
        if (workCalendar != null && (dateentry = workCalendar.getDynamicObjectCollection("dateentry")) != null && !dateentry.isEmpty()) {
            Iterator iterator = dateentry.iterator();
            while (iterator.hasNext()) {
                DynamicObject object = (DynamicObject)iterator.next();
                String datetype = object.getString("datetype");
                if (dateTypeSet == null || dateTypeSet.contains(datetype)) continue;
                iterator.remove();
            }
            BaseDataServiceHelper.sortCalendar(dateentry);
        }
        return workCalendar;
    }

    private static void sortCalendar(DynamicObjectCollection workCalendar) {
        if (workCalendar == null || workCalendar.size() == 0) {
            return;
        }
        workCalendar.sort((o1, o2) -> {
            long t1 = o1.getDate("workdate").getTime();
            long t2 = o2.getDate("workdate").getTime();
            return Long.compare(t1, t2);
        });
    }

    private static DynamicObject getWorkCalendarByOrg(Long orgId, boolean haveWork, DynamicObject workCalendar, Map<String, String> dateMap, List<DynamicObject> personalCalendar, Date start, Date end) {
        List<Long> superiorOrgs;
        QFilter personalFilter;
        DynamicObject personalWorkCalendar;
        QFilter workFilter;
        QFilter[] filters;
        QFilter orgIdFilter = new QFilter(CREATE_ORG, "=", (Object)orgId);
        if (start != null && end != null) {
            QFilter startDateFilter = new QFilter("dateentry.workdate", ">=", (Object)start);
            QFilter endDateFilter = new QFilter("dateentry.workdate", "<=", (Object)end);
            orgIdFilter.and(startDateFilter).and(endDateFilter);
        }
        if (!haveWork && (workCalendar = BusinessDataServiceHelper.loadSingle(entityID_workCalendar, filters = new QFilter[]{orgIdFilter, workFilter = new QFilter("isindividuation", "=", (Object)"0")})) != null) {
            BaseDataServiceHelper.filterCalendarDate(workCalendar, start, end);
            haveWork = true;
        }
        if ((personalWorkCalendar = BusinessDataServiceHelper.loadSingle(entityID_workCalendar, filters = new QFilter[]{orgIdFilter, personalFilter = new QFilter("isindividuation", "=", (Object)"1")})) != null) {
            BaseDataServiceHelper.filterCalendarDate(personalWorkCalendar, start, end);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            DynamicObjectCollection dateentry = personalWorkCalendar.getDynamicObjectCollection("dateentry");
            for (Object date : dateentry) {
                String dateKey = df.format(date.getDate("workdate"));
                if (dateMap.containsKey(dateKey)) continue;
                dateMap.put(dateKey, date.getString("datetype"));
                personalCalendar.add((DynamicObject)date);
            }
        }
        if ((superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs("01", orgId)) != null && superiorOrgs.size() > 0) {
            return BaseDataServiceHelper.getWorkCalendarByOrg(superiorOrgs.get(0), haveWork, workCalendar, dateMap, personalCalendar, start, end);
        }
        if (!haveWork) {
            return workCalendar;
        }
        if (personalCalendar.size() == 0) {
            return workCalendar;
        }
        DynamicObjectCollection newWorkCalendar = new DynamicObjectCollection();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject date : personalCalendar) {
            newWorkCalendar.add((Object)date);
        }
        DynamicObjectCollection orgCalendar = workCalendar.getDynamicObjectCollection("dateentry");
        for (DynamicObject date : orgCalendar) {
            String dateKey = df.format(date.getDate("workdate"));
            if (dateMap.containsKey(dateKey)) continue;
            newWorkCalendar.add((Object)date);
        }
        workCalendar.set("dateentry", (Object)newWorkCalendar);
        return workCalendar;
    }

    private static void filterCalendarDate(DynamicObject calendar, Date start, Date end) {
        if (start == null || end == null) {
            return;
        }
        DynamicObjectCollection dateentry = calendar.getDynamicObjectCollection("dateentry");
        if (dateentry == null || dateentry.size() == 0) {
            return;
        }
        Iterator iterator = dateentry.iterator();
        while (iterator.hasNext()) {
            DynamicObject object = (DynamicObject)iterator.next();
            Date date = object.getDate("workdate");
            if (date.compareTo(start) >= 0 && date.compareTo(end) <= 0) continue;
            iterator.remove();
        }
    }

    public Map<Long, DynamicObject> getWorkCalendarBatch(List<Long> orgIds) {
        HashMap<Long, DynamicObject> workCalendarMap = new HashMap<Long, DynamicObject>(orgIds.size());
        for (Long id : orgIds) {
            workCalendarMap.put(id, BaseDataServiceHelper.getWorkCalendarByOrg(id, false, null, new HashMap<String, String>(), new LinkedList<DynamicObject>(), null, null));
        }
        return workCalendarMap;
    }

    public DynamicObject getWorkCalendar(Long orgId, Date startDate, Date endDate) {
        Object workCalendar = null;
        startDate = (Date)startDate.clone();
        startDate.setHours(0);
        startDate.setMinutes(0);
        startDate.setSeconds(0);
        endDate = (Date)endDate.clone();
        endDate.setHours(0);
        endDate.setMinutes(0);
        endDate.setSeconds(0);
        return BaseDataServiceHelper.getWorkCalendarByOrg(orgId, false, null, new HashMap<String, String>(), new LinkedList<DynamicObject>(), startDate, endDate);
    }

    public static String getVerifyOrgPropertyName(String entityType, String operationKey) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getVerifyOrgPropertyName(entityType, operationKey);
    }

    public QFilter getBaseDataCreaterOrgFilter(String entityID, Long orgID) {
        QFilter baseDataCreaterOrgFilter = BaseDataServiceHelper.getBaseDataProFilter(entityID, orgID, CREATE_ORG);
        return baseDataCreaterOrgFilter;
    }

    public static QFilter getBaseDataIdInFilter(String entityID, Long orgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBaseDataIdInFilter(entityID, orgID);
    }

    public static QFilter getBaseDataFilter(String entityID, Long orgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBaseDataFilter(entityID, orgID);
    }

    public static QFilter getLookUpListFilter(String entityId, Long orgId, QFilter customFilter) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getLookUpListFilter(entityId, orgId, customFilter);
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgID, boolean isRemoveDup) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBaseDataFilter(entityID, orgID, isRemoveDup);
    }

    public static void refreshBaseDataUseRange(String entityID, List<Long> orgIDList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.refreshBaseDataUseRange(entityID, orgIDList);
    }

    public static QFilter getBaseDataProFilter(String entityID, Long orgID, String property) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBaseDataProFilter(entityID, orgID, property);
    }

    public static DynamicObjectCollection getAllUseOrg(String entityType) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getAllUseOrg(entityType);
    }

    protected String getDataBaseFieldName() {
        String dataBaseFieldName = "FDataID";
        return dataBaseFieldName;
    }

    protected String getUsingOrgFieldName() {
        String usingOrgFieldName = "fuseorgid";
        return usingOrgFieldName;
    }

    protected static String getDataBaseUsingTableName(String entityId) {
        String dataBaseUsingTableName = "T_BD_MaterialPurchasUse";
        return dataBaseUsingTableName;
    }

    @Deprecated
    public static Map<Long, List<Long>> batchAssign(String entityID, List<Long> dataIDs, List<Long> orgIDs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        Map map = baseDataService.batchAssign(entityID, dataIDs, orgIDs);
        HashMap<Long, List<Long>> newMap = new HashMap<Long, List<Long>>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Set set = ((Map)entry.getValue()).keySet();
            ArrayList orgIds = new ArrayList(set);
            newMap.put((Long)entry.getKey(), orgIds);
        }
        return newMap;
    }

    @Deprecated
    public static Map<Long, List<Long>> batchAssign(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        Map map = baseDataService.batchAssign(entityID, assignOrgID, dataIDs, orgIDs);
        HashMap<Long, List<Long>> newMap = new HashMap<Long, List<Long>>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Set set = ((Map)entry.getValue()).keySet();
            ArrayList orgIds = new ArrayList(set);
            newMap.put((Long)entry.getKey(), orgIds);
        }
        return newMap;
    }

    public static Map<Long, Map<Long, String>> batchAssignWithDetail(String entityID, List<Long> dataIDs, List<Long> orgIDs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.batchAssign(entityID, dataIDs, orgIDs);
    }

    public static Map<Long, Map<Long, String>> batchAssignWithDetail(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.batchAssign(entityID, assignOrgID, dataIDs, orgIDs);
    }

    @Deprecated
    public void batchUnAssign(String entityID, Long[] dataIDs, Long[] orgIDs) {
    }

    public static void handleDisable(String entityID, DynamicObject[] objs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.handleDisable(entityID, objs);
    }

    public static boolean handleEnable(String entityID, DynamicObject[] objs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.handleEnable(entityID, objs);
    }

    public static List<Long> getAssignUseOrgSet(DynamicObject dataInfo, Long orgID, Long createorgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getAssignUseOrgSet(dataInfo, orgID, createorgId);
    }

    public static void baseDataAssignHandler(DynamicObject dataInfo, Long orgID, Long createorgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataAssignHandler(dataInfo, orgID, createorgId);
    }

    public static void baseDataAddnewHandler(DynamicObject dataInfo, Long createOrgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataAddnewHandler(dataInfo, createOrgID);
    }

    public static void baseDataAddnewHandler(DynamicObject[] objs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataAddnewHandler(objs);
    }

    public static void baseDataOrgChangeHandler(DynamicObject dataInfo) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataOrgChangeHandler(dataInfo);
    }

    public static void baseDataSubmitHandler(DynamicObject dataInfo, Long createOrgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataSubmitHandler(dataInfo, createOrgID);
    }

    public static void baseDataSubmitHandler(DynamicObject[] datas) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataSubmitHandler(datas);
    }

    public static void baseDataAuditHandler(DynamicObject dataInfo, Long createOrgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataAuditHandler(dataInfo, createOrgID);
    }

    public static void baseDataAuditHandler(DynamicObject[] datas) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataAuditHandler(datas);
    }

    public static void baseDataCtrlChangeHandler(DynamicObject dataInfo) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataCtrlChangeHandler(dataInfo);
    }

    public static void baseDataCtrlChangeHandler(List<DynamicObject> dataInfoList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataCtrlChangeHandler(dataInfoList);
    }

    public static void clearCache(DynamicObject dataInfo) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.clearCache(dataInfo);
    }

    public static void clearCache(DynamicObject[] datas) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.clearCache(datas);
    }

    public static DynamicObject getDefaultCtrlStrtgy(String entityID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getDefaultCtrlStrtgy(entityID);
    }

    public static DynamicObject getCtrlview(String entityID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getCtrlview(entityID);
    }

    public static void baseDataDeleteHandler(DynamicObject[] dataInfos) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataDeleteHandler(dataInfos);
    }

    public static void baseDataDeleteHandler(DynamicObject dataInfo, Long orgID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.baseDataDeleteHandler(dataInfo, orgID);
    }

    public static void orgAddnewHandler(Long orgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.orgAddnewHandler(orgId);
    }

    public static void orgAddnewHandler(Long orgViewId, List<Long> orgs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.orgAddnewHandler(orgViewId, orgs);
    }

    public static void handleManageOrg(DynamicObject dataInfo) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.handleManageOrg(dataInfo);
    }

    public static DynamicObject getCtrlStrtgy(DynamicObject dataObj) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getCtrlStrtgy(dataObj);
    }

    public String getWorkCalendarVersion(Long orgId) {
        return null;
    }

    public static boolean checkWorkCalendarDateType(Long orgId, Date date, String dateType) {
        if (null == orgId || null == date || StringUtils.isEmpty((CharSequence)dateType)) {
            return false;
        }
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        DynamicObject workCalendar = baseDataServiceHelper.getWorkCalendar(orgId);
        if (workCalendar == null) {
            return false;
        }
        HashMap<String, String> dateMap = new HashMap<String, String>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObjectCollection dateentry = workCalendar.getDynamicObjectCollection("dateentry");
        if (null != dateentry && dateentry.size() > 0) {
            for (DynamicObject obj : dateentry) {
                dateMap.put(df.format(obj.getDate("workdate")), obj.getString("datetype"));
            }
        }
        return dateType.equals(dateMap.get(df.format(date)));
    }

    public static boolean isWorkDay(Long orgId, Date date) {
        return BaseDataServiceHelper.checkWorkCalendarDateType(orgId, date, "1");
    }

    public static boolean isRestDay(Long orgId, Date date) {
        return BaseDataServiceHelper.checkWorkCalendarDateType(orgId, date, "4");
    }

    public static boolean isWeekendDay(Long orgId, Date date) {
        return BaseDataServiceHelper.checkWorkCalendarDateType(orgId, date, "3");
    }

    public static boolean isHalfWorkDay(Long orgId, Date date) {
        return BaseDataServiceHelper.checkWorkCalendarDateType(orgId, date, "2");
    }

    public int getCalHolidays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public int getCalRestDays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public int getCalWorkDays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public Boolean isHalfHolidays(Long orgId, Date arg0) {
        return null;
    }

    public static boolean handleModify(DynamicObject dataInfo) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.handleModify(dataInfo);
    }

    public static void saveBaseDataExc(DynamicObject dataInfo, Long dataPk, Long createOrgID, List<Long> orgList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.saveBaseDataExc(dataInfo, dataPk, createOrgID, orgList);
    }

    public static List<Long> getAssignDesOrgs(Long srcOrgID, String ctrlType, Long orgViewID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getAssignDesOrgs(srcOrgID, ctrlType, orgViewID);
    }

    public static List<Long> getCreateOrgList(String entity, String appid) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getCreateOrgList(entity, appid);
    }

    public static List<Long> getCreateOrgList(String entity) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getCreateOrgList(entity);
    }

    public static List<Long> getBdCtrlOrgs(String entity) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBdCtrlOrgs(entity);
    }

    public static String getBdCtrlStrgy(String entity, String createOrg) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBdCtrlStrgy(entity, createOrg);
    }

    public static Map<String, String> getBdCtrlStrgyBatch(String entity, List<Long> createOrgs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBdCtrlStrgyBatch(entity, createOrgs);
    }

    public static String getUseOrgFunc(String entity) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getUseOrgFunc(entity);
    }

    public static String getCtrlStgyViewSchema(String entity) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getCtrlStgyViewSchema(entity);
    }

    public static Boolean chectDuplicate(String entityType, Map<String, String> chectProperties, Long orgID, Long dataID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.chectDuplicate(entityType, chectProperties, orgID, dataID);
    }

    public static Boolean chectDuplicate(String entityType, Long orgID, List numberList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.chectDuplicate(entityType, orgID, numberList);
    }

    public static DynamicObject getMaterialMU(Long materialId, Long muId) {
        DynamicObject mu = null;
        QFilter[] filters = new QFilter[]{new QFilter(MATERIAL_ID, "=", (Object)materialId), new QFilter(MEASUREUNIT_ID, "=", (Object)muId)};
        mu = QueryServiceHelper.queryOne(BD_MULTIMEASUREUNIT, "*", filters);
        return mu;
    }

    public static String getMaterialMUConvertType(Long materialId, Long muId) {
        String convertType = null;
        DynamicObject mu = BaseDataServiceHelper.getMaterialMU(materialId, muId);
        if (mu != null) {
            convertType = mu.getString(CONVERT_TYPE);
        }
        return convertType;
    }

    public static List<Long> getAssistMUListResult(Long materialId, Long srcmuId, String convertType) {
        if (!("".equals(convertType) || null == convertType || "1".equals(convertType) || "2".equals(convertType))) {
            logger.info("\u6362\u7b97\u7c7b\u578b\u53c2\u6570\u5f02\u5e38!");
            return new ArrayList<Long>(1);
        }
        List<Map<String, Long>> allUnitList = BaseDataServiceHelper.getUnitList(convertType);
        List<Map<String, Long>> multiUnitList = BaseDataServiceHelper.getMultiUnitList(materialId, convertType);
        List<Map<String, Long>> allUnitMirroredList = BaseDataServiceHelper.mirroredCopy(allUnitList);
        allUnitList.addAll(allUnitMirroredList);
        List<Map<String, Long>> multiUnitMirroredList = BaseDataServiceHelper.mirroredCopy(multiUnitList);
        allUnitList.addAll(multiUnitMirroredList);
        List<Long> assistMUListResult = BaseDataServiceHelper.getAssistMUList(srcmuId, allUnitList, multiUnitList);
        if (!assistMUListResult.contains(srcmuId)) {
            assistMUListResult.add(srcmuId);
        }
        return assistMUListResult;
    }

    private static List<Map<String, Long>> mirroredCopy(List<Map<String, Long>> allUnitList) {
        ArrayList<Map<String, Long>> allUnitMirroredList = new ArrayList<Map<String, Long>>(allUnitList.size());
        HashMap<String, Long> newMap = null;
        for (Map<String, Long> map : allUnitList) {
            newMap = new HashMap<String, Long>();
            newMap.put(DESMUID, map.get(SRCMUID));
            newMap.put(SRCMUID, map.get(DESMUID));
            newMap.put(NUMERATOR, map.get(DENOMINATOR));
            newMap.put(DENOMINATOR, map.get(NUMERATOR));
            allUnitMirroredList.add(newMap);
        }
        return allUnitMirroredList;
    }

    private static List<Map<String, Long>> getUnitList(String convertType) {
        ArrayList<Map<String, Long>> unitList = new ArrayList(16);
        StringBuilder sql = null;
        StringBuffer convertTypeSql = new StringBuffer(" u.fconverttype=? ");
        SqlParameter param = new SqlParameter(FCONVERT_TYPE, 12, (Object)convertType);
        Object[] params = new SqlParameter[]{param};
        sql = new StringBuilder("select fdesmuid as desmuid,fsrcmuid as srcmuid,fnumerator as numerator,").append("fdenominator as denominator from t_bd_measureunitconv u where ").append(convertTypeSql);
        unitList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Long>>>(){

            public List<Map<String, Long>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Long>> searchList = new ArrayList<Map<String, Long>>(16);
                HashMap<String, Long> map = null;
                while (rs.next()) {
                    map = new HashMap<String, Long>(4);
                    map.put(BaseDataServiceHelper.DESMUID, rs.getLong(BaseDataServiceHelper.DESMUID));
                    map.put(BaseDataServiceHelper.SRCMUID, rs.getLong(BaseDataServiceHelper.SRCMUID));
                    map.put(BaseDataServiceHelper.NUMERATOR, rs.getLong(BaseDataServiceHelper.NUMERATOR));
                    map.put(BaseDataServiceHelper.DENOMINATOR, rs.getLong(BaseDataServiceHelper.DENOMINATOR));
                    searchList.add(map);
                }
                return searchList;
            }
        });
        return unitList;
    }

    private static List<Map<String, Long>> getMultiUnitList(Long materialId, String convertType) {
        ArrayList<Map<String, Long>> multiUnitList = new ArrayList(16);
        StringBuilder sql = null;
        StringBuffer convertTypeSql = new StringBuffer(" u.fconverttype=? ");
        StringBuffer materialSql = new StringBuffer(" and m.fid=? ");
        SqlParameter paramA = new SqlParameter(FCONVERT_TYPE, 12, (Object)convertType);
        SqlParameter paramB = new SqlParameter(":fid", 12, (Object)materialId);
        Object[] params = new SqlParameter[]{paramA, paramB};
        sql = new StringBuilder(" select m.fbaseunit as baseunit , u.fmeasureunitid as measureunitid ,").append(" u.fdenominator as denominator, u.fnumerator as numerator ").append(" from t_bd_multimeasureunit u left join t_bd_material m on u.fmaterialid = m.fid").append(" where ").append(convertTypeSql).append(materialSql);
        multiUnitList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Long>>>(){

            public List<Map<String, Long>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Long>> searchList = new ArrayList<Map<String, Long>>(16);
                while (rs.next()) {
                    HashMap<String, Long> map = new HashMap<String, Long>(4);
                    map.put(BaseDataServiceHelper.BASEUNIT, rs.getLong(BaseDataServiceHelper.BASEUNIT));
                    map.put(BaseDataServiceHelper.MEASUREUNIT_ID, rs.getLong(BaseDataServiceHelper.MEASUREUNIT_ID));
                    map.put(BaseDataServiceHelper.NUMERATOR, rs.getLong(BaseDataServiceHelper.NUMERATOR));
                    map.put(BaseDataServiceHelper.DENOMINATOR, rs.getLong(BaseDataServiceHelper.DENOMINATOR));
                    searchList.add(map);
                }
                return searchList;
            }
        });
        return multiUnitList;
    }

    public static List<Long> getAssistMUListResult(Long materialId, Long srcmuId, String convertType, Boolean isAllAssistUnit) {
        if (isAllAssistUnit.booleanValue()) {
            return BaseDataServiceHelper.getAssistMUListResult(materialId, srcmuId, convertType);
        }
        return BaseDataServiceHelper.getOnlyMaterialUnitList(materialId, srcmuId, convertType);
    }

    private static List<Long> getOnlyMaterialUnitList(Long materialId, Long srcmuId, String convertType) {
        SqlParameter materialIdParam = new SqlParameter(":fid", 12, (Object)materialId);
        SqlParameter convertTypeParam = new SqlParameter(FCONVERT_TYPE, 12, (Object)convertType);
        Object[] materalUnitParams = new SqlParameter[]{materialIdParam, convertTypeParam};
        StringBuilder sql = new StringBuilder(" select u.fmeasureunitid as unitId ").append(" from t_bd_multimeasureunit u left join t_bd_material m on u.fmaterialid = m.fid ").append(" where m.fid = ? and u.fconverttype= ? ");
        List materialUnitList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])materalUnitParams, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                LinkedList<Long> materialUnitList = new LinkedList<Long>();
                while (rs.next()) {
                    Long unitId = rs.getLong("unitId");
                    materialUnitList.add(unitId);
                }
                return materialUnitList;
            }
        });
        if (!materialUnitList.contains(srcmuId)) {
            materialUnitList.add(srcmuId);
        }
        return materialUnitList;
    }

    private static List<Long> getAssistMUList(Long srcmuId, List<Map<String, Long>> allUnitList, List<Map<String, Long>> multiUnitList) {
        Set<Long> resultList = new HashSet<Long>(16);
        for (Map<String, Long> map : multiUnitList) {
            Long measureunitid = map.get(MEASUREUNIT_ID);
            Long baseunit = map.get(BASEUNIT);
            resultList = BaseDataServiceHelper.getUnitForWardRec(measureunitid, allUnitList, resultList);
            resultList.add(measureunitid);
            resultList.add(baseunit);
        }
        resultList = BaseDataServiceHelper.getUnitForWardRec(srcmuId, allUnitList, resultList);
        return new ArrayList<Long>(new LinkedHashSet<Long>(resultList));
    }

    private static Set<Long> getUnitForWardRec(Long srcId, List<Map<String, Long>> allUnitList, Set<Long> resultList) {
        for (Map<String, Long> map : allUnitList) {
            Long desmuid = map.get(DESMUID);
            Long srcmuid = map.get(SRCMUID);
            if (null == srcmuid || null == srcId || !srcmuid.equals(srcId) || !resultList.add(desmuid)) continue;
            BaseDataServiceHelper.getUnitForWardRec(desmuid, allUnitList, resultList);
        }
        return resultList;
    }

    public static DynamicObject[] getMUConv(List<Map<String, Long>> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        DynamicObject[] unitconv = new DynamicObject[params.size()];
        int i = 0;
        for (Map<String, Long> param : params) {
            Long materialId = param.get("materialId");
            Long srcmuid = param.get(SRCMUID);
            Long desmuid = param.get(DESMUID);
            unitconv[i] = BaseDataServiceHelper.getMUConv(materialId, srcmuid, desmuid);
            ++i;
        }
        return unitconv;
    }

    public static DynamicObject getMUConv(final Long materialId, final Long srcmuid, final Long desmuid) {
        if (srcmuid != null && desmuid != null && srcmuid.equals(desmuid)) {
            DynamicObject measureunitconv = BusinessDataServiceHelper.newDynamicObject("bd_measureunitconv");
            measureunitconv.set(SRCMUID, (Object)srcmuid);
            measureunitconv.set(DESMUID, (Object)desmuid);
            measureunitconv.set(CONVERT_TYPE, (Object)1);
            measureunitconv.set(NUMERATOR, (Object)1);
            measureunitconv.set(DENOMINATOR, (Object)1);
            return measureunitconv;
        }
        if (null == srcmuid) {
            throw new NullPointerException();
        }
        if (null == desmuid) {
            throw new NullPointerException();
        }
        String threadCacheKey = String.format("%s_%s_%s_%s_%s", RequestContext.get().getTenantCode(), THREAD_CACHE_KEY_UNIT_CONV, materialId, srcmuid, desmuid);
        DynamicObject cacheUnitConv = (DynamicObject)ThreadCache.get((Object)threadCacheKey, (CacheLoader)new CacheLoader<DynamicObject>(){

            public DynamicObject load() {
                String selectProps;
                DynamicObject material;
                Map map = BaseDataServiceHelper.getConv(materialId, srcmuid, desmuid);
                if (null == map) {
                    return new NullUnitConv();
                }
                DynamicObject unitconv = BusinessDataServiceHelper.newDynamicObject(BaseDataServiceHelper.BD_MULTIMEASUREUNIT);
                unitconv.set(BaseDataServiceHelper.MATERIAL_ID, (Object)materialId);
                unitconv.set(BaseDataServiceHelper.CONVERT_TYPE, map.get(BaseDataServiceHelper.CONVERT_TYPE1));
                Long srcId = (Long)map.get(BaseDataServiceHelper.SRCMUID);
                Long desId = (Long)map.get(BaseDataServiceHelper.DESMUID);
                long maxComDiv = BaseDataServiceHelper.getMaxComDiv((Long)map.get(BaseDataServiceHelper.NUMERATOR), (Long)map.get(BaseDataServiceHelper.DENOMINATOR));
                long lDenominator = (Long)map.get(BaseDataServiceHelper.DENOMINATOR) / maxComDiv;
                long lNumerator = (Long)map.get(BaseDataServiceHelper.NUMERATOR) / maxComDiv;
                int numerator = Integer.parseInt(String.valueOf(lNumerator));
                int denominator = Integer.parseInt(String.valueOf(lDenominator));
                if (materialId != -1L && null != (material = BusinessDataServiceHelper.loadSingleFromCache(materialId, BaseDataServiceHelper.BD_MATERIAL, selectProps = BaseDataServiceHelper.BASEUNIT))) {
                    unitconv.set(BaseDataServiceHelper.INTEGERFIELD, (Object)0);
                    if (srcmuid.longValue() == ((DynamicObject)material.get(BaseDataServiceHelper.BASEUNIT)).getLong("id")) {
                        unitconv.set(BaseDataServiceHelper.MEASUREUNIT_ID, (Object)desId);
                    } else if (desmuid.longValue() == ((DynamicObject)material.get(BaseDataServiceHelper.BASEUNIT)).getLong("id")) {
                        unitconv.set(BaseDataServiceHelper.MEASUREUNIT_ID, (Object)srcId);
                    }
                }
                unitconv.set(BaseDataServiceHelper.NUMERATOR, (Object)numerator);
                unitconv.set(BaseDataServiceHelper.DENOMINATOR, (Object)denominator);
                return unitconv;
            }
        });
        if (cacheUnitConv instanceof NullUnitConv) {
            return null;
        }
        return cacheUnitConv;
    }

    public static List<Long> getDescMU(Long materialId, Long srcMUid) {
        List<Long> descMUList = null;
        return descMUList;
    }

    private static Map<String, Long> getConv(Long materialId, Long srcmuid, Long desmuid) {
        List<Map<String, Long>> resultList = null;
        Map<String, Long> resultMap = null;
        if (materialId == -1L) {
            resultList = BaseDataServiceHelper.getAllMeasureUnitConvFromCache();
            if (null == resultList) {
                throw new NullPointerException();
            }
            if ((resultList = BaseDataServiceHelper.combindResultList(resultList, null)).size() > 0) {
                resultMap = BaseDataServiceHelper.getConvRec(srcmuid, desmuid, resultList);
            }
        } else {
            resultList = BaseDataServiceHelper.getMultiMeasureUnitConvFromCache(materialId);
            if (resultList.size() > 0) {
                for (Map<String, Long> map : resultList) {
                    if (srcmuid.equals(map.get(SRCMUID)) && desmuid.equals(map.get(DESMUID))) {
                        resultMap = map;
                        return resultMap;
                    }
                    if (!srcmuid.equals(map.get(DESMUID)) || !desmuid.equals(map.get(SRCMUID))) continue;
                    resultMap = new HashMap<String, Long>(5);
                    resultMap.put(DESMUID, map.get(DESMUID));
                    resultMap.put(SRCMUID, map.get(SRCMUID));
                    resultMap.put(NUMERATOR, map.get(DENOMINATOR));
                    resultMap.put(DENOMINATOR, map.get(NUMERATOR));
                    resultMap.put(CONVERT_TYPE1, map.get(CONVERT_TYPE1));
                    return resultMap;
                }
            }
            if (null == resultMap) {
                List<Map<String, Long>> multiResultList = resultList;
                resultList = BaseDataServiceHelper.getAllMeasureUnitConvFromCache();
                if ((resultList = BaseDataServiceHelper.combindResultList(resultList, multiResultList)).size() > 0) {
                    resultMap = BaseDataServiceHelper.getConvRec(srcmuid, desmuid, resultList);
                }
                if (null != resultMap) {
                    try {
                        long maxComDiv = BaseDataServiceHelper.getMaxComDiv(resultMap.get(NUMERATOR), resultMap.get(DENOMINATOR));
                        long lNumerator = resultMap.get(NUMERATOR) / maxComDiv;
                        long lDenominator = resultMap.get(DENOMINATOR) / maxComDiv;
                        int numerator = Integer.parseInt(String.valueOf(lNumerator));
                        int denominator = Integer.parseInt(String.valueOf(lDenominator));
                        Long convertType = resultMap.get(CONVERT_TYPE1);
                        BaseDataServiceHelper.addMultiMaterial(materialId, srcmuid, desmuid, numerator, denominator, convertType);
                    }
                    catch (Exception ex) {
                        String err = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u5f02\u5e38 numerator:%1$s,denominator:%2$s,convertType:%3$d,materialId:%4$d,srcmuid:%5$d,desmuid:%6$d", (String)"BaseDataServiceHelper_2", (String)"bos-servicehelper", (Object[])new Object[0]), resultMap.get(NUMERATOR).toString(), resultMap.get(DENOMINATOR).toString(), resultMap.get(CONVERT_TYPE1), materialId, srcmuid, desmuid);
                        logger.error(err);
                        String msg = ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38\u3002", (String)"BaseDataServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]);
                        throw new KDBizException(new ErrorCode("", msg), new Object[0]);
                    }
                }
            }
        }
        return resultMap;
    }

    private static void addMultiMaterial(Long materialId, Long srcmuid, Long desmuid, int numerator, int denominator, Long convertType) {
        try (TXHandle h = TX.requiresNew();){
            String selectMatProps;
            DynamicObject material;
            DynamicObject multimeasureunit = BusinessDataServiceHelper.newDynamicObject(BD_MULTIMEASUREUNIT);
            multimeasureunit.set(MATERIAL_ID, (Object)materialId);
            if (null != multimeasureunit.get(MATERIAL_ID) && materialId > 0L && null != (material = BusinessDataServiceHelper.loadSingleFromCache(materialId, BD_MATERIAL, selectMatProps = BASEUNIT))) {
                Long baseUnitId = ((DynamicObject)material.get(BASEUNIT)).getLong("id");
                if (desmuid.equals(baseUnitId)) {
                    multimeasureunit.set(MEASUREUNIT_ID, (Object)srcmuid);
                    multimeasureunit.set(NUMERATOR, (Object)numerator);
                    multimeasureunit.set(DENOMINATOR, (Object)denominator);
                    multimeasureunit.set(CONVERT_TYPE, (Object)convertType);
                } else if (srcmuid.equals(baseUnitId)) {
                    multimeasureunit.set(MEASUREUNIT_ID, (Object)desmuid);
                    multimeasureunit.set(NUMERATOR, (Object)denominator);
                    multimeasureunit.set(DENOMINATOR, (Object)numerator);
                    multimeasureunit.set(CONVERT_TYPE, (Object)convertType);
                }
                if (null != multimeasureunit.get(MEASUREUNIT_ID)) {
                    DynamicObject measureunits = BusinessDataServiceHelper.loadSingleFromCache(multimeasureunit.get(MEASUREUNIT_ID), ENTITY_BD_MEASURE_UNIT);
                    Object precision = measureunits.get(PRECISION);
                    multimeasureunit.set(PRECISION, precision);
                    SaveServiceHelper.save(new DynamicObject[]{multimeasureunit});
                }
            }
        }
    }

    private static List<Map<String, Long>> combindResultList(List<Map<String, Long>> resultList, List<Map<String, Long>> multiResultList) {
        if (null != multiResultList && multiResultList.size() > 0) {
            resultList.addAll(multiResultList);
        }
        ArrayList mirroList = new ArrayList(resultList.size());
        HashMap<String, Long> mirroMap = null;
        for (Map<String, Long> map : resultList) {
            mirroMap = new HashMap<String, Long>(5);
            mirroMap.put(SRCMUID, map.get(DESMUID));
            mirroMap.put(DESMUID, map.get(SRCMUID));
            mirroMap.put(NUMERATOR, map.get(DENOMINATOR));
            mirroMap.put(DENOMINATOR, map.get(NUMERATOR));
            mirroMap.put(CONVERT_TYPE1, map.get(CONVERT_TYPE1));
            mirroList.add(mirroMap);
        }
        resultList.addAll(mirroList);
        return resultList;
    }

    private static Map<String, Long> getConvRec(Long srcmuid, Long desmuid, List<Map<String, Long>> resultList) {
        Map<String, Long> resultMap = null;
        for (Map<String, Long> map : resultList) {
            if (srcmuid.equals(map.get(SRCMUID)) && desmuid.equals(map.get(DESMUID))) {
                resultMap = map;
                break;
            }
            if (!srcmuid.equals(map.get(DESMUID)) || !desmuid.equals(map.get(SRCMUID))) continue;
            resultMap = new HashMap<String, Long>(5);
            resultMap.put(DESMUID, map.get(DESMUID));
            resultMap.put(SRCMUID, map.get(SRCMUID));
            resultMap.put(NUMERATOR, map.get(DENOMINATOR));
            resultMap.put(DENOMINATOR, map.get(NUMERATOR));
            resultMap.put(CONVERT_TYPE1, map.get(CONVERT_TYPE1));
            break;
        }
        if (null != resultMap) {
            return resultMap;
        }
        Long old_numerator = 1L;
        Long old_denominator = 1L;
        Long old_convertType = 1L;
        Map<String, Long[]> allConv = new HashMap<String, Long[]>();
        Long[] conv = (allConv = BaseDataServiceHelper.indirectConv(srcmuid, resultList, old_numerator, old_denominator, old_convertType, allConv, srcmuid)).get(srcmuid + "-" + desmuid);
        if (null != conv) {
            resultMap = new HashMap<String, Long>(5);
            resultMap.put(DESMUID, desmuid);
            resultMap.put(SRCMUID, srcmuid);
            resultMap.put(NUMERATOR, conv[0]);
            resultMap.put(DENOMINATOR, conv[1]);
            resultMap.put(CONVERT_TYPE1, conv[2]);
        }
        return resultMap;
    }

    private static Map<String, Long[]> indirectConv(Long srcmuid, List<Map<String, Long>> resultList, Long old_numerator, Long old_denominator, Long oLdConvertType, Map<String, Long[]> allConv, Long initSrcId) {
        Long[] conv = null;
        for (Map<String, Long> map : resultList) {
            Long srcId = map.get(SRCMUID);
            Long desId = map.get(DESMUID);
            if (!srcmuid.equals(srcId) || allConv.containsKey(initSrcId + "-" + desId)) continue;
            Long numerator = map.get(NUMERATOR);
            Long denominator = map.get(DENOMINATOR);
            Long convertType = map.get(CONVERT_TYPE1);
            numerator = old_numerator * numerator;
            denominator = old_denominator * denominator;
            conv = new Long[]{numerator, denominator, convertType};
            allConv.put(initSrcId + "-" + desId, conv);
            BaseDataServiceHelper.indirectConv(desId, resultList, numerator, denominator, convertType, allConv, initSrcId);
        }
        return allConv;
    }

    private static List<Map<String, Long>> getAllMeasureUnitConvFromCache() {
        ArrayList<Map<String, Long>> resultList = new ArrayList<Map<String, Long>>(16);
        String selectProperties = "srcmuid,desmuid,numerator,denominator,converttype";
        Map<Object, DynamicObject> resultMap = BusinessDataServiceHelper.loadFromCache("bd_measureunitconv", selectProperties, null);
        if (resultMap.size() > 0) {
            HashMap<String, Long> map = null;
            for (DynamicObject obj : resultMap.values()) {
                map = new HashMap<String, Long>(5);
                Long srcmuid = (Long)((DynamicObject)obj.get(SRCMUID)).getPkValue();
                Long desmuid = (Long)((DynamicObject)obj.get(DESMUID)).getPkValue();
                Long numerator = obj.getLong(NUMERATOR);
                Long denominator = obj.getLong(DENOMINATOR);
                Long convertType = obj.getLong(CONVERT_TYPE);
                map.put(SRCMUID, srcmuid);
                map.put(DESMUID, desmuid);
                map.put(NUMERATOR, numerator);
                map.put(DENOMINATOR, denominator);
                map.put(CONVERT_TYPE1, convertType);
                resultList.add(map);
            }
        }
        return resultList;
    }

    private static List<Map<String, Long>> getMultiMeasureUnitConvFromCache(Long materialId) {
        ArrayList<Map<String, Long>> resultList = new ArrayList<Map<String, Long>>(16);
        String selectProperties = "baseunit,measureunitid,numerator,denominator,converttype";
        QFilter filter = new QFilter(MATERIAL_ID, "=", (Object)materialId);
        QFilter[] filters = new QFilter[]{filter};
        Map<Object, DynamicObject> resultMap = BusinessDataServiceHelper.loadFromCache(BD_MULTIMEASUREUNIT, selectProperties, filters);
        String selectMatProps = BASEUNIT;
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache(materialId, BD_MATERIAL, selectMatProps);
        if (resultMap.size() > 0 && null != material) {
            HashMap<String, Long> map = null;
            Long baseunit = (Long)((DynamicObject)material.get(BASEUNIT)).getPkValue();
            for (DynamicObject obj : resultMap.values()) {
                map = new HashMap<String, Long>(5);
                Long srcmuid = (Long)((DynamicObject)obj.get(MEASUREUNIT_ID)).getPkValue();
                Long desmuid = baseunit;
                Long numerator = obj.getLong(NUMERATOR);
                Long denominator = obj.getLong(DENOMINATOR);
                Long convertType = obj.getLong(CONVERT_TYPE);
                map.put(SRCMUID, srcmuid);
                map.put(DESMUID, desmuid);
                map.put(NUMERATOR, numerator);
                map.put(DENOMINATOR, denominator);
                map.put(CONVERT_TYPE1, convertType);
                resultList.add(map);
            }
        }
        return resultList;
    }

    public static double getDesmuCount(Long materialId, Long srcmuid, double srcmuCount, Long desmuid) {
        double desmuCount = -1.0;
        DynamicObject muConv = BaseDataServiceHelper.getMUConv(materialId, srcmuid, desmuid);
        if (muConv != null && muConv.getLong(NUMERATOR) != 0L) {
            desmuCount = srcmuCount * (double)muConv.getInt(NUMERATOR) / (double)muConv.getInt(DENOMINATOR);
        }
        return desmuCount;
    }

    public static BigDecimal getDesmuCount(Long materialId, Long srcmuid, BigDecimal srcmuCount, Long desmuid) {
        DynamicObject muConv = BaseDataServiceHelper.getMUConv(materialId, srcmuid, desmuid);
        if (null == muConv || 0L == muConv.getLong(NUMERATOR)) {
            return BigDecimal.valueOf(0L);
        }
        BigDecimal numerator = BigDecimal.valueOf(muConv.getInt(NUMERATOR));
        BigDecimal denominator = BigDecimal.valueOf(muConv.getInt(DENOMINATOR));
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (0L == desmuid) {
            return srcmuCount.multiply(numerator).divide(denominator, 10, roundingMode);
        }
        QFilter filter = new QFilter("id", "=", (Object)desmuid);
        DynamicObject targetUnit = BusinessDataServiceHelper.loadSingleFromCache(ENTITY_BD_MEASURE_UNIT, MEASURE_UNIT_SELECT_FIELDS, filter.toArray());
        String precisionAccount = targetUnit.getString("precisionaccount");
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        int precision = targetUnit.getInt(PRECISION);
        if (FmtInfoUtils.applyMaterialPrecision()) {
            QFilter materialFilter = new QFilter(MATERIAL_ID, "=", (Object)materialId);
            materialFilter.and(MEASUREUNIT_ID, "=", (Object)srcmuid);
            DynamicObject measureUnit = BusinessDataServiceHelper.loadSingleFromCache(BD_MULTIMEASUREUNIT, PRECISION, materialFilter.toArray());
            if (null != measureUnit) {
                precision = measureUnit.getInt(PRECISION);
            }
        }
        return srcmuCount.multiply(numerator).divide(denominator, precision, roundingMode);
    }

    public static long getMaxComDiv(long num1, long num2) {
        long remaind = 0L;
        while (num2 != 0L) {
            remaind = num1 % num2;
            num1 = num2;
            num2 = remaind;
        }
        return num1;
    }

    public static int getMaxComDiv(int num1, int num2) {
        int remaind = 0;
        while (num2 != 0) {
            remaind = num1 % num2;
            num1 = num2;
            num2 = remaind;
        }
        return num1;
    }

    public static boolean isAssignData(String number, Object primaryKeyValue, Long useOrgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.isAlreadyAssign(number, primaryKeyValue, useOrgId);
    }

    public static boolean isHasAssignData(String entityNumber, Object dataID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.isHasAssignData(entityNumber, dataID);
    }

    @Deprecated
    public static DynamicObject getBaseData(String entityID, Long orgID, String number, String selectFields) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getBaseData(entityID, orgID, number, selectFields);
    }

    public static DynamicObjectCollection queryBaseData(String entityID, Long orgID, QFilter filter, String selectFields) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.queryBaseData(entityID, orgID, filter, selectFields);
    }

    public static Map<Object, DynamicObject> queryBaseDataFromCache(String entityID, Long orgID, QFilter filter, String selectFields) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.queryBaseDataFromCache(entityID, orgID, filter, selectFields);
    }

    public static IBaseDataCtrlPlugin getBaseDataCtrlPlugin(String entityType) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = null;
        String baseDataCtrlPluginStr = BaseDataCtrlCache.getBaseDataCtrlPlugin((String)entityType);
        if (!StringUtils.isEmpty((CharSequence)baseDataCtrlPluginStr)) {
            if ("DATA_LOADED".equals(baseDataCtrlPluginStr)) {
                baseDataCtrlPlugin = null;
                return baseDataCtrlPlugin;
            }
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        String selectPro = PLUGIN;
        QFilter[] qf = new QFilter[]{new QFilter("basedataid", "=", (Object)entityType)};
        DynamicObjectCollection defStrgyCol = QueryServiceHelper.query(defaultctrlstrategy_entityID, selectPro, qf);
        if (defStrgyCol != null && defStrgyCol.size() > 0 && !StringUtils.isEmpty((CharSequence)((DynamicObject)defStrgyCol.get(0)).getString(PLUGIN))) {
            baseDataCtrlPluginStr = ((DynamicObject)defStrgyCol.get(0)).getString(PLUGIN);
            BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        baseDataCtrlPluginStr = "DATA_LOADED";
        BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
        return baseDataCtrlPlugin;
    }

    public static DynamicObjectCollection getAccountingSysBaseInfo(Long[] orgIds) {
        String selectFields = "id,basecurrrency,exratetable,baseacctorg";
        QFilter orgqf = new QFilter("baseacctorg", "in", (Object)orgIds);
        DynamicObjectCollection baseColl = QueryServiceHelper.query(BD_ACCOUNTINGSYS_BASE, selectFields, orgqf.toArray(), "id");
        return baseColl;
    }

    public static DynamicObjectCollection getAccountingSysBizOrg(Long acctSysId, Long[] acctorgs) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        QFilter orgqf = new QFilter("bizorgentry.bizacctorg", "in", (Object)acctorgs);
        DynamicObjectCollection bizColl = QueryServiceHelper.query(BD_ACCOUNTINGSYS, selectFields, new QFilter[]{acctQf, orgqf}, "id");
        return bizColl;
    }

    public static DynamicObjectCollection getAccountingSysAcctOrg(Long acctSysId, Long[] bizacctorgs) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "in", (Object)bizacctorgs);
        DynamicObjectCollection bizColl = QueryServiceHelper.query(BD_ACCOUNTINGSYS, selectFields, new QFilter[]{acctQf, orgqf}, "id");
        return bizColl;
    }

    public static Map<String, String> getAccountingSysView(Long acctSysId) {
        String selectFields = "id,viewentry.id viewid";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        DynamicObjectCollection bizColl = QueryServiceHelper.query(BD_ACCOUNTINGSYS, selectFields, new QFilter[]{acctQf}, "id");
        HashMap<String, String> viewIds = new HashMap<String, String>();
        if (bizColl != null) {
            HashSet viewSet = new HashSet();
            bizColl.forEach(v -> viewSet.add(v.getString("viewid")));
            DynamicObjectCollection viewColl = QueryServiceHelper.query(BD_ACCOUNTINGSYSVIEWSCH, "id,ismainview", new QFilter("id", "in", viewSet).toArray(), "id");
            if (viewColl != null) {
                viewColl.forEach(v -> viewIds.put(v.getString("id"), v.getString("ismainview")));
                return viewIds;
            }
        }
        return viewIds;
    }

    public static Map<String, Long> getBaseAccountingInfo(Long accountOrgID) {
        if (accountOrgID == 0L) {
            return new HashMap<String, Long>(0);
        }
        Map<String, Long> baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo(Collections.singletonList(accountOrgID));
        if (baseAccountingInfo.isEmpty()) {
            List<Long> parentOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs("10", accountOrgID);
            baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo(parentOrgIds);
        }
        return baseAccountingInfo;
    }

    private static Map<String, Long> getBaseAccountingInfo(List<Long> accountingOrgIds) {
        HashMap<String, Long> baseAccountingInfo = new HashMap<String, Long>(2);
        if (accountingOrgIds == null || accountingOrgIds.isEmpty()) {
            return baseAccountingInfo;
        }
        String selectFields = "baseacctorg.id,exratetable.id,basecurrrency.id";
        QFilter orgFilter = new QFilter("baseacctorg", "in", accountingOrgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        Map<Object, DynamicObject> accountingObjMap = BusinessDataServiceHelper.loadFromCache(BD_ACCOUNTINGSYS_BASE, selectFields, filters);
        if (accountingObjMap == null || accountingObjMap.isEmpty()) {
            return baseAccountingInfo;
        }
        DynamicObject baseAccountingObj = null;
        if (accountingObjMap.size() == 1) {
            baseAccountingObj = accountingObjMap.entrySet().iterator().next().getValue();
        } else {
            HashMap<Long, DynamicObject> orgAccountingObjMap = new HashMap<Long, DynamicObject>(accountingObjMap.size());
            for (DynamicObject accountingObj : accountingObjMap.values()) {
                orgAccountingObjMap.put(accountingObj.getLong("baseacctorg.id"), accountingObj);
            }
            for (int i = accountingOrgIds.size() - 1; i >= 0 && (baseAccountingObj = (DynamicObject)orgAccountingObjMap.get(accountingOrgIds.get(i))) == null; --i) {
            }
        }
        if (baseAccountingObj != null) {
            baseAccountingInfo.put("baseCurrencyID", baseAccountingObj.getLong("basecurrrency.id"));
            baseAccountingInfo.put("exchangeRateTableID", baseAccountingObj.getLong("exratetable.id"));
        }
        return baseAccountingInfo;
    }

    public static QFilter getBdCtrlAssistantDataFilter(Long orgID) {
        QFilter baseDataPropertyFilter = null;
        HashSet<Long> baseDataPropertySet = new HashSet<Long>();
        if (StringUtils.isBlank((Object)orgID)) {
            return baseDataPropertyFilter;
        }
        try {
            String sql = "select cadt.FCtrlViewID from t_bd_ctrlassistdatatype cadt  inner join t_org_structure  os on cadt.FCtrlViewID = os.fviewid where forgID =  " + orgID;
            Set bdCtrlAssistantDataViewSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws SQLException {
                    HashSet<Long> set = new HashSet<Long>(16);
                    while (rs.next()) {
                        set.add(rs.getLong("FCtrlViewID"));
                    }
                    return set;
                }
            });
            HashSet<Long> bdCtrlAssistantData = new HashSet<Long>(16);
            for (Long viewid : bdCtrlAssistantDataViewSet) {
                bdCtrlAssistantData.add(orgID);
                BaseDataServiceHelper.getSuperiorOrg(viewid, orgID, bdCtrlAssistantData);
            }
            ORM ormOV = ORM.create();
            QFilter f1 = new QFilter(CREATE_ORG, "in", bdCtrlAssistantData);
            try (DataSet ds = ormOV.queryDataSet(BaseDataServiceHelper.class.getName(), BD_CTRLASSISTDATATYPE, "id", new QFilter[]{f1}, "id");){
                for (Row row : ds) {
                    if (row.get("id") == null) continue;
                    baseDataPropertySet.add(Long.parseLong(row.get("id").toString()));
                }
            }
            baseDataPropertyFilter = new QFilter("id", "in", baseDataPropertySet);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7ec4\u7ec7" + orgID + "\u53ef\u7528\u7684\u53d7\u63a7\u8f85\u52a9\u8d44\u6599\u8303\u56f4\u62a5\u9519:" + e);
        }
        return baseDataPropertyFilter;
    }

    private static Set<Long> getSuperiorOrg(Long viewid, Long orgID, Set<Long> bdCtrlAssistantData) {
        List<Long> superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs(viewid.toString(), orgID);
        if (superiorOrgs == null || superiorOrgs.size() == 0 || superiorOrgs.get(0) == 0L) {
            bdCtrlAssistantData.add(orgID);
            return bdCtrlAssistantData;
        }
        return BaseDataServiceHelper.getSuperiorOrg(viewid, superiorOrgs.get(0), bdCtrlAssistantData);
    }

    public static QFilter getBdCtrlAssistDataFilter(Long dataTypeId) {
        QFilter baseDataPropertyFilter = null;
        HashSet<Long> baseDataPropertySet = new HashSet<Long>();
        if (StringUtils.isBlank((Object)dataTypeId)) {
            return baseDataPropertyFilter;
        }
        try {
            DynamicObject queryOne = QueryServiceHelper.queryOne(BD_CTRLASSISTDATATYPE, "longnumber,createorg", new QFilter[]{new QFilter("id", "=", (Object)dataTypeId)});
            String longnumber = queryOne.getString("longnumber");
            Long createOrgId = queryOne.getLong(CREATE_ORG);
            ORM ormOV = ORM.create();
            HashSet<Long> baseDataTypeSet = new HashSet<Long>();
            QFilter[] f = new QFilter[]{new QFilter("longnumber", "like", (Object)(longnumber + "%")), new QFilter(CREATE_ORG, "=", (Object)createOrgId)};
            try (DataSet ds = ormOV.queryDataSet(BaseDataServiceHelper.class.getName(), BD_CTRLASSISTDATATYPE, "id", f, "id");){
                for (Row row : ds) {
                    if (row.get("id") == null) continue;
                    baseDataTypeSet.add(Long.parseLong(row.get("id").toString()));
                }
            }
            f = new QFilter[]{new QFilter("datatype", "in", baseDataTypeSet)};
            ds = ormOV.queryDataSet(BaseDataServiceHelper.class.getName(), "bd_ctrlassistdata", "id", f, "id");
            var10_11 = null;
            try {
                for (Row row : ds) {
                    if (row.get("id") == null) continue;
                    baseDataPropertySet.add(Long.parseLong(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var10_11 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var10_11.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            baseDataPropertyFilter = new QFilter("id", "in", baseDataPropertySet);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7c7b\u578b\u4e3a" + dataTypeId + "\u53ef\u7528\u7684\u53d7\u63a7\u8f85\u52a9\u8d44\u6599\u8303\u56f4\u62a5\u9519:" + e);
        }
        return baseDataPropertyFilter;
    }

    public static String getFullTextIndex(String entityNumber) {
        String fullTextIndex = null;
        String fullTextIndexEntity = "bas_fulltextindex";
        QFilter entityFilter = new QFilter("fentitynumber.number", "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{entityFilter};
        DynamicObject fullTextIndexObj = BusinessDataServiceHelper.loadSingleFromCache(fullTextIndexEntity, filters);
        if (fullTextIndexObj != null && fullTextIndexObj.getString("ffieldname") != null) {
            fullTextIndex = fullTextIndexObj.getString("ffieldname");
        }
        return fullTextIndex;
    }

    public static Boolean isDBFulltext(String entityNumber, String propertyNumber) {
        boolean isDBFulltextProperty = false;
        String fullTextIndex = BaseDataServiceHelper.getFullTextIndex(entityNumber);
        if (fullTextIndex != null && fullTextIndex.toLowerCase().indexOf(propertyNumber.toLowerCase()) >= 0) {
            isDBFulltextProperty = true;
        }
        return isDBFulltextProperty;
    }

    public static Boolean checkBaseDataCtrl(String entityID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.checkBaseDataCtrl(entityID);
    }

    public static Boolean isNoneCustomEntity(String entityNumber) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.isNoneCustomEntity(entityNumber);
    }

    public static Map<Long, String> batchModifyVerify(String entityID, Long orgID, List<DynamicObject> dataList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.batchModifyVerify(entityID, orgID, dataList);
    }

    public static Map<Long, String> batchHandleModify(String entityID, Long orgID, List<DynamicObject[]> dataList) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.batchHandleModify(entityID, orgID, dataList);
    }

    public static List<Object[]> getUnInsertExcHistory(String entityID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getUnInsertExcHistory(entityID);
    }

    public static void afterSetCtrlUintHandle(String orgViewId, List<String> orgs) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.afterSetCtrlUintHandle(orgViewId, orgs);
    }

    public static void managePermChange(String entityNumber, List<Long> ids, Long orgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.managePermChange(entityNumber, ids, orgId);
    }

    public static String getMasterIdPropName(String entityName) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getMasterIdPropName(entityName);
    }

    public static String getMasterIdFieldName(String entityName) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.getMasterIdFieldName(entityName);
    }

    public static Boolean isEnableNameVersion(String entityID) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.isEnableNameVersion(entityID);
    }

    public static List<CancelAssignResult> cancelAssign(String entityId, Set<Long> dataIds, Set<Long> orgIds) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.cancelAssign(entityId, dataIds, orgIds);
    }

    public static DynamicObjectCollection queryBaseDataByDate(String entityID, Long orgID, QFilter filter, String selectFields, Date queryDate) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.queryBaseDataByDate(entityID, orgID, filter, selectFields, queryDate);
    }

    public static BaseDataResponse changeCtrlStrategy(String entityId, Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.changeCtrlStrategy(entityId, dataIds, ctrlStrategy, appId, useOrgId);
    }

    @KSMethod
    public static BaseDataResponse assign(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.assign(entityId, assignOrgId, appId, dataIds, orgIds);
    }

    @KSMethod
    public static BaseDataResponse individualize(String entityId, Long useOrgId, String appId, Set<Long> dataIds) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.individualize(entityId, useOrgId, appId, dataIds);
    }

    public static AssignQueryResponse assignQueryByData(List<Long> dataIds, String entity, Long orgId, String appId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.assignQueryByData(dataIds, entity, orgId, appId);
    }

    @KSMethod
    public static BaseDataResponse changeManageRight(String entityId, Long useOrgId, String appId, Set<Long> dataIds, Long targetOrgId) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.changeManageRight(entityId, useOrgId, appId, dataIds, targetOrgId);
    }

    public static void orgSaveHandler(List<Long> orgIds) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        baseDataService.orgSaveHandler(orgIds);
    }

    public static UpgradeResult presetCtrlOrgUseRangData(String dbKey, String entity, String tableName, Map<Long, Long> dataOrgMap, boolean isTreeType) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.presetCtrlOrgUseRangData(dbKey, entity, tableName, dataOrgMap, isTreeType);
    }

    public static Map<Long, String> executeIndividualizeOnFreeStrategy(String entity, Long useOrgId, String appId, Set<Long> dataIds, IBaseDataCtrlPlugin service) {
        IBaseDataService baseDataService = BaseDataServiceHelper.getService();
        return baseDataService.executeIndividualizeOnFreeStrategy(entity, useOrgId, appId, dataIds, (Object)service);
    }

    public static BaseDataResponse batchAssignOnFreeStrategy(Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds, String entity) {
        IBaseDataService service = BaseDataServiceHelper.getService();
        return service.batchAssignOnFreeStrategy(assignOrgId, appId, dataIds, orgIds, entity);
    }

    @KSMethod
    public static boolean addCtrlTableColumns(String dbKey, String tableName) {
        IBaseDataService service = BaseDataServiceHelper.getService();
        return service.addCtrlTableColumns(dbKey, tableName);
    }

    @KSMethod
    public static boolean repairNewPropsValue(String entity) {
        IBaseDataService service = BaseDataServiceHelper.getService();
        return service.repairNewPropsValue(entity);
    }

    public static void fillCtrlStrategyFieldAfterCopy(String entity, List<DynamicObject> dataList) {
        IBaseDataService service = BaseDataServiceHelper.getService();
        service.fillCtrlStrategyFieldAfterCopy(entity, dataList);
    }

    static class NullUnitConv
    extends DynamicObject {
        NullUnitConv() {
        }
    }
}

