/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.param.ParameterReader;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class SoftDeleteHandler {
    public static final String BOS_FORM_MVC = "bos_form_mvc";
    public static final String ENABLE = "enable";
    private String entityNumber;
    private String operateKey;

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("basedata-softdelete", new DistributeCacheHAPolicy(true, true));
    }

    public SoftDeleteHandler() {
    }

    public SoftDeleteHandler(String entityNumber, String operateKey) {
        this.entityNumber = entityNumber;
        this.operateKey = operateKey;
    }

    public OperationResult process(String entityNumber, Object[] ids) {
        DynamicObject[] objs;
        OperationResult result = new OperationResult();
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (DynamicObject obj : objs = BusinessDataReader.load((Object[])ids, (DynamicObjectType)entityType, (Boolean)Boolean.FALSE)) {
            map.put(obj.getPkValue().toString(), Integer.parseInt(obj.get(ENABLE).toString()));
            obj.set(ENABLE, (Object)0);
        }
        List<Object> records = SoftDeleteHandler.getSoftDeleteRecords(entityNumber);
        records.addAll(Arrays.asList(ids));
        DistributeSessionlessCache cache = SoftDeleteHandler.getCache();
        cache.put("softdelet-" + entityNumber, (Object)SerializationUtils.toJsonString(records));
        SaveServiceHelper.update(objs);
        this.startDelTask(ids, map, entityType.getDisplayName().toString());
        result.setSuccessPkIds(Arrays.asList(ids));
        result.setSuccess(true);
        return result;
    }

    public static List<Object> getSoftDeleteRecords(String entityId) {
        DistributeSessionlessCache cache = SoftDeleteHandler.getCache();
        String idStr = (String)cache.get("softdelet-" + entityId);
        if (idStr == null) {
            return new ArrayList<Object>();
        }
        return (List)SerializationUtils.fromJsonString((String)idStr, List.class);
    }

    public static boolean hasOpenSoftDelete(String entityId, String operationKey) {
        Optional softDelete = Optional.empty();
        DynamicObject obj = ParameterReader.getBillParameter((String)entityId);
        if (obj != null && obj.getDataEntityType() != null) {
            boolean haveCodeRuleBillParams = obj.getDataEntityType().getProperties().containsKey((Object)"softdelete");
            Optional<Object> optional = softDelete = haveCodeRuleBillParams ? Optional.of(obj.get("softdelete")) : Optional.empty();
        }
        if (!softDelete.isPresent() || !((Boolean)softDelete.get()).booleanValue()) {
            return false;
        }
        Map oper = EntityMetadataCache.getDataEntityOperate((String)entityId, (String)operationKey);
        String operateType = (String)oper.get("type");
        if (!"delete".equals(operateType)) {
            return false;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        return entityType instanceof BasedataEntityType && entityType.findProperty(ENABLE) instanceof BillStatusProp;
    }

    private void startDelTask(Object[] ids, Map<String, Integer> map, String caption) {
        JobInfo jobInfo = this.getJobInfo(ids, map, caption);
        ScheduleServiceHelper.dispatch(jobInfo);
    }

    private JobInfo getJobInfo(Object[] ids, Map<String, Integer> map, String caption) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"%s\u5f02\u6b65\u5220\u9664\u4efb\u52a1", (String)"SoftDeleteHandler_0", (String)"bos-servicehelper", (Object[])new Object[0]), caption));
        jobInfo.setNumber(this.entityNumber + "_del_work_SKDJ_S");
        jobInfo.setTaskClassname("kd.bos.servicehelper.basedata.DelBasedataTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("baseKey", this.entityNumber);
        params.put("basePks", SerializationUtils.toJsonString((Object)ids));
        params.put("operateKey", this.operateKey);
        params.put("originStatus", map);
        params.put("userId", RequestContext.get().getUserId());
        jobInfo.setParams(params);
        return jobInfo;
    }
}

