/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.coross;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.facade.coross.ControlStrategy;
import kd.bos.facade.coross.ICrossTransferFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

public class BaseCorossTransfer
implements ICrossTransferFacade {
    private static final Log log = LogFactory.getLog(BaseCorossTransfer.class);
    private static final String TRANSBORDER_CHANNEL = "privacy_transchannel";
    private static final String TRANSBORDER_STRATEGY = "privacy_transrules";
    private static final String TRANSBORDER_DATATAG = "privacy_transdatatag";
    private static final String DESEN_RULE = "privacy_desen_rules";
    private static final String SOURCE_POINT = "sender";
    private static final String TARGET_POINT = "recipient";
    private static final String IS_OPEN = "istransmission";
    private static final String MASK_STR_NUMBER = "desenrule.number";
    private static final String MASK_STR_ID = "desenrule.id";
    private static final String MASK_Rule_Type = "desenrule.ruletype";
    private static final String NO = "NO";
    private static final String NUMBER = "number";
    private static final String DATA_CLASS_CODE = "datalabel.number";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private Map<String, Map<String, ControlStrategy>> transferConfig = new HashMap<String, Map<String, ControlStrategy>>();

    private Map<Object, DynamicObject> getPipelineChannel() {
        return BusinessDataServiceHelper.loadFromCache(TRANSBORDER_CHANNEL, null);
    }

    private Map<Object, DynamicObject> getPipelineStrategy() {
        return BusinessDataServiceHelper.loadFromCache(TRANSBORDER_DATATAG, null);
    }

    public Map<String, ControlStrategy> getPipelineImpl() {
        HashMap<String, ControlStrategy> pipeline = new HashMap<String, ControlStrategy>();
        try (EntityTraceSpan span = EntityTracer.create((String)"initChannel", (String)"BaseCorossTransfer.initPipelineImpl");){
            Map<Object, DynamicObject> pipelineChannel = this.getPipelineChannel();
            for (Map.Entry<Object, DynamicObject> strategyMap : pipelineChannel.entrySet()) {
                DynamicObject strategy = strategyMap.getValue();
                ControlStrategy pipelineStrategy = new ControlStrategy();
                DynamicObject sender = strategy.getDynamicObject(SOURCE_POINT);
                DynamicObject recipient = strategy.getDynamicObject(TARGET_POINT);
                if (sender == null || recipient == null) continue;
                pipelineStrategy.setSourcePoint(sender.getString(NUMBER));
                pipelineStrategy.setTargetPoint(recipient.getString(NUMBER));
                pipelineStrategy.setIsOpen(Boolean.valueOf(strategy.getBoolean(IS_OPEN)));
                pipeline.put(pipelineStrategy.getPipelineKey(), pipelineStrategy);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("pipeline", pipeline);
            }
        }
        return pipeline;
    }

    public Map<String, ControlStrategy> getDataClassImpl() {
        HashMap<String, ControlStrategy> strategies = new HashMap<String, ControlStrategy>();
        try (EntityTraceSpan span = EntityTracer.create((String)"initStrateg", (String)"BaseCorossTransfer.initDataClassImpl");){
            Map<Object, DynamicObject> strategyMaps = this.getPipelineStrategy();
            for (Map.Entry<Object, DynamicObject> strategyMap : strategyMaps.entrySet()) {
                DynamicObject strategy = strategyMap.getValue();
                ControlStrategy controlStrategy = new ControlStrategy();
                String maskRule = strategy.getString(MASK_STR_NUMBER);
                if ("0".equals(strategy.getString(MASK_Rule_Type))) {
                    maskRule = strategy.getString(MASK_STR_ID);
                }
                controlStrategy.setMaskRule(maskRule);
                controlStrategy.setCustom(Boolean.valueOf(false));
                controlStrategy.setCtrlType(ResManager.loadKDString((String)"\u8131\u654f", (String)"BaseCorossTransfer_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                controlStrategy.setDataClassCode(strategy.getString(NUMBER));
                strategies.put(controlStrategy.getDataClassCode(), controlStrategy);
            }
            if (span.isRealtime()) {
                span.addLocaleTag("strategies", strategies);
            }
        }
        return strategies;
    }

    public void rebuild(String type) {
    }

    private static boolean dataCheck(ControlStrategy strategy) {
        return strategy.getDataClassCode() != null && strategy.getFieldName() != null && strategy.getDataId() != null && strategy.getAppId() != null;
    }

    public synchronized void register(List<ControlStrategy> strategyList) throws Exception {
        Map<String, ControlStrategy> global = this.getDataClassImpl();
        if (global == null) {
            throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25\uff0c\u4e2d\u5fc3\u89c4\u5219\u52a0\u8f7d\u5931\u8d25\u3002", (String)"BaseCorossTransfer_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
        Map<Object, Object> result = null;
        for (ControlStrategy stra : strategyList) {
            if (!BaseCorossTransfer.dataCheck(stra)) {
                throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u63a7\u5236\u7b56\u7565\u6709\u95ee\u9898\u3002", (String)"BaseCorossTransfer_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            }
            if (this.transferConfig.get("custom") == null) {
                result = new HashMap();
                this.transferConfig.put("custom", result);
                result.put(stra.getKey(), stra);
                continue;
            }
            result = this.transferConfig.get("custom");
            result.put(stra.getKey(), stra);
        }
    }

    private ControlStrategy getCustomStrategy(ControlStrategy inputStrategy) {
        if (this.transferConfig.get("custom") == null) {
            return null;
        }
        return this.transferConfig.get("custom").get(inputStrategy.getKey());
    }

    private ControlStrategy getStrategy(String dataClassCode) {
        Map<String, ControlStrategy> global = this.getDataClassImpl();
        if (global == null) {
            return null;
        }
        return global.get(dataClassCode);
    }

    private void convertValue(ControlStrategy inputStrategy, List<Object> fieldValues) {
        ControlStrategy strategy;
        if (fieldValues == null || fieldValues.size() <= 0) {
            return;
        }
        Object value = fieldValues.get(0);
        if (value instanceof String && (strategy = this.getCustomStrategy(inputStrategy)) != null) {
            Integer n;
            Integer n2;
            Integer i;
            if (strategy.getCustom().booleanValue()) {
                i = 0;
                while (i < fieldValues.size()) {
                    fieldValues.set(i, strategy.getMaskStr());
                    n2 = i;
                    n = i = Integer.valueOf(i + 1);
                }
            } else if ((strategy = this.getStrategy(strategy.getDataClassCode())) != null) {
                i = 0;
                while (i < fieldValues.size()) {
                    fieldValues.set(i, strategy.getMaskStr());
                    n2 = i;
                    n = i = Integer.valueOf(i + 1);
                }
            }
        }
        if (value instanceof Integer) {
            for (Object a : fieldValues) {
                a = 0;
            }
        }
    }

    private Object convertValue(ControlStrategy inputStrategy, Object fieldValue) {
        ControlStrategy strategy = this.getCustomStrategy(inputStrategy);
        if (strategy != null) {
            if (strategy.getCustom().booleanValue()) {
                return strategy.getMaskStr();
            }
            if ((strategy = this.getStrategy(strategy.getDataClassCode())) != null) {
                return this.getDesensitizeValue(strategy, fieldValue);
            }
        } else {
            strategy = this.getStrategy(inputStrategy.getDataClassCode());
            if (strategy != null) {
                return this.getDesensitizeValue(strategy, fieldValue);
            }
        }
        return fieldValue;
    }

    private Object getDesensitizeValue(ControlStrategy strategy, Object fieldValue) {
        String desenRuleId = strategy.getMaskRule();
        if (StringUtils.isBlank((CharSequence)desenRuleId) || NO.equals(desenRuleId)) {
            return fieldValue;
        }
        return PrivacyCenterServiceHelper.getDesenValueByRule(desenRuleId, fieldValue);
    }

    /*
     * Unable to fully structure code
     */
    public Object execute(ControlStrategy inputStrategy, Object fieldValue) throws Exception {
        if (inputStrategy == null) {
            return fieldValue;
        }
        sourcePoint = inputStrategy.getSourcePoint();
        targetPoint = inputStrategy.getTargetPoint();
        if (StringUtils.isBlank((CharSequence)sourcePoint) || StringUtils.isBlank((CharSequence)targetPoint) || inputStrategy.getSourcePoint().equals(inputStrategy.getTargetPoint())) {
            return fieldValue;
        }
        span = EntityTracer.create((String)"coross", (String)"BaseCorossTransfer.execute");
        var6_6 = null;
        try {
            pipeline = this.getPipelineImpl();
            if (pipeline == null || pipeline.isEmpty()) ** GOTO lbl24
            if (!pipeline.containsKey(inputStrategy.getPipelineKey())) ** GOTO lbl19
            pipelineStrategy = pipeline.get(inputStrategy.getPipelineKey());
            if (pipelineStrategy.getIsOpen().booleanValue()) {
                var9_10 = this.convertValue(inputStrategy, fieldValue);
                return var9_10;
            }
            try {
                throw new Exception(ResManager.loadKDString((String)"\u4f20\u8f93\u901a\u9053\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u4f20\u8f93\u8be5\u7c7b\u6570\u636e\u3002", (String)"BaseCorossTransfer_1", (String)"bos-servicehelper", (Object[])new Object[0]));
lbl19:
                // 1 sources

                if (span.isRealtime()) {
                    span.addLocaleTag("inputStrategy", (Object)inputStrategy);
                }
                BaseCorossTransfer.log.warn("\u6570\u636e\u8de8\u5883\u4f20\u8f93\u5931\u8d25\u3002\u6570\u636e\u8de8\u5883\u4f20\u8f93\u521d\u59cb\u5316\u6570\u636e\uff1a{}\uff1b\u4f20\u5165\u7ba1\u9053\u7b56\u7565\uff1a{}", (Object)SerializationUtils.toJsonString(pipeline), (Object)SerializationUtils.toJsonString((Object)inputStrategy));
                throw new Exception(ResManager.loadKDString((String)"\u4f20\u8f93\u901a\u9053\u672a\u5b9a\u4e49\uff0c\u4e0d\u5141\u8bb8\u4f20\u8f93\u3002", (String)"BaseCorossTransfer_2", (String)"bos-servicehelper", (Object[])new Object[0]));
lbl24:
                // 1 sources

                throw new Exception(ResManager.loadKDString((String)"\u4f20\u8f93\u901a\u9053\u672a\u5b9a\u4e49\uff0c\u4e0d\u5141\u8bb8\u4f20\u8f93\u3002", (String)"BaseCorossTransfer_2", (String)"bos-servicehelper", (Object[])new Object[0]));
            }
            catch (Throwable var7_8) {
                var6_6 = var7_8;
                throw var7_8;
            }
        }
        finally {
            if (span != null) {
                if (var6_6 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable var10_11) {
                        var6_6.addSuppressed(var10_11);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    public void initDataClassImpl() throws Exception {
    }

    public void initPipelineImpl() throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(ControlStrategy inputStrategy, List<Object> fieldValues) throws Exception {
        if (inputStrategy == null) {
            return;
        }
        String sourcePoint = inputStrategy.getSourcePoint();
        String targetPoint = inputStrategy.getTargetPoint();
        if (StringUtils.isBlank((CharSequence)sourcePoint) || StringUtils.isBlank((CharSequence)targetPoint) || inputStrategy.getSourcePoint().equals(inputStrategy.getTargetPoint())) {
            return;
        }
        Map<String, ControlStrategy> pipeline = this.getPipelineImpl();
        if (pipeline == null || pipeline.isEmpty()) return;
        if (!pipeline.containsKey(inputStrategy.getPipelineKey())) throw new Exception(ResManager.loadKDString((String)"\u4f20\u8f93\u901a\u9053\u672a\u5b9a\u4e49\uff0c\u4e0d\u5141\u8bb8\u4f20\u8f93\u3002", (String)"BaseCorossTransfer_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        ControlStrategy pipelineStrategy = pipeline.get(inputStrategy.getPipelineKey());
        if (!pipelineStrategy.getIsOpen().booleanValue()) throw new Exception(ResManager.loadKDString((String)"\u4f20\u8f93\u901a\u9053\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u4f20\u8f93\u8be5\u7c7b\u6570\u636e\u3002", (String)"BaseCorossTransfer_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        this.convertValue(inputStrategy, fieldValues);
    }
}

