/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.devportal;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.config.EnvConfigurationUtil;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.pureplatform.PurePlatformBlackList;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.AppRuntimeMeta;
import kd.bos.metadata.devportal.AppTemplate;
import kd.bos.metadata.devportal.AppWriter;
import kd.bos.metadata.devportal.DifferenceOperationParseUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@KSObject
public class AppMetaServiceHelper {
    private static final Log log = LogFactory.getLog(AppMetaServiceHelper.class);
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVP_MENUMETADATA = "bos_devp_menumetadata";
    private static final String BOS_DEVPORTAL_MENU = "bos_devportal_menu";
    private static final String SIMPLE_NUMBER = "simpleNumber";
    private static final String NUMBER = "number";
    private static final String VISIBLE = "visible";
    private static final String MESSAGE = "message";
    private static final String BOS_DEVP_METADATAUNIT = "bos_devp_metadataunit";
    private static final String BOS_DEVPORTAL_BIZUNIT = "bos_devportal_bizunit";
    private static final String PARENTID = "parentid";
    private static final String SUCCESS = "success\uff01";
    private static final String OPENTTYPE = "openttype";
    private static final String SUCCESS1 = "success";
    private static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";

    private static BizAppService getBizAppService() {
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        return bizAppService;
    }

    @KSMethod
    public static String getDeveloperInfo() {
        BizAppService bizAppService = AppMetaServiceHelper.getBizAppService();
        return bizAppService.getIsv();
    }

    public static String getSvnUrl() {
        String host = System.getProperty("mc.server.url");
        String accountId = CacheKeyUtil.getAcctId();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accountId", accountId);
        String result = null;
        try {
            String param = JSONUtils.toString(map);
            result = HttpClientUtils.postjson((String)(host + "/login/getsvnurl"), headers, (String)param);
            JSONObject parse = (JSONObject)JSONObject.parse((String)result);
            if (parse != null && parse.getIntValue("errorcode") == 100 && parse.get((Object)"data") != null) {
                return parse.getJSONObject("data").getString("svnurl");
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return null;
    }

    public static String getIsvByApp(AppMetadata metadata) {
        return metadata.getIsv();
    }

    public static String getIsvByAppId(String bizAppId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, BOS_DEVPORTAL_BIZAPP, "isv");
        String isv = null;
        if (obj != null) {
            isv = obj.getString("isv");
        }
        return isv;
    }

    public static AppMetadata CreateBlankAppMetadata() {
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = template.CreateBlankAppMetadata();
        String id = DBServiceHelper.genStringId();
        metadata.setIsv(AppMetaServiceHelper.getDeveloperInfo());
        metadata.setId(id);
        return metadata;
    }

    public static AppMenuElement CreateBlankAppMenuElement() {
        AppMenuElement appMenuElement = new AppMenuElement();
        String id = DBServiceHelper.genStringId();
        appMenuElement.setId(id);
        return appMenuElement;
    }

    public static AppFunctionPacketElement CreateBlankAppFunctionPacketElement() {
        AppFunctionPacketElement appFunctionPacketElement = new AppFunctionPacketElement();
        String id = DBServiceHelper.genStringId();
        appFunctionPacketElement.setId(id);
        return appFunctionPacketElement;
    }

    public static AppMetadata convertDynamicObjectsToAppMetadata(DynamicObject[] objects) {
        AppMetadata metadata = null;
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                DynamicObject obj = objects[i];
                String typeName = obj.getDynamicObjectType().getName();
                if (BOS_DEVPORTAL_BIZAPP.equalsIgnoreCase(typeName)) {
                    metadata = AppMetaServiceHelper.getAppMetadata(obj);
                    continue;
                }
                if (metadata == null || !BOS_DEVP_MENUMETADATA.equalsIgnoreCase(typeName) && !BOS_DEVPORTAL_MENU.equalsIgnoreCase(typeName) && !BOS_DEVP_METADATAUNIT.equalsIgnoreCase(typeName) && !BOS_DEVPORTAL_BIZUNIT.equalsIgnoreCase(typeName)) continue;
                AppMetaServiceHelper.updateAppMetadata(obj, metadata);
            }
        }
        return metadata;
    }

    public static AppMetadata getAppMetadata(DynamicObject appObject) {
        AppMetadata metadata = AppMetaServiceHelper.CreateBlankAppMetadata();
        if (appObject != null) {
            AppMetadata baseMetadata;
            String id = appObject.getString("id");
            boolean initGenerateMetadata = true;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                DynamicObject obj;
                metadata.setId(id);
                if (QueryServiceHelper.exists(BOS_DEVPORTAL_BIZAPP, id) && StringUtils.isNotBlank((CharSequence)(obj = BusinessDataServiceHelper.loadSingle((Object)id, BOS_DEVPORTAL_BIZAPP)).getString("metadata"))) {
                    metadata = AppMetaServiceHelper.loadAppMetadataById(id, false);
                    initGenerateMetadata = false;
                }
            } else {
                appObject.set("id", (Object)metadata.getId());
            }
            if (metadata == null) {
                return null;
            }
            String parentId = appObject.getString("parentId");
            if (parentId != null && parentId.trim().length() == 0) {
                parentId = "";
            }
            metadata.setParentId(parentId);
            String masterId = appObject.getString("masterId");
            if (masterId != null && masterId.trim().length() == 0) {
                masterId = "";
            }
            metadata.setMasterId(masterId);
            String type = appObject.getString("type");
            if (StringUtils.isNotBlank((CharSequence)type)) {
                metadata.setDevType(type);
            } else {
                metadata.setDevType("0");
            }
            if ("2".equalsIgnoreCase(type) && StringUtils.isNotBlank((CharSequence)parentId) && initGenerateMetadata && (baseMetadata = AppMetaServiceHelper.loadAppMetadataById(parentId, false)) != null) {
                metadata.setAppMenus(baseMetadata.getAppMenus());
                metadata.setAppFunctionPackets(baseMetadata.getAppFunctionPackets());
            }
            try {
                String inheritPath = appObject.getString("inheritPath");
                if (StringUtils.isBlank((CharSequence)inheritPath)) {
                    DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)parentId, BOS_DEVPORTAL_BIZAPP);
                    String parentInheritPath = parentObj.getString("inheritPath");
                    inheritPath = StringUtils.isNotBlank((CharSequence)parentInheritPath) ? parentInheritPath + "," + parentId : parentId;
                }
                if (inheritPath != null && inheritPath.trim().length() == 0) {
                    inheritPath = "";
                }
                metadata.setInheritPath(inheritPath);
            }
            catch (Exception e) {
                String inheritPath = parentId;
                metadata.setInheritPath(inheritPath);
            }
            LocaleString name = LocaleString.fromMap((Map)appObject.getLocaleString("name"));
            metadata.setName(name);
            short seq = (short)appObject.getInt("sequence");
            metadata.getAppElement().setSeq(seq);
            String bizCloudID = appObject.getDynamicObject("bizcloud").getString("id");
            metadata.setBizCloudID(bizCloudID);
            String number = appObject.getString(NUMBER);
            metadata.setNumber(number);
            metadata.getAppElement().setNumber(number);
            String simpleNumber = appObject.getString(SIMPLE_NUMBER);
            if (simpleNumber != null && simpleNumber.trim().length() == 0) {
                simpleNumber = "";
            }
            metadata.getAppElement().setSimpleNumber(simpleNumber);
            Boolean visible = appObject.getBoolean(VISIBLE);
            metadata.getAppElement().setVisible(visible != false ? "1" : "0");
            String version = appObject.getString("version");
            metadata.getAppElement().setVersion(version);
            String deployStatus = appObject.getString("deployStatus");
            metadata.getAppElement().setDeployStatus(deployStatus);
            LocaleString description = LocaleString.fromMap((Map)appObject.getLocaleString("description"));
            metadata.getAppElement().setDescription(description);
            String backImage = appObject.getString("backImage");
            if (backImage != null && backImage.trim().length() == 0) {
                backImage = "";
            }
            metadata.getAppElement().setBackImage(backImage);
            String image = appObject.getString("image");
            if (image != null && image.trim().length() == 0) {
                image = "";
            }
            metadata.getAppElement().setImage(image);
            String helpURL = appObject.getString("helpURL");
            if (helpURL != null && helpURL.trim().length() == 0) {
                helpURL = "";
            }
            metadata.getAppElement().setHelpURL(helpURL);
            String mainFormType = appObject.getString("mainFormType");
            if (mainFormType != null && mainFormType.trim().length() == 0) {
                mainFormType = "";
            }
            metadata.getAppElement().setMainFormType(mainFormType);
            String mainFormID = appObject.getString("mainFormID");
            if (mainFormID != null && mainFormID.trim().length() == 0) {
                mainFormID = "";
            }
            metadata.getAppElement().setMainFormID(mainFormID);
            metadata.getAppElement().setMainFormNumber(MetadataDao.getNumberById((String)mainFormID));
            String mainFormName = appObject.getString("mainFormName");
            if (mainFormName != null && mainFormName.trim().length() == 0) {
                mainFormName = "";
            }
            metadata.getAppElement().setMainFormName(mainFormName);
            String homeURL = appObject.getString("homeURL");
            if (homeURL != null && homeURL.trim().length() == 0) {
                homeURL = "";
            }
            metadata.getAppElement().setHomeURL(homeURL);
            String dependency = appObject.getString("dependency");
            if (dependency != null && dependency.trim().length() == 0) {
                dependency = "";
            }
            metadata.getAppElement().setDependency(dependency);
            String dependencyID = appObject.getString("dependencyID");
            if (dependencyID != null && dependencyID.trim().length() == 0) {
                dependencyID = "";
            }
            metadata.getAppElement().setDependencyID(dependencyID);
            String dbRoute = appObject.getString("dbRoute");
            if (dbRoute != null && dbRoute.trim().length() == 0) {
                dbRoute = "";
            }
            metadata.getAppElement().setDbRoute(dbRoute);
            String openType = appObject.getString("openTType");
            if (openType != null && openType.trim().length() == 0) {
                openType = "";
            }
            metadata.getAppElement().setOpenType(openType);
            Boolean allUserApp = appObject.getBoolean("allUserApp");
            metadata.getAppElement().setAllUserApp(allUserApp != false ? "1" : "0");
            String label = appObject.getString("label");
            if (label != null && label.trim().length() == 0) {
                label = "";
            }
            metadata.getAppElement().setLabel(label);
            String userType = appObject.getString("userType");
            metadata.getAppElement().setUserType(userType);
            DynamicObject industryObj = appObject.getDynamicObject("industry");
            DynamicObject refappObj = appObject.getDynamicObject("refapp");
            if (industryObj != null) {
                String refAppId;
                metadata.setIndustryId((Long)industryObj.getPkValue());
                if (refappObj != null && StringUtils.isNotBlank((CharSequence)(refAppId = (String)refappObj.getPkValue()))) {
                    metadata.getAppElement().setRefAppId(refAppId);
                }
            }
            try {
                String orgFunc = appObject.getString("orgFunc");
                if (orgFunc != null && orgFunc.trim().length() == 0) {
                    orgFunc = "";
                }
                metadata.getAppElement().setOrgFunc(orgFunc);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return metadata;
    }

    public static Map<String, Object> convertDynamicObjectToAppMenuElement(DynamicObject obj, AppMenuElement appMenuElement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appMenuElement == null || obj == null) {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"AppMenuElement\u548cDynamicObject\u5bf9\u8c61\u90fd\u4e0d\u53ef\u4e3anull!", (String)"AppMetaServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        String id = obj.getString("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            appMenuElement.setId(id);
        } else if (StringUtils.isNotBlank((CharSequence)appMenuElement.getId())) {
            obj.set("id", (Object)appMenuElement.getId());
        } else {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"\u672a\u7ed9AppMenuElement\u5bf9\u8c61\u6307\u5b9aId!", (String)"AppMetaServiceHelper_1", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        int seq = obj.getInt("seq");
        appMenuElement.setSeq((short)seq);
        LocaleString name = LocaleString.fromMap((Map)obj.getLocaleString("name"));
        appMenuElement.setName(name);
        String number = obj.getString(NUMBER);
        appMenuElement.setNumber(number);
        LocaleString description = LocaleString.fromMap((Map)obj.getLocaleString("description"));
        appMenuElement.setDescription(description);
        Boolean visible = obj.getBoolean(VISIBLE);
        appMenuElement.setVisible(visible != false ? "1" : "0");
        String simpleNumber = obj.getString(SIMPLE_NUMBER);
        if (simpleNumber != null && simpleNumber.trim().length() == 0) {
            simpleNumber = "";
        }
        appMenuElement.setSimpleNumber(simpleNumber);
        String icon = obj.getString("icon");
        if (icon != null && icon.trim().length() == 0) {
            icon = "";
        }
        appMenuElement.setIcon(icon);
        String iconAct = obj.getString("iconAct");
        if (iconAct != null && iconAct.trim().length() == 0) {
            iconAct = "";
        }
        appMenuElement.setIconAct(iconAct);
        String iconShortcut = obj.getString("shortcutentrance");
        if (iconShortcut != null && iconShortcut.trim().length() == 0) {
            iconShortcut = "";
        }
        appMenuElement.setIconShortcut(iconShortcut);
        String formId = obj.getString("formId");
        if (formId != null && formId.trim().length() == 0) {
            formId = "";
        }
        appMenuElement.setFormId(formId);
        String formName = obj.getString("formName");
        if (formName != null && formName.trim().length() == 0) {
            formName = "";
        }
        appMenuElement.setFormName(formName);
        String parameter = obj.getString("parameter");
        if (parameter != null && parameter.trim().length() == 0) {
            parameter = "";
        }
        appMenuElement.setParameter(parameter);
        String parameterType = obj.getString("parameterType");
        if (parameterType != null && parameterType.trim().length() == 0) {
            parameterType = "";
        }
        appMenuElement.setParameterType(parameterType);
        String openType = obj.getString(OPENTTYPE);
        if (openType != null && openType.trim().length() == 0) {
            openType = "";
        }
        appMenuElement.setOpenType(openType);
        String permission = obj.getString("permission");
        if (permission != null && permission.trim().length() == 0) {
            permission = "";
        }
        appMenuElement.setPermission(permission);
        Object parent = obj.get(PARENTID);
        String parentId = " ";
        if (StringUtils.isNotBlank((Object)parent)) {
            parentId = parent instanceof DynamicObject ? ((DynamicObject)parent).getString("id") : parent.toString();
        }
        if (parentId != null && parentId.trim().length() == 0) {
            parentId = "";
        }
        appMenuElement.setParentId(parentId);
        String vectorImage = obj.getString("vectorvalue");
        if (vectorImage != null && vectorImage.trim().length() == 0) {
            vectorImage = "";
        }
        appMenuElement.setVectorImage(vectorImage);
        map.put(SUCCESS1, Boolean.TRUE);
        map.put(MESSAGE, SUCCESS);
        return map;
    }

    public static Map<String, Object> convertAppMenuElementToDynamicObject(AppMenuElement appMenuElement, DynamicObject obj, AppMetadata metadata) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appMenuElement == null || obj == null || StringUtils.isBlank((CharSequence)appMenuElement.getId())) {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"AppMenuElement\u548cDynamicObject\u5bf9\u8c61\u4e0d\u53ef\u4e3anull!", (String)"AppMetaServiceHelper_2", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        obj.set("id", (Object)appMenuElement.getId());
        obj.set("seq", (Object)appMenuElement.getSeq());
        obj.set("name", (Object)appMenuElement.getName());
        obj.set(NUMBER, (Object)appMenuElement.getNumber());
        obj.set("description", (Object)appMenuElement.getDescription());
        obj.set(VISIBLE, (Object)Integer.parseInt(appMenuElement.getVisible()));
        obj.set(SIMPLE_NUMBER, (Object)appMenuElement.getSimpleNumber());
        obj.set("icon", (Object)appMenuElement.getIcon());
        obj.set("iconAct", (Object)appMenuElement.getIconAct());
        obj.set("shortcutentrance", (Object)appMenuElement.getIconShortcut());
        obj.set("formId", (Object)appMenuElement.getFormId());
        obj.set("formName", (Object)appMenuElement.getFormName());
        obj.set("parameter", (Object)appMenuElement.getParameter());
        obj.set("parameterType", (Object)appMenuElement.getParameterType());
        obj.set(OPENTTYPE, (Object)appMenuElement.getOpenType());
        obj.set("permission", (Object)appMenuElement.getPermission());
        String parentId = appMenuElement.getParentId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            if (metadata != null) {
                AppMenuElement menu = (AppMenuElement)metadata.getMapMenus().get(parentId);
                DynamicObject menuObject = BusinessDataServiceHelper.newDynamicObject(BOS_DEVPORTAL_MENU);
                AppMetaServiceHelper.convertAppMenuElementToDynamicObject(menu, menuObject, metadata);
                obj.set(PARENTID, (Object)menuObject);
            } else {
                obj.set(PARENTID, (Object)parentId);
            }
        }
        obj.set("vectorvalue", (Object)appMenuElement.getVectorImage());
        map.put(SUCCESS1, Boolean.TRUE);
        map.put(MESSAGE, SUCCESS);
        return map;
    }

    public static Map<String, Object> convertDynamicObjectToAppFunctionPacketElement(DynamicObject obj, AppFunctionPacketElement appFunctionPacketElement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appFunctionPacketElement == null) {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"AppFunctionPacketElement\u5bf9\u8c61\u4e0d\u53ef\u4e3anull!", (String)"AppMetaServiceHelper_3", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        String id = obj.getString("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            appFunctionPacketElement.setId(id);
        } else if (StringUtils.isNotBlank((CharSequence)appFunctionPacketElement.getId())) {
            obj.set("id", (Object)appFunctionPacketElement.getId());
        } else {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"\u672a\u7ed9AppFunctionPacketElement\u5bf9\u8c61\u6307\u5b9aId!", (String)"AppMetaServiceHelper_4", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        int seq = obj.getInt("seq");
        appFunctionPacketElement.setSeq((short)seq);
        LocaleString name = LocaleString.fromMap((Map)obj.getLocaleString("name"));
        appFunctionPacketElement.setName(name);
        String number = obj.getString(NUMBER);
        appFunctionPacketElement.setNumber(number);
        LocaleString description = LocaleString.fromMap((Map)obj.getLocaleString("description"));
        appFunctionPacketElement.setDescription(description);
        String type = obj.getString("type");
        if (type != null && type.trim().length() == 0) {
            type = "";
        }
        appFunctionPacketElement.setType(type);
        Boolean leaf = obj.getBoolean("isleaf");
        appFunctionPacketElement.setLeaf(leaf != false ? "1" : "0");
        String parentId = obj.getString("parentunitid");
        if (parentId != null && parentId.trim().length() == 0) {
            parentId = "";
        }
        appFunctionPacketElement.setParentId(parentId);
        String parentName = obj.getString("parentunit");
        if (parentName != null && parentName.trim().length() == 0) {
            parentName = "";
        }
        appFunctionPacketElement.setParentName(parentName);
        map.put(SUCCESS1, Boolean.TRUE);
        map.put(MESSAGE, SUCCESS);
        return map;
    }

    public static Map<String, Object> convertAppFunctionPacketElementToDynamicObject(AppFunctionPacketElement appFunctionPacketElement, DynamicObject obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appFunctionPacketElement == null || obj == null || StringUtils.isNotBlank((CharSequence)appFunctionPacketElement.getId())) {
            map.put(SUCCESS1, Boolean.FALSE);
            map.put(MESSAGE, ResManager.loadKDString((String)"AppFunctionPacketElement\u548cDynamicObject\u5bf9\u8c61\u4e0d\u53ef\u4e3anull!", (String)"AppMetaServiceHelper_5", (String)"bos-servicehelper", (Object[])new Object[0]));
            return map;
        }
        obj.set("id", (Object)appFunctionPacketElement.getId());
        obj.set("seq", (Object)appFunctionPacketElement.getSeq());
        obj.set("name", (Object)appFunctionPacketElement.getName());
        obj.set(NUMBER, (Object)appFunctionPacketElement.getNumber());
        obj.set("description", (Object)appFunctionPacketElement.getDescription());
        obj.set("type", (Object)appFunctionPacketElement.getType());
        obj.set("isleaf", (Object)Integer.parseInt(appFunctionPacketElement.getLeaf()));
        obj.set("parentunitid", (Object)appFunctionPacketElement.getParentId());
        obj.set("parentunit", (Object)appFunctionPacketElement.getParentName());
        map.put(SUCCESS1, Boolean.TRUE);
        map.put(MESSAGE, SUCCESS);
        return map;
    }

    @KSMethod
    public static AppMetadata loadAppMetadataFromCacheById(String bizAppId, boolean runtime) {
        String realId;
        if (StringUtils.isNotBlank((CharSequence)bizAppId) && bizAppId.length() <= 10) {
            String realId2 = AppReader.getAppIdByNumber((String)bizAppId);
            if (StringUtils.isNotBlank((CharSequence)realId2)) {
                bizAppId = realId2;
            }
            return AppMetaServiceHelper.loadAppMetadataFromCacheByBizAppId(bizAppId, runtime);
        }
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheByBizAppId(bizAppId, runtime);
        if (appMetadata == null && StringUtils.isNotBlank((CharSequence)(realId = AppReader.getAppIdByNumber((String)bizAppId)))) {
            bizAppId = realId;
            appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheByBizAppId(bizAppId, runtime);
        }
        return appMetadata;
    }

    private static AppMetadata loadAppMetadataFromCacheByBizAppId(String bizAppId, boolean runtime) {
        AppMetadata metadata = null;
        if (runtime) {
            String appXml = MetadataDao.getAppCacheById((String)bizAppId, (boolean)runtime);
            if (StringUtils.isBlank((CharSequence)appXml)) {
                metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
                if (metadata != null) {
                    appXml = AppMetaServiceHelper.buildAppMetadataDiffXml(metadata, null, false);
                    MetadataDao.putAppCache((String)bizAppId, (String)appXml, (boolean)runtime);
                }
            } else {
                metadata = AppMetaServiceHelper.getAppMetadata(appXml, null);
            }
        } else {
            metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        }
        if (EnvConfigurationUtil.isPurePlatform()) {
            AppMetaServiceHelper.removePurePlatformBlackList(metadata);
        }
        return metadata;
    }

    @KSMethod
    public static AppMetadata loadAppMetadataById(String bizAppId, boolean runtime) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return null;
        }
        AppMetadata metadata = null;
        try {
            metadata = AppReader.loadMeta((String)bizAppId, (boolean)runtime);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\uff1a%s \u7684\u5e94\u7528\u5143\u6570\u636e\u5f02\u5e38\u3002", (String)"AppMetaServiceHelper_7", (String)"bos-servicehelper", (Object[])new Object[]{bizAppId});
            log.error(msg, (Throwable)e);
        }
        if (metadata == null) {
            return null;
        }
        String parentAppId = metadata.getParentId();
        if (!runtime && StringUtils.isNotBlank((CharSequence)parentAppId)) {
            AppMetadata baseMetadata = AppReader.loadMeta((String)parentAppId, (boolean)false);
            String diffXml = AppMetaServiceHelper.buildAppMetadataDiffXml(metadata, baseMetadata, false);
            AppMetaServiceHelper.compareAppElement(metadata, diffXml);
        }
        return metadata;
    }

    private static void compareAppElement(AppMetadata metadata, String diffXml) {
        Map<String, Object> operationMap = AppMetaServiceHelper.parseDiffOperations(diffXml);
        for (AppMenuElement menu : metadata.getAppMenus()) {
            String operation = (String)operationMap.get(menu.getId());
            if (operation == null) {
                menu.setDevType("1");
                continue;
            }
            if ("addNew".equalsIgnoreCase(operation)) {
                menu.setDevType("3");
                continue;
            }
            if ("edit".equalsIgnoreCase(operation)) {
                menu.setDevType("2");
                continue;
            }
            if (!"remove".equalsIgnoreCase(operation)) continue;
            menu.setDevType("2");
        }
        QFilter bizappFilter = new QFilter("bizapp", "=", (Object)metadata.getId());
        QFilter[] bizappFilters = new QFilter[]{bizappFilter};
        QFilter bizappFilter1 = new QFilter("bizappid", "=", (Object)metadata.getId());
        QFilter[] bizappFilter1s = new QFilter[]{bizappFilter1};
        try (DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet("compareAppElement.bos_devportal_unitrelform", "bos_devportal_unitrelform", "bizunit,form", bizappFilters, "id asc");
             DataSet formDataSet = QueryServiceHelper.queryDataSet("compareAppElement.bos_formmeta", "bos_formmeta", "id,number,name", bizappFilter1s, "number asc");
             DataSet result = unitRelFormDataSet.join(formDataSet, JoinType.INNER).on("form", "id").select(new String[]{"bizunit"}).finish();){
            HashMap<String, Boolean> funcContainRes = new HashMap<String, Boolean>();
            for (Row row : result) {
                String funcId = row.getString("bizunit");
                if (funcContainRes.get(funcId) != null && ((Boolean)funcContainRes.get(funcId)).booleanValue()) continue;
                funcContainRes.put(funcId, Boolean.TRUE);
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load("ide_pluginscript", "bizunitid", bizappFilter1s);
            if (objs != null) {
                for (DynamicObject obj : objs) {
                    String funcId = obj.getString("bizunitid");
                    if (funcContainRes.get(funcId) != null && ((Boolean)funcContainRes.get(funcId)).booleanValue()) continue;
                    funcContainRes.put(funcId, Boolean.TRUE);
                }
            }
            block30: for (AppFunctionPacketElement func : metadata.getAppFunctionPackets()) {
                String operation = (String)operationMap.get(func.getId());
                if (operation == null) {
                    boolean isExist = false;
                    if (funcContainRes.get(func.getId()) != null && ((Boolean)funcContainRes.get(func.getId())).booleanValue()) {
                        isExist = true;
                    }
                    if (isExist) {
                        func.setType("2");
                        if (!StringUtils.isNotBlank((CharSequence)func.getParentId())) continue;
                        for (AppFunctionPacketElement parentFunc : metadata.getAppFunctionPackets()) {
                            if (!func.getParentId().equals(parentFunc.getId())) continue;
                            parentFunc.setType("2");
                            continue block30;
                        }
                        continue;
                    }
                    func.setType("1");
                    continue;
                }
                if ("addNew".equalsIgnoreCase(operation)) {
                    func.setType("3");
                    continue;
                }
                if ("edit".equalsIgnoreCase(operation)) {
                    func.setType("2");
                    continue;
                }
                if (!"remove".equalsIgnoreCase(operation)) continue;
                func.setType("2");
            }
        }
    }

    @KSMethod
    public static AppMetadata loadAppMetadataById(String bizAppId) {
        return AppMetaServiceHelper.loadAppMetadataById(bizAppId, true);
    }

    public static DynamicObject convertAppMetadataToDynamicAppObject(AppMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject(BOS_DEVPORTAL_BIZAPP);
        dynamicObject.set("id", (Object)metadata.getId());
        dynamicObject.set("sequence", (Object)metadata.getAppElement().getSeq());
        dynamicObject.set(NUMBER, (Object)metadata.getNumber());
        dynamicObject.set("name", (Object)metadata.getName());
        dynamicObject.set("deploystatus", (Object)metadata.getAppElement().getDeployStatus());
        dynamicObject.set("usertype", (Object)metadata.getAppElement().getUserType());
        dynamicObject.set("orgfunc", (Object)metadata.getAppElement().getOrgFunc());
        dynamicObject.set(VISIBLE, (Object)Integer.parseInt(metadata.getAppElement().getVisible()));
        dynamicObject.set("simplenumber", (Object)metadata.getAppElement().getSimpleNumber());
        DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)metadata.getBizCloudID(), "bos_devportal_bizcloud");
        dynamicObject.set("bizcloud", (Object)cloudObject);
        dynamicObject.set("version", (Object)metadata.getAppElement().getVersion());
        dynamicObject.set("alluserapp", (Object)Integer.parseInt(metadata.getAppElement().getAllUserApp()));
        dynamicObject.set("label", (Object)metadata.getAppElement().getLabel());
        dynamicObject.set("mainformname", (Object)metadata.getAppElement().getMainFormName());
        dynamicObject.set("type", (Object)metadata.getDevType());
        dynamicObject.set(OPENTTYPE, (Object)metadata.getAppElement().getOpenType());
        dynamicObject.set("dependency", (Object)metadata.getAppElement().getDependency());
        dynamicObject.set("helpurl", (Object)metadata.getAppElement().getHelpURL());
        dynamicObject.set("svnpath", (Object)BizAppServiceHelp.getSVNPathByAppId(metadata.getId()));
        dynamicObject.set("description", (Object)metadata.getAppElement().getDescription());
        dynamicObject.set("mainformid", (Object)metadata.getAppElement().getMainFormID());
        dynamicObject.set("dependencyid", (Object)metadata.getAppElement().getDependencyID());
        dynamicObject.set("masterid", (Object)metadata.getMasterId());
        dynamicObject.set(PARENTID, (Object)metadata.getParentId());
        dynamicObject.set("dbroute", (Object)metadata.getAppElement().getDbRoute());
        dynamicObject.set("inheritpath", (Object)metadata.getInheritPath());
        dynamicObject.set("image", (Object)metadata.getAppElement().getImage());
        dynamicObject.set("backimage", (Object)metadata.getAppElement().getBackImage());
        if (metadata.getIndustryId() != null) {
            DynamicObject industryObj = BusinessDataServiceHelper.loadSingle((Object)metadata.getIndustryId(), "bos_devp_industry");
            dynamicObject.set("industry", (Object)industryObj);
            dynamicObject.set("refappid", (Object)metadata.getAppElement().getRefAppId());
        }
        return dynamicObject;
    }

    @KSMethod
    public static DynamicObject loadDynamicAppObjectById(String bizAppId, boolean runtime) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        return AppMetaServiceHelper.convertAppMetadataToDynamicAppObject(metadata);
    }

    @KSMethod
    public static DynamicObject loadDynamicAppObjectById(String bizAppId) {
        return AppMetaServiceHelper.loadDynamicAppObjectById(bizAppId, true);
    }

    public static String buildAppMetadataDiffXml(AppMetadata metadata, AppMetadata baseMetadata, boolean onlyLocaleValue) {
        AppTemplate template = new AppTemplate();
        String diffXml = template.buildDiffXml(metadata, baseMetadata, onlyLocaleValue);
        return diffXml;
    }

    private static AppMetadata getAppMetadata(String diffXml, AppMetadata baseMetadata) {
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = template.getMetadata(diffXml, baseMetadata);
        return metadata;
    }

    public static Map<String, Object> parseDiffOperations(String diffXml) {
        HashMap<String, Object> map = new HashMap();
        DifferenceOperationParseUtil util = new DifferenceOperationParseUtil();
        map = util.getDiffOperationsFromString(diffXml);
        return map;
    }

    private static String getParentIdIfExtendApp(String diffXml) {
        DifferenceOperationParseUtil util = new DifferenceOperationParseUtil();
        String parentId = util.getParentIdIfExtendApp(diffXml);
        return parentId;
    }

    public static Map<String, Object> deleteApp(String appId) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_BIZAPP);
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, BOS_DEVPORTAL_BIZAPP, "number,masterid");
        String number = appObj.getString(NUMBER);
        Object[] ids = new Object[]{appId};
        BusinessDataServiceHelper.delete((IDataEntityType)met, ids);
        BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(AppRuntimeMeta.class), (Object[])ids);
        String delSql1 = String.format("delete from t_meta_appruntime_l where fappid = '%s';", number);
        DB.execute((DBRoute)DBRoute.meta, (String)delSql1);
        String delSql = String.format("delete from t_meta_menuruntime where fappid = '%s';", number);
        DB.execute((DBRoute)DBRoute.meta, (String)delSql);
        String masterId = appObj.getString("masterid");
        boolean masterAppExist = QueryServiceHelper.exists(BOS_DEVPORTAL_BIZAPP, masterId);
        if (masterAppExist && StringUtils.isNotBlank((CharSequence)masterId) && !appId.equals(masterId)) {
            MetadataDao.rebuildRuntimeAppMetaById((String)masterId);
        } else {
            MetadataDao.cleanAppCache((String)appId, (String)masterId, (String)number);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("result", SUCCESS1);
        return ret;
    }

    public static Map<String, Object> save(AppMetadata metadata) {
        Map result = null;
        if (metadata != null) {
            if (!(!StringUtils.isBlank((CharSequence)metadata.getIsv()) && metadata.getIsv().equals(ISVService.getISVInfo().getId()) || AppMetaServiceHelper.isNoCodeApp(metadata))) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put(SUCCESS1, Boolean.FALSE);
                error.put(MESSAGE, ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6!", (String)"AppMetaServiceHelper_6", (String)"bos-servicehelper", (Object[])new Object[0]));
                return error;
            }
            AppWriter appWrite = new AppWriter();
            result = appWrite.save(metadata);
            if ("true".equalsIgnoreCase(result.get(SUCCESS1).toString())) {
                PermissionServiceHelper.clearAllUserAppCache();
            }
        }
        return result;
    }

    private static boolean isNoCodeApp(AppMetadata metadata) {
        return NOCODE_CLOUD_ID.equalsIgnoreCase(metadata.getBizCloudID());
    }

    public static Map<String, Object> save(DynamicObject obj) {
        Map<Object, Object> map = new HashMap();
        String typeName = obj.getDynamicObjectType().getName();
        if (BOS_DEVPORTAL_BIZAPP.equalsIgnoreCase(typeName)) {
            map = AppMetaServiceHelper.saveDynamicAppObject(obj);
        } else {
            String bizAppid = "";
            if (BOS_DEVPORTAL_MENU.equalsIgnoreCase(typeName) || BOS_DEVP_MENUMETADATA.equalsIgnoreCase(typeName)) {
                bizAppid = obj.getString("bizappid");
            } else if (BOS_DEVPORTAL_BIZUNIT.equalsIgnoreCase(typeName) || BOS_DEVP_METADATAUNIT.equalsIgnoreCase(typeName)) {
                bizAppid = obj.getDynamicObject("bizapp").getString("id");
            }
            map = AppMetaServiceHelper.save(obj, bizAppid);
        }
        return map;
    }

    public static Map<String, Object> save(DynamicObject obj, String bizAppid) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)bizAppid)) {
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppid, false);
            AppMetaServiceHelper.updateAppMetadata(obj, metadata);
            map = AppMetaServiceHelper.save(metadata);
        }
        return map;
    }

    public static Map<String, Object> saveDynamicAppObject(DynamicObject appObject) {
        AppMetadata metadata = AppMetaServiceHelper.getAppMetadata(appObject);
        return AppMetaServiceHelper.save(metadata);
    }

    private static Map<String, Object> updateAppMetadata(DynamicObject obj, AppMetadata metadata) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String typeName = obj.getDynamicObjectType().getName();
        if (BOS_DEVPORTAL_MENU.equalsIgnoreCase(typeName) || BOS_DEVP_MENUMETADATA.equalsIgnoreCase(typeName)) {
            String id = obj.getString("id");
            AppMenuElement appMenuElement = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                    AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                    if (!id.equalsIgnoreCase(menu.getId())) continue;
                    appMenuElement = menu;
                    break;
                }
            }
            if (appMenuElement == null) {
                appMenuElement = AppMetaServiceHelper.CreateBlankAppMenuElement();
                metadata.getAppMenus().add(appMenuElement);
            }
            AppMetaServiceHelper.convertDynamicObjectToAppMenuElement(obj, appMenuElement);
        } else if (BOS_DEVPORTAL_BIZUNIT.equalsIgnoreCase(typeName) || BOS_DEVP_METADATAUNIT.equalsIgnoreCase(typeName)) {
            String id = obj.getString("id");
            AppFunctionPacketElement appFunctionPacketElement = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
                    AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
                    if (!id.equalsIgnoreCase(func.getId())) continue;
                    appFunctionPacketElement = func;
                    break;
                }
            }
            if (appFunctionPacketElement == null) {
                appFunctionPacketElement = AppMetaServiceHelper.CreateBlankAppFunctionPacketElement();
                metadata.getAppFunctionPackets().add(appFunctionPacketElement);
            }
            AppMetaServiceHelper.convertDynamicObjectToAppFunctionPacketElement(obj, appFunctionPacketElement);
        }
        map.put(SUCCESS1, Boolean.TRUE);
        map.put(MESSAGE, SUCCESS);
        return map;
    }

    @KSMethod
    public static AppMenuElement getMenuById(String menuId, String bizAppId, boolean runtime) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        AppMenuElement appMenuElement = null;
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuId.equalsIgnoreCase(menu.getId())) continue;
                appMenuElement = menu;
                break;
            }
        }
        return appMenuElement;
    }

    @KSMethod
    public static AppFunctionPacketElement getFunctionPacketById(String funcId, String bizAppId, boolean runtime) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        AppFunctionPacketElement appFunctionPacketElement = null;
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
                AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
                if (!funcId.equalsIgnoreCase(func.getId())) continue;
                appFunctionPacketElement = func;
                break;
            }
        }
        return appFunctionPacketElement;
    }

    @KSMethod
    public static AppMenuElement getMenuByNumber(String menuNumber, String bizAppId, boolean runtime) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        AppMenuElement appMenuElement = null;
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuNumber.equalsIgnoreCase(menu.getNumber())) continue;
                appMenuElement = menu;
                break;
            }
        }
        return appMenuElement;
    }

    @KSMethod
    public static boolean cleanAppMetaCache(String appId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById(appId, false);
        if (null != appMetadata) {
            MetadataDao.cleanAppCache((String)appId, (String)appMetadata.getMasterId());
        }
        return true;
    }

    @KSMethod
    public static AppFunctionPacketElement getFunctionPacketByNumber(String funcNumber, String bizAppId, boolean runtime) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, runtime);
        AppFunctionPacketElement appFunctionPacketElement = null;
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
                AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
                if (!funcNumber.equalsIgnoreCase(func.getNumber())) continue;
                appFunctionPacketElement = func;
                break;
            }
        }
        return appFunctionPacketElement;
    }

    @KSMethod
    public static void deleteMenuById(String menuId, String bizAppId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuId.equalsIgnoreCase(menu.getId())) continue;
                metadata.getAppMenus().remove(menu);
                AppMetaServiceHelper.save(metadata);
                break;
            }
        }
    }

    @KSMethod
    public static void deleteMenuByNumber(String menuNumber, String bizAppId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuNumber.equalsIgnoreCase(menu.getNumber())) continue;
                metadata.getAppMenus().remove(menu);
                AppMetaServiceHelper.save(metadata);
                break;
            }
        }
    }

    @KSMethod
    public static void deleteFunctionPacketById(String funcId, String bizAppId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
                AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
                if (!funcId.equalsIgnoreCase(func.getId())) continue;
                metadata.getAppFunctionPackets().remove(func);
                AppMetaServiceHelper.save(metadata);
                break;
            }
        }
    }

    @KSMethod
    public static void deleteFunctionPacketByNumber(String funcNumber, String bizAppId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById(bizAppId, false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
                AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
                if (!funcNumber.equalsIgnoreCase(func.getNumber())) continue;
                metadata.getAppFunctionPackets().remove(func);
                AppMetaServiceHelper.save(metadata);
                break;
            }
        }
    }

    public static String serializeToJSONString(AppMetadata metadata, AppMetadata baseMetadata) {
        AppTemplate template = new AppTemplate();
        String jsonStr = template.serializeToJSONString(metadata, baseMetadata);
        return jsonStr;
    }

    public static AppMetadata deserializeFromJSONString(String json, AppMetadata baseMetadata) {
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = (AppMetadata)template.deserializeFromJSONString(json, baseMetadata);
        return metadata;
    }

    public static List<DeployFile> getCloudDeployFile(String cloudId) {
        return MetadataDao.getCloudDeployFile((String)cloudId);
    }

    public static List<DeployFile> getAppDeployFile(String id) {
        return MetadataDao.getAppDeployFile((String)id);
    }

    public static List<String> deployAppMetadata(String content) {
        return AppMetaServiceHelper.deployAppMetadata(content, null);
    }

    public static List<String> deployAppMetadata(String content, String bizCloudId) {
        return MetadataDao.deployAppMetadata((String)content, (String)bizCloudId);
    }

    private static void removePurePlatformBlackList(AppMetadata meta) {
        try {
            if (meta == null) {
                return;
            }
            log.info("\u7eaf\u5e73\u53f0\u73af\u5883\u542f\u7528\u83dc\u5355\u9ed1\u540d\u5355\u3002");
            meta.getAppFunctionPackets().removeIf(es -> PurePlatformBlackList.getBaseFuncBlackList().contains(es.getId()));
            Iterator itMenu = meta.getAppMenus().iterator();
            while (itMenu.hasNext()) {
                AppMenuElement element = (AppMenuElement)itMenu.next();
                if (PurePlatformBlackList.getBaseMenuBlackList().contains(element.getId())) {
                    itMenu.remove();
                    continue;
                }
                if (!PurePlatformBlackList.getSysMenuBlackList().contains(element.getId())) continue;
                itMenu.remove();
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7eaf\u5e73\u53f0\u73af\u5883\u83dc\u5355\u9ed1\u540d\u5355remove\u83dc\u5355\u51fa\u9519", (Throwable)e);
        }
    }
}

