/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.inte;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.inte.api.address.AddressCommitResult;
import kd.bos.inte.api.address.AddressConfigInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.MapUtils;

@SdkPublic
public class InteServiceHelper {
    private static Log logger = LogFactory.getLog(InteServiceHelper.class);
    public static final String EntityID_SYS_TIMEZONE = "inte_systimezone";
    public static final String EntityID_USER_TIMEZONE = "inte_usertimezone";
    public static final String EntityID_ORG_TIMEZONE = "inte_orgtimezone";
    public static final String EntityID_BIZ_ORG_TIMEZONE = "inte_bizorgtimezone";

    public static DynamicObject getSysTimezone() {
        IInteService inteService = InteServiceHelper.getInteService();
        DynamicObject sysTimezone = inteService.getSysTimezone();
        return sysTimezone;
    }

    public static DynamicObject getUserTimezone(Long userID) {
        IInteService inteService = InteServiceHelper.getInteService();
        DynamicObject userTimezone = inteService.getUserTimezone(userID);
        return userTimezone;
    }

    public static DynamicObject getOrgTimezone(Long orgID) {
        IInteService inteService = InteServiceHelper.getInteService();
        DynamicObject orgTimezone = inteService.getOrgTimezone(orgID);
        return orgTimezone;
    }

    public static DynamicObject getBizOrgTimezone(Long orgID) {
        IInteService inteService = InteServiceHelper.getInteService();
        DynamicObject bizOrgTimezone = inteService.getBizOrgTimezone(orgID);
        return bizOrgTimezone;
    }

    private static IInteService getInteService() {
        return (IInteService)ServiceFactory.getService(IInteService.class);
    }

    public static FormatObject getUserFormat(Long userID) {
        HashMap<String, Object> userFormat = new HashMap();
        IInteService inteService = InteServiceHelper.getInteService();
        userFormat = inteService.getUserFormat(userID);
        DynamicObject userTimeArea = inteService.getUserTimezone(userID);
        if (userTimeArea == null) {
            userTimeArea = inteService.getSysTimezone();
        }
        String timeArea = userTimeArea == null ? null : userTimeArea.getString("number");
        return InteServiceHelper.packFormatObject(userFormat, timeArea);
    }

    public static String getDateFormat(Long userID) {
        IInteService inteService = InteServiceHelper.getInteService();
        String dateFormat = inteService.getDateFormat(userID);
        return dateFormat;
    }

    public static Map<String, String> getTimeFormat(Long userID) {
        HashMap<String, String> timeFormats = new HashMap();
        IInteService inteService = InteServiceHelper.getInteService();
        timeFormats = inteService.getTimeFormat(userID);
        return timeFormats;
    }

    public static Map<String, String> getNumberFormat(Long userID, int precision) {
        HashMap<String, String> numberFormat = new HashMap();
        IInteService inteService = InteServiceHelper.getInteService();
        numberFormat = inteService.getNumberFormat(userID, precision);
        return numberFormat;
    }

    public static Map<String, String> getCurrencyFormat(Long userID) {
        HashMap<String, String> currencyFormat = new HashMap();
        IInteService inteService = InteServiceHelper.getInteService();
        currencyFormat = inteService.getCurrencyFormat(userID);
        return currencyFormat;
    }

    public static void saveUserTimezone(Long userID, DynamicObject timezone) {
        IInteService inteService = InteServiceHelper.getInteService();
        inteService.saveUserTimezone(userID, timezone);
    }

    public static void saveOrgTimezone(Long orgID, DynamicObject timezone) {
        IInteService inteService = InteServiceHelper.getInteService();
        inteService.saveOrgTimezone(orgID, timezone);
    }

    public static void saveOrgTimezone(Map<Long, DynamicObject> orgTimeZoneMap) {
        IInteService inteService = InteServiceHelper.getInteService();
        inteService.saveOrgTimezone(orgTimeZoneMap);
    }

    public static FormatObject getFormat(Long formatID) {
        IInteService service = InteServiceHelper.getInteService();
        Map format = service.getFormat(formatID);
        if (MapUtils.isEmpty((Map)format)) {
            return null;
        }
        return InteServiceHelper.packFormatObject(format, null);
    }

    private static FormatObject packFormatObject(Map<String, Object> format, String timeArea) {
        String dateFormat;
        String fmt;
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)format.get("numberFormat");
        Map timeFormat = (Map)format.get("timeFormat");
        Map currencyFormat = (Map)format.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
            result.getTimeFormat().setTimeArea(timeArea);
            result.getTimeFormat().setLocaleStr((String)format.get("locale"));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(dateFormat = (String)format.get("dateFormat")))) {
            DateFormatObject dateFormatObject = new DateFormatObject(dateFormat);
            dateFormatObject.setTimeArea(timeArea);
            dateFormatObject.setLocaleStr((String)format.get("locale"));
            result.setDateFormat(dateFormatObject);
        }
        return result;
    }

    public static List<EnabledLang> getEnabledLang() {
        IInteService service = InteServiceHelper.getInteService();
        return service.getEnabledLang();
    }

    public static List<EnabledLang> getMultiLangEnabledLang() {
        IInteService service = InteServiceHelper.getInteService();
        return service.getMultiLangEnabledLang();
    }

    public static EnabledLang getUserLang(Long userID) {
        return InteServiceHelper.getInteService().getUserLang(userID);
    }

    public static AddressCommitResult commitAddressInfo(Map<String, Object> addressInfo) {
        return InteServiceHelper.getInteService().commitAddressInfo(addressInfo);
    }

    public static AddressCommitResult commitAddressConfig(AddressConfigInfo addressConfigInfo) {
        return InteServiceHelper.getInteService().commitAddressConfig(addressConfigInfo);
    }

    public static List<Language> getAllLanguageForLogin(Account currentAccount) {
        RequestContext context = RequestContext.get();
        if (context != null && StringUtils.isNotEmpty((CharSequence)context.getAccountId())) {
            return InteServiceHelper.getAllLanguageForLoginByCache();
        }
        return InteServiceHelper.getAllLanguageForLoginByDb(currentAccount);
    }

    public static List<Language> getAllLanguageForLoginByCache() {
        ArrayList<Language> returnList = new ArrayList<Language>(8);
        try {
            List<EnabledLang> langList = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : langList) {
                Language language = new Language();
                language.setName(enabledLang.getName());
                language.setNumber(enabledLang.getNumber());
                language.setDefault(enabledLang.getIsDefault().booleanValue());
                returnList.add(language);
            }
            if (returnList.size() <= 0) {
                Language language = new Language();
                language.setName("\u7b80\u4f53\u4e2d\u6587");
                language.setNumber("zh_CN");
                language.setDefault(true);
                returnList.add(language);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            returnList.clear();
            Language language = new Language();
            language.setName("\u7b80\u4f53\u4e2d\u6587");
            language.setNumber("zh_CN");
            language.setDefault(true);
            returnList.add(language);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Language> getAllLanguageForLoginByDb(Account currentAccount) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        ArrayList<Language> returnList;
        block6: {
            returnList = new ArrayList<Language>(8);
            conn = null;
            stmt = null;
            rs = null;
            try {
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ResManager.loadKDString((String)"getAllLanguageForLogin\u62a5\u9519", (String)"InteServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0])});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "select t.fnumber,t.fisdefault,t.fname, l.fnumber AS langNumber,l.fname AS langName from T_INT_EnabledLanguagenew t left join T_INT_LANGUAGE l on l.fid = t.fid where t.fenabledlang = '1' ";
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String number = rs.getString("fnumber");
                    String name = rs.getString("fname");
                    String langNumber = rs.getString("langNumber");
                    String langName = rs.getString("langName");
                    if (!StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.isNotEmpty((CharSequence)langName)) continue;
                    Language language = new Language();
                    language.setName(StringUtils.isNotEmpty((CharSequence)langName) ? langName : name);
                    language.setNumber(StringUtils.isNotEmpty((CharSequence)langNumber) ? langNumber : number);
                    language.setDefault(Boolean.parseBoolean(rs.getString("fisdefault")));
                    returnList.add(language);
                }
                if (returnList.size() > 0) break block6;
                Language language = new Language();
                language.setName("\u7b80\u4f53\u4e2d\u6587");
                language.setNumber("zh_CN");
                language.setDefault(true);
                returnList.add(language);
            }
            catch (Exception e) {
                try {
                    logger.error((Throwable)e);
                    returnList.clear();
                    Language language = new Language();
                    language.setName("\u7b80\u4f53\u4e2d\u6587");
                    language.setNumber("zh_CN");
                    language.setDefault(true);
                    returnList.add(language);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return returnList;
    }

    public static Map<String, Object> calculateDateByInterval(Long workingPlanId, Date date, Integer interval, Integer intervalType, Integer outputIntervalType) {
        return InteServiceHelper.getInteService().calculateDateByInterval(workingPlanId, date, interval, intervalType, outputIntervalType);
    }

    public static Map<String, Object> calculateDateByStartAndEndDate(Long workingPlanId, Date startDate, Date endDate) {
        return InteServiceHelper.getInteService().calculateDateByStartAndEndDate(workingPlanId, startDate, endDate);
    }

    public static Map<String, DynamicObject> getCountryConfiguration(Long countryId) {
        return InteServiceHelper.getInteService().getCountryConfiguration(countryId);
    }

    public static Map<String, Object> validIdentityCardNo(Long countryId, String identityNo) {
        return InteServiceHelper.getInteService().validIdentityCardNo(countryId, identityNo);
    }

    public static String getDefaultLangNumber() {
        List enabledLangList = InteServiceHelper.getInteService().getEnabledLang();
        String defaultLangNumber = "zh_CN";
        for (EnabledLang enabledLang : enabledLangList) {
            if (!enabledLang.getIsDefault().booleanValue()) continue;
            defaultLangNumber = enabledLang.getNumber();
            break;
        }
        return defaultLangNumber;
    }

    public static Map<String, Object> updateUserTimeZone(Long userId, String timeZoneNum) {
        return InteServiceHelper.getInteService().updateUserTimeZone(userId, timeZoneNum);
    }

    public static List<EnabledLang> getRebuildMetaLang() {
        IInteService service = InteServiceHelper.getInteService();
        return service.getRebuildMetaLang();
    }
}

