/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.jobnotify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobNotifyEvent;
import kd.bos.schedule.api.JobNotifyListener;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class JobProcessorNotify
implements JobNotifyListener {
    private static Log log = LogFactory.getLog(JobProcessorNotify.class);
    private static Map<String, String> msgChannelMap = new HashMap<String, String>();

    public void sendMessage(JobNotifyEvent jobNotifyEvent) {
        try {
            String[] notifyTypeArray;
            JobInfo jobInfo = jobNotifyEvent.getMessageInfo().fetchJobInfo();
            if (jobInfo == null) {
                log.info("jobInfo is null");
                return;
            }
            ArrayList<Long> receiverIds = new ArrayList<Long>();
            long jobPrincipalId = jobInfo.getJobPrincipal();
            if (jobPrincipalId == 0L) {
                log.warn("jobPrincipalId is null");
                return;
            }
            String notifyTypes = jobInfo.getNotifyType();
            if (StringUtils.isBlank((CharSequence)notifyTypes)) {
                log.warn("notifyTypes is blank");
                return;
            }
            String msgContent = jobInfo.getMsgContent();
            if (StringUtils.isBlank((CharSequence)msgContent)) {
                log.warn("msgContent is null");
                return;
            }
            String defaultCaption = ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u901a\u77e5", (String)"JobProcessorNotify_0", (String)"bos-servicehelper", (Object[])new Object[0]);
            StringBuilder captionBuilder = new StringBuilder();
            String caption = jobInfo.getCaption();
            boolean isJson = this.isJSONValid(msgContent);
            if (isJson) {
                String emailContent;
                JSONObject msgContentJson = JSON.parseObject((String)msgContent);
                String emailTitle = msgContentJson.getString("emailTitle");
                if (StringUtils.isNotBlank((CharSequence)emailTitle)) {
                    caption = emailTitle;
                }
                if (StringUtils.isNotBlank((CharSequence)(emailContent = msgContentJson.getString("emailContent")))) {
                    msgContent = emailContent;
                }
            }
            receiverIds.add(jobPrincipalId);
            if (StringUtils.isBlank((CharSequence)caption)) {
                captionBuilder.append(defaultCaption);
            } else {
                captionBuilder.append(caption);
            }
            String captionTemp = captionBuilder.toString();
            for (String notifyType : notifyTypeArray = notifyTypes.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)notifyType) || msgChannelMap.get(notifyType) == null) continue;
                MessageInfo messageInfo = new MessageInfo();
                messageInfo.setType("message");
                messageInfo.setContent(msgContent);
                messageInfo.setUserIds(receiverIds);
                String title = captionTemp + "-" + msgChannelMap.get(notifyType);
                messageInfo.setTitle(title);
                messageInfo.setTag(defaultCaption);
                messageInfo.setNotifyType(notifyType);
                MessageCenterServiceHelper.sendMessage(messageInfo);
            }
        }
        catch (Exception e) {
            log.error("schedule job notify exception: %s", (Throwable)e);
        }
    }

    private boolean isJSONValid(String msgContent) {
        try {
            JSONObject.parseObject((String)msgContent);
        }
        catch (JSONException ex) {
            try {
                JSONObject.parseArray((String)msgContent);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    static {
        for (MessageChannels messageChannel : MessageChannels.values()) {
            msgChannelMap.put(messageChannel.getNumber(), messageChannel.getName());
        }
    }
}

