/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.license;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.license.api.RegisterUserLog;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.api.bean.LicenseError;
import kd.bos.license.api.bean.LicenseGroupInfo;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

@KSObject
@SdkService(name="\u8bb8\u53ef\u5355\u5143\u670d\u52a1::LicenseServiceHelper_1::bos-servicehelper")
public class LicenseServiceHelper {
    private static Log logger = LogFactory.getLog(LicenseServiceHelper.class);
    @SdkInternal
    public static final String LIC_LICENSE = "lic_license";
    public static final String SYNCSTATUS = "2";

    public static boolean updateLicGroupAssignCount(Map<Long, Integer> groupIdAndCount) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.updateLicGroupAssignCount(groupIdAndCount);
    }

    public static Boolean isUserActived(Long userID) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        Boolean isUserActived = licenseService.isUserActived(userID);
        return isUserActived;
    }

    public static LicenseCheckResult checkUserInGroup(Long userID, Long groupID) {
        LicenseCheckResult checkResult = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        checkResult = licenseService.checkUserInGroup(userID, groupID);
        return checkResult;
    }

    public static Long getGroupByHomeCard(String cardID) {
        Long groupID = 0L;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        groupID = licenseService.getGroupByHomeCard(cardID);
        return groupID;
    }

    public static Long getGroupByAppCard(String cardID) {
        Long groupID = 0L;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        groupID = licenseService.getGroupByAppCard(cardID);
        return groupID;
    }

    public static Long getGroupByMenu(String menuID) {
        Long groupID = 0L;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        groupID = licenseService.getGroupByMenu(menuID);
        return groupID;
    }

    private static ILicenseService getService() {
        return (ILicenseService)ServiceFactory.getService(ILicenseService.class);
    }

    public static void addLog(String optName, String opDescription) {
        Date opTime = TimeServiceHelper.now();
        long userID = Long.parseLong(RequestContext.get().getUserId());
        RegisterUserLog regUserLog = new RegisterUserLog(optName, opDescription, opTime, Long.valueOf(userID));
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.addLog(regUserLog);
    }

    public static LicenseCheckResult checkPerformGroup(String groupNumber) {
        LicenseCheckResult checkResult = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        checkResult = licenseService.checkPerformGroup(groupNumber);
        return checkResult;
    }

    public static LicenseCheckResult checkGroup(String groupNumber) {
        LicenseCheckResult checkResult = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        checkResult = licenseService.checkGroup(groupNumber);
        return checkResult;
    }

    public static LicenseCheckResult checkByAppAndBizObj(String bizAppID, String bizObjID, Long userID) {
        LicenseCheckResult checkResult = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        checkResult = licenseService.checkByAppAndBizObj(bizAppID, bizObjID, userID);
        return checkResult;
    }

    @Deprecated
    public static LicenseCheckResult checkUserInBOSRunTimeGroup(Long userID) {
        LicenseCheckResult checkResult = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        checkResult = licenseService.checkUserInBOSRunTimeGroup(userID);
        return checkResult;
    }

    public static Map<String, String> getProductInfo() {
        Map productInfo = null;
        ILicenseService licenseService = LicenseServiceHelper.getService();
        productInfo = licenseService.getProductInfo();
        return productInfo;
    }

    public static List<Map<String, String>> getProductInfos() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getProductInfos();
    }

    public LicenseCheckResult checkMutiOrgQuery(String bizAppID, String bizObjID, Long userID) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.checkMutiOrgQuery(bizAppID, bizObjID, userID);
    }

    public static boolean checkEntityMaxData(String entityId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.checkEntityMaxData(entityId);
    }

    public static void deleteUserLic(Set<Long> userID) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.deleteUserLic(userID);
    }

    public static void deleteUserLicGroup(Set<Long> userID, Boolean deleteSyncGroup) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.deleteUserLicGroup(userID, deleteSyncGroup);
    }

    public static void addUsers2LicGroupDif(Set<Long> userIDs) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.addUsers2LicGroupDif(userIDs);
    }

    public static void addUser2LicGroupDif(Long userID) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        HashSet<Long> userIDs = new HashSet<Long>();
        userIDs.add(userID);
        licenseService.addUsers2LicGroupDif(userIDs);
    }

    public static List<Long> addUserListByGroupNum(String groupNumber, List<Long> userIds) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.addUserListByGroupNum(groupNumber, userIds);
    }

    public static List<Long> addUserListByGroupId(Object groupId, List<Long> userIds) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.addUserListByGroupId(groupId, userIds);
    }

    public static List<Long> addUserListByGroupId(Object groupId, List<Long> userIds, Long legalPersonID) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.addUserListByGroupId(groupId, userIds, legalPersonID);
    }

    public static Map<String, Object> syncUserGroup() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.syncUserGroup();
    }

    public static Map<String, Object> syncUserGroup(Long userId) {
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add(userId);
        return LicenseServiceHelper.syncUserGroup(userIds);
    }

    public static Map<String, Object> syncUserGroup(Set<Long> userIds) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.syncUserGroup(userIds);
    }

    @Deprecated
    public static List<CloudUserInfo> getCloudUserInfo() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getCloudUserInfo();
    }

    public static List<CloudUserInfo> getCloudUserInfo(String productInstCode) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getCloudUserInfo(productInstCode);
    }

    public static Map<String, Object> getActiveCode(String phone) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getActiveCode(phone);
    }

    public static boolean verifyCloudCode(String phone, String vcode) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.verifyCloudCode(phone, vcode);
    }

    public static Map<String, Object> validateLicDate() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.validateLicDate();
    }

    public static SyncLicenseProgressInfo getUploadRegUserProgress() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        String uploadRegUserProgress = licenseService.getUploadRegUserProgress();
        if (uploadRegUserProgress == null) {
            return new SyncLicenseProgressInfo();
        }
        SyncLicenseProgressInfo info = (SyncLicenseProgressInfo)SerializationUtils.fromJsonString((String)uploadRegUserProgress, SyncLicenseProgressInfo.class);
        return info;
    }

    public static void updateUploadRegUserProgress(boolean inSync, int hasSyncNum, int syncTotal, boolean isUpdateSuccess, boolean isDownloadSuccess, boolean inUpdate, boolean inDownload) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.updateUploadRegUserProgress(inSync, hasSyncNum, syncTotal, isUpdateSuccess, isDownloadSuccess, inUpdate, inDownload);
    }

    public static void reLoadLicenseCache() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.reLoadLicenseCache();
    }

    @Deprecated
    public static boolean productValidate() {
        logger.info("LicenseServiceHelper.productValidate ");
        return true;
    }

    @Deprecated
    @SdkInternal
    public static JSONObject generateJSONObject() {
        JSONObject json = new JSONObject();
        Map<String, String> productInfo = LicenseServiceHelper.getProductInfo();
        json.put("FProductRegNO", (Object)productInfo.get("productNo"));
        json.put("FProductID", (Object)productInfo.get("productID"));
        json.put("FLicExpireDate", (Object)productInfo.get("expdate"));
        json.put("FAdditionalInfo", (Object)productInfo.get("softwareCode"));
        json.put("FMode", (Object)"1");
        json.put("FType", (Object)productInfo.get("type"));
        json.put("FPeriod", (Object)LicenseServiceHelper.generatePeriod());
        json.put("FLicName", (Object)("kingdee eas nextcloud V" + productInfo.get("productversion")));
        json.put("FAccounts", (Object)"");
        json.put("FLicMD5", (Object)"");
        json.put("FCellsMD5", (Object)"");
        logger.info("LicenseServiceHelper.generateJSONObject : json = " + json);
        return json;
    }

    private static String generatePeriod() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int weekday = calendar.get(4);
        return "Y" + year + "M" + (month > 9 ? "" : "0") + month + "W" + weekday;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @SdkInternal
    public static String sendData(JSONObject json) {
        try (CloseableHttpClient http = HttpClients.createDefault();){
            String url = "https://api.cmcloud.cn/api/genuineCheck.do";
            HttpPost post = new HttpPost(url);
            post.setHeader("Content-type", "application/x-www-form-urlencoded");
            post.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            JSONObject jObject = new JSONObject();
            jObject.put("req", (Object)json);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("req", json.toJSONString()));
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = http.execute((HttpUriRequest)post);
            HttpEntity resEntity = response.getEntity();
            String responseStr = "";
            if (resEntity != null) {
                responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
            post.releaseConnection();
            String string = responseStr;
            return string;
        }
        catch (IOException e) {
            logger.error("LicenseServiceHelper.sendData error.", (Throwable)e);
            return "";
        }
    }

    public static Map<String, String> getHttpRequestJsonHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "text/html;charset=utf-8");
        return header;
    }

    public static Map<String, Object> addUserLicGroupByBizAppAndBizObj(Long userId, Map<String, List<String>> bizAppAndObjInfo) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.addUserLicGroupByBizAppAndBizObj(userId, bizAppAndObjInfo);
    }

    public static Map<String, Object> addUsersLicGroupByBizAppAndBizObj(List<Long> userIds, Map<String, List<String>> bizAppAndObjInfo) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.addUsersLicGroupByBizAppAndBizObj(userIds, bizAppAndObjInfo);
    }

    public static boolean removeUserLicGroupById(Long userId, Set<Long> groupId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.removeUserLicGroupById(userId, groupId);
    }

    public static boolean removeUserLicGroupByNum(Long userId, Set<String> groupNum) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.removeUserLicGroupByNum(userId, groupNum);
    }

    public static boolean clearUserLicGroup(Long userId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.clearUserLicGroup(userId);
    }

    public static int getTotalNumber(Object groupId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getTotalNumber(groupId);
    }

    public static int getTotalNumberNoUpdateCache(Object groupId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getTotalNumberNoUpdateCache(groupId);
    }

    public static int getRemainNumber(Object groupId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getRemainNumber(groupId);
    }

    public static String checkAppInLicenseCtrl(String appId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.checkAppInLicenseCtrl(appId);
    }

    public static boolean isTemporaryLicense() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.isTemporaryLicense();
    }

    public static boolean isCosmic() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.isCosmic();
    }

    public static String getProductVersion() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getProductVersion();
    }

    public static LicenseCheckResult checkLicenseRight(Long userId, String bizAppId, String entityTypeId) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.checkLicenseRight(userId, bizAppId, entityTypeId);
    }

    public static void checkLicenseRight(FormShowParameter formShowParameter, Map<String, Object> ret) {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        licenseService.checkLicenseRight(formShowParameter, ret);
    }

    public static int getModeType() {
        ILicenseService licenseService = LicenseServiceHelper.getService();
        return licenseService.getModeType();
    }

    public static String getPubTenantType() {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getPubTenantType();
    }

    public static Set<String> getAvailableApps() {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getAvailableApps();
    }

    public static String getLicenseType() {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getLicenseType();
    }

    public static Set<String> getLicenseModules() {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getLicenseModules();
    }

    public static LicenseCheckResult checkLicenseModules(String bizAppId) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.checkLicenseModules(bizAppId);
    }

    public static Date getExpireDateByGroup(Long groupId) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getExpireDateByGroup(groupId);
    }

    public static Map<String, Date> getGroupTimeRange(Long groupId) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getGroupTimeRange(groupId);
    }

    public static boolean isSingleOrgManageMode() {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.isSingleOrgManageMode();
    }

    public static List<LicenseError> addUserGroupById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.addUserGroupById(userIds, groupIds, legalPersonID);
    }

    public static List<LicenseError> deleteUserGroupById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.deleteUserGroupById(userIds, groupIds, legalPersonID);
    }

    public static Integer getUsedQuantityByGroup(Long groupId) {
        ILicenseService service = LicenseServiceHelper.getService();
        Map result = service.getUsedQuantityByGroups(Collections.singletonList(groupId));
        if (result == null || result.isEmpty()) {
            return 0;
        }
        return (Integer)result.get(groupId);
    }

    public static Map<Long, Integer> getUsedQuantityByGroups(List<Long> groupIds) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getUsedQuantityByGroups(groupIds);
    }

    public static List<Map<String, String>> getProdInfosByGroup(String groupNumber) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getProdInfosByGroup(groupNumber);
    }

    public static boolean isIsv(String entityTypeId) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.isIsv(entityTypeId);
    }

    public static Map<Long, LicenseGroupInfo> getSubscribedGroupInfo(List<Long> groupIds) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.getSubscribedGroupInfo(groupIds);
    }

    public static FormShowParameter buildNoticeFormShowParameter(String title, List<String> details) {
        ILicenseService service = LicenseServiceHelper.getService();
        return service.buildNoticeFormShowParameter(title, details);
    }
}

