/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;

public class AduitLogTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(AduitLogTask.class);

    public void execute(RequestContext context, Map<String, Object> map) throws KDException {
        log.info("AduitLogTask:begin to process Aduit Log");
        LogORM logOrm = LogORM.create();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        List infos = (List)map.get("infos");
        log.info("AduitLogTask:logInfos = " + infos);
        Long userId = (Long)map.get("userId");
        String userName = (String)map.get("userName");
        for (AppLogInfo info : infos) {
            this.doAduitLog(info, list, userId, userName);
        }
        logOrm.insert(list);
    }

    private void doAduitLog(AppLogInfo logInfo, List<DynamicObject> list, Long userId, String userName) {
        if (StringUtils.isBlank((CharSequence)logInfo.getModifyBillID()) || StringUtils.isBlank((CharSequence)logInfo.getModifyContent())) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_aduit_log_new");
        DynamicObject obj = new DynamicObject((DynamicObjectType)type);
        obj.set("username", (Object)this.getUserName(userId, userName));
        obj.set("opname", (Object)logInfo.getOpName());
        obj.set("opdesc", (Object)logInfo.getOpDescription());
        obj.set("opdate", (Object)TimeServiceHelper.now());
        obj.set("modifybillid", (Object)logInfo.getModifyBillID());
        obj.set("modifybillno", (Object)logInfo.getModifyBillNo());
        obj.set("modifyfields", (Object)logInfo.getModifyFields());
        obj.set("modifycontent", (Object)logInfo.getModifyContent());
        obj.set("modifycontent_tag", (Object)logInfo.getModifyContentTag());
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeNoCache((String)logInfo.getBizObjID());
        obj.set("bizobjname", (Object)entityType.getDisplayName().toString());
        obj.set("bizobjnumber", (Object)logInfo.getBizObjID());
        obj.set("clienttype", (Object)logInfo.getClientType());
        list.add(obj);
    }

    private String getUserName(Long userId, String userName) {
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache(userId, "bos_user", "number,name");
        if (user == null) {
            return userName;
        }
        String number = user.get("number") == null ? "" : user.get("number").toString();
        String name = user.get("name") == null ? "" : user.get("name").toString();
        return (number + " " + name).trim();
    }
}

