/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.NotificationLevel;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.sdk.annotation.SdkService;
import org.apache.commons.collections.CollectionUtils;

@SdkService(name="\u5728\u7ebf\u901a\u77e5\u670d\u52a1")
public class NotificationServiceHelper {
    private static String BOS_SERVICEHELPER = "bos-servicehelper";

    public static void sendNotification(List<String> userIds, NotificationFormInfo notificationFormInfo) {
        NotificationServiceHelper.fillInfo(notificationFormInfo, null);
        NotificationServiceHelper.sendByUserId(userIds, notificationFormInfo);
    }

    public static void sendNotificationByLang(Map<String, List<String>> userSessionIdsMap, NotificationFormInfo notificationFormInfo, String lang) {
        for (Map.Entry<String, List<String>> next : userSessionIdsMap.entrySet()) {
            String userId = next.getKey();
            List<String> sessionIds = next.getValue();
            NotificationServiceHelper.sendBySessionId(userId, sessionIds, notificationFormInfo, lang);
        }
    }

    private static void fillInfo(NotificationFormInfo notificationFormInfo, String lang) {
        if (notificationFormInfo.getNotification() == null) {
            ErrorCode ec = new ErrorCode("NOTIFICATION_BODY_EMPTY", "NOTIFICATION_BODY_EMPTY");
            throw new KDException(ec, new Object[0]);
        }
        if (notificationFormInfo.getNotification().getAppId() == null) {
            ErrorCode ec = new ErrorCode("NOTIFICATION_APPID_EMPTY", "NOTIFICATION_APPID_EMPTY");
            throw new KDException(ec, new Object[0]);
        }
        ArrayList<NotificationBody.ButtonInfo> buttonInfoList = notificationFormInfo.getNotification().getButtonInfo();
        if (CollectionUtils.isEmpty((Collection)buttonInfoList)) {
            buttonInfoList = new ArrayList<NotificationBody.ButtonInfo>(16);
        }
        if (notificationFormInfo.getNotification().getLevel() == NotificationLevel.normal.getLevel()) {
            NotificationBody.ButtonInfo ignoreButton;
            if (!buttonInfoList.stream().anyMatch(v -> "ignore".equals(v.getKey()))) {
                ignoreButton = new NotificationBody.ButtonInfo();
                ignoreButton.setKey("ignore");
                ignoreButton.setText(ResManager.loadKDString((String)"\u5ffd\u7565", (String)"NotificationServiceHelper_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                buttonInfoList.add(ignoreButton);
            } else {
                ignoreButton = buttonInfoList.stream().filter(v -> "ignore".equals(v.getKey())).findFirst().get();
            }
            if (StringUtils.isNotBlank((CharSequence)lang)) {
                ignoreButton.setText((String)ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5ffd\u7565", (String)"NotificationServiceHelper_1", (String)"bos-servicehelper", (Object[])new Object[0]), (String)"Notification_0", (String)BOS_SERVICEHELPER).get((Object)lang));
            }
        }
        notificationFormInfo.getNotification().setButtonInfo(buttonInfoList);
        if (notificationFormInfo.getNotification().getNotificationId() == null) {
            notificationFormInfo.getNotification().setNotificationId(UUID.randomUUID().toString());
        }
        notificationFormInfo.getNotification().setTenantId(RequestContext.get().getTenantId());
    }

    private static void sendByUserId(List<String> userIds, NotificationFormInfo notificationFormInfo) {
        for (String userId : userIds) {
            NotificationClientCache.putNotificationFormInfo((String)userId, (String)notificationFormInfo.getNotification().getNotificationId(), (NotificationFormInfo)notificationFormInfo);
            List<Object> userAllNotificationFormInfos = new ArrayList<NotificationFormInfo>(16);
            if (notificationFormInfo.getNotification().getLevel() == NotificationLevel.important.getLevel()) {
                userAllNotificationFormInfos.add(notificationFormInfo);
            } else {
                userAllNotificationFormInfos.addAll(NotificationClientCache.getUserAllNotificationFormInfos((String)userId));
                userAllNotificationFormInfos = userAllNotificationFormInfos.stream().filter(v -> v.getNotification().getLevel() == NotificationLevel.normal.getLevel()).collect(Collectors.toList());
                userAllNotificationFormInfos = userAllNotificationFormInfos.stream().filter(v -> !"activity".equals(v.getMsgType())).collect(Collectors.toList());
            }
            List<Object> notificationBodyList = new ArrayList<NotificationBody>(16);
            if (CollectionUtils.isNotEmpty(userAllNotificationFormInfos)) {
                for (NotificationFormInfo notificationFormInfo1 : userAllNotificationFormInfos) {
                    notificationBodyList.add(notificationFormInfo1.getNotification());
                }
            }
            if (!CollectionUtils.isNotEmpty(notificationBodyList)) continue;
            notificationBodyList = notificationBodyList.stream().sorted(Comparator.comparing(NotificationBody::getCreateTime).reversed()).collect(Collectors.toList());
            Map<Integer, List<NotificationBody>> map = notificationBodyList.stream().collect(Collectors.groupingBy(NotificationBody::getLevel));
            for (List<NotificationBody> list : map.values()) {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("notification", list);
                param.put("duration", notificationFormInfo.getDuration());
                PushServiceHelper.sendWebSocketAction("showNotification", param, Stream.of(userId).collect(Collectors.toList()));
            }
        }
    }

    private static void sendBySessionId(String userId, List<String> sessionIds, NotificationFormInfo notificationFormInfo, String lang) {
        NotificationClientCache.putNotificationFormInfo((String)userId, (String)notificationFormInfo.getNotification().getNotificationId(), (NotificationFormInfo)notificationFormInfo);
        List<Object> userAllNotificationFormInfos = new ArrayList<NotificationFormInfo>(16);
        if (notificationFormInfo.getNotification().getLevel() == NotificationLevel.important.getLevel()) {
            userAllNotificationFormInfos.add(notificationFormInfo);
        } else {
            userAllNotificationFormInfos.addAll(NotificationClientCache.getUserAllNotificationFormInfos((String)userId));
            userAllNotificationFormInfos = userAllNotificationFormInfos.stream().filter(v -> v.getNotification().getLevel() == NotificationLevel.normal.getLevel()).collect(Collectors.toList());
            userAllNotificationFormInfos = userAllNotificationFormInfos.stream().filter(v -> !"activity".equals(v.getMsgType())).collect(Collectors.toList());
        }
        List<Object> notificationBodyList = new ArrayList(16);
        if (CollectionUtils.isNotEmpty(userAllNotificationFormInfos)) {
            for (NotificationFormInfo notificationFormInfo1 : userAllNotificationFormInfos) {
                NotificationServiceHelper.fillInfo(notificationFormInfo1, lang);
                notificationBodyList.add(notificationFormInfo1.getNotification());
            }
        }
        if (CollectionUtils.isNotEmpty(notificationBodyList)) {
            notificationBodyList = notificationBodyList.stream().sorted(Comparator.comparing(NotificationBody::getCreateTime).reversed()).collect(Collectors.toList());
            Map<Integer, List<NotificationBody>> map = notificationBodyList.stream().collect(Collectors.groupingBy(NotificationBody::getLevel));
            for (List<NotificationBody> list : map.values()) {
                HashMap<String, List<NotificationBody>> param = new HashMap<String, List<NotificationBody>>(16);
                param.put("notification", list);
                PushServiceHelper.sendWebSocketActionBySession("showNotification", param, sessionIds.toArray(new String[sessionIds.size()]));
            }
        }
    }

    public static void sendClearNotification(String userId) {
        PushServiceHelper.sendWebSocketAction("clearNotification", new HashMap(), Stream.of(userId).collect(Collectors.toList()));
    }

    public static void sendClearNotification(String userId, List<String> notificationIds, int level) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("notificationIds", notificationIds);
        param.put("level", level);
        PushServiceHelper.sendWebSocketAction("clearNotification", param, Stream.of(userId).collect(Collectors.toList()));
    }

    public static void sendIgnoreNotification(String userId, String notificationId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("notificationId", notificationId);
        PushServiceHelper.sendWebSocketAction("ignoreNotification", param, Stream.of(userId).collect(Collectors.toList()));
    }
}

