/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.org;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.OrgSeparation;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.model.OrgSaveModel;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OrgServiceHelper {
    private static final String VIEW_TREETYPE = "view.treetype";
    private static final String PARENT = "parent";
    private static final String IS_LEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String NUMBER = "number";
    private static final String FULL_NAME = "fullname";
    private static final String IS_CTRLUNIT = "isctrlunit";
    private static final String FISCONTROLUNIT = "fiscontrolunit";
    private static final String ORG_ID = "org.id";
    private static final String VIEW_ISDEFAULT = "view.isdefault";
    private static final String LONGNUMBER_DESC = "longnumber desc";
    private static final String LEVEL = "level";
    private static final String YZJORGID = "yzjorgid";
    private static final String YZJPARENTORG_ID = "yzjparentorgid";
    private static final String FFIELD_NAME = "ffieldname";
    private static final String FNUMBER = "fnumber";
    private static final String SELECT_FIELDS = "id,fnumber,ffieldname";
    private static final String VIEW_NUMBER = "view.number";
    private static final String TOTYPE = "totype";
    private static final String FROMTYPE = "fromtype";
    private static Log logger = LogFactory.getLog(OrgServiceHelper.class);
    public static final String entityID_bos_org = "bos_org";
    public static final String entityID_bos_org_biz = "bos_org_biz";
    public static final String number_maindata = "16";
    public static final String entityID_org_viewschema = "bos_org_viewschema";
    public static final String entityID_org_structure = "bos_org_structure";
    private static final String ENTITYID_ORGTYPESTATUSREC = "bos_orgtypestatusrec";
    private static final String SELFIELD_SCHANGE = "id,yzjorgid,org,org.id,org.name,yzjparentorgid,parent,parent.id,patent.name";
    public static final String entityID_bos_org_typerelation = "bos_org_typerelation";
    public static final String entityID_bos_org_orgrelation = "bos_org_orgrelation";
    public static final String ENTITYID_BOS_ORG_DUTYRELATION = "bos_org_dutyrelation";

    public static List<Map<String, String>> getOrgBizList() {
        ArrayList<Map<String, String>> lstBizs = new ArrayList<Map<String, String>>();
        return lstBizs;
    }

    public static List<Map<String, String>> getAllOrgBiz() {
        ArrayList<Map<String, String>> lstBizs = new ArrayList<Map<String, String>>();
        return lstBizs;
    }

    public static Map<String, Object> getOrgbyYzjorgId(String yzjorgId) {
        return OrgUnitServiceHelper.getOrgbyYzjorgId(yzjorgId);
    }

    public static <T> Map<String, Object> getCompanyfromOrg(T org) {
        return OrgUnitServiceHelper.getCompanyfromOrg(org);
    }

    public static List<Long> getSuperiorOrgs(String orgFunction, long orgId) {
        return OrgUnitServiceHelper.getSuperiorOrgs(orgFunction, orgId);
    }

    public static List<Long> getSuperiorOrgs(long orgId) {
        return OrgUnitServiceHelper.getSuperiorOrgs("01", orgId);
    }

    public static List<Long> getSuperiorOrgs(List<Long> orgIds) {
        return OrgUnitServiceHelper.getSuperiorOrgs("01", orgIds);
    }

    public static List<Long> getSubordinateOrgs(long orgId) {
        if (orgId == 0L) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> lstParaOrgs = new ArrayList<Long>();
        lstParaOrgs.add(orgId);
        return OrgServiceHelper.getSubordinateOrgs(lstParaOrgs);
    }

    public static List<Long> getSubordinateOrgs(List<Long> orgIds) {
        ArrayList<Long> lstOrgs = new ArrayList<Long>();
        if (orgIds.size() == 0) {
            return lstOrgs;
        }
        QFilter f2 = new QFilter(VIEW_TREETYPE, "=", (Object)"01");
        QFilter f3 = new QFilter(PARENT, "in", orgIds);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, "org", new QFilter[]{f2, f3});){
            for (Row row : ds) {
                if (row.getLong("org") == null) continue;
                lstOrgs.add(row.getLong("org"));
            }
        }
        return lstOrgs;
    }

    public static List<Long> getSubordinateOrgs(Map<Long, Boolean> orgInfoMap) {
        if (orgInfoMap == null || orgInfoMap.isEmpty()) {
            return new ArrayList<Long>();
        }
        int count = orgInfoMap.size();
        ArrayList<Long> allOrgList = new ArrayList<Long>(count);
        ArrayList<Long> includeSubOrgList = new ArrayList<Long>(count);
        for (Map.Entry<Long, Boolean> entry : orgInfoMap.entrySet()) {
            long orgId = entry.getKey();
            allOrgList.add(orgId);
            if (!entry.getValue().booleanValue()) continue;
            includeSubOrgList.add(orgId);
        }
        if (includeSubOrgList.isEmpty()) {
            return allOrgList;
        }
        allOrgList.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs(OrgUnitServiceHelper.getViewIdByType("15"), includeSubOrgList, false));
        return allOrgList;
    }

    public static List<Long> getAllSubordinateOrgs(List<Long> orgIds, boolean bIncludeCurOrg) {
        if (orgIds == null || orgIds.size() <= 0) {
            return new ArrayList<Long>();
        }
        return OrgServiceHelper.getAllSubordinateOrgs("01", orgIds, bIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(long viewType, List<Long> orgIds, boolean bIncludeCurOrg) {
        return OrgUnitServiceHelper.getAllSubordinateOrgs(viewType, orgIds, bIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(String viewType, List<Long> orgIds, boolean bIncludeCurOrg) {
        long viewId = OrgUnitServiceHelper.getViewIdByType(viewType);
        if (viewId == 0L) {
            return new ArrayList<Long>(0);
        }
        return OrgServiceHelper.getAllSubordinateOrgs(viewId, orgIds, bIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(long orgId, boolean bIncludeCurOrg) {
        if (orgId == 0L) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List<Long> resultList = OrgServiceHelper.getAllSubordinateOrgs(orgIds, bIncludeCurOrg);
        return resultList;
    }

    public static List<Long> getAllSubordinateOrgs(String orgFunction, Long orgId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        return orgIdList;
    }

    public static List<Long> getAllSubordinateCtrlOrgs(Long orgId, boolean isIncludeCtrlOrg) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        return orgIdList;
    }

    public List<DynamicObject> getAuthorizedBizOrgUnits(Long userID, String orgFunction, String entityID, String permissionItem) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getAuthorizedBizOrgUnits(userID, orgFunction, entityID, permissionItem);
    }

    public DynamicObject getBizOrg(Long orgID, String orgFunction) {
        return ((IOrgService)ServiceFactory.getService(IOrgService.class)).getBizOrg(orgID, orgFunction);
    }

    public QFilter getBizOrgFilter(String orgFunction) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getBizOrgFilter(orgFunction);
    }

    public List<DynamicObject> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        ArrayList<DynamicObject> subordinateOrgList = new ArrayList();
        subordinateOrgList = this.getAllDirectSubordinateOrgList(orgViewId, parentOrgId, true);
        return subordinateOrgList;
    }

    public List<DynamicObject> getAllDirectSubordinateOrgList(Long orgViewId, Long parentOrgId, boolean isOnlyLeaf) {
        ArrayList<DynamicObject> subordinateOrgList = new ArrayList<DynamicObject>();
        String selectFields = "*, org.*";
        QFilter[] filters = null;
        String orderBys = "";
        QFilter filterId = new QFilter("view", "=", (Object)orgViewId);
        QFilter filterParentId = new QFilter(PARENT, "=", (Object)parentOrgId);
        if (isOnlyLeaf) {
            QFilter filterIsLeaf = new QFilter(IS_LEAF, "=", (Object)"1");
            filters = new QFilter[]{filterId, filterParentId, filterIsLeaf};
        } else {
            filters = new QFilter[]{filterId, filterParentId};
        }
        ORM orm = ORM.create();
        DynamicObjectCollection orgCollection = orm.query(entityID_org_structure, selectFields, filters, orderBys);
        if (orgCollection == null || orgCollection.size() == 0) {
            return subordinateOrgList;
        }
        DynamicObject org = null;
        for (DynamicObject orgEntry : orgCollection) {
            org = orgEntry.getDynamicObject("org");
            subordinateOrgList.add(org);
        }
        return subordinateOrgList;
    }

    public static Map<String, Object> getOrgLongProperty(long ovType, long orgId) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        if (orgId == 0L) {
            return mp;
        }
        QFilter f2 = new QFilter("view", "=", (Object)ovType);
        QFilter f3 = new QFilter("org", "=", (Object)orgId);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, "longnumber,fullname", new QFilter[]{f2, f3});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                mp.put(NUMBER, row.getString(LONGNUMBER));
                mp.put("name", row.getString(FULL_NAME));
            }
        }
        return mp;
    }

    @Deprecated
    public static Map<String, String> getAdminOrgLongProperty(String ovType) {
        QFilter f2;
        HashMap<String, String> mp = new HashMap<String, String>();
        try {
            f2 = new QFilter("view", "=", (Object)Long.valueOf(ovType));
        }
        catch (Exception e) {
            f2 = new QFilter(VIEW_NUMBER, "=", (Object)ovType);
        }
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, "longnumber,org", new QFilter[]{f2});){
            for (Row row : ds) {
                mp.put(row.getString("org"), row.getString(LONGNUMBER));
            }
        }
        return mp;
    }

    public static Map<String, Object> getOrgLongProperty(String ovType, long orgId) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        if (orgId == 0L) {
            return mp;
        }
        QFilter f1 = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter f2 = new QFilter(VIEW_TREETYPE, "=", (Object)ovType);
        QFilter f3 = new QFilter("org", "=", (Object)orgId);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, "longnumber,fullname", new QFilter[]{f1, f2, f3});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                mp.put(NUMBER, row.getString(LONGNUMBER));
                mp.put("name", row.getString(FULL_NAME));
            }
        }
        return mp;
    }

    @Deprecated
    public static List<Map<String, String>> getOrgChildrenTreeData(long ovType, long parentid) {
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        return orgTreeData;
    }

    @Deprecated
    public static long getCuByOrgId(long orgId) {
        if (orgId == 0L) {
            return 0L;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, entityID_bos_org);
        if (org.getBoolean(FISCONTROLUNIT)) {
            return orgId;
        }
        List<Long> parentIdList = OrgServiceHelper.getSuperiorOrgs("15", orgId);
        if (parentIdList != null && parentIdList.size() > 0) {
            return OrgServiceHelper.getCuByOrgId(parentIdList.get(0));
        }
        return 0L;
    }

    public static Long getCtrlUnitByOrgId(Long viewSchemaID, Long orgID) {
        Long ctrlUnitID = 0L;
        String selectFields = "org.id,longnumber,isctrlunit";
        QFilter viewSchemaFilter = new QFilter("view", "=", (Object)viewSchemaID);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgID);
        QFilter[] filters = new QFilter[]{viewSchemaFilter, orgFilter};
        DynamicObject orgInfo = QueryServiceHelper.queryOne(entityID_org_structure, selectFields, filters);
        if (orgInfo == null) {
            return ctrlUnitID;
        }
        if (orgInfo.getBoolean(IS_CTRLUNIT)) {
            ctrlUnitID = orgInfo.getLong(ORG_ID);
            return ctrlUnitID;
        }
        QFilter isCtrlUnitFilter = new QFilter(IS_CTRLUNIT, "=", (Object)Boolean.TRUE);
        String longnumber = orgInfo.getString(LONGNUMBER);
        HashSet<String> allLongNumberSet = new HashSet<String>(32);
        while (longnumber.indexOf(33) > 0) {
            longnumber = longnumber.substring(0, longnumber.lastIndexOf(33));
            allLongNumberSet.add(longnumber);
        }
        QFilter allLongNumberFilter = new QFilter(LONGNUMBER, "in", allLongNumberSet);
        filters = new QFilter[]{viewSchemaFilter, allLongNumberFilter, isCtrlUnitFilter};
        String orderBys = LONGNUMBER_DESC;
        DynamicObjectCollection allSuperiorOrg = QueryServiceHelper.query(entityID_org_structure, selectFields, filters, orderBys);
        if (allSuperiorOrg == null || allSuperiorOrg.size() == 0) {
            logger.info("\u67e5\u627e\u4e0d\u5230\u7ba1\u63a7\u5355\u5143");
            return ctrlUnitID;
        }
        ctrlUnitID = ((DynamicObject)allSuperiorOrg.get(0)).getLong(ORG_ID);
        return ctrlUnitID;
    }

    public boolean autoBuildBizTree(List<Long> bizList, OrgSaveModel<String> orgModel) {
        return true;
    }

    @Deprecated
    public static void addOrgViewEntry(long lOrgViewTypeId, Long lParentOrgId, OrgSaveModel<String> orgModel) {
        if (orgModel == null) {
            return;
        }
        long lOrgId = Long.parseLong(orgModel.getOrgId());
        String sCurOrgNumber = orgModel.getOrgNumber();
        String sCurOrgName = orgModel.getOrgName();
        if (lOrgViewTypeId == 0L || lOrgId == 0L || StringUtils.isEmpty((String)sCurOrgNumber) || StringUtils.isEmpty((String)sCurOrgName)) {
            return;
        }
        if (OrgServiceHelper.CheckIsExistOrgViewEntry(lOrgViewTypeId, lOrgId).booleanValue()) {
            return;
        }
        String selectProperties = "org,org.id,parent,parent.id,longnumber,isleaf,fullname,level,isctrlunit";
        QFilter f1 = new QFilter("view", "=", (Object)lOrgViewTypeId);
        QFilter f2 = new QFilter("org", "=", (Object)lParentOrgId);
        QFilter[] filters = new QFilter[]{f1, f2};
        DynamicObject doOVParent = null;
        DynamicObject[] doOVParents = BusinessDataServiceHelper.load(entityID_org_structure, selectProperties, filters);
        if (doOVParents.length == 1) {
            doOVParent = doOVParents[0];
        }
        String sParentLongnumber = "";
        String sParentLongname = "";
        long level = 1L;
        if (doOVParent != null && doOVParent.get("org") != null && lParentOrgId == Long.parseLong(doOVParent.get(ORG_ID).toString())) {
            doOVParent.set(IS_LEAF, (Object)"0");
            sParentLongnumber = doOVParent.get(LONGNUMBER) != null ? doOVParent.get(LONGNUMBER).toString() : "";
            sParentLongname = doOVParent.get(FULL_NAME) != null ? doOVParent.get(FULL_NAME).toString() : "";
            level = doOVParent.get(LEVEL) != null ? Long.parseLong(doOVParent.get(LEVEL).toString()) + 1L : 0L;
        }
        String longNumber = null;
        String longName = null;
        OrgSeparation orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        longNumber = StringUtils.isEmpty((String)sParentLongnumber) ? sCurOrgNumber : sParentLongnumber + orgSeparation.getLongNumberSep() + sCurOrgNumber;
        longName = StringUtils.isEmpty((String)sParentLongname) ? sCurOrgName : sParentLongname + orgSeparation.getFullNameSep() + sCurOrgName;
        DynamicObject doNew = BusinessDataServiceHelper.newDynamicObject(entityID_org_structure);
        doNew.set("org", (Object)lOrgId);
        doNew.set(PARENT, (Object)lParentOrgId);
        doNew.set(YZJORGID, (Object)orgModel.getYzjorgId());
        doNew.set(YZJPARENTORG_ID, (Object)orgModel.getYzjParentorgId());
        doNew.set(IS_LEAF, (Object)"1");
        doNew.set(LONGNUMBER, (Object)longNumber);
        doNew.set(FULL_NAME, (Object)longName);
        doNew.set(LEVEL, (Object)level);
        doNew.set("view", (Object)lOrgViewTypeId);
        doNew.set("enable", (Object)"1");
        doNew.set("status", (Object)"C");
        doNew.set(IS_CTRLUNIT, (Object)orgModel.isIsCtrlUnit());
        try (TXHandle h = TX.beginNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)doNew.getDataEntityType(), (Object[])new Object[]{doNew});
                if (doOVParent != null) {
                    BusinessDataServiceHelper.save(doOVParent.getDataEntityType(), new Object[]{doOVParent});
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private static Boolean CheckIsExistOrgViewEntry(long lOrgViewTypeId, long lOrgId) {
        QFilter filterOrg = new QFilter("org", "=", (Object)lOrgId);
        QFilter filterOrg1 = new QFilter("view", "=", (Object)lOrgViewTypeId);
        QFilter[] filterOrgs = new QFilter[]{filterOrg, filterOrg1};
        DynamicObject dyOrg = QueryServiceHelper.queryOne(entityID_org_structure, "id", filterOrgs);
        if (dyOrg != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static DynamicObjectCollection getOrgBizDataById(Long bizId) {
        QFilter f1 = new QFilter("id", "=", (Object)bizId);
        QFilter f2 = new QFilter(FFIELD_NAME, "!=", (Object)"");
        QFilter[] filters = new QFilter[]{f1, f2};
        Map<Object, DynamicObject> orgBizMap = BusinessDataServiceHelper.loadFromCache(entityID_bos_org_biz, SELECT_FIELDS, filters, "id");
        orgBizMap.values();
        DynamicObjectCollection doc = new DynamicObjectCollection();
        for (DynamicObject orgBiz : orgBizMap.values()) {
            doc.add((Object)orgBiz);
        }
        return doc;
    }

    public List<DynamicObject> getOrgBizNameList() {
        QFilter f2;
        QFilter f1 = new QFilter("id", ">", (Object)0);
        QFilter[] filters = new QFilter[]{f1, f2 = new QFilter(FFIELD_NAME, "!=", (Object)"")};
        Map<Object, DynamicObject> orgBizMap = BusinessDataServiceHelper.loadFromCache(entityID_bos_org_biz, SELECT_FIELDS, filters, "id");
        if (orgBizMap == null || orgBizMap.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(orgBizMap.size());
        for (DynamicObject orgBiz : orgBizMap.values()) {
            list.add(orgBiz);
        }
        return list;
    }

    public static long getBizID(String number) {
        QFilter f1 = new QFilter(FNUMBER, "=", (Object)number);
        QFilter f2 = new QFilter("fuserdefine", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{f1, f2};
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache(entityID_bos_org_biz, SELECT_FIELDS, filters);
        long id = Long.parseLong(dy.get("id").toString());
        return id;
    }

    public static String getOrgBizPro(String orgFunction) {
        String orgFuncProName = null;
        QFilter f1 = new QFilter(FNUMBER, "=", (Object)orgFunction);
        QFilter f2 = new QFilter("fuserdefine", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{f1, f2};
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache(entityID_bos_org_biz, "id,propertyname", filters);
        orgFuncProName = dy.getString("propertyname");
        return orgFuncProName;
    }

    public static long getSamePropertyParentID(long lOldParentID, long lTreetype) {
        QFilter filter = new QFilter("org", "=", (Object)lOldParentID);
        QFilter filterTreeType = null;
        if (lTreetype == 16L) {
            filterTreeType = new QFilter("view", "=", (Object)lTreetype);
            filterTreeType = filterTreeType.and(new QFilter(IS_CTRLUNIT, "=", (Object)Boolean.TRUE));
            filterTreeType = filterTreeType.or(new QFilter("view", "=", (Object)15L));
        } else {
            filterTreeType = new QFilter("view", "in", (Object)new Long[]{lTreetype, 15L});
        }
        QFilter[] filters = new QFilter[]{filter, filterTreeType};
        String orgUnitLongnumber = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet("OrgServiceHelper.getSamePropertyParentIDByLongNumber", entityID_org_structure, "view,org,longnumber", filters, LONGNUMBER_DESC);){
            for (Row row : dataSet) {
                long viewId = row.getLong("view");
                if (15L != viewId) {
                    long l = row.getLong("org");
                    return l;
                }
                orgUnitLongnumber = row.getString(LONGNUMBER);
            }
        }
        return OrgServiceHelper.getSamePropertyParentIDByLongNumber(lOldParentID, lTreetype, orgUnitLongnumber);
    }

    public static long getSamePropertyParentIDByLongNumber(long lOldParentID, long lTreetype) {
        return OrgServiceHelper.getSamePropertyParentIDByLongNumber(lOldParentID, lTreetype, "");
    }

    public static long getSamePropertyParentIDByLongNumber(long lOldParentID, long lTreetype, String orgUnitLongnumber) {
        long lCurParentID = 0L;
        if (StringUtils.isEmpty((String)orgUnitLongnumber)) {
            QFilter filterUnit = new QFilter("org", "=", (Object)lOldParentID);
            QFilter filterView = new QFilter("view", "=", (Object)15L);
            QFilter[] filterUnits = new QFilter[]{filterUnit, filterView};
            DynamicObject dyUnit = QueryServiceHelper.queryOne(entityID_org_structure, "id,level,parent,parent.id,org,org.id,longnumber", filterUnits);
            if (dyUnit == null) {
                return OrgServiceHelper.getViewRootOrgId(lTreetype);
            }
            orgUnitLongnumber = dyUnit.getString(LONGNUMBER);
        }
        if (StringUtils.isNotEmpty((String)orgUnitLongnumber)) {
            String[] parentNumberArr = orgUnitLongnumber.split(OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep());
            QFilter numberFilter = new QFilter("org.number", "in", (Object)parentNumberArr);
            QFilter filterTreeType = new QFilter("view", "=", (Object)lTreetype);
            if (lTreetype == 16L) {
                filterTreeType = filterTreeType.and(new QFilter(IS_CTRLUNIT, "=", (Object)Boolean.TRUE));
            }
            QFilter[] filterOrgs = new QFilter[]{numberFilter, filterTreeType};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet("OrgServiceHelper.getSamePropertyParentIDByLongNumber", entityID_org_structure, "org", filterOrgs, LONGNUMBER_DESC, 1);){
                for (Row row : dataSet) {
                    lCurParentID = row.getLong("org");
                }
            }
        }
        if (lCurParentID == 0L) {
            return OrgServiceHelper.getViewRootOrgId(lTreetype);
        }
        return lCurParentID;
    }

    private static long getViewRootOrgId(long viewId) {
        long orgId = 0L;
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter parentFilter = new QFilter(PARENT, "=", (Object)0L);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.org.OrgServiceHelper.getViewRootOrgId", entityID_org_structure, "org", filters, LONGNUMBER, 1);){
            if (ds.hasNext()) {
                long l = ds.next().getLong("org");
                return l;
            }
        }
        return orgId;
    }

    @Deprecated
    public static boolean AddRoot(String lTreetype) {
        QFilter filter1 = QFilter.notExists((String)"id").or(PARENT, "=", (Object)0);
        QFilter filter2 = new QFilter(VIEW_TREETYPE, "=", (Object)lTreetype);
        QFilter filter3 = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        QFilter filterUnit1 = new QFilter(PARENT, "=", (Object)0);
        QFilter filterUnit2 = new QFilter(VIEW_TREETYPE, "=", (Object)"15");
        QFilter filterUnit3 = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter[] filterUnits = new QFilter[]{filterUnit1, filterUnit2, filterUnit3};
        if (QueryServiceHelper.exists(entityID_org_structure, filters)) {
            return false;
        }
        DynamicObject dyUnit = BusinessDataServiceHelper.loadSingle(entityID_org_structure, filterUnits);
        if (dyUnit == null) {
            return false;
        }
        boolean bUpdating = false;
        long vTypeId = OrgViewServiceHelper.getViewIDByNumber(lTreetype);
        DynamicObject doNew = BusinessDataServiceHelper.newDynamicObject(entityID_org_structure);
        doNew.set("org", dyUnit.getDynamicObject("org").getPkValue());
        doNew.set(YZJORGID, dyUnit.get(YZJORGID));
        doNew.set(PARENT, (Object)0);
        doNew.set(YZJPARENTORG_ID, dyUnit.get(YZJPARENTORG_ID));
        doNew.set(IS_LEAF, dyUnit.get(IS_LEAF));
        doNew.set(LONGNUMBER, dyUnit.get(LONGNUMBER));
        doNew.set(LEVEL, dyUnit.get(LEVEL));
        doNew.set("sortcode", dyUnit.get("sortcode"));
        doNew.set(FULL_NAME, dyUnit.get(FULL_NAME));
        doNew.set("view", (Object)vTypeId);
        try (TXHandle h = TX.beginRequired();){
            try {
                BusinessDataServiceHelper.save(doNew.getDataEntityType(), new Object[]{doNew});
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        bUpdating = true;
        return true;
    }

    @Deprecated
    public static void delOrgViewEntry(DynamicObject bizData, Object pkid) {
        boolean isSub;
        String bizName = bizData.getString(FFIELD_NAME);
        long bizID = bizData.getLong("id");
        QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(pkid.toString()));
        QFilter filter2 = null;
        filter2 = new QFilter("view", "=", (Object)bizID);
        QFilter filter3 = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter[] filters = null;
        long parentId = -1L;
        filters = new QFilter[]{filter, filter2, filter3};
        DynamicObject[] schemaObjs = BusinessDataServiceHelper.load(entityID_org_structure, "id,parent", filters);
        if (schemaObjs != null) {
            for (DynamicObject dy0 : schemaObjs) {
                DynamicObject[] dynamicObjectArray = null;
                try (TXHandle h = TX.beginRequired();){
                    try {
                        BusinessDataWriter.delete((IDataEntityType)dy0.getDataEntityType(), (Object[])new Object[]{dy0.get("id")});
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
                catch (Throwable object) {
                    dynamicObjectArray = object;
                    throw object;
                }
                parentId = dy0.getLong("parent.id");
            }
        }
        if (parentId != -1L && !(isSub = OrgViewServiceHelper.existsSubOrg(bizID, parentId))) {
            DynamicObject[] dyoOrgParents;
            QFilter filterOrgId = new QFilter("org", "=", (Object)parentId);
            QFilter filterView = new QFilter("view", "=", (Object)bizID);
            QFilter[] filterParents = new QFilter[]{filterOrgId, filterView};
            for (DynamicObject dyoOrgParent : dyoOrgParents = BusinessDataServiceHelper.load(entityID_org_structure, "id,isleaf", filterParents)) {
                dyoOrgParent.set(IS_LEAF, (Object)"1");
                try (TXHandle h = TX.beginRequired();){
                    try {
                        BusinessDataServiceHelper.save(dyoOrgParent.getDataEntityType(), new Object[]{dyoOrgParent});
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
        }
    }

    @Deprecated
    public static String getOrgFullName(String sTreeTypeNum, long orgId) {
        QFilter f1 = new QFilter(VIEW_NUMBER, "=", (Object)sTreeTypeNum);
        QFilter f2 = new QFilter("org", "=", (Object)orgId);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, FULL_NAME, new QFilter[]{f1, f2});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                String string = row.getString(FULL_NAME);
                return string;
            }
        }
        return null;
    }

    @Deprecated
    public static boolean verityByOrgFullName(String sTreeTypeNum, String sFullName, long pkid) {
        QFilter f1 = new QFilter(VIEW_NUMBER, "=", (Object)sTreeTypeNum);
        QFilter f2 = new QFilter(FULL_NAME, "=", (Object)sFullName);
        DynamicObject dyOrg = null;
        if (pkid > 0L) {
            QFilter f3 = new QFilter("org", "!=", (Object)pkid);
            dyOrg = QueryServiceHelper.queryOne(entityID_org_structure, "id", new QFilter[]{f1, f2, f3});
        } else {
            dyOrg = QueryServiceHelper.queryOne(entityID_org_structure, "id", new QFilter[]{f1, f2});
        }
        return dyOrg == null;
    }

    @Deprecated
    public static boolean updateParentId(String viewTypeNum, List<Long> lstOrgId, long lDirectParentId, long oldParentId, boolean IsAdd) {
        if (lstOrgId == null || lstOrgId.isEmpty()) {
            return true;
        }
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(lstOrgId.size());
        for (Long orgId : lstOrgId) {
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId.longValue());
            orgParam.setParentId(lDirectParentId);
            orgParam.setDuty(viewTypeNum);
            orgParamList.add(orgParam);
        }
        OrgUnitServiceHelper.update(orgParamList);
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static List<Map<String, Object>> getOrgChangeInfos(String timestamp) {
        return new ArrayList<Map<String, Object>>();
    }

    public boolean updateOrgChange(Map<String, Object> orgMap) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITYID_ORGTYPESTATUSREC);
            DynamicObject doOV = new DynamicObject((DynamicObjectType)dt);
            MainEntityType metOV = EntityMetadataCache.getDataEntityType((String)ENTITYID_ORGTYPESTATUSREC);
            doOV.set("org", orgMap.get("org"));
            doOV.set("name", orgMap.get("name"));
            doOV.set("operatime", orgMap.get("operatime"));
            doOV.set("viewschema", orgMap.get("treetype"));
            doOV.set("operatype", orgMap.get("operatype"));
            doOV.set("status", orgMap.get("C"));
            try (TXHandle h = TX.beginRequired();){
                try {
                    BusinessDataWriter.save((IDataEntityType)metOV, (Object[])new Object[]{doOV});
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
            return false;
        }
        return true;
    }

    public Map<String, String> getOrgParentInfo(long orgId, String treeType) {
        QFilter fOrg = new QFilter("org", "=", (Object)orgId);
        QFilter fTreetype = new QFilter(VIEW_NUMBER, "=", (Object)treeType);
        QFilter[] qFilters = new QFilter[]{fTreetype, fOrg};
        DynamicObject[] dosAlls = BusinessDataServiceHelper.load(entityID_org_structure, SELFIELD_SCHANGE, qFilters);
        HashMap<String, String> mParentInfo = new HashMap<String, String>();
        if (dosAlls != null && dosAlls.length > 0) {
            DynamicObject obj = dosAlls[0];
            DynamicObject parentObj = obj.getDynamicObject(PARENT);
            if (parentObj == null) {
                mParentInfo.put("id", "0");
                mParentInfo.put("name", "");
            } else {
                mParentInfo.put("id", parentObj.getString("id"));
                mParentInfo.put("name", parentObj.getString("name"));
            }
        }
        return mParentInfo;
    }

    public static List<Map<String, String>> getAllOrgRelationType() {
        Map<Object, DynamicObject> relationTypeList = BusinessDataServiceHelper.loadFromCache(entityID_bos_org_typerelation, null);
        if (relationTypeList == null || relationTypeList.isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> allOrgRelationType = new ArrayList<Map<String, String>>(relationTypeList.size());
        HashMap<String, String> relationTypeMap = null;
        String totypename = null;
        String fromtypename = null;
        for (DynamicObject relationType : relationTypeList.values()) {
            relationTypeMap = new HashMap<String, String>();
            relationTypeMap.put(NUMBER, relationType.getString(NUMBER));
            relationTypeMap.put("name", relationType.getString("name"));
            relationTypeMap.put(TOTYPE, relationType.getString(TOTYPE));
            totypename = OrgServiceHelper.getOrgBizTypeName(relationType.getString(TOTYPE));
            relationTypeMap.put("totypename", totypename);
            relationTypeMap.put(FROMTYPE, relationType.getString(FROMTYPE));
            fromtypename = OrgServiceHelper.getOrgBizTypeName(relationType.getString(FROMTYPE));
            relationTypeMap.put("fromtypename", fromtypename);
            allOrgRelationType.add(relationTypeMap);
        }
        return allOrgRelationType;
    }

    private static String getOrgBizTypeName(String orgBizTypeNumber) {
        Map<String, String> orgBizType;
        String orgBizTypeName = "";
        List<Map<String, String>> lstBizs = OrgServiceHelper.getAllOrgBiz();
        Iterator<Map<String, String>> iterator = lstBizs.iterator();
        while (iterator.hasNext() && StringUtils.isEmpty((String)(orgBizTypeName = (orgBizType = iterator.next()).get(orgBizTypeNumber)))) {
        }
        return orgBizTypeName;
    }

    @Deprecated
    public static List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, Long billTypeId) {
        return OrgUnitServiceHelper.getFromOrgs(toOrgType, toOrgId, fromOrgType);
    }

    @Deprecated
    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, Long billTypeId) {
        return OrgUnitServiceHelper.getToOrg(fromOrgType, toOrgType, fromOrgId);
    }

    @Deprecated
    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, Long billTypeId) {
        return OrgUnitServiceHelper.getAllToOrg(fromOrgType, toOrgType, fromOrgId);
    }

    public static boolean updateBizStatus(String viewType, List<Long> lstOrgId, String updateValue) {
        boolean updateState = false;
        String selField = "id,fisadministrative,fispurchase,fissale,fisproduce,fisinventory,fisqc,fissettlement,fisbankroll,fisasset,fisaccounting,fishr,fisscc,fisbudget,fiscontrolunit";
        QFilter filOrgId = new QFilter("id", "in", lstOrgId);
        QFilter[] filterOrgs = new QFilter[]{filOrgId};
        DynamicObject[] dovOs = BusinessDataServiceHelper.load(entityID_bos_org, selField, filterOrgs);
        if (dovOs != null) {
            for (DynamicObject dy0 : dovOs) {
                switch (viewType) {
                    case "02": {
                        dy0.set("fispurchase", (Object)updateValue);
                        break;
                    }
                    case "03": {
                        dy0.set("fissale", (Object)updateValue);
                        break;
                    }
                    case "04": {
                        dy0.set("fisproduce", (Object)updateValue);
                        break;
                    }
                    case "05": {
                        dy0.set("fisinventory", (Object)updateValue);
                        break;
                    }
                    case "06": {
                        dy0.set("fisqc", (Object)updateValue);
                        break;
                    }
                    case "07": {
                        dy0.set("fissettlement", (Object)updateValue);
                        break;
                    }
                    case "08": {
                        dy0.set("fisbankroll", (Object)updateValue);
                        break;
                    }
                    case "09": {
                        dy0.set("fisasset", (Object)updateValue);
                        break;
                    }
                    case "10": {
                        dy0.set("fisaccounting", (Object)updateValue);
                        break;
                    }
                    case "11": {
                        dy0.set("fishr", (Object)updateValue);
                        break;
                    }
                    case "12": {
                        dy0.set("fisscc", (Object)updateValue);
                        break;
                    }
                    case "13": {
                        dy0.set("fisbudget", (Object)updateValue);
                        break;
                    }
                    case "14": {
                        dy0.set(FISCONTROLUNIT, (Object)updateValue);
                        break;
                    }
                    case "16": {
                        dy0.set(FISCONTROLUNIT, (Object)updateValue);
                        break;
                    }
                }
                BusinessDataServiceHelper.save(dy0.getDataEntityType(), new Object[]{dy0});
            }
        }
        return updateState;
    }

    public static List<Long> getOrgAllSubIds(Long parentId, String viewType, boolean isIncludeItself) {
        ORM orm = ORM.create();
        String selFields = "id,longnumber";
        QFilter filterOrgId = new QFilter(ORG_ID, "=", (Object)parentId);
        QFilter filterTreeType = new QFilter(VIEW_TREETYPE, "=", (Object)viewType);
        QFilter filterDefault = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreeType, filterDefault};
        DynamicObject dyOrg = orm.queryOne(entityID_org_structure, selFields, filters);
        String longNumber = null;
        if (dyOrg != null) {
            longNumber = dyOrg.get("longNumber").toString();
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter filterSubTreeType = new QFilter(VIEW_TREETYPE, "=", (Object)viewType);
        QFilter filterSubDefault = new QFilter(VIEW_ISDEFAULT, "=", (Object)"1");
        QFilter filterLongNumber = new QFilter(LONGNUMBER, "like", (Object)(longNumber + "!%"));
        if (isIncludeItself) {
            filterLongNumber.or(ORG_ID, "=", (Object)parentId);
        }
        ArrayList<Long> Orgs = new ArrayList<Long>();
        try (DataSet ds = orm.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, ORG_ID, new QFilter[]{freezeFilter, filterSubTreeType, filterSubDefault, filterLongNumber});){
            for (Row row : ds) {
                if (row.getLong(ORG_ID) == null) continue;
                Orgs.add(row.getLong(ORG_ID));
            }
        }
        return Orgs;
    }

    public static Map<String, String> getViewSchemaInfoByBizId(long bizId) {
        ORM orm = ORM.create();
        String selFields = "id,fnumber";
        QFilter filterBizId = new QFilter("id", "=", (Object)bizId);
        QFilter[] filters = new QFilter[]{filterBizId};
        DynamicObject dyBiz = BusinessDataServiceHelper.loadSingleFromCache(entityID_bos_org_biz, selFields, filters);
        String number = null;
        HashMap<String, String> schemaInfo = null;
        if (dyBiz != null) {
            number = dyBiz.get(FNUMBER).toString();
            String sel = "id,number";
            QFilter filterNumber = new QFilter(NUMBER, "=", (Object)number);
            QFilter filterDefault = new QFilter("isdefault", "=", (Object)"1");
            QFilter[] filterSchemas = new QFilter[]{filterNumber, filterDefault};
            DynamicObject dySchema = orm.queryOne(entityID_org_viewschema, sel, filterSchemas);
            if (dySchema != null) {
                schemaInfo = new HashMap<String, String>();
                schemaInfo.put("id", dySchema.getString("id"));
                schemaInfo.put(NUMBER, dySchema.getString(NUMBER));
            }
        }
        return schemaInfo;
    }

    public static boolean isLeaf(long orgId, long viewId) {
        boolean isleaf = false;
        ORM orm = ORM.create();
        String sel = "id,isleaf";
        QFilter filterOrg = new QFilter("org", "=", (Object)orgId);
        QFilter filterView = new QFilter("view", "=", (Object)viewId);
        QFilter[] filterOrgs = new QFilter[]{filterOrg, filterView};
        DynamicObject dyOrg = orm.queryOne(entityID_org_structure, sel, filterOrgs);
        if (dyOrg != null) {
            isleaf = dyOrg.getBoolean(IS_LEAF);
        }
        return isleaf;
    }

    public static String getOrgFiDuty(long orgId) {
        String selectFields = "id,orgduty.number number";
        QFilter groupFilter = new QFilter("orgduty.group", "=", (Object)1);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{groupFilter, orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne(ENTITYID_BOS_ORG_DUTYRELATION, selectFields, filters);
        if (org == null) {
            return "0";
        }
        return org.getString(NUMBER);
    }

    public static String getOrgFiDuty(long orgId, String defaultDuty) {
        String orgDutyId = OrgServiceHelper.getOrgFiDuty(orgId);
        if ("0".equals(orgDutyId)) {
            return defaultDuty;
        }
        return orgDutyId;
    }
}

