/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.model.EntityExcelModel;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@SdkPublic
public class ExcelHelper {
    private static Log log = LogFactory.getLog(ExcelHelper.class);
    public static final String EXCEL_XLS = "xls";
    public static final String EXCEL_XLSX = "xlsx";
    public static final String EXCEL_XLSM = "xlsm";
    private static final String SPLIT_TITLE = "#";
    private static final String SPLIT_ENTRYENTITY = "\\.";
    public static final String KEY_ROW_INDEX = "_key_row_index_";
    public static final String KEY_ENTRYENTITY = "_key_entryentity_";

    public static Workbook getImportWorkbook(String fileUrl, String fileName) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileUrl) || StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(fileUrl);){
            Workbook workbook = ExcelHelper.getWorkbook(in, fileName);
            return workbook;
        }
    }

    public static Workbook getWorkbook(String filePath) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        File file = new File(filePath);
        return ExcelHelper.getWorkbook(file);
    }

    public static Workbook getWorkbook(File file) throws IOException {
        if (file == null) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(file);){
            Workbook workbook = ExcelHelper.getWorkbook(in, file.getName());
            return workbook;
        }
    }

    public static Workbook getWorkbook(InputStream in, String fileName) throws IOException {
        if (in == null || StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        HSSFWorkbook wb = null;
        if (fileName.endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(in);
        } else if (fileName.endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(in);
        }
        return wb;
    }

    public static Map<Integer, String> getTitle(Workbook workbook, int sheetIndex, int rowIndex) {
        if (workbook == null) {
            return Collections.EMPTY_MAP;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, rowIndex)) {
            return Collections.EMPTY_MAP;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int rowCount = sheet.getPhysicalNumberOfRows();
        if (rowCount <= rowIndex) {
            return Collections.EMPTY_MAP;
        }
        Row row = sheet.getRow(rowIndex);
        int end = row.getLastCellNum();
        HashMap<Integer, String> titleMap = new HashMap<Integer, String>(end);
        for (int i = 0; i < end; ++i) {
            Object obj;
            String cellValue = "";
            Cell cell = row.getCell(i);
            if (cell != null && (obj = ExcelHelper.getValue(cell)) != null) {
                cellValue = obj.toString();
            }
            titleMap.put(i, cellValue);
        }
        return titleMap;
    }

    public static Map<Integer, String> getTitlePropertyName(Workbook workbook, int sheetIndex, int rowIndex) {
        if (workbook == null) {
            return Collections.EMPTY_MAP;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, rowIndex)) {
            return Collections.EMPTY_MAP;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int rowCount = sheet.getPhysicalNumberOfRows();
        if (rowCount <= rowIndex) {
            return Collections.EMPTY_MAP;
        }
        Row row = sheet.getRow(rowIndex);
        return ExcelHelper.getTitlePropertyName(row);
    }

    private static Map<Integer, String> getTitlePropertyName(Row row) {
        int end = row.getLastCellNum();
        HashMap<Integer, String> titleMap = new HashMap<Integer, String>(end);
        for (int i = 0; i < end; ++i) {
            Object obj;
            String cellValue = "";
            Cell cell = row.getCell(i);
            if (cell != null && (obj = ExcelHelper.getValue(cell)) != null) {
                cellValue = obj.toString();
            }
            cellValue = StringUtils.substringAfterLast((String)cellValue, (String)SPLIT_TITLE).trim();
            titleMap.put(i, cellValue);
        }
        return titleMap;
    }

    private static Map<String, EntityExcelModel> getEntityIndex(Row row, int lastCellNum) {
        HashMap<String, EntityExcelModel> entityMap = new HashMap<String, EntityExcelModel>();
        String cellValue = "";
        for (int i = 0; i < lastCellNum; ++i) {
            Object obj;
            Cell cell = row.getCell(i);
            if (cell != null && (obj = ExcelHelper.getValue(cell)) != null && StringUtils.isNotBlank((Object)obj)) {
                cellValue = obj.toString();
                cellValue = StringUtils.substringAfterLast((String)cellValue, (String)SPLIT_TITLE).trim();
            }
            if (StringUtils.isBlank((CharSequence)cellValue)) continue;
            String[] entityArr = cellValue.split(SPLIT_ENTRYENTITY);
            String entityName = entityArr[0];
            EntityExcelModel entity = (EntityExcelModel)entityMap.get(entityName);
            if (entity == null) {
                entity = new EntityExcelModel();
                entityMap.put(entityName, entity);
            }
            if (entityArr.length == 1) {
                entity.getFieldIndexList().add(i);
                continue;
            }
            String entryEntityName = entityArr[1];
            List<EntityExcelModel> entryEntityList = entity.getEntryEntityList();
            EntityExcelModel entryEntityModel = null;
            if (entryEntityList.isEmpty()) {
                entryEntityModel = new EntityExcelModel();
                entryEntityModel.setEntityName(entryEntityName);
                entryEntityList.add(entryEntityModel);
            } else {
                for (EntityExcelModel eachEntity : entryEntityList) {
                    if (!entryEntityName.equals(eachEntity.getEntityName())) continue;
                    entryEntityModel = eachEntity;
                    break;
                }
            }
            if (null == entryEntityModel) continue;
            entryEntityModel.getFieldIndexList().add(i);
        }
        return entityMap;
    }

    public static List<Map<Integer, Object>> getCellValue(Workbook workbook, int sheetIndex, int startRowIndex) {
        if (workbook == null) {
            return Collections.EMPTY_LIST;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, startRowIndex)) {
            return Collections.EMPTY_LIST;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int rowCount = sheet.getPhysicalNumberOfRows();
        ArrayList<Map<Integer, Object>> dataList = new ArrayList<Map<Integer, Object>>(rowCount);
        for (int rowIndex = startRowIndex; rowIndex < rowCount; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            int end = row.getLastCellNum();
            HashMap<Integer, Object> cellMap = new HashMap<Integer, Object>(end);
            for (int i = 0; i < end; ++i) {
                Object cellValue = "";
                Cell cell = row.getCell(i);
                if (cell != null) {
                    cellValue = ExcelHelper.getValue(cell);
                }
                cellMap.put(i, cellValue);
            }
            dataList.add(cellMap);
        }
        return dataList;
    }

    public static List<Map<String, Object>> getCellValue(Workbook workbook, int sheetIndex, int startRowIndex, Map<Integer, String> propertyMap) {
        if (workbook == null || propertyMap == null || propertyMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, startRowIndex)) {
            return Collections.EMPTY_LIST;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        return ExcelHelper.getCellValue(sheet, startRowIndex, propertyMap);
    }

    private static List<Map<String, Object>> getCellValue(Sheet sheet, int startRowIndex, Map<Integer, String> propertyMap) {
        int rowCount = sheet.getPhysicalNumberOfRows();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(rowCount);
        for (int rowIndex = startRowIndex; rowIndex < rowCount; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            int end = row.getLastCellNum();
            HashMap<String, Object> cellMap = new HashMap<String, Object>(end);
            for (int i = 0; i < end; ++i) {
                Object cellValue = "";
                String propertyName = propertyMap.get(i);
                if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                Cell cell = row.getCell(i);
                if (cell != null) {
                    cellValue = ExcelHelper.getValue(cell);
                }
                cellMap.put(propertyName, cellValue);
            }
            dataList.add(cellMap);
        }
        return dataList;
    }

    private static boolean isGetCellValueAble(Workbook workbook, int sheetIndex, int startRowIndex) {
        int sheetCount = workbook.getNumberOfSheets();
        if (sheetCount <= sheetIndex) {
            return false;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int rowCount = sheet.getPhysicalNumberOfRows();
        return rowCount > startRowIndex;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellType()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static List<Map<String, Object>> getImportData(String fileUrl, String fileName, int sheetIndex, int titleRowIndex) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileUrl) || StringUtils.isBlank((CharSequence)fileName)) {
            return Collections.EMPTY_LIST;
        }
        Workbook workbook = ExcelHelper.getImportWorkbook(fileUrl, fileName);
        if (workbook == null) {
            return Collections.EMPTY_LIST;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, titleRowIndex)) {
            return Collections.EMPTY_LIST;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        Row titleRow = sheet.getRow(titleRowIndex);
        Map<Integer, String> propertyMap = ExcelHelper.getTitlePropertyName(titleRow);
        int valueIndex = titleRowIndex + 1;
        return ExcelHelper.getCellValue(sheet, valueIndex, propertyMap);
    }

    public static Map<String, List<Map<String, Object>>> getImportDataMultiEntity(String fileUrl, String fileName, int sheetIndex, int titleRowIndex) throws IOException {
        if (titleRowIndex == 0) {
            return Collections.EMPTY_MAP;
        }
        if (StringUtils.isBlank((CharSequence)fileUrl) || StringUtils.isBlank((CharSequence)fileName)) {
            return Collections.EMPTY_MAP;
        }
        Workbook workbook = ExcelHelper.getImportWorkbook(fileUrl, fileName);
        if (workbook == null) {
            return Collections.EMPTY_MAP;
        }
        if (!ExcelHelper.isGetCellValueAble(workbook, sheetIndex, titleRowIndex)) {
            return Collections.EMPTY_MAP;
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        Row titleRow = sheet.getRow(titleRowIndex);
        Map<Integer, String> titleMap = ExcelHelper.getTitlePropertyName(titleRow);
        Row entityRow = sheet.getRow(titleRowIndex - 1);
        Map<String, EntityExcelModel> entityMap = ExcelHelper.getEntityIndex(entityRow, titleRow.getLastCellNum());
        return ExcelHelper.getCellValue(sheet, titleRowIndex, entityMap, titleMap);
    }

    private static Map<String, List<Map<String, Object>>> getCellValue(Sheet sheet, int titleRowIndex, Map<String, EntityExcelModel> entityMap, Map<Integer, String> propertyMap) {
        int valueRowIndex = titleRowIndex + 1;
        int rowCount = sheet.getPhysicalNumberOfRows();
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>();
        for (int rowIndex = valueRowIndex; rowIndex < rowCount; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            for (Map.Entry<String, EntityExcelModel> entity : entityMap.entrySet()) {
                boolean isNotAllCellBlank = false;
                String entityName = entity.getKey();
                EntityExcelModel entityModel = entity.getValue();
                List<Integer> dataIndexList = entityModel.getFieldIndexList();
                ArrayList dataList = (ArrayList)dataMap.get(entityName);
                if (dataList == null) {
                    dataList = new ArrayList();
                    dataMap.put(entityName, dataList);
                }
                HashMap<String, Object> cellMap = new HashMap<String, Object>(dataIndexList.size());
                cellMap.put(KEY_ROW_INDEX, rowIndex);
                for (int index : dataIndexList) {
                    Object cellValue = "";
                    String propertyName = propertyMap.get(index);
                    if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                    Cell cell = row.getCell(index);
                    if (cell != null) {
                        cellValue = ExcelHelper.getValue(cell);
                    }
                    if (isNotAllCellBlank || StringUtils.isNotBlank((Object)cellValue)) {
                        isNotAllCellBlank = true;
                    }
                    cellMap.put(propertyName, cellValue);
                }
                List<EntityExcelModel> entityList = entityModel.getEntryEntityList();
                for (EntityExcelModel eachEntity : entityList) {
                    String entryentityName = eachEntity.getEntityName();
                    ArrayList entityValueList = (ArrayList)cellMap.get(entryentityName);
                    if (entityValueList == null) {
                        entityValueList = new ArrayList();
                        cellMap.put(entryentityName, entityValueList);
                    }
                    List<Integer> entityIndexList = eachEntity.getFieldIndexList();
                    HashMap<String, Object> entityCellMap = new HashMap<String, Object>(entityIndexList.size());
                    for (int index : entityIndexList) {
                        Object cellValue = "";
                        String propertyName = propertyMap.get(index);
                        if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                        Cell cell = row.getCell(index);
                        if (cell != null) {
                            cellValue = ExcelHelper.getValue(cell);
                        }
                        if (isNotAllCellBlank || StringUtils.isNotBlank((Object)cellValue)) {
                            isNotAllCellBlank = true;
                        }
                        entityCellMap.put(propertyName, cellValue);
                    }
                    entityValueList.add(entityCellMap);
                }
                if (!isNotAllCellBlank) continue;
                dataList.add(cellMap);
            }
        }
        return dataMap;
    }

    public static Row addCellAtStart(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        block6: for (int col = row.getLastCellNum() - 1; col >= 0; --col) {
            Cell oldCell = row.getCell(col);
            Cell newCell = row.createCell(col + 1);
            if (oldCell == null) continue;
            newCell.setCellStyle(oldCell.getCellStyle());
            newCell.setCellComment(oldCell.getCellComment());
            switch (oldCell.getCellType()) {
                case BOOLEAN: {
                    newCell.setCellValue(oldCell.getBooleanCellValue());
                    continue block6;
                }
                case ERROR: {
                    newCell.setCellValue((double)oldCell.getErrorCellValue());
                    continue block6;
                }
                case NUMERIC: {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                    continue block6;
                }
                case STRING: {
                    newCell.setCellValue(oldCell.getStringCellValue());
                    continue block6;
                }
            }
        }
        return row;
    }

    public static boolean cellEqual(CellType cellType1, CellType cellType2) {
        return cellType1 == cellType2;
    }

    public static boolean cellEqual(int typeCode, CellType cellType2) {
        return typeCode == cellType2.getCode();
    }

    public static CellType getCellType(CellType cellType) {
        return cellType;
    }

    public static CellType getCellType(int cellType) {
        return CellType.forInt((int)cellType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream excelSecurityVerification(InputStream in, String fileName) {
        String ext = "";
        if (fileName != null && fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (!(ext.equalsIgnoreCase(EXCEL_XLS) || ext.equalsIgnoreCase(EXCEL_XLSX) || ext.equalsIgnoreCase(EXCEL_XLSM))) {
                return in;
            }
        } else {
            return in;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream newInputStream = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            HSSFWorkbook workbook = null;
            if (ext.equalsIgnoreCase(EXCEL_XLS)) {
                workbook = new HSSFWorkbook(in);
            } else if (ext.equalsIgnoreCase(EXCEL_XLSX) || ext.equalsIgnoreCase(EXCEL_XLSM)) {
                workbook = new XSSFWorkbook(in);
            }
            if (workbook != null) {
                for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                    Sheet sheetAt = workbook.getSheetAt(i);
                    ExcelHelper.securityVerification((Workbook)workbook, sheetAt);
                }
                workbook.write((OutputStream)outputStream);
                newInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            InputStream inputStream = in;
            return inputStream;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return newInputStream;
    }

    public static boolean securityVerification(Workbook workbook, Sheet sheet) {
        if (sheet.getPhysicalNumberOfRows() == 0) {
            return true;
        }
        boolean verification = true;
        int firstRow = sheet.getFirstRowNum();
        int lastRow = sheet.getLastRowNum();
        for (int i = firstRow; i <= lastRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int firstColumn = row.getFirstCellNum();
            short lastColumn = row.getLastCellNum();
            for (int j = firstColumn; j < lastColumn; ++j) {
                Cell cell = sheet.getRow(i).getCell(j);
                if (cell == null || !Pattern.compile("^[=@]").matcher(cell.toString()).find() && CellType.FORMULA != cell.getCellType()) continue;
                String actualValue = cell.toString();
                if (CellType.FORMULA == cell.getCellType() && cell instanceof XSSFCell) {
                    actualValue = ((XSSFCell)cell).getRawValue();
                }
                CellStyle cellStyle2 = workbook.createCellStyle();
                DataFormat format = workbook.createDataFormat();
                cellStyle2.setDataFormat(format.getFormat("@"));
                cell.setCellStyle(cellStyle2);
                cell.setCellValue(actualValue);
                cell.setCellType(CellType.STRING);
                if (!verification) continue;
                verification = false;
            }
        }
        return verification;
    }
}

