/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.workflow;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.INoCodeWorkflowService;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.model.NodeMacro;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessInitiator;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.api.model.ProcessNode;
import kd.bos.workflow.api.model.ProcessTemplate;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u65e0\u4ee3\u7801\u6d41\u7a0b\u670d\u52a1")
public class NoCodeWorkflowServiceHelper {
    private static final Log logger = LogFactory.getLog(NoCodeWorkflowServiceHelper.class);
    public static final String SEPARATESTORAGEKEY = "separateStorageKey";
    public static final String SEPARATESTORAGEKEY_NOCODE = "nocode";

    @KSMethod
    private static IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }

    @KSMethod
    private static INoCodeWorkflowService getNoCodeWFService() {
        return (INoCodeWorkflowService)ServiceFactory.getService(INoCodeWorkflowService.class);
    }

    private static void setThreadLocalVariables() {
        ThreadTruck.put((Object)SEPARATESTORAGEKEY, (Object)SEPARATESTORAGEKEY_NOCODE);
    }

    private static void removeThreadLocalVariables() {
        ThreadTruck.remove((Object)SEPARATESTORAGEKEY);
    }

    @KSMethod
    public static List<ProcessModel> getProcessesByEntityNumber(String entityNumber) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            List list = workflowService.getProcessesByEntityNumber(entityNumber);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static ProcessDefinitionInfo getProcessDefinitionInfoByProcInstId(Long procInstId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            ProcessDefinitionInfo processDefinitionInfo = workflowService.getProcessDefinitionInfoByProcInstId(procInstId);
            return processDefinitionInfo;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static Long getTaskIdByProcessInstanceIdAndActivityIdAndUserId(Long processInstanceId, String activityId, Long userId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            Long l = workflowService.getTaskIdByProcessInstanceIdAndActivityIdAndUserId(processInstanceId, activityId, userId);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static TaskInfo findTaskById(Long taskId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            TaskInfo taskInfo = workflowService.findTaskById(taskId);
            return taskInfo;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static ProcessDefinitionInfo getProcessDefinitionInfoById(Long procDefId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            ProcessDefinitionInfo processDefinitionInfo = workflowService.getProcessDefinitionInfoById(procDefId);
            return processDefinitionInfo;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static ProcessModel getProcess(Long modelId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            ProcessModel processModel = workflowService.getProcess(modelId);
            return processModel;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Long saveProcess(ProcessModel model) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            Long l = workflowService.saveProcess(model);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static ProcPublishResult publishProcess(Long modelId, Map<String, Object> deploymentProperty) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            ProcPublishResult procPublishResult = workflowService.publishProcess(modelId, deploymentProperty);
            return procPublishResult;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static void discardProcesses(List<Long> modelIds, boolean disableProcDefinition, boolean terminalProcInst) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            workflowService.discardProcesses(modelIds, disableProcDefinition, terminalProcInst);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void updateLatestProcessDefaultScheme(Long modelId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            workflowService.updateLatestProcessDefaultScheme(modelId);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<String, List<String>> canWithdrawByProcessInstanceId(Long processInstanceId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            Map map = workflowService.canWithdrawByProcessInstanceId(processInstanceId);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void withdrawByProcessInstanceId(Long processInstanceId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            workflowService.withdrawByProcessInstanceId(processInstanceId);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static void completeTask(Long taskId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            workflowService.completeTask(taskId, userId, decOptionNumber, auditMessage, variables);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<ProcessNode> getProcessNodes(String procType) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            IWorkflowService workflowService = NoCodeWorkflowServiceHelper.getWFService();
            List list = workflowService.getProcessNodes(procType);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<ProcessModel> getAllProcesses(String procType, String appOrCloudId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getAllProcesses(procType, appOrCloudId);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void tryTriggerProcessByTriggerMode(String entityNumber, String billId, String triggerMode) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            NoCodeWorkflowServiceHelper.getNoCodeWFService().tryTriggerProcessByTriggerMode(entityNumber, billId, triggerMode);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void tryTriggerProcess(Long modelId, String businessKey, String operation) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            NoCodeWorkflowServiceHelper.getNoCodeWFService().tryTriggerProcess(modelId, businessKey, operation);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<NodeMacro> getNodeMacros(Long modelId, String macroType) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNodeMacros(modelId, macroType);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<ProcessDefinitionInfo> getProcessDefinitionsByTriggerMode(String entityNumber, String triggerMode) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcessDefinitionsByTriggerMode(entityNumber, triggerMode);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<NodeMacro> getNodeMacros(String modelJson, String macroType) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNodeMacros(modelJson, macroType);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static List<NodeMacro> getNodeMacros(String procType, String nodeJson, String macroType) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNodeMacros(procType, nodeJson, macroType);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<String, Integer> getNoCodeFlowTaskCounts(String userId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowTaskCounts(userId);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<ProcessTemplate> getProcessTemplatesByAppId(String appId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcessTemplatesByAppId(appId);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static Map<Long, Long> createProcessesByTemplates(String appId, List<Long> templateIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().createProcessesByTemplates(appId, templateIds, entityMap, roleMap);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static Map<Long, Long> saveProcessesAsTemplates(String appId, List<Long> modelIds, Map<String, String> entityMap, Map<String, String> roleMap) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().saveProcessesAsTemplates(appId, modelIds, entityMap, roleMap);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void deleteProcessTemplates(List<Long> templateIds) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            NoCodeWorkflowServiceHelper.getNoCodeWFService().deleteProcessTemplates(templateIds);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    public static String createBlankProcessResource(String procType, Map<String, Object> config) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            String string = NoCodeWorkflowServiceHelper.getNoCodeWFService().createBlankProcessResource(procType, config);
            return string;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static boolean inProcessByProcessInstanceId(Long processInstanceId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            boolean bl = NoCodeWorkflowServiceHelper.getNoCodeWFService().inProcessByProcessInstanceId(processInstanceId);
            return bl;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowProcessInstanceInfoByProcessCode(int start, int limit, String processCode) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowProcessInstanceInfoByProcessCode(start, limit, processCode);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static long getNoCodeFlowProcessInstanceCountByProcessCode(String processCode) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            long l = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowProcessInstanceCountByProcessCode(processCode);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<Long, ProcessInitiator> getProcessesInitiator(List<Long> procInstIds) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcessesInitiator(procInstIds);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<String, List<BizProcessStatus>> getNoCodeFlowBizProcessStatus(String[] businessKeys) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowBizProcessStatus(businessKeys);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowApprovalRecordsFromDetailLog(String businessKey, String entityNumber) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowApprovalRecordsFromDetailLog(businessKey, entityNumber);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowToHandleTasksByUserId(int start, int limit, String uid) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowToHandleTasksByUserId(start, limit, uid);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Long getNoCodeFlowTaskCountByType(String uid, String type) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Long l = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowTaskCountByType(uid, type);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowInProcessApply(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowApplyTasksByStartId(start, limit, uid, sqlFilterMap);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowApplyedProcess(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, Map<String, Object> paramFilter) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowApplyedProcessAssistantCollection(userId, start, limit, starterOrSubjectFilter, timeFilter, paramFilter);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getNoCodeFlowHandledTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            DynamicObjectCollection dynamicObjectCollection = NoCodeWorkflowServiceHelper.getNoCodeWFService().getNoCodeFlowHandledTasksByUserId(start, limit, uid, sqlFilterMap);
            return dynamicObjectCollection;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static String getBusinessKeyByProcessInstanceId(Long processInstanceId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            String string = NoCodeWorkflowServiceHelper.getNoCodeWFService().getBusinessKeyByProcessInstanceId(processInstanceId);
            return string;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<Long> getProcDefIdsByEntityNumber(String entityNumber) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcDefIdsByEntityNumber(entityNumber);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static List<Long> getProcInstIdsByProcDefId(int start, int limit, Long procDefId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcInstIdsByProcDefId(start, limit, procDefId);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Long getProcessInstanceCountByProcDefId(Long procDefId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Long l = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcessInstanceCountByProcDefId(procDefId);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static List<Long> getProcInstIdsByEntityNumberOrBusinessKey(int start, int limit, String entityNumber, String businessKey) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcInstIdsByEntityNumberOrBusinessKey(start, limit, entityNumber, businessKey);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Long getProcessInstanceCountByEntityNumberOrBusinessKey(String entityNumber, String businessKey) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Long l = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcessInstanceCountByEntityNumberOrBusinessKey(entityNumber, businessKey);
            return l;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static List<Long> getProcDefIdsByModelId(Long modelId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            List list = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcDefIdsByModelId(modelId);
            return list;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void deleteProcessInstanceInfoByProcInstId(Long procInstId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            NoCodeWorkflowServiceHelper.getNoCodeWFService().deleteProcessInstanceInfoByProcInstId(procInstId);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static void deleteProcessByProcDefId(Long procDefId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            NoCodeWorkflowServiceHelper.getNoCodeWFService().deleteProcessByProcDefId(procDefId);
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static boolean deleteProcessByModelId(Long modelId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            boolean bl = NoCodeWorkflowServiceHelper.getNoCodeWFService().deleteProcessByModelId(modelId);
            return bl;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static String getProcTemplatePresetSQL(Long templateId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            String string = NoCodeWorkflowServiceHelper.getNoCodeWFService().getProcTemplatePresetSQL(templateId);
            return string;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static String getExportedProcessFileContent(Long modelId) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            String string = NoCodeWorkflowServiceHelper.getNoCodeWFService().getExportedProcessFileContent(modelId);
            return string;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<String, Object> importProcessFileContent(String content) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().importProcessFileContent(content);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }

    @KSMethod
    public static Map<String, Object> importProcessFileContent(String content, boolean forceNew) {
        try {
            NoCodeWorkflowServiceHelper.setThreadLocalVariables();
            Map map = NoCodeWorkflowServiceHelper.getNoCodeWFService().importProcessFileContent(content, forceNew);
            return map;
        }
        finally {
            NoCodeWorkflowServiceHelper.removeThreadLocalVariables();
        }
    }
}

