/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.workflow;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.OpenStyle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.api.EnabledProcessInfo;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.api.model.BillCard;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.api.model.ProcessNode;
import kd.bos.workflow.basedata.role.WorkflowRole;
import kd.bos.workflow.basedata.role.WorkflowRoleResult;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.dynprocess.billpage.BillPageAttributeConfig;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.process.ProcessInstData;
import kd.bos.workflow.engine.task.AddYunzhijiaTaskParam;
import kd.bos.workflow.engine.task.AuditPointResult;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.BusinessKeyQueryParams;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.ThirdCommentInfo;
import kd.sdk.annotation.SdkService;
import org.apache.commons.collections.CollectionUtils;

@KSObject
@SdkService(name="\u5de5\u4f5c\u6d41\u670d\u52a1")
public class WorkflowServiceHelper {
    private static final Log logger = LogFactory.getLog(WorkflowServiceHelper.class);
    public static final String TOHANDLE = "toHandle";
    public static final String HANDLED = "handled";
    public static final String APPLYED = "applyed";
    public static final String TOAPPLY = "toApply";
    public static final String NOT_IN_PROCESS = "notInProcess";
    public static final String WF_CAN_WITHDRAW = "wfCanWithdraw";
    public static final String WF_CAN_WITHDRAW_BYABANDONPROC = "wfCanWithdrawByAbandonProc";
    public static final String CACHEKEY_WITHDRAWDELETEBIZJOBIDS = "withdrawDeleteBizJobIds";
    public static final String PRINT_BIZIDENTIFYKEY = "bizIdentifyKey";
    public static final String PRINT_ACTIVITYNAME = "activityName";
    public static final String PRINT_META = "printMeta";
    public static final String PRINT_TYPE_ALL = "all";
    public static final String PRINT_TYPE_ALLCONSENT = "allConsent";
    public static final String PRINT_TYPE_LASTEDCONSENT = "lastedConsent";
    public static final String PROCESS_INITIATOR = "_initiator_";

    @KSMethod
    public static void tryTriggerProcess(String businessKey, String operation, String entityNumber, Map<String, Object> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        try (TXHandle tx = TX.requiresNew();){
            workflowService.tryTriggerProcess(businessKey, operation, entityNumber, variables);
        }
    }

    @KSMethod
    public static void tryTriggerProcessByProcNumber(String businessKey, String processNumber, String entityNumber, Map<String, Object> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        try (TXHandle tx = TX.requiresNew();){
            workflowService.tryTriggerProcessByProcNumber(businessKey, processNumber, entityNumber, variables);
        }
    }

    @KSMethod
    private static IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }

    @KSMethod
    public static void updateParticipant(Long taskId, List<Long> userIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateParticipant(taskId, userIds);
    }

    @KSMethod
    public static void discardProcesses(List<Long> modelIds, boolean disableProcDefinition, boolean terminalProcInst) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.discardProcesses(modelIds, disableProcDefinition, terminalProcInst);
    }

    @KSMethod
    public static Long saveProcess(ProcessModel model) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.saveProcess(model);
    }

    @KSMethod
    public static ProcPublishResult publishProcess(Long modelId, Map<String, Object> deploymentProperty) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.publishProcess(modelId, deploymentProperty);
    }

    @KSMethod
    public static void updateLatestProcessDefaultScheme(Long modelId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateLatestProcessDefaultScheme(modelId);
    }

    @KSMethod
    public static ProcessModel getProcess(Long modelId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcess(modelId);
    }

    @KSMethod
    public static List<ProcessModel> getProcessesByEntityNumber(String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessesByEntityNumber(entityNumber);
    }

    @KSMethod
    public static ProcessDefinitionInfo getProcessDefinitionInfoById(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessDefinitionInfoById(procDefId);
    }

    @KSMethod
    public static void abandonRootProcessInstance(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.abandonRootProcessInstance(businessKey);
    }

    @KSMethod
    public static ProcessDefinitionInfo getProcessDefinitionInfoByProcInstId(Long procInstId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessDefinitionInfoByProcInstId(procInstId);
    }

    @KSMethod
    public static List<ProcessNode> getProcessNodes(String procType) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessNodes(procType);
    }

    @KSMethod
    public static WFProcess getProcessInfo(DynamicObject bill, String operation) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessInfo(bill, operation);
    }

    @KSMethod
    public static List<WFFlowElement> getProcessElements(DynamicObject bill, String operation) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessElements(bill, operation);
    }

    @KSMethod
    public static WFProcess getProcessInfo(String number, String version) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessInfo(number, version);
    }

    @KSMethod
    public static List<WFFlowElement> getProcessElements(String number, String version) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessElements(number, version);
    }

    @KSMethod
    public static void addNodeTemplate(NodeTemplate template) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addNodeTemplate(template);
    }

    @KSMethod
    public static void updateNodeTemplateInfo(String nodeTemplateNumber, Map<String, Object> nodeTemplateInfo) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateNodeTemplateInfo(nodeTemplateNumber, nodeTemplateInfo);
    }

    @KSMethod
    public static void completeTask(Long taskId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.completeTask(taskId, userId, decOptionNumber, auditMessage, variables);
    }

    @KSMethod
    public static void completeTask(Long taskId, Long userId, String decOptionNumber, String auditMessage) {
        WorkflowServiceHelper.completeTask(taskId, userId, decOptionNumber, auditMessage, new HashMap<String, Object>());
    }

    @KSMethod
    public static void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser, Map<String, Object> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.completeTask(businessKey, nodeId, userId, decOptionNumber, auditMessage, checkUser, variables);
    }

    @KSMethod
    public static void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser) {
        WorkflowServiceHelper.completeTask(businessKey, nodeId, userId, decOptionNumber, auditMessage, checkUser, new HashMap<String, Object>());
    }

    @KSMethod
    public static Map<String, List<String>> canWithdraw(DynamicObject[] objs) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.canWithdraw(objs);
    }

    @KSMethod
    public static void withdraw(DynamicObject obj) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdraw(obj, "");
    }

    @KSMethod
    public static void withdraw(DynamicObject obj, String operationName) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdraw(obj, operationName);
    }

    @KSMethod
    public static String batchWithdraw(DynamicObject[] objs, String operationName) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.batchWithdraw(objs, operationName);
    }

    @KSMethod
    public static void billUnsubmit(DynamicObject[] objs, String operationName, Map<String, Object> param) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.billUnsubmit(objs, operationName, param);
    }

    @KSMethod
    public static boolean inProcess(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.inProcess(businessKey);
    }

    public static ExtendedDataEntity[] getInProcessDataEntity(ExtendedDataEntity[] dataEntities) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getInProcessDataEntity(dataEntities);
    }

    @KSMethod
    public static List<Long> getApproverByBusinessKey(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApproverByBusinessKey(businessKey);
    }

    @KSMethod
    public static List<Comment> getLastNodesComment(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getLastNodesComment(businessKey);
    }

    @KSMethod
    public static DynamicObjectCollection getCommentsByTaskId(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getCommentsByTaskId(taskId);
    }

    @KSMethod
    public static void updateTaskInfoAndParticipant(TaskInfo task, List<Long> userIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateTaskInfoAndParticipant(task, userIds);
    }

    @KSMethod
    public static IApprovalRecordItem createApprovalRecordItem() {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.createApprovalRecordItem();
    }

    @KSMethod
    public static void addComment(Comment comment) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addComment(comment);
    }

    @KSMethod
    public static void updateTrdRelatedProcComment(String relationValue, Comment comment) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateTrdRelatedProcComment(relationValue, comment);
    }

    @KSMethod
    public static Comment createNewComment() {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.createNewComment();
    }

    @KSMethod
    public static ThirdCommentInfo createNewTrdComment() {
        try {
            Class<?> clazz = Class.forName("kd.bos.workflow.engine.task.ThirdCommentInfo");
            return (ThirdCommentInfo)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @KSMethod
    public static void addTrdComment(ThirdCommentInfo thirdCommentInfo) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addTrdComment(thirdCommentInfo);
    }

    @KSMethod
    public static void updateTrdComment(ThirdCommentInfo thirdCommentInfo) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateTrdComment(thirdCommentInfo);
    }

    @KSMethod
    public static TaskInfo findTaskById(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.findTaskById(taskId);
    }

    @KSMethod
    public static DynamicObjectCollection getToHandleTasksByUserId(int start, int limit, String uid) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getToHandleTasksByUserId(start, limit, uid);
    }

    @KSMethod
    public static Map<String, List<Long>> getApproversMapByBusinessKeys(String[] businessKeyArr) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApproversMapByBusinessKeys(businessKeyArr);
    }

    @KSMethod
    public static List<Object> getBusinessKeyByEntityNumberUIds(BusinessKeyQueryParams businessKeyQueryParams) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getBusinessKeyByEntityNumberUIds(businessKeyQueryParams);
    }

    @KSMethod
    public static void viewFlowchart(String pageId, Object billId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchart(pageId, billId);
    }

    @KSMethod
    public static void viewFlowchart(String pageId, Object billId, OpenStyle style) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchart(pageId, billId, style);
    }

    @KSMethod
    public static void viewFlowchart(String pageId, OpenStyle style, Object billId, Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchart(pageId, style, billId, procDefId);
    }

    @KSMethod
    public static void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchartWithEntityNumber(pageId, entityNumber, billId);
    }

    @KSMethod
    public static void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId, OpenStyle style) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchartWithEntityNumber(pageId, entityNumber, billId, style);
    }

    @KSMethod
    public static void viewFlowchartWithEntityNumber(String pageId, String entityNumber, Object billId, OpenStyle style, Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.viewFlowchartWithEntityNumber(pageId, entityNumber, billId, style, procDefId);
    }

    @KSMethod
    public static void showBillRelationGraph(String pageId, List<BillCard> billCards, String currentEntityNumber, String currentBusinessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.showBillRelationGraph(pageId, billCards, currentEntityNumber, currentBusinessKey);
    }

    @KSMethod
    public static boolean isUserBelongToRole(Long userId, String roleNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.isUserBelongToRole(userId, roleNumber);
    }

    public static DynamicObject[] getModelByAppId(String appId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getModelByAppId(appId);
    }

    public static String getDeployModel(long modelId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getDeployModel(modelId);
    }

    public static void deployModel(String deployModelString) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.deployModel(deployModelString);
    }

    public static DynamicObject[] getAllProcessCategory() {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAllProcessCategory();
    }

    public static DynamicObject[] getModelByProcessCategoryId(Long processCategoryId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getModelByProcessCategoryId(processCategoryId);
    }

    @KSMethod
    public static List<IApprovalRecordGroup> getAllApprovalRecord(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAllApprovalRecord(businessKey);
    }

    @KSMethod
    public static Long getTaskCountByType(String uid, String type) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getTaskCountByType(uid, type);
    }

    @KSMethod
    public static List<Map<String, Object>> getToHandleTasksMessage(Long userId, Integer topCount) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getToHandleTasksMessage(userId, topCount);
    }

    @KSMethod
    public static Long getTaskIdByBusinessKeyAndUserId(String businessKey, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getTaskIdByBusinessKeyAndUserId(businessKey, userId);
    }

    @Deprecated
    @KSMethod
    public static void taskTransfer(Long taskId, Long transfererId, String transferOpinion, Boolean transferSubscribe) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.taskTransfer(taskId, transfererId, transferOpinion, transferSubscribe);
    }

    @KSMethod
    public static void taskTransfer(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.taskTransfer(taskId, transfererId, transferOpinion, transferSubscribe);
    }

    @KSMethod
    public static Map<String, Object> taskCirculate(Long taskId, List<Long> userIds, ILocaleString circulationMsg) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskCirculate(taskId, userIds, circulationMsg);
    }

    @KSMethod
    public static BatchOperateResult taskCirculateForBatch(List<Long> taskIds, List<Long> circulationUserIds, Long senderUserId, ILocaleString circulationMsg) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskCirculateForBatch(taskIds, circulationUserIds, senderUserId, circulationMsg);
    }

    @KSMethod
    public static String taskCoordinate(Long taskId, List<Long> userIds, ILocaleString coordinateMsg, Boolean isPublic) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskCoordinate(taskId, userIds, coordinateMsg, isPublic);
    }

    @KSMethod
    public static String taskCoordinateRequestWithdraw(Long taskId, List<Long> coordinaterIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskCoordinateRequestWithdraw(taskId, coordinaterIds);
    }

    @KSMethod
    public static Map<String, String> getApprovalRecordMeta() {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApprovalRecordMeta();
    }

    @KSMethod
    public static List<Map<String, String>> getCommentForPrint(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getCommentForPrint(businessKey);
    }

    public Object getNodeProp(Long processInstanceId, String nodeId, String propName) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getNodeProp(processInstanceId, nodeId, propName);
    }

    public static List<Long> getWorkflowMultiLanguageIdsByAppId(String applicationId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getWorkflowMultiLanguageIdsByAppId(applicationId);
    }

    public static List<Long> getWorkflowModelMultiLanguageIdsByAppId(String applicationId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getWorkflowModelMultiLanguageIdsByAppId(applicationId);
    }

    public static List<Map<String, Object>> getWorkflowTemplateMultiLanguageIdsByCategoryId(Long categoryId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getWorkflowTemplateMultiLanguageIdsByCategoryId(categoryId);
    }

    public static Map<String, Object> getWorkflowMultiLanguageWords(Long resourceId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getWorkflowMultiLanguageWords(resourceId);
    }

    public static void applyWorkflowMultiLanguageWords(Map<String, Object> mutiLangDatas) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.applyWorkflowMultiLanguageWords(mutiLangDatas);
    }

    public static void applyWorkflowMultiLanguageWords4ModelAndTpl(Map<String, Object> mutiLangDatas) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.applyWorkflowMultiLanguageWords4ModelAndTpl(mutiLangDatas);
    }

    public static Map<String, Object> makeWorkflowMultiLanguagePackage(Map<String, Object> mutiLangDatas) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.makeWorkflowMultiLanguagePackage(mutiLangDatas);
    }

    public static Long getProcessInstanceIdByBusinessKey(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessInstanceIdByBusinessKey(businessKey);
    }

    @KSMethod
    public static Map<String, List<BizProcessStatus>> getBizProcessStatus(String[] businessKeys) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getBizProcessStatus(businessKeys);
    }

    @KSMethod
    public static Map<String, List<BizProcessStatus>> getBizProcessStatus(String[] businessKeys, String name) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getBizProcessStatus(businessKeys, name);
    }

    @KSMethod
    public static Collection<Map<String, Object>> getPrintMetaEntityNumber(String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getPrintMetaEntityNumber(entityNumber);
    }

    @KSMethod
    public static List<Map<String, Object>> getNextUserTaskNodeByBusinessKey(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getNextUserTaskNodeByBusinessKey(businessKey);
    }

    @KSMethod
    public static Collection<Map<String, String>> getCommentForPrintByType(String businessKey, String type) {
        return WorkflowServiceHelper.getPrintCommentWithParam(businessKey, type, new HashMap<String, Object>());
    }

    @KSMethod
    public static Collection<Map<String, String>> getPrintCommentWithParam(String businessKey, String type, Map<String, Object> printParam) {
        logger.info("businessKey=" + businessKey);
        logger.info("type=" + type);
        if (printParam != null && printParam.size() > 0) {
            logger.info("getPrintCommentWithParam:");
            for (Map.Entry<String, Object> entry : printParam.entrySet()) {
                logger.info(entry.getKey() + "=" + entry.getValue());
            }
        }
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getPrintCommentWithParam(businessKey, type, printParam);
    }

    public static List<Map<String, Object>> getNextUserTaskNodeByModel(DynamicObject dataEntity, String operation, String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getNextUserTaskNodeByModel(dataEntity, operation, entityNumber);
    }

    @KSMethod
    public static void setProcessInstanceVariable(Long procInstId, String variableName, Object value) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.setProcessInstanceVariable(procInstId, variableName, value);
    }

    @KSMethod
    public static void setDynPanticipant(Long taskId, List<Map<String, String>> list) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.setDynPanticipant(taskId, list);
    }

    @KSMethod
    public static void batchCompleteCompositeTasks(Map<Long, Map<String, Object>> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.batchCompleteCompositeTasks(variables);
    }

    @KSMethod
    public static String addSign(Long taskId, AddSignInfo addSignInfo) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.addSign(taskId, addSignInfo);
    }

    @KSMethod
    public static String addSignClear(Long taskId, String type) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.addSignClear(taskId, type);
    }

    @KSMethod
    public static String addSignByAdmin(Long procinstId, String activityId, AddSignInfo addSignInfo) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.addSignByAdmin(procinstId, activityId, addSignInfo);
    }

    @KSMethod
    public static String addSignClearByAdmin(Long procinstId, String activityId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.addSignClearByAdmin(procinstId, activityId);
    }

    @KSMethod
    public static IPreComputorRecord getPreComputorRecord(Long procInstId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getPreComputorRecord(procInstId);
    }

    @KSMethod
    public static IPreComputorRecord getPreComputorRecordWithOutCurrentNodes(Long procInstId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getPreComputorRecordWithOutCurrentNodes(procInstId);
    }

    @KSMethod
    public static void updateBpmnModelPropertys(Long procInstId, String actId, Map<String, Map<String, Object>> params) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.updateBpmnModelPropertys(procInstId, actId, params);
    }

    @KSMethod
    public static void createProcessAndStart(String businessKey, String operation, String entityNumber, Map<String, Object> variables, WFProcess wfProcess) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.createProcessAndStart(businessKey, operation, entityNumber, variables, wfProcess);
    }

    @KSMethod
    public static void abandon(Long procInstId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.abandonProInstance(procInstId.longValue());
    }

    @KSMethod
    public static void abandonByBusienssKey(String businessKey) {
        Long procInstId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey(businessKey);
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.abandonProInstance(procInstId.longValue());
    }

    @KSMethod
    public static Map<String, Object> getProcessInstancePropertiesByBusinesskey(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessInstancePropertiesByBusinesskey(businessKey);
    }

    @KSMethod
    public static void addJointAuditParticipants(String businesskey, String nodeId, List<Long> userIds, Map<String, String> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addJointAuditParticipants(businesskey, nodeId, userIds, variables);
    }

    @KSMethod
    public static void removeJointAuditParticipants(String businesskey, String nodeId, List<Long> userIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.removeJointAuditParticipants(businesskey, nodeId, userIds);
    }

    @KSMethod
    public static void SuspendProcessInstanceAndRuleByUserId(Long userId, ILocaleString suspendReason) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.suspendProcessInstanceByUserId(userId, suspendReason);
    }

    @KSMethod
    public static void ActivateProcessInstanceAndRuleByUserIdCmd(Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.activateProcessInstanceByUserId(userId);
    }

    @KSMethod
    public static List<Map<String, Object>> getProcessWindowRecords(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessWindowRecords(businessKey);
    }

    @KSMethod
    public static List<Map<String, Object>> getProcessWindowRecords(Long procdefId, DynamicObject billObj) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessWindowRecords(procdefId, billObj);
    }

    @KSMethod
    public static void withdrawTaskByBusinessKeyAndUserId(String businessKey, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdrawTaskByBusinessKeyAndUserId(businessKey, userId);
    }

    @KSMethod
    public static Boolean existProcDefByEntityNumber(String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.existProcDefByEntityNumber(entityNumber);
    }

    @KSMethod
    public static Map<String, Object> taskReminders(Long processInstanceId, ILocaleString reminderMsg) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskReminders(processInstanceId, reminderMsg);
    }

    @KSMethod
    public static BatchOperateResult taskReminders(Long[] processInstanceIds, ILocaleString reminderMsg) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.taskReminders(processInstanceIds, reminderMsg);
    }

    @KSMethod
    public static Map<String, Object> batchAuditByBusinesskeys(List<String> businessKeys, Map<String, Object> param) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.batchAuditByBusinesskeys(businessKeys, param);
    }

    @KSMethod
    public static List<EnabledProcessInfo> getEnabledProcesses(DynamicObject dataEntity, String operation) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getEnabledProcesses(dataEntity, operation);
    }

    @KSMethod
    public static void rejectToInnerNode(Long taskId, Long userId, String decOptionNumber, String auditMessage, List<String> innerNodeIds, boolean skipPath, Map<String, Object> variables) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.rejectToInnerNode(taskId, userId, decOptionNumber, auditMessage, innerNodeIds, skipPath, variables);
    }

    @KSMethod
    public static List<Map<String, Object>> getRejectInnerNodes(Long procinstId, String activityId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getRejectInnerNodes(procinstId, activityId);
    }

    @KSMethod
    public static long getEnableProcessCount() {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getEnabledProcessCount();
    }

    @KSMethod
    public static Map<String, Object> withdrawTransferTask(Long taskId, Long ownerId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.withdrawTransferTask(taskId, ownerId);
    }

    @KSMethod
    public static void withdrawTaskByTaskId(Long taskId, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdrawTask(taskId, userId);
    }

    @KSMethod
    public static void coordinateReplyTaskWithdraw(Long taskId, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdrawCoordinateTaskReply(taskId, userId);
    }

    @KSMethod
    public static String batchAgreeTaskWithUserId(List<Long> taskIds, ILocaleString opinion, Long userId) {
        StringBuilder str = new StringBuilder();
        if (!CollectionUtils.isEmpty(taskIds)) {
            for (int i = 0; i < taskIds.size(); ++i) {
                str.append(String.valueOf(taskIds.get(i)));
                if (i >= taskIds.size() - 1) continue;
                str.append(",");
            }
        }
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.batchAgreeTaskWithUserId(str.toString(), opinion, userId);
    }

    @KSMethod
    public static void completeTaskByBusinessKey(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.completeTask(businessKey, nodeId, userId, decOptionNumber, auditMessage, checkUser);
    }

    @KSMethod
    public static void replyCoordinateTask(Long taskId, ILocaleString taskCoordinateOpinion, List<Map<String, Object>> attch, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.taskCoordinateReply(taskId, taskCoordinateOpinion, attch, userId);
    }

    @KSMethod
    public static List<Map<String, Object>> getEnabledProcDefByEntityNumber(String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getEnabledProcDefByEntityNumber(entityNumber);
    }

    @KSMethod
    public static Map<String, Object> getProcDefById(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcDefById(procDefId);
    }

    @KSMethod
    public static void disableProcess(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.disableProcess(procDefId);
    }

    @KSMethod
    public static void enableProcess(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.enableProcess(procDefId);
    }

    @KSMethod
    public static Map<String, Object> getProcSchemeBySchemeId(Long schemeId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcSchemeBySchemeId(schemeId);
    }

    @KSMethod
    public static Map<String, Object> getProcSchemeBySchemeNumber(String schemeNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcSchemeBySchemeNumber(schemeNumber);
    }

    @KSMethod
    public static List<WFFlowElement> getProcElementsByProcDefId(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcElementsByProcDefId(procDefId);
    }

    @KSMethod
    public static List<WFFlowElement> getProcElementsBySchemeId(Long schemeId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcElementsBySchemeId(schemeId);
    }

    @KSMethod
    public static List<WFFlowElement> getProcElementsBySchemeNumber(String schemeNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcElementsBySchemeNumber(schemeNumber);
    }

    @KSMethod
    public static Map<String, Object> getProcDefByNumberAndVerson(String processNumber, String version) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcDefByNumberAndVerson(processNumber, version);
    }

    @KSMethod
    public static List<Map<String, Object>> getProcSchemesByProcDefId(Long procDefId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcSchemesByProcDefId(procDefId);
    }

    @KSMethod
    public static Map<String, Object> getVariablesByProcInstId(Long procInstId, String[] variableKeys) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getVariablesByProcInstId(procInstId, variableKeys);
    }

    @KSMethod
    public static void addTaskComment(Comment comment) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addComment(comment);
    }

    @KSMethod
    public static List<IApprovalRecordGroup> getAllApprovalRecordInclCoordinate(String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAllApprovalRecordInclCoordinate(businessKey);
    }

    @KSMethod
    public static void assignNextParticipant(Long taskId, Map<String, List<String>> dynParticipants) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.assignNextParticipant(taskId, dynParticipants);
    }

    @KSMethod
    public static List<Long> getAutoCoordinateUsers(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAutoCoorinateUsers(taskId);
    }

    @KSMethod
    public static Map<String, Map<String, List<Long>>> getNextUseableUserAndScope(Long taskId, String auditNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getNextUseableUserAndScope(taskId, auditNumber);
    }

    @KSMethod
    public static DynamicObjectCollection getApplyedProcess(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, Map<String, Object> paramFilter) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApplyedProcessAssistantCollection(userId, start, limit, starterOrSubjectFilter, timeFilter, paramFilter);
    }

    @KSMethod
    public static DynamicObjectCollection getHandledTasksByUserId(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getHandledTasksByUserId(start, limit, uid, sqlFilterMap);
    }

    @KSMethod
    public static DynamicObjectCollection getInProcessApply(int start, int limit, String uid, Map<String, String> sqlFilterMap) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApplyTasksByStartId(start, limit, uid, sqlFilterMap);
    }

    @KSMethod
    public static Map<String, Integer> getTaskCounts(String userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getTaskCounts(userId);
    }

    @KSMethod
    public static List<Map<String, Object>> getTaskEntityName(Long uid, String type) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getTaskEntityName(uid, type);
    }

    @KSMethod
    public static Map<String, Object> getPageVariables(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getPageVariables(taskId);
    }

    @KSMethod
    public static List<WFRejectNodesModel> getRejectNodes(Long taskId, String decisionOptionNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getRejectNodes(taskId, decisionOptionNumber);
    }

    @KSMethod
    public static void suspendProcessInstanceByProcessInstanceId(Long processInstanceId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.suspendProcessInstanceByProcessInstanceId(processInstanceId);
    }

    @KSMethod
    public static void revokeSuspendProcessInstancesByProcessInstanceId(Long processInstanceId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.revokeSuspendProcessInstancesByIds(processInstanceId);
    }

    @KSMethod
    public static void jumpToNode(Long procInstId, String destId, String srcId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.jumpToNode(procInstId, destId, srcId);
    }

    @KSMethod
    public static void jumpToNodeWithReason(Long procInstId, String destId, String srcId, ILocaleString reason) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.jumpToNodeWithReason(procInstId, destId, srcId, reason);
    }

    @KSMethod
    public static void abortProcessInstance(Long procInstId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.abortProcessInstance(procInstId);
    }

    @KSMethod
    public List<String> getArchiveRouteKeys(String archiveEntity, List<ArchiveRouteIndexCondition> archiveRouteIndexConditions) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getArchiveRouteKeys(archiveEntity, archiveRouteIndexConditions);
    }

    public static WorkflowRoleResult updateWorkflowRole(List<WorkflowRole> role) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.updateWorkflowRole(role);
    }

    @KSMethod
    public static Long getProInsIdByBusinessKeyAndEntityNumber(String businessKey, String entityNumber) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessInstanceIdByBusinessKeyAndEntityNumber(businessKey, entityNumber);
    }

    @KSMethod
    public static List<Map<String, Object>> getNextMandatoryNodes(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getNextMandatoryNodes(taskId);
    }

    @KSMethod
    public static List<IApprovalRecordGroup> getApprovalRecords(String entityNumber, String businessKey, boolean allRecord) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getApprovalRecords(entityNumber, businessKey, allRecord);
    }

    public static Map<String, List<ApprovalAttachmentInfo>> getProcessAttachmentsInfo(String entityNumber, String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getProcessAttachmentsInfo(entityNumber, businessKey);
    }

    public static Map<String, List<Map<String, Object>>> getActInstInfo(String businessKey, List<String> actIds, boolean isOnlyCompleted) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getActInstInfo(businessKey, actIds, isOnlyCompleted);
    }

    @KSMethod
    public static List<Map<String, String>> getAuditAllowModifiedFields(Long taskId, String type) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAuditAllowModifiedFields(taskId, type);
    }

    @KSMethod
    public static BillPageAttributeConfig getBillPageAttributeConfig(Long taskId, String type) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getBillPageAttributeConfig(taskId, type);
    }

    @KSMethod
    public static void withdrawByProcessInstanceId(Long processInstanceId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.withdrawByProcessInstanceId(processInstanceId);
    }

    @KSMethod
    public static Map<String, List<String>> canWithdrawByProcessInstanceId(Long processInstanceId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.canWithdrawByProcessInstanceId(processInstanceId);
    }

    @KSMethod
    public static Long getTaskIdByProcessInstanceIdAndActivityIdAndUserId(Long processInstanceId, String activityId, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getTaskIdByProcessInstanceIdAndActivityIdAndUserId(processInstanceId, activityId, userId);
    }

    @KSMethod
    public static Map<String, Object> suspendTaskById(Long taskId, Long userId, ILocaleString suspendReason) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.suspendTaskById(taskId, userId, suspendReason);
    }

    @KSMethod
    public static Map<String, Object> activateTaskById(Long taskId, Long userId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.activateTaskById(taskId, userId);
    }

    @KSMethod
    public static List<WFFlowNode> getRejectedPreNode(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getRejectedPreNode(taskId);
    }

    @KSMethod
    public static List<AuditPointResult> getAuditPointResultsByTaskId(Long taskId) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAuditPointResultsByTaskId(taskId);
    }

    @KSMethod
    public static void makeProcessInst(ProcessInstData processInstData) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.makeProcessInst(processInstData);
    }

    @KSMethod
    public static List<DynamicObject> findOperationLogByProcInstId(Long procInstId, String selectFeilds, String orderBy) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.findOperationLogByProcInstId(procInstId, selectFeilds, orderBy);
    }

    @KSMethod
    public static List<DynamicObject> findOperationLogByBusinessKey(String businessKey, String selectFeilds, String orderBy) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.findOperationLogByBusinessKey(businessKey, selectFeilds, orderBy);
    }

    @KSMethod
    public static List<Map<String, Object>> getAddressAndPreCompute(String operation, String entityNumber, String businessKey) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        return workflowService.getAddressAndPreCompute(operation, entityNumber, businessKey);
    }

    @KSMethod
    public static void addOneYunzhijiaCompletedChildTask(AddYunzhijiaTaskParam param) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addOneYunzhijiaCompletedChildTask(param);
    }

    @KSMethod
    public static void addProcessRelationPerson(Long processInstanceId, List<Long> assigneeIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addProcessRelationPerson(processInstanceId, assigneeIds);
    }

    @KSMethod
    public static void addProcessRelationPerson(String entityNumber, String businessKey, List<Long> assigneeIds) {
        IWorkflowService workflowService = WorkflowServiceHelper.getWFService();
        workflowService.addProcessRelationPerson(entityNumber, businessKey, assigneeIds);
    }
}

