/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.tree.TreeNode;

public class RuntimeMetaUtil {
    private static final String BOS_ENTITY_CORE = "bos-entity-core";

    public static TreeNode buildBillTreeNodes(MainEntityType mainType, boolean isIncludePKField, boolean isOnlyPhysicsField) {
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = RuntimeMetaUtil.buildFldTreeNodes(mainType, isIncludePKField, isOnlyPhysicsField);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(MainEntityType mainType, boolean isIncludePKField, boolean isOnlyPhysicsField) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"RuntimeMetaUtil_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName + " - " + entityNodeId);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (isIncludePKField) {
                RuntimeMetaUtil.buildPKFldTreeNode(entityType, entityNode, entityFldNodes);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                TreeNode fldNode;
                boolean matched = false;
                if (isOnlyPhysicsField && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName()) || (fldNode = RuntimeMetaUtil.BuildFldTreeNode(property, entityNode, "")) == null) continue;
                entityFldNodes.add(fldNode);
                matched = true;
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = RuntimeMetaUtil.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), entityNode, "");
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"RuntimeMetaUtil_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = RuntimeMetaUtil.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), entityNode, entityType.getName());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"RuntimeMetaUtil_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = RuntimeMetaUtil.BuildFldTreeNode((IDataEntityProperty)seqProp, entityNode, entityType.getName())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"RuntimeMetaUtil_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix) {
        String fldNodeName;
        String fullPropName;
        TreeNode fldNode = null;
        DynamicProperty prop = (DynamicProperty)fldProperty;
        String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
        String string = fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        if (fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput() || fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput()) {
            fldNodeName = fldNodeName + "*";
        }
        fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName + " - " + fldNodeId);
        fldNode.setIsOpened(false);
        return fldNode;
    }
}

