/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.CacheKeyUtil;

public class AICommandCache {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai-command", new DistributeCacheHAPolicy(true, true));

    private AICommandCache() {
    }

    public static void push(String aitoken, String userId, String id, String command) {
        String key = AICommandCache.getKey(aitoken, userId, id);
        List<String> listCommand = AICommandCache.getCommandList(key);
        listCommand.add(command);
        cache.remove(key);
        cache.addList(key, listCommand.toArray(new String[listCommand.size()]));
    }

    public static String pop(String id) {
        String key = AICommandCache.getKey(RequestContext.get().getGlobalSessionId(), RequestContext.get().getUserId(), id);
        List<String> listCommand = AICommandCache.getCommandList(key);
        if (listCommand.isEmpty()) {
            return null;
        }
        String command = listCommand.get(0);
        listCommand.remove(0);
        cache.remove(key);
        if (!listCommand.isEmpty()) {
            cache.addList(key, listCommand.toArray(new String[listCommand.size()]));
        }
        return command;
    }

    private static List<String> getCommandList(String key) {
        String[] commands = cache.getList(key);
        ArrayList<String> listCommand = new ArrayList<String>(10);
        for (String command : commands) {
            listCommand.add(command);
        }
        return listCommand;
    }

    private static String getKey(String aitoken, String userid, String id) {
        return CacheKeyUtil.getAcctId() + "." + id + userid + aitoken;
    }
}

