/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.TCacheSortField;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.entity.property.entryfilter.EntrySortItemInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;

final class ModelDataTable {
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private static final String TYPE_NAME = "TableCache";
    private static final String SPAN_DT_NAME = "dt.name";
    private static final String SPAN_ENTRY_KEY = "entrykey";
    private static final String SPAN_FILTER = "filter";
    private static final String SPAN_ORDERBY = "orderby";
    private static final String SPAN_TOP = "top";
    private static final String SPAN_SCAN_ROWS = "scan.rows";
    private static final String SPAN_PASS_ROWS = "pass.rows";
    private static final String SPAN_BATCH_SIZE = "batchsize";
    private static final int MAX_FILTER_ROWS = 100000;
    private static final int BATCH_SIZE = 5000;
    private String pageId;
    private MainEntityType dt;
    private IRefrencedataProvider refProvide;
    private Boolean pkIsStr;
    private DataEntitySerializerOption rootOption;
    private DataEntitySerializerOption entryOption;

    public ModelDataTable(IRefrencedataProvider refProvide, MainEntityType dt, String pageId) {
        this.refProvide = refProvide;
        this.dt = dt;
        this.pageId = pageId;
    }

    public String getTableName() {
        return this.isStrPK() ? "t_bos_modeldata_spk" : "t_bos_modeldata";
    }

    public String getEntryPkField() {
        return "fentryid";
    }

    public static int getMaxFilterRows() {
        return 100000;
    }

    public DynamicObject readRoot() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readRoot");){
            String sql = String.format("SELECT fdata  FROM %s  WHERE fpageid = ? and fentrykey = ? ", this.getTableName());
            Object[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)this.dt.getName())};
            String strMain = (String)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return resultSet.getString(1);
                    }
                    return null;
                }
            });
            if (strMain == null) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            DynamicObject dynamicObject = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)strMain, (IDataEntityType)this.dt, (DataEntityDeserializerOption)option);
            return dynamicObject;
        }
    }

    public List<TableData> readEntryRows(ICollectionProperty prop) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readEntryRows");){
            List<TableData> list = this.readEntryTableData(prop.getName());
            return list;
        }
    }

    public List<TableData> readEntryRows(ICollectionProperty prop, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readEntryRows");){
            boolean entryIdIsStr = prop.getItemType().getPrimaryKey() instanceof VarcharProp;
            String sql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel   FROM %s  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq < ? and fisdel = ?  ORDER BY fseq asc", this.getTableName());
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fseq1", 4, (Object)(startRowIndex + 1)), new SqlParameter("fseq2", 4, (Object)(endRowIndex + 1)), new SqlParameter("fisdel", 1, (Object)"0")};
            List<TableData> list = this.readEntryTableData(sql, params);
            return list;
        }
    }

    public TableData readEntryRow(ICollectionProperty prop, int rowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readEntryRow");){
            boolean entryIdIsStr = prop.getItemType().getPrimaryKey() instanceof VarcharProp;
            String sql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and fseq = ? and fisdel = ? order by fentryid ", this.getTableName());
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fseq", 4, (Object)(rowIndex + 1)), new SqlParameter("fisdel", 1, (Object)"0")};
            List<TableData> tableDataList = this.readEntryTableData(sql, params);
            if (tableDataList.isEmpty()) {
                TableData tableData = null;
                return tableData;
            }
            TableData tableData = tableDataList.get(0);
            return tableData;
        }
    }

    public Object[] readObject(Object[] pkArray, IDataEntityType det, int start, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readObject");){
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)det);
            if (start > 0) {
                dataManager.setStartRowIndex(start);
            }
            if (limit > 0) {
                dataManager.setPageSize(Integer.valueOf(limit));
            }
            Object[] objectArray = dataManager.read(pkArray);
            return objectArray;
        }
    }

    public int readEntryRowCount(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readEntryRowCount");){
            String sql = String.format("SELECT count(*) FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? ", this.getTableName());
            Object[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0")};
            int n = (Integer)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    return 0;
                }
            });
            return n;
        }
    }

    public int readMaxSeq(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readMaxSeq");){
            String sql = String.format("SELECT TOP 1 fseq FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ?  ORDER BY fseq desc", this.getTableName());
            Object[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0")};
            int n = (Integer)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    return 0;
                }
            });
            return n;
        }
    }

    public int readBatch1MaxSeq(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readBatch1MaxSeq");){
            String sql = String.format("SELECT TOP 1 fseq FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fisbatch1 = ?  ORDER BY fseq desc", this.getTableName());
            Object[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0"), new SqlParameter("fisbatch1", 1, (Object)"1")};
            int n = (Integer)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    return 0;
                }
            });
            return n;
        }
    }

    public void insertRows(ICollectionProperty prop, int row, DynamicObject[] entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"insertRows");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(2);
            String addSeqSql = String.format("UPDATE %s  SET fseq = fseq + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? ", this.getTableName());
            SqlParameter[] addSeqParams = new SqlParameter[]{new SqlParameter("LEN", 4, (Object)entryRows.length), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fseq", 4, (Object)(row + 1))};
            sqlList.add(new SqlAndParams(addSeqSql, addSeqParams));
            int filterSeq = this.readFilterSeq(prop.getName(), row);
            if (filterSeq > 0) {
                String addFilterSeqSql = String.format("UPDATE %s  SET ffilterseq = ffilterseq + ?  WHERE fpageid = ? and fentrykey = ? and ffilterseq >= ? ", this.getTableName());
                SqlParameter[] addFilterSeqParams = new SqlParameter[]{new SqlParameter("LEN", 4, (Object)entryRows.length), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("ffilterseq", 4, (Object)filterSeq)};
                sqlList.add(new SqlAndParams(addFilterSeqSql, addFilterSeqParams));
            }
            ISimpleProperty entryIdProp = prop.getItemType().getPrimaryKey();
            IDataEntityProperty seqProp = (IDataEntityProperty)prop.getItemType().getProperties().get((Object)"seq");
            Date currTime = KDDateUtils.now();
            String insertSql = null;
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(entryRows.length);
            for (DynamicObject entryRow : entryRows) {
                SqlAndParams sqlAndParams = this.buildSqlInsertEntryRow(prop.getName(), entryRow, (IDataEntityProperty)entryIdProp, seqProp, true, false, filterSeq, currTime);
                insertSql = sqlAndParams.getSql();
                insertParams.add(sqlAndParams.getExecuteParams());
                if (filterSeq <= 0) continue;
                ++filterSeq;
            }
            if (!insertParams.isEmpty()) {
                sqlList.add(new SqlAndParams(insertSql, insertParams, true));
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void appendRows(ICollectionProperty prop, DynamicObject[] entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"appendRows");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(entryRows.length);
            ISimpleProperty entryIdProp = prop.getItemType().getPrimaryKey();
            IDataEntityProperty seqProp = (IDataEntityProperty)prop.getItemType().getProperties().get((Object)"seq");
            Date currTime = KDDateUtils.now();
            int filterSeq = this.readFilterEntryRowCount(prop.getName());
            if (filterSeq > 0) {
                ++filterSeq;
            }
            String insertSql = null;
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(entryRows.length);
            for (DynamicObject entryRow : entryRows) {
                SqlAndParams sqlAndParams = this.buildSqlInsertEntryRow(prop.getName(), entryRow, (IDataEntityProperty)entryIdProp, seqProp, true, false, filterSeq, currTime);
                insertSql = sqlAndParams.getSql();
                insertParams.add(sqlAndParams.getExecuteParams());
                if (filterSeq <= 0) continue;
                ++filterSeq;
            }
            if (!insertParams.isEmpty()) {
                sqlList.add(new SqlAndParams(insertSql, insertParams, true));
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void deleteRows(String entryKey, int row, int len) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteRows");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(len + 2);
            sqlList.addAll(this.buildDelUpdateFilterSeq(entryKey, row, len));
            sqlList.addAll(this.buildSqlDelEntryRows(entryKey, row, len));
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void deleteRows(String entryKey, int[] rowIndices) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteRows");){
            ArrayList<int[]> removeItems = ModelDataTable.getRemoveItems(rowIndices);
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(removeItems.size() * 3);
            sqlList.addAll(this.buildDelUpdateFilterSeq(entryKey, rowIndices));
            for (int i = removeItems.size() - 1; i >= 0; --i) {
                int startIndex = removeItems.get(i)[0];
                int len = removeItems.get(i)[1];
                sqlList.addAll(this.buildSqlDelEntryRows(entryKey, startIndex, len));
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void deleteEntry(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteEntry");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(1);
            String delEntrySql = String.format("UPDATE %s SET fisdel = ?  WHERE fpageid = ? and fentrykey = ? ", this.getTableName());
            SqlParameter[] delEntryParams = new SqlParameter[]{new SqlParameter("fisdel", 1, (Object)"1"), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey)};
            sqlList.add(new SqlAndParams(delEntrySql, delEntryParams));
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public int[] checkDelEntryRows(String entryKey, int[] rowIndices) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"checkDelEntryRows");){
            if (rowIndices == null || rowIndices.length == 0) {
                int[] nArray = rowIndices;
                return nArray;
            }
            SqlParameter[] readRowParams = new SqlParameter[3 + rowIndices.length];
            readRowParams[0] = new SqlParameter("fpageid", 12, (Object)this.pageId);
            readRowParams[1] = new SqlParameter("fentrykey", 12, (Object)entryKey);
            readRowParams[2] = new SqlParameter("fisdel", 1, (Object)"0");
            ArrayList<String> rowList = new ArrayList<String>(rowIndices.length);
            for (int i = 0; i < rowIndices.length; ++i) {
                int rowIndex = rowIndices[i];
                rowList.add("?");
                readRowParams[3 + i] = new SqlParameter("fseq" + i, 4, (Object)(rowIndex + 1));
            }
            String readRowSql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fseq in (%s)", this.getTableName(), StringUtils.join((Object[])rowList.toArray(), (String)", "));
            List<TableData> tableDatas = this.readEntryTableData(readRowSql, readRowParams);
            ArrayList<Integer> rowIndexlist = new ArrayList<Integer>(rowIndices.length);
            for (TableData tableData : tableDatas) {
                if (!StringUtils.isNotBlank((CharSequence)tableData.getData())) continue;
                rowIndexlist.add(tableData.getSeq() - 1);
            }
            int[] passRowIndices = new int[rowIndexlist.size()];
            for (int i = 0; i < rowIndexlist.size(); ++i) {
                passRowIndices[i] = (Integer)rowIndexlist.get(i);
            }
            int[] nArray = passRowIndices;
            return nArray;
        }
    }

    public void swapEntryRow(ICollectionProperty prop, int rowIndex1, int rowIndex2) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"swapEntryRow");){
            String readRowSql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fseq in (%s)", this.getTableName(), "?,?");
            SqlParameter[] readRowParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fisdel", 1, (Object)"0"), new SqlParameter("fseq1", 4, (Object)(rowIndex1 + 1)), new SqlParameter("fseq2", 4, (Object)(rowIndex2 + 1))};
            List<TableData> tableDatas = this.readEntryTableData(readRowSql, readRowParams);
            String updateSeqSql = String.format("UPDATE %s SET fseq = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
            ArrayList<SqlParameter[]> updateSeqParams = new ArrayList<SqlParameter[]>(2);
            for (TableData tableData : tableDatas) {
                Integer seq = null;
                if (rowIndex1 == tableData.getSeq() - 1) {
                    seq = rowIndex2 + 1;
                } else if (rowIndex2 == tableData.getSeq() - 1) {
                    seq = rowIndex1 + 1;
                }
                if (seq == null) continue;
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, tableData.getEntryId())};
                updateSeqParams.add(params);
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (!updateSeqParams.isEmpty()) {
                        DB.executeBatch((DBRoute)dbroute, (String)updateSeqSql, updateSeqParams);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void moveEntryBlockRows(String entryKey, int startIndex, int len, int toIndex) {
        ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(3);
        SqlParameter pageParam = new SqlParameter("fpageid", 12, (Object)this.pageId);
        SqlParameter entryKeyParam = new SqlParameter("fentrykey", 12, (Object)entryKey);
        String tempSql = String.format("UPDATE %s  SET fseq = (fseq * -1) + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq <= ?", this.getTableName());
        SqlParameter[] tempParams = new SqlParameter[]{new SqlParameter("len", 4, (Object)0), pageParam, entryKeyParam, new SqlParameter("fseq1", 4, (Object)(startIndex + 1)), new SqlParameter("fseq2", 4, (Object)(startIndex + len))};
        sqlList.add(new SqlAndParams(tempSql, tempParams));
        int moveLen = 0;
        if (toIndex > startIndex) {
            String ipSql = String.format("UPDATE %s  SET fseq = fseq + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq <= ?", this.getTableName());
            SqlParameter[] ipParams = new SqlParameter[]{new SqlParameter("len", 4, (Object)(-1 * len)), pageParam, entryKeyParam, new SqlParameter("fseq1", 4, (Object)(startIndex + 1 + len)), new SqlParameter("fseq2", 4, (Object)(toIndex + 1))};
            sqlList.add(new SqlAndParams(ipSql, ipParams));
            moveLen = toIndex - startIndex - len + 1;
        } else {
            String toBeforeSql = String.format("UPDATE %s  SET fseq = fseq + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq <= ?", this.getTableName());
            SqlParameter[] toBeforeParams = new SqlParameter[]{new SqlParameter("len", 4, (Object)len), pageParam, entryKeyParam, new SqlParameter("fseq1", 4, (Object)(toIndex + 1)), new SqlParameter("fseq2", 4, (Object)startIndex)};
            sqlList.add(new SqlAndParams(toBeforeSql, toBeforeParams));
            moveLen = -1 * len;
        }
        String moveSql = String.format("UPDATE %s  SET fseq = (fseq * -1) + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq <= ?", this.getTableName());
        SqlParameter[] moveParams = new SqlParameter[]{new SqlParameter("len", 4, (Object)moveLen), pageParam, entryKeyParam, new SqlParameter("fseq1", 4, (Object)(-1 * (startIndex + len))), new SqlParameter("fseq2", 4, (Object)(-1 * (startIndex + 1)))};
        sqlList.add(new SqlAndParams(moveSql, moveParams));
        DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
        try (TXHandle h = TX.requiresNew();){
            try {
                for (SqlAndParams sql : sqlList) {
                    sql.execute(dbroute);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void moveEntryBlockRows(ICollectionProperty prop, List<Integer> rows, int startRowIndex, int endRowIndex) {
        List<TableData> tableDatas = this.readEntryRows(prop, startRowIndex, endRowIndex);
        String updateSeqSql = String.format("UPDATE %s SET fseq = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
        ArrayList<SqlParameter[]> updateSeqParams = new ArrayList<SqlParameter[]>(2);
        int i = startRowIndex + 1;
        for (int j = 0; j < rows.size(); ++j) {
            TableData tableData = tableDatas.get(rows.get(j) - startRowIndex);
            if (tableData == null) continue;
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fseq", 4, (Object)i), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, tableData.getEntryId())};
            updateSeqParams.add(params);
            ++i;
        }
        DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!updateSeqParams.isEmpty()) {
                    DB.executeBatch((DBRoute)dbroute, (String)updateSeqSql, updateSeqParams);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void initTable(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"initTable");){
            this.createTable();
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(8);
            sqlList.add(this.buildSqlClearTable());
            Object pkValue = dataEntity.getPkValue();
            Date currTime = KDDateUtils.now();
            IDataEntityType dt = dataEntity.getDataEntityType();
            ISimpleProperty pkProp = dt.getPrimaryKey();
            List properties = dt.getProperties().getCollectionProperties(false);
            for (ICollectionProperty entryProp : properties) {
                SqlAndParams sqlObject;
                ArrayList<Object[]> params;
                String sql;
                ISimpleProperty entryIdProp = entryProp.getItemType().getPrimaryKey();
                IDataEntityProperty seqProp = (IDataEntityProperty)entryProp.getItemType().getProperties().get((Object)"seq");
                DynamicObjectCollection cols = (DynamicObjectCollection)entryProp.getValueFast((Object)dataEntity);
                if (ModelDataTable.isSplitPage(dataEntity, entryProp.getName())) {
                    sqlList.add(this.buildSqlCopyEntry(entryProp, (IDataEntityProperty)pkProp, (IDataEntityProperty)entryIdProp, seqProp, pkValue));
                    sql = null;
                    params = new ArrayList(cols.size());
                    for (DynamicObject entryRow : cols) {
                        sqlObject = this.buildSqlInitUpdateEntryRow(entryProp.getName(), entryRow, (IDataEntityProperty)entryIdProp);
                        sql = sqlObject.getSql();
                        params.add(sqlObject.getExecuteParams());
                    }
                    if (params.isEmpty()) continue;
                    sqlList.add(new SqlAndParams(sql, params, true));
                    continue;
                }
                sql = null;
                params = new ArrayList<Object[]>(cols.size());
                for (DynamicObject entryRow : cols) {
                    sqlObject = this.buildSqlInsertEntryRow(entryProp.getName(), entryRow, (IDataEntityProperty)entryIdProp, seqProp, false, true, 0, currTime);
                    sql = sqlObject.getSql();
                    params.add(sqlObject.getExecuteParams());
                }
                if (params.isEmpty()) continue;
                sqlList.add(new SqlAndParams(sql, params, true));
            }
            sqlList.add(this.buildSqlInsertRoot(dataEntity));
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void updateAll(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"updateAll");){
            IDataEntityType dt = dataEntity.getDataEntityType();
            ISimpleProperty pkProp = dt.getPrimaryKey();
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(8);
            List properties = dt.getProperties().getCollectionProperties(false);
            for (ICollectionProperty prop : properties) {
                DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
                if (!ModelDataTable.isSplitPage(dataEntity, prop.getName())) {
                    sqlList.addAll(this.buildSqlResetEntry(cols));
                    continue;
                }
                sqlList.addAll(this.buildSqlUpdateEntryRows(cols));
            }
            sqlList.add(this.buildSqlUpdateRoot(dataEntity, this.pkIsStr));
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void updateChanged(DynamicObject rootDataEntity, Map<String, Map<Integer, DynamicObject>> localEntryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"updateChanged");){
            IDataEntityType dt = rootDataEntity.getDataEntityType();
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(8);
            for (Map.Entry<String, Map<Integer, DynamicObject>> localEntryItem : localEntryRows.entrySet()) {
                ICollectionProperty prop = (ICollectionProperty)dt.getProperties().get((Object)localEntryItem.getKey());
                IDataEntityType entryType = prop.getItemType();
                ISimpleProperty entryIdProp = entryType.getPrimaryKey();
                IDataEntityProperty seqProp = (IDataEntityProperty)entryType.getProperties().get((Object)"seq");
                Map<Integer, DynamicObject> mapRows = localEntryItem.getValue();
                String updateEntrySql = null;
                ArrayList<Object[]> updateEntryParams = new ArrayList<Object[]>(mapRows.size());
                for (Map.Entry<Integer, DynamicObject> entryRowItem : mapRows.entrySet()) {
                    DynamicObject entryRow = entryRowItem.getValue();
                    if (!ModelDataTable.isEntryRowChanged(entryRow, seqProp)) continue;
                    SqlAndParams sql = this.buildSqlUpdateEntryRow(prop.getName(), entryRow, (IDataEntityProperty)entryIdProp, seqProp, true);
                    updateEntrySql = sql.getSql();
                    updateEntryParams.add(sql.getExecuteParams());
                }
                if (updateEntryParams.isEmpty()) continue;
                sqlList.add(new SqlAndParams(updateEntrySql, updateEntryParams, true));
            }
            if (rootDataEntity != null && rootDataEntity.getLastDirty().length() > 0) {
                boolean billIdIsStr = dt.getPrimaryKey() instanceof VarcharProp;
                sqlList.add(this.buildSqlUpdateRoot(rootDataEntity, billIdIsStr));
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void updateRows(DynamicObjectCollection entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"updateRows");){
            String entryKey = entryRows.getDynamicObjectType().getName();
            DynamicObject root = entryRows.getRootEntity();
            List<SqlAndParams> sqlList = null;
            sqlList = !ModelDataTable.isSplitPage(root, entryKey) ? this.buildSqlResetEntry(entryRows) : this.buildSqlUpdateEntryRows(entryRows);
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void updateRowsFromDb(ICollectionProperty prop, DynamicObject[] entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"updateRowsFromDb");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(8);
            IDataEntityType entryType = prop.getItemType();
            ISimpleProperty entryIdProp = entryType.getPrimaryKey();
            IDataEntityProperty seqProp = (IDataEntityProperty)entryType.getProperties().get((Object)"seq");
            String updateEntrySql = null;
            ArrayList<Object[]> updateEntryParams = new ArrayList<Object[]>(entryRows.length);
            for (DynamicObject entryRow : entryRows) {
                SqlAndParams sql = this.buildSqlUpdateEntryRow(prop.getName(), entryRow, (IDataEntityProperty)entryIdProp, seqProp, false);
                updateEntrySql = sql.getSql();
                updateEntryParams.add(sql.getExecuteParams());
            }
            if (!updateEntryParams.isEmpty()) {
                sqlList.add(new SqlAndParams(updateEntrySql, updateEntryParams, true));
            }
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void clear() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"clear");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(2);
            sqlList.add(this.buildSqlClearTable());
            sqlList.add(this.buildSqlClearExpireData());
            DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (SqlAndParams sql : sqlList) {
                        sql.execute(dbroute);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void resetFilterRows(EntryProp prop) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"resetFilterRows");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + span.getName());
            String updateSql = String.format("UPDATE %s  SET fisfilter = ?, ffilterseq = ?  WHERE fpageid = ? and fentrykey = ?", this.getTableName());
            Object[] updateParams = new SqlParameter[]{new SqlParameter("fisfilter", 1, (Object)"0"), new SqlParameter("ffilterseq", 4, (Object)0), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName())};
            try (TXHandle h = TX.notSupported();){
                DB.execute((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)updateSql, (Object[])updateParams);
            }
        }
    }

    public void filterFromDb(EntryProp prop, Object pkValue, EntryQueryParser parser) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"filterFromDb");){
            String orderBySeq = prop.getName() + ".seq";
            String selectFields = prop.getName() + ".id as f0, " + orderBySeq;
            String selectOrderFields = parser.getOrderFields();
            if (StringUtils.isNotBlank((CharSequence)selectOrderFields)) {
                selectFields = selectFields + ", " + selectOrderFields;
            }
            String orderBy = orderBySeq;
            if (StringUtils.isNotBlank((CharSequence)parser.getOrderByDbTable())) {
                orderBy = parser.getOrderByDbTable() + ", " + orderBySeq;
            }
            QFilter filter = new QFilter("id", "=", pkValue);
            if (StringUtils.isNotBlank((CharSequence)parser.getFormula())) {
                filter.and(parser.getQFilter());
            }
            String updateSql = null;
            int paramCount = 0;
            if (parser.getSortFields().isEmpty()) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 4;
            } else if (parser.getSortFields().size() == 1) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 5;
            } else if (parser.getSortFields().size() == 2) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?, forder2 = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 6;
            } else if (parser.getSortFields().size() == 3) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?, forder2 = ?, forder3 = ?   WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 7;
            }
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(10);
            ArrayList<Object> updateParams = new ArrayList<Object[]>(5000);
            SqlParameter isFilterParam = new SqlParameter("fisfilter", 1, (Object)"1");
            SqlParameter pageParam = new SqlParameter("fpageid", 12, (Object)this.pageId);
            SqlParameter entryKeyParam = new SqlParameter("fentrykey", 12, (Object)prop.getName());
            ORM orm = ORM.create();
            DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
            int rowCount = 0;
            try (DataSet dataSet = orm.queryDataSet(this.getClass().getName() + ".filterEntry", this.dt.getName(), selectFields, new QFilter[]{filter}, orderBy, parser.getTop());){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ++rowCount;
                    SqlParameter[] params = new SqlParameter[paramCount];
                    params[0] = isFilterParam;
                    for (int i = 1; i <= 3; ++i) {
                        if (i > parser.getSortFields().size()) continue;
                        TCacheSortField sortField = (TCacheSortField)parser.sortFields.get(i - 1);
                        params[i] = new SqlParameter(sortField.getAlias(), -9, sortField.formatValue(row));
                    }
                    params[paramCount - 1] = pageParam;
                    params[paramCount - 2] = entryKeyParam;
                    params[paramCount - 3] = this.isStrPK() ? new SqlParameter("fentryid", 12, (Object)row.getString(0)) : new SqlParameter("fentryid", -5, (Object)row.getLong(0));
                    updateParams.add(params);
                    if (updateParams.size() < 5000) continue;
                    sqlList.add(new SqlAndParams(updateSql, updateParams, true));
                    updateParams = new ArrayList(5000);
                }
            }
            if (!updateParams.isEmpty()) {
                sqlList.add(new SqlAndParams(updateSql, updateParams, true));
                updateParams = null;
            }
            for (SqlAndParams sql : sqlList) {
                TXHandle h = TX.notSupported();
                Throwable throwable = null;
                try {
                    sql.execute(dbRoute);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + prop.getName()));
                span.addLocaleTag("select", (Object)selectFields);
                span.addLocaleTag(SPAN_FILTER, (Object)filter);
                span.addLocaleTag(SPAN_ORDERBY, (Object)orderBy);
                span.addLocaleTag(SPAN_TOP, (Object)parser.getTop());
                span.addLocaleTag(SPAN_PASS_ROWS, (Object)rowCount);
                for (int i = 0; i < sqlList.size(); ++i) {
                    span.addLocaleTag(SPAN_BATCH_SIZE + i, (Object)((SqlAndParams)sqlList.get(i)).batchExecuteParams.size());
                }
            }
        }
    }

    public void filterFromTemp(EntryProp prop, EntryQueryParser parser) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"filterFromTemp");){
            List<TableData> tableDatas = this.readChangedTableData(prop.getName(), parser);
            ArrayList<String> strRows = new ArrayList<String>(tableDatas.size());
            for (TableData tableData : tableDatas) {
                if (!StringUtils.isNotBlank((CharSequence)tableData.getData())) continue;
                strRows.add(tableData.getData());
            }
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            ArrayList rowsFromTable = new ArrayList(strRows.size());
            DataEntitySerializer.deserializerFromListString(rowsFromTable, (IDataEntityType)prop.getItemType(), (String[])strRows.toArray(new String[strRows.size()]), (DataEntityDeserializerOption)option);
            this.refProvide.fillReferenceData(rowsFromTable.toArray(), prop.getItemType());
            String updateSql = null;
            int paramCount = 0;
            if (parser.getSortFields().isEmpty()) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 4;
            } else if (parser.getSortFields().size() == 1) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 5;
            } else if (parser.getSortFields().size() == 2) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?, forder2 = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 6;
            } else if (parser.getSortFields().size() == 3) {
                updateSql = String.format("UPDATE %s  SET fisfilter = ?, forder1 = ?, forder2 = ?, forder3 = ?   WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
                paramCount = 7;
            }
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(10);
            ArrayList<Object> updateParams = new ArrayList<Object[]>(5000);
            SqlParameter filterPassParam = new SqlParameter("fisfilter", 1, (Object)"1");
            SqlParameter filterFailParam = new SqlParameter("fisfilter", 1, (Object)"0");
            SqlParameter pageParam = new SqlParameter("fpageid", 12, (Object)this.pageId);
            SqlParameter entryKeyParam = new SqlParameter("fentrykey", 12, (Object)prop.getName());
            RowDataModel rowDataModel = new RowDataModel(prop.getName(), this.dt);
            ExpressionParameter expressionParameter = new ExpressionParameter(parser.getFormula(), rowDataModel);
            if (StringUtils.isNotBlank((CharSequence)expressionParameter.getBOSExpression().getErrMessage())) {
                if (span.isRealtime()) {
                    span.addTag("ExpressionErrMessage", expressionParameter.getBOSExpression().getErrMessage());
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u503c\u4e2d\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ModelDataTable_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
            int rowCount = 0;
            for (Object entryRow : rowsFromTable) {
                expressionParameter.setActiveRow(entryRow);
                boolean isPass = false;
                if (StringUtils.isBlank((CharSequence)parser.getFormula())) {
                    isPass = true;
                } else {
                    Object expValue = CalcExprParser.getExpressionValue((ExpressionParameter)expressionParameter);
                    if (expValue != null && ((Boolean)expValue).booleanValue()) {
                        isPass = true;
                    }
                }
                if (isPass) {
                    ++rowCount;
                }
                SqlParameter[] params = new SqlParameter[paramCount];
                params[0] = isPass ? filterPassParam : filterFailParam;
                for (int i = 1; i <= 3; ++i) {
                    if (i > parser.getSortFields().size()) continue;
                    TCacheSortField sortField = (TCacheSortField)parser.sortFields.get(i - 1);
                    params[i] = new SqlParameter(sortField.getAlias(), -9, sortField.formatValue((DynamicObject)entryRow));
                }
                params[paramCount - 1] = pageParam;
                params[paramCount - 2] = entryKeyParam;
                params[paramCount - 3] = new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, entryRow.getPkValue());
                updateParams.add(params);
                if (updateParams.size() < 5000) continue;
                sqlList.add(new SqlAndParams(updateSql, updateParams, true));
                updateParams = new ArrayList(5000);
            }
            if (!updateParams.isEmpty()) {
                sqlList.add(new SqlAndParams(updateSql, updateParams, true));
            }
            DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
            for (SqlAndParams sql : sqlList) {
                TXHandle h = TX.notSupported();
                Throwable throwable = null;
                try {
                    sql.execute(dbRoute);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + prop.getName()));
                span.addLocaleTag(SPAN_FILTER, (Object)parser.getFormula());
                span.addLocaleTag(SPAN_ORDERBY, (Object)parser.getOrderByDbTable());
                span.addLocaleTag(SPAN_SCAN_ROWS, (Object)rowsFromTable.size());
                span.addLocaleTag(SPAN_PASS_ROWS, (Object)rowCount);
                for (int i = 0; i < sqlList.size(); ++i) {
                    span.addLocaleTag(SPAN_BATCH_SIZE + i, (Object)((SqlAndParams)sqlList.get(i)).batchExecuteParams.size());
                }
            }
        }
    }

    public void sortFilterRows(EntryProp prop, EntryQueryParser parser) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"sortFilterRows");){
            DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
            String orderby = parser.getOrderByTampTable();
            orderby = StringUtils.isBlank((CharSequence)orderby) ? "fseq" : orderby + ", " + "fseq";
            SqlParameter pageParam = new SqlParameter("fpageid", 12, (Object)this.pageId);
            SqlParameter entryKeyParam = new SqlParameter("fentrykey", 12, (Object)prop.getName());
            String selectRowSql = String.format("SELECT TOP %s fentryid  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fisfilter = ? and ffilterseq = ?  ORDER BY %s", 5000, this.getTableName(), orderby);
            Object[] selectRowParams = new SqlParameter[]{pageParam, entryKeyParam, new SqlParameter("fisdel", 1, (Object)"0"), new SqlParameter("fisfilter", 1, (Object)"1"), new SqlParameter("ffilterseq", 4, (Object)0)};
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(10);
            String updateRowSql = String.format("UPDATE %s  SET ffilterseq = ?  WHERE fentryid = ? and fentrykey = ? and fpageid = ? ", this.getTableName());
            int seq = 1;
            int index = 0;
            int rowCount = this.readEntryRowCount(prop.getName());
            while (index < rowCount && seq <= parser.getTop()) {
                ++index;
                List entryIds = (List)DB.query((DBRoute)dbRoute, (String)selectRowSql, (Object[])selectRowParams, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                    public List<Object> handle(ResultSet resultSet) throws Exception {
                        ArrayList<Object> list = new ArrayList<Object>(5000);
                        while (resultSet.next()) {
                            list.add(ModelDataTable.this.isStrPK() ? resultSet.getString(1) : Long.valueOf(resultSet.getLong(1)));
                        }
                        return list;
                    }
                });
                if (entryIds.isEmpty()) break;
                ArrayList<Object[]> updateRowParams = new ArrayList<Object[]>(entryIds.size());
                for (Object entryId : entryIds) {
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter("ffilterseq", 4, (Object)seq), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, entryId), entryKeyParam, pageParam};
                    updateRowParams.add(params);
                    ++seq;
                }
                try (TXHandle h = TX.notSupported();){
                    DB.executeBatch((DBRoute)dbRoute, (String)updateRowSql, updateRowParams);
                }
                sqlList.add(new SqlAndParams(updateRowSql, updateRowParams, true));
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + prop.getName()));
                span.addLocaleTag(SPAN_ORDERBY, (Object)orderby);
                span.addLocaleTag(SPAN_TOP, (Object)parser.getTop());
                span.addLocaleTag(SPAN_PASS_ROWS, (Object)(seq - 1));
                for (int i = 0; i < sqlList.size(); ++i) {
                    span.addLocaleTag(SPAN_BATCH_SIZE + i, (Object)((SqlAndParams)sqlList.get(i)).batchExecuteParams.size());
                }
            }
        }
    }

    public int readFilterEntryRowCount(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readFilterEntryRowCount");){
            String selectSql = String.format("SELECT TOP 1 ffilterseq FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fisfilter = ?  ORDER BY ffilterseq desc", this.getTableName());
            Object[] selectParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0"), new SqlParameter("fisfilter", 1, (Object)"1")};
            int n = (Integer)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)selectSql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    return 0;
                }
            });
            return n;
        }
    }

    public List<TableData> readFilterEntryRows(ICollectionProperty prop, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readFilterEntryRows");){
            boolean entryIdIsStr = prop.getItemType().getPrimaryKey() instanceof VarcharProp;
            String sql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel   FROM %s  WHERE fpageid = ? and fentrykey = ? and ffilterseq >= ? and ffilterseq < ? and fisdel = ?  ORDER BY ffilterseq asc", this.getTableName());
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fseq1", 4, (Object)(startRowIndex + 1)), new SqlParameter("fseq2", 4, (Object)(endRowIndex + 1)), new SqlParameter("fisdel", 1, (Object)"0")};
            List<TableData> list = this.readEntryTableData(sql, params);
            return list;
        }
    }

    public List<Integer> readFilterEntryRowKeys(String entryKey, final int startRowIndex, final int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readFilterEntryRowKeys");){
            Object[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq1", 4, (Object)(startRowIndex + 1)), new SqlParameter("fseq2", 4, (Object)(endRowIndex + 1)), new SqlParameter("fisdel", 1, (Object)"0")};
            String selSeqSql = String.format("SELECT fseq   FROM %s  WHERE fpageid = ? and fentrykey = ? and ffilterseq >= ? and ffilterseq < ? and fisdel = ?  ORDER BY ffilterseq asc", this.getTableName());
            List list = (List)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)selSeqSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Integer>>(){

                public List<Integer> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Integer> list = new ArrayList<Integer>(endRowIndex - startRowIndex);
                    while (resultSet.next()) {
                        Integer seq = resultSet.getInt(1);
                        if (seq == null || seq <= 0) continue;
                        list.add(seq - 1);
                    }
                    return list;
                }
            });
            return list;
        }
    }

    public List<Integer> readFilterSeqByRowKeys(String entryKey, final int[] rowIndexs) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readFilterSeqByRowKeys");){
            Object[] seqArray = new String[rowIndexs.length];
            ArrayList<SqlParameter> selSeqParams = new ArrayList<SqlParameter>(rowIndexs.length + 3);
            selSeqParams.add(new SqlParameter("fpageid", 12, (Object)this.pageId));
            selSeqParams.add(new SqlParameter("fentrykey", 12, (Object)entryKey));
            selSeqParams.add(new SqlParameter("fisdel", 1, (Object)"0"));
            for (int i = 0; i < rowIndexs.length; ++i) {
                seqArray[i] = "?";
                selSeqParams.add(new SqlParameter("fseq" + i, 4, (Object)(rowIndexs[i] + 1)));
            }
            String selSeqSql = String.format("SELECT ffilterseq  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fseq in (%s) order by ffilterseq ", this.getTableName(), StringUtils.join((Object[])seqArray, (String)","));
            List list = (List)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)selSeqSql, (Object[])selSeqParams.toArray(new SqlParameter[0]), (ResultSetHandler)new ResultSetHandler<List<Integer>>(){

                public List<Integer> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Integer> list = new ArrayList<Integer>(rowIndexs.length);
                    while (resultSet.next()) {
                        Integer filterSeq = resultSet.getInt(1);
                        if (filterSeq == null || filterSeq <= 0) continue;
                        list.add(filterSeq);
                    }
                    return list;
                }
            });
            return list;
        }
    }

    public List<Integer> readFilterSortByRowKeys(String entryKey, final int[] rowIndexs) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"readFilterSortByRowKeys");){
            Object[] seqArray = new String[rowIndexs.length];
            ArrayList<SqlParameter> selSeqParams = new ArrayList<SqlParameter>(rowIndexs.length + 3);
            selSeqParams.add(new SqlParameter("fpageid", 12, (Object)this.pageId));
            selSeqParams.add(new SqlParameter("fentrykey", 12, (Object)entryKey));
            selSeqParams.add(new SqlParameter("fisdel", 1, (Object)"0"));
            for (int i = 0; i < rowIndexs.length; ++i) {
                seqArray[i] = "?";
                selSeqParams.add(new SqlParameter("fseq" + i, 4, (Object)(rowIndexs[i] + 1)));
            }
            String selSeqSql = String.format("SELECT fseq  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fseq in (%s) order by ffilterseq ", this.getTableName(), StringUtils.join((Object[])seqArray, (String)","));
            List list = (List)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)selSeqSql, (Object[])selSeqParams.toArray(new SqlParameter[0]), (ResultSetHandler)new ResultSetHandler<List<Integer>>(){

                public List<Integer> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Integer> list = new ArrayList<Integer>(rowIndexs.length);
                    while (resultSet.next()) {
                        Integer filterSeq = resultSet.getInt(1);
                        if (filterSeq == null || filterSeq <= 0) continue;
                        list.add(filterSeq);
                    }
                    return list;
                }
            });
            return list;
        }
    }

    public boolean checkAndFixEntrySeq(ICollectionProperty prop) throws KDException {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"checkAndFixEntrySeq");){
            int maxSeq = this.readMaxSeq(prop.getName());
            int rowCount = this.readEntryRowCount(prop.getName());
            DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
            int zeroRowCount = this.fixDupSeq(prop.getName(), 0, maxSeq + 1);
            maxSeq += zeroRowCount;
            String dupSql = String.format("SELECT fseq, count(fseq) from %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ?  GROUP BY fseq  HAVING count(fseq) > 1  ORDER BY fseq desc ", this.getTableName());
            Object[] dupParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)prop.getName()), new SqlParameter("fisdel", 1, (Object)"0")};
            List dupSeqs = (List)DB.query((DBRoute)dbRoute, (String)dupSql, (Object[])dupParams, (ResultSetHandler)new ResultSetHandler<List<Tuple<Integer, Integer>>>(){

                public List<Tuple<Integer, Integer>> handle(ResultSet resultSet) throws Exception {
                    ArrayList<Tuple<Integer, Integer>> list = new ArrayList<Tuple<Integer, Integer>>(1);
                    while (resultSet.next()) {
                        int seq = resultSet.getInt(1);
                        int count = resultSet.getInt(2);
                        list.add((Tuple<Integer, Integer>)new Tuple((Object)seq, (Object)count));
                    }
                    return list;
                }
            });
            if (!dupSeqs.isEmpty()) {
                for (Tuple tuple : dupSeqs) {
                    int seq = (Integer)tuple.item1;
                    int count = this.fixDupSeq(prop.getName(), seq, seq);
                    maxSeq = maxSeq + count - 1;
                }
            }
            if (maxSeq != rowCount) {
                this.fixLostSeq(prop.getName());
            }
            if (span.isRealtime()) {
                span.addTag(SPAN_DT_NAME, this.dt.getName());
                span.addTag(SPAN_ENTRY_KEY, prop.getName());
                span.addLocaleTag("rowcount", (Object)rowCount);
                span.addLocaleTag("zeroRowCount", (Object)zeroRowCount);
                span.addLocaleTag("dupSeqs", (Object)dupSeqs);
                span.addLocaleTag("maxSeq", (Object)maxSeq);
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean checkEntryDelRows(ICollectionProperty prop, List<Object> delEntryIds) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"checkEntryDelRows");){
            ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(1);
            ArrayList<String> inStr = new ArrayList<String>(delEntryIds.size());
            ArrayList<SqlParameter> idParams = new ArrayList<SqlParameter>(delEntryIds.size());
            idParams.add(new SqlParameter("fpageid", 12, (Object)this.pageId));
            idParams.add(new SqlParameter("fentrykey", 12, (Object)prop.getName()));
            idParams.add(new SqlParameter("fisdel", 1, (Object)"0"));
            int index = 0;
            for (Object entryId : delEntryIds) {
                inStr.add("?");
                idParams.add(new SqlParameter("fentryid" + index, this.isStrPK() ? 12 : -5, entryId));
                if (idParams.size() > 5000) {
                    String checkDelSeq = String.format("SELECT fentryid, fseq from %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ?  and fentryid in (%s) ", this.getTableName(), StringUtils.join((Object[])inStr.toArray(), (String)", "));
                    sqlList.add(new SqlAndParams(checkDelSeq, idParams.toArray(new SqlParameter[0])));
                    inStr.clear();
                    idParams.clear();
                    idParams.add(new SqlParameter("fpageid", 12, (Object)this.pageId));
                    idParams.add(new SqlParameter("fentrykey", 12, (Object)prop.getName()));
                    idParams.add(new SqlParameter("fisdel", 1, (Object)"0"));
                }
                ++index;
            }
            if (!idParams.isEmpty()) {
                String checkDelSeq = String.format("SELECT fentryid, fseq from %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ?  and fentryid in (%s) ", this.getTableName(), StringUtils.join((Object[])inStr.toArray(), (String)", "));
                sqlList.add(new SqlAndParams(checkDelSeq, idParams.toArray(new SqlParameter[0])));
                inStr.clear();
                idParams.clear();
            }
            DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
            for (SqlAndParams sql : sqlList) {
                List seqs = (List)DB.query((DBRoute)dbRoute, (String)sql.getSql(), (Object[])sql.executeParams, (ResultSetHandler)new ResultSetHandler<List<Integer>>(){

                    public List<Integer> handle(ResultSet resultSet) throws Exception {
                        ArrayList<Integer> list = new ArrayList<Integer>(10);
                        while (resultSet.next()) {
                            list.add(resultSet.getInt(2));
                        }
                        return list;
                    }
                });
                if (seqs.isEmpty()) continue;
                if (span.isRealtime()) {
                    span.addTag(SPAN_ENTRY_KEY, prop.getName());
                    span.addLocaleTag("delEntryIds", delEntryIds);
                    span.addLocaleTag("undel.seqs", (Object)seqs);
                }
                throw new KDException(new ErrorCode(this.getClass().getSimpleName() + ".checkSeq.03", String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u3010%1$s\u3011\u4e2d\u884c\u53f7 %2$s \u672a\u6807\u8bb0\u4e3a\u5df2\u5220\u9664\uff0c\u4f46\u672a\u88ab\u52a0\u8f7d\u5230\u6570\u636e\u5305\uff0c\u4e0d\u77e5\u4ea7\u751f\u539f\u56e0\u3002\u4f46\u5982\u679c\u7ee7\u7eed\u7f16\u8f91\u5e76\u4fdd\u5b58\uff0c\u4f1a\u81ea\u52a8\u5220\u9664\u6b64\u884c\uff0c\u4ece\u800c\u5bfc\u81f4\u6570\u636e\u4e22\u5931\u3002\u8bf7\u653e\u5f03\u672c\u6b21\u4fee\u6539\uff0c\u91cd\u65b0\u6253\u5f00\u5355\u636e\u8fdb\u884c\u7f16\u8f91\uff0c\u62b1\u6b49\u3002", (String)"ModelDataTable_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString(), seqs.get(0))), new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
    }

    private void createTable() {
        DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
        String tableName = this.getTableName();
        String sqlCreate = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s ( fpageid           varchar(100)    DEFAULT(' ') not null, fentitynumber     varchar(100)    DEFAULT(' ') not null, fentrykey         varchar(100)    DEFAULT(' ') not null, fbillid           %s, fentryid          %s, fseq_old          INT             DEFAULT(0)  not null, fseq              INT             DEFAULT(0)  not null, fdata             NCLOB                       null, fdirtyflag        varchar(500)    DEFAULT(' ') null, fischanged        CHAR(1)         DEFAULT('0') not null, fisnew            CHAR(1)         DEFAULT('0') not null, fisdel            CHAR(1)         DEFAULT('0') not null, fisload           CHAR(1)         DEFAULT('0') not null, fisbatch1         CHAR(1)         DEFAULT('0') not null, fisfilter         CHAR(1)         DEFAULT('0') not null, ffilterseq        INT             DEFAULT(0)   not null, forder1           varchar(100)    DEFAULT(' ') null, forder2           varchar(100)    DEFAULT(' ') null, forder3           varchar(100)    DEFAULT(' ') null, fcreatetime       DATETIME                    null) ", tableName, tableName, this.isStrPK() ? "varchar(100)    DEFAULT(' ') not null" : "BIGINT          DEFAULT(0) not null", this.isStrPK() ? "varchar(100)    DEFAULT(' ') not null" : "BIGINT          DEFAULT(0) not null");
        String idxName = tableName.substring(2);
        String sqlIdx_page = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_pg')  create index idx_%s_pg on %s (fpageid ASC)", idxName, idxName, tableName);
        String sqlIdx_ekey = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_ekey')  create index idx_%s_ekey on %s (fentrykey ASC)", idxName, idxName, tableName);
        String sqlIdx_eid = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_eid')  create index idx_%s_eid on %s(fentryid ASC)", idxName, idxName, tableName);
        String sqlIdx_seq = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_seq')  create index idx_%s_seq on %s (fseq ASC)", idxName, idxName, tableName);
        String sqlIdx_filterseq = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_flt')  create index idx_%s_flt on %s (ffilterseq ASC)", idxName, idxName, tableName);
        String sqlIdx_filterUn = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_INDNAME = 'idx_%s_un')  create index idx_%s_un on %s (fentryid ASC, fentrykey ASC, fpageid ASC)", idxName, idxName, tableName);
        if (!DB.exitsTable((DBRoute)dbroute, (String)this.getTableName())) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)dbroute, (String)sqlCreate);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_page);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_ekey);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_eid);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_seq);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_filterseq);
                    DB.execute((DBRoute)dbroute, (String)sqlIdx_filterUn);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private int fixDupSeq(String entryKey, int dupSeq, int seq) {
        SqlParameter[] zeroParams;
        String zeroSql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and fseq = ? and fisdel = ? order by fentryid ", this.getTableName());
        List<TableData> tableDataList = this.readEntryTableData(zeroSql, zeroParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq", 4, (Object)dupSeq), new SqlParameter("fisdel", 1, (Object)"0")});
        if (tableDataList.isEmpty()) {
            return tableDataList.size();
        }
        ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(10);
        int count = tableDataList.size();
        if (dupSeq != 0) {
            String addSeqSql = String.format("UPDATE %s  SET fseq = fseq + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? ", this.getTableName());
            SqlParameter[] addSqlParams = new SqlParameter[]{new SqlParameter("fseq1", 4, (Object)(count - 1)), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq2", 4, (Object)dupSeq)};
            sqlList.add(new SqlAndParams(addSeqSql, addSqlParams));
        }
        String updateSeqSql = String.format("UPDATE %s SET fseq = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
        ArrayList<Object> updateZeroParams = new ArrayList<Object[]>(5000);
        for (TableData tableData : tableDataList) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, tableData.getEntryId())};
            updateZeroParams.add(params);
            if (updateZeroParams.size() >= 5000) {
                sqlList.add(new SqlAndParams(updateSeqSql, updateZeroParams, true));
                updateZeroParams = new ArrayList(5000);
            }
            ++seq;
        }
        if (!updateZeroParams.isEmpty()) {
            sqlList.add(new SqlAndParams(updateSeqSql, updateZeroParams, true));
            updateZeroParams = null;
        }
        DBRoute dbroute = new DBRoute(this.dt.getDBRouteKey());
        try (TXHandle h = TX.requiresNew();){
            try {
                for (SqlAndParams sql : sqlList) {
                    sql.execute(dbroute);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return tableDataList.size();
    }

    private int fixLostSeq(String entryKey) {
        String selSeqSql = String.format("SELECT fentryid, fseq  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? order by fseq desc ", this.getTableName());
        Object[] selSeqParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0")};
        DBRoute dbRoute = new DBRoute(this.dt.getDBRouteKey());
        List lostSeqs = (List)DB.query((DBRoute)dbRoute, (String)selSeqSql, (Object[])selSeqParams, (ResultSetHandler)new ResultSetHandler<List<Tuple<Integer, Integer>>>(){

            public List<Tuple<Integer, Integer>> handle(ResultSet resultSet) throws Exception {
                ArrayList<Tuple<Integer, Integer>> list = new ArrayList<Tuple<Integer, Integer>>(10);
                int preSeq = 0;
                while (resultSet.next()) {
                    int seq = resultSet.getInt(2);
                    if (preSeq > seq + 1) {
                        list.add((Tuple<Integer, Integer>)new Tuple((Object)preSeq, (Object)(preSeq - seq - 1)));
                    }
                    preSeq = seq;
                }
                return list;
            }
        });
        EntityTracer.addLocaleTag((String)"lostSeqs", (Object)lostSeqs);
        int lostCount = 0;
        if (lostSeqs.isEmpty()) {
            return lostCount;
        }
        ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(10);
        for (Tuple tuple : lostSeqs) {
            int seq = (Integer)tuple.item1;
            int count = (Integer)tuple.item2;
            lostCount += count;
            String addSeqSql = String.format("UPDATE %s  SET fseq = fseq - ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ?", this.getTableName());
            SqlParameter[] addSqlParams = new SqlParameter[]{new SqlParameter("fseq1", 4, (Object)count), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq2", 4, (Object)seq)};
            sqlList.add(new SqlAndParams(addSeqSql, addSqlParams));
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                for (SqlAndParams sql : sqlList) {
                    sql.execute(dbRoute);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return lostCount;
    }

    private SqlAndParams buildSqlClearTable() {
        String sql = String.format(" DELETE FROM %S WHERE fpageid = ? ", this.getTableName());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId)};
        return new SqlAndParams(sql, params);
    }

    private SqlAndParams buildSqlClearExpireData() {
        String sql = String.format(" DELETE FROM %S WHERE fcreatetime < ? ", this.getTableName());
        long currTime = KDDateUtils.now().getTime();
        Date expireTime = new Date(currTime - 86400000L);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("fcreatetime", 91, (Object)expireTime)};
        return new SqlAndParams(sql, params);
    }

    private SqlAndParams buildSqlInsertRoot(DynamicObject dataEntity) {
        String data = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)this.getRootOption());
        String sqlInsertRoot = String.format("INSERT INTO %s  (fpageid, fentitynumber, fentrykey, fbillid, fdata,  fcreatetime)  VALUES (?,?,?,?,?, ?)", this.getTableName());
        SqlParameter[] paramInsertRoot = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentitynumber", 12, (Object)this.dt.getName()), new SqlParameter("fentrykey", 12, (Object)this.dt.getName()), new SqlParameter("fbillid", this.isStrPK() ? 12 : -5, dataEntity.getPkValue()), new SqlParameter("fdata", 12, (Object)data), new SqlParameter("fcreatetime", 91, (Object)KDDateUtils.now())};
        return new SqlAndParams(sqlInsertRoot, paramInsertRoot);
    }

    private SqlAndParams buildSqlUpdateRoot(DynamicObject dataEntity, boolean billIdIsStr) {
        String data = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)this.getRootOption());
        String sqlUpdateRoot = String.format("UPDATE %s SET fdata = ? WHERE fpageid = ? and fentrykey = ? ", this.getTableName());
        SqlParameter[] paramUpdateRoot = new SqlParameter[]{new SqlParameter("fdata", 12, (Object)data), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)this.dt.getName())};
        return new SqlAndParams(sqlUpdateRoot, paramUpdateRoot);
    }

    private SqlAndParams buildSqlInsertEntryRow(String entryKey, DynamicObject entryRow, IDataEntityProperty entryIdProp, IDataEntityProperty seqProp, boolean isChanged, boolean isBatch1, int filterSql, Date currTime) {
        Object pkValue = null;
        if (entryRow.getParent() != null) {
            pkValue = ((DynamicObject)entryRow.getParent()).getPkValue();
        }
        Object entryId = this.getPKValue(entryRow, entryIdProp, this.isStrPK());
        int seq = entryRow.getInt("seq");
        String data = this.serializerEntryRow(entryRow);
        String dirtyFlag = this.getDirtyFlag(entryRow, entryIdProp, seqProp);
        boolean isNew = !entryRow.getDataEntityState().getFromDatabase();
        String seqInsertEntry = String.format("INSERT INTO %s  (fpageid, fentitynumber, fentrykey, fbillid, fentryid,  fseq_old, fseq, fdata, fdirtyflag, fischanged,  fisnew, fisload, fisbatch1, fisfilter, ffilterseq,  fcreatetime)  VALUES (?,?,?,?,?,  ?,?,?,?,?,  ?,?,?,?,?, ?)", this.getTableName());
        SqlParameter[] paramInsertEntry = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentitynumber", 12, (Object)this.dt.getName()), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fbillid", this.isStrPK() ? 12 : -5, pkValue), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, entryId), new SqlParameter("fseq_old", 4, (Object)(isNew ? 0 : seq)), new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fdata", 12, (Object)data), new SqlParameter("fdirtyflag", 12, (Object)dirtyFlag), new SqlParameter("fischanged", 1, (Object)(isChanged ? "1" : "0")), new SqlParameter("fisnew", 1, (Object)(isNew ? "1" : "0")), new SqlParameter("fisload", 1, (Object)(isNew ? "0" : "1")), new SqlParameter("fisbatch1", 1, (Object)(isBatch1 ? "1" : "0")), new SqlParameter("fisfilter", 1, (Object)(filterSql > 0 ? "1" : "0")), new SqlParameter("ffilterseq", 4, (Object)filterSql), new SqlParameter("fcreatetime", 91, (Object)currTime)};
        return new SqlAndParams(seqInsertEntry, paramInsertEntry);
    }

    private SqlAndParams buildSqlCopyEntry(ICollectionProperty entryProp, IDataEntityProperty pkProp, IDataEntityProperty entryIdProp, IDataEntityProperty seqProp, Object pkValue) {
        String sqlCopyEntry = String.format("INSERT INTO %s  (fpageid, fentitynumber, fentrykey, fbillid, fentryid, fseq_old, fseq, fcreatetime) SELECT '%s' as fpageid,  '%s' as fentitynumber,  '%s' as fentrykey,  %s as fbillid,  %s as fentryid,  %s as fseq_old,  %s as fseq,  NOW() as fcreatetime  from %s where %s = ? ", this.getTableName(), this.pageId, this.dt.getName(), entryProp.getName(), pkProp.getAlias(), entryIdProp.getAlias(), seqProp.getAlias(), seqProp.getAlias(), entryProp.getItemType().getAlias(), pkProp.getAlias());
        SqlParameter[] paramCopyEntry = new SqlParameter[]{new SqlParameter("fbillid", this.isStrPK() ? 12 : -5, pkValue)};
        return new SqlAndParams(sqlCopyEntry, paramCopyEntry);
    }

    private SqlAndParams buildSqlInitUpdateEntryRow(String entryKey, DynamicObject entryRow, IDataEntityProperty entryIdProp) {
        Object entityId = this.getPKValue(entryRow, entryIdProp, this.isStrPK());
        int seq = entryRow.getInt("seq");
        String data = this.serializerEntryRow(entryRow);
        String sqlUpdateRoot = String.format("UPDATE %s  SET fseq =?, fdata = ?, fdirtyflag = ?, fischanged = ?, fisload = ?, fisbatch1 = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
        SqlParameter[] paramUpdateRoot = new SqlParameter[]{new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fdata", 12, (Object)data), new SqlParameter("fdirtyflag", 12, (Object)"{}"), new SqlParameter("fischanged", 1, (Object)"0"), new SqlParameter("fisload", 1, (Object)"1"), new SqlParameter("fisbatch1", 1, (Object)"1"), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, entityId)};
        return new SqlAndParams(sqlUpdateRoot, paramUpdateRoot);
    }

    private SqlAndParams buildSqlUpdateEntryRow(String entryKey, DynamicObject entryRow, IDataEntityProperty entryIdProp, IDataEntityProperty seqProp, boolean changed) {
        Object entityId = this.getPKValue(entryRow, entryIdProp, this.isStrPK());
        int seq = entryRow.getInt("seq");
        String data = this.serializerEntryRow(entryRow);
        String dirtyFlag = this.getDirtyFlag(entryRow, entryIdProp, seqProp);
        boolean isNew = !entryRow.getDataEntityState().getFromDatabase();
        String sqlUpdateRoot = String.format("UPDATE %s  SET fseq =?, fdata = ?, fdirtyflag = ?, fischanged = ?, fisload = ?, fisnew = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
        SqlParameter[] paramUpdateRoot = new SqlParameter[]{new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fdata", 12, (Object)data), new SqlParameter("fdirtyflag", 12, (Object)dirtyFlag), new SqlParameter("fischanged", 1, (Object)(changed ? "1" : "0")), new SqlParameter("fisload", 1, (Object)"1"), new SqlParameter("fisnew", 1, (Object)(isNew ? "1" : "0")), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, entityId)};
        return new SqlAndParams(sqlUpdateRoot, paramUpdateRoot);
    }

    private String getDirtyFlag(DynamicObject entryRow, IDataEntityProperty pkProp, IDataEntityProperty seqProp) {
        BitSet set = BitSet.valueOf(entryRow.getDataEntityState().getDirtyFlags());
        set.set(pkProp.getOrdinal(), false);
        set.set(seqProp.getOrdinal(), false);
        return set.toString();
    }

    private List<SqlAndParams> buildSqlUpdateEntryRows(DynamicObjectCollection entryRows) {
        ArrayList<SqlAndParams> ret = new ArrayList<SqlAndParams>(8);
        DynamicObjectType entryType = entryRows.getDynamicObjectType();
        ISimpleProperty entryIdProp = entryType.getPrimaryKey();
        IDataEntityProperty seqProp = (IDataEntityProperty)entryType.getProperties().get((Object)"seq");
        String entryKey = entryType.getName();
        List<TableData> tableRows = this.readEntryTableData(entryKey);
        LinkedHashMap<Object, TableData> tableRowMap = new LinkedHashMap<Object, TableData>(tableRows.size());
        for (TableData tableData : tableRows) {
            if (tableData.isDeleted()) continue;
            tableRowMap.put(tableData.getEntryId(), tableData);
        }
        LinkedHashMap<Object, DynamicObject> entryRowMap = new LinkedHashMap<Object, DynamicObject>(entryRows.size());
        for (DynamicObject entryRow : entryRows) {
            entryRowMap.put(this.getPKValue(entryRow, (IDataEntityProperty)entryIdProp, this.isStrPK()), entryRow);
        }
        LinkedHashMap<Object, ArrayList<DynamicObject>> linkedHashMap = new LinkedHashMap<Object, ArrayList<DynamicObject>>(4);
        int addRowCount = 0;
        Object oid = "0";
        for (int i = entryRows.size() - 1; i >= 0; --i) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(i);
            Iterator pkValue = this.getPKValue(entryRow, (IDataEntityProperty)entryIdProp, this.isStrPK());
            if (tableRowMap.containsKey(pkValue)) {
                oid = pkValue;
                continue;
            }
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)linkedHashMap.get(oid);
            if (list == null) {
                list = new ArrayList<DynamicObject>(8);
                linkedHashMap.put(oid, list);
            }
            list.add(entryRow);
            ++addRowCount;
        }
        ArrayList delRows = new ArrayList(tableRowMap.size());
        ArrayList<Tuple> modifyRows = new ArrayList<Tuple>(tableRowMap.size());
        for (Map.Entry entry : tableRowMap.entrySet()) {
            DynamicObject entryRow = (DynamicObject)entryRowMap.get(entry.getKey());
            if (entryRow != null) {
                modifyRows.add(new Tuple((Object)entryRow, entry.getValue()));
                continue;
            }
            delRows.add(entry.getValue());
        }
        int[] delRowSeqs = new int[delRows.size()];
        ArrayList<Object[]> delRowParams = new ArrayList<Object[]>(delRows.size());
        for (int i = 0; i < delRows.size(); ++i) {
            delRowSeqs[i] = ((TableData)delRows.get(i)).getSeq();
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fisdel", 1, (Object)"1"), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fentryid", this.isStrPK() ? 12 : -5, ((TableData)delRows.get(i)).getEntryId())};
            delRowParams.add(params);
        }
        if (!delRowParams.isEmpty()) {
            String delRowSQL = String.format("UPDATE %s SET fisdel = ?  WHERE fpageid = ? and fentrykey = ? and fentryid = ?", this.getTableName());
            ret.add(new SqlAndParams(delRowSQL, delRowParams, true));
        }
        ArrayList<int[]> sortDelRowSeqs = ModelDataTable.getRemoveItems(delRowSeqs);
        for (int i = sortDelRowSeqs.size() - 1; i >= 0; --i) {
            int[] delBatch = (int[])sortDelRowSeqs.get(i);
            int startSeq = delBatch[0];
            int len = delBatch[1];
            String delSeqSql = String.format("UPDATE %s  SET fseq = fseq - ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ?", this.getTableName());
            SqlParameter[] delSeqParams = new SqlParameter[]{new SqlParameter("LEN", 4, (Object)len), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq", 4, (Object)(startSeq + len))};
            ret.add(new SqlAndParams(delSeqSql, delSeqParams));
            for (TableData tableData : tableRows) {
                tableData.delRows(startSeq, len);
            }
        }
        DynamicObject root = entryRows.getRootEntity();
        Date currTime = KDDateUtils.now();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (StringUtils.equals((CharSequence)"0", (CharSequence)entry.getKey().toString())) continue;
            TableData tableData = (TableData)tableRowMap.get(entry.getKey());
            int startSeq = tableData.getSeq();
            int len = ((List)entry.getValue()).size();
            String addSeqSql = String.format("UPDATE %s  SET fseq = fseq + ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? ", this.getTableName());
            SqlParameter[] addSeqParams = new SqlParameter[]{new SqlParameter("LEN", 4, (Object)len), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq", 4, (Object)startSeq)};
            ret.add(new SqlAndParams(addSeqSql, addSeqParams));
            for (TableData tableRow : tableRows) {
                tableRow.insertRows(startSeq, len);
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            int startSeq = 0;
            List list = (List)entry.getValue();
            if (StringUtils.equals((CharSequence)"0", (CharSequence)entry.getKey().toString())) {
                startSeq = this.readEntryRowCount(entryKey) - delRows.size() + addRowCount - list.size() + 1;
            } else {
                TableData tableData = (TableData)tableRowMap.get(entry.getKey());
                int len = ((List)entry.getValue()).size();
                startSeq = tableData.getSeq() - len;
            }
            String addRowSql = null;
            ArrayList<Object[]> addRowParams = new ArrayList<Object[]>(list.size());
            int addLen = 0;
            for (int i = list.size(); i > 0; --i) {
                DynamicObject entryRow = (DynamicObject)list.get(i - 1);
                entryRow.set("seq", (Object)(startSeq + addLen));
                SqlAndParams insertRowSql = this.buildSqlInsertEntryRow(entryKey, entryRow, (IDataEntityProperty)entryIdProp, seqProp, true, false, 0, currTime);
                addRowSql = insertRowSql.getSql();
                addRowParams.add(insertRowSql.getExecuteParams());
                ++addLen;
            }
            if (addRowParams.isEmpty()) continue;
            ret.add(new SqlAndParams(addRowSql, addRowParams, true));
        }
        String updateRowSQL = null;
        ArrayList<Object[]> updateRowParams = new ArrayList<Object[]>(modifyRows.size());
        for (Tuple item : modifyRows) {
            TableData tableData;
            DynamicObject modifyRow = (DynamicObject)item.item1;
            tableData = (TableData)item.item2;
            if (!tableData.isChanged() && !ModelDataTable.isEntryRowChanged(modifyRow, seqProp)) continue;
            modifyRow.set("seq", (Object)((TableData)item.item2).getSeq());
            SqlAndParams updateSql = this.buildSqlUpdateEntryRow(entryKey, modifyRow, (IDataEntityProperty)entryIdProp, seqProp, true);
            updateRowSQL = updateSql.getSql();
            updateRowParams.add(updateSql.getExecuteParams());
        }
        if (!updateRowParams.isEmpty()) {
            ret.add(new SqlAndParams(updateRowSQL, updateRowParams, true));
        }
        return ret;
    }

    private List<SqlAndParams> buildSqlResetEntry(DynamicObjectCollection entryRows) {
        ArrayList<SqlAndParams> ret = new ArrayList<SqlAndParams>(2);
        DynamicObjectType entryType = entryRows.getDynamicObjectType();
        ISimpleProperty entryIdProp = entryType.getPrimaryKey();
        IDataEntityProperty seqProp = (IDataEntityProperty)entryType.getProperties().get((Object)"seq");
        String entryKey = entryType.getName();
        boolean entryIdIsStr = entryIdProp instanceof VarcharProp;
        String delEntrySQL = String.format("DELETE FROM %s where fpageid = ? and fentrykey = ? ", this.getTableName());
        SqlParameter[] delEntryParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey)};
        ret.add(new SqlAndParams(delEntrySQL, delEntryParams));
        DynamicObject root = entryRows.getRootEntity();
        Date currTime = KDDateUtils.now();
        String addRowSql = null;
        ArrayList<Object[]> addRowParams = new ArrayList<Object[]>(entryRows.size());
        int seq = 1;
        for (DynamicObject entryRow : entryRows) {
            entryRow.set("seq", (Object)seq);
            SqlAndParams insertRowSql = this.buildSqlInsertEntryRow(entryKey, entryRow, (IDataEntityProperty)entryIdProp, seqProp, true, true, 0, currTime);
            addRowSql = insertRowSql.getSql();
            addRowParams.add(insertRowSql.getExecuteParams());
            ++seq;
        }
        if (!addRowParams.isEmpty()) {
            ret.add(new SqlAndParams(addRowSql, addRowParams, true));
        }
        return ret;
    }

    private List<SqlAndParams> buildSqlDelEntryRows(String entryKey, int row, int len) {
        ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(2);
        String delEntrySql = String.format("UPDATE %s SET fisdel = ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ? and fseq < ?", this.getTableName());
        SqlParameter[] delEntryParams = new SqlParameter[]{new SqlParameter("fisdel", 1, (Object)"1"), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq1", 4, (Object)(row + 1)), new SqlParameter("fseq2", 4, (Object)(row + len + 1))};
        sqlList.add(new SqlAndParams(delEntrySql, delEntryParams));
        String upSeqSql = String.format("UPDATE %s  SET fseq = fseq - ?  WHERE fpageid = ? and fentrykey = ? and fseq >= ?", this.getTableName());
        SqlParameter[] upSeqParams = new SqlParameter[]{new SqlParameter("fseq1", 4, (Object)len), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq2", 4, (Object)(row + len + 1))};
        sqlList.add(new SqlAndParams(upSeqSql, upSeqParams));
        return sqlList;
    }

    private List<SqlAndParams> buildDelUpdateFilterSeq(String entryKey, int rowIndex, int len) {
        int[] rows = new int[len];
        for (int i = 0; i < len; ++i) {
            rows[i] = rowIndex + i;
        }
        return this.buildDelUpdateFilterSeq(entryKey, rows);
    }

    private List<SqlAndParams> buildDelUpdateFilterSeq(String entryKey, int[] delRows) {
        if (delRows == null || delRows.length == 0 || this.readFilterEntryRowCount(entryKey) == 0) {
            return new ArrayList<SqlAndParams>(0);
        }
        List<Integer> delFilterSeqs = this.readFilterSeqByRowKeys(entryKey, delRows);
        if (delFilterSeqs.isEmpty()) {
            return new ArrayList<SqlAndParams>(0);
        }
        ArrayList<int[]> sortDelFilterSeqs = ModelDataTable.getRemoveItems(delFilterSeqs);
        ArrayList<SqlAndParams> sqlList = new ArrayList<SqlAndParams>(sortDelFilterSeqs.size());
        for (int i = sortDelFilterSeqs.size() - 1; i >= 0; --i) {
            int startSeq = ((int[])sortDelFilterSeqs.get(i))[0];
            int len = ((int[])sortDelFilterSeqs.get(i))[1];
            String upSeqSql = String.format("UPDATE %s  SET ffilterseq = ffilterseq + ?  WHERE fpageid = ? and fentrykey = ? and ffilterseq >= ? ", this.getTableName());
            SqlParameter[] upSeqParams = new SqlParameter[]{new SqlParameter("fseq1", 4, (Object)(-1 * len)), new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fseq2", 4, (Object)(startSeq + len))};
            sqlList.add(new SqlAndParams(upSeqSql, upSeqParams));
        }
        return sqlList;
    }

    private List<TableData> readEntryTableData(String entryKey) {
        String sql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and (fisbatch1 = ? or fischanged = ? or fisnew = ? or fisdel = ?)  ORDER BY fseq asc", this.getTableName());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisbatch1", 1, (Object)"1"), new SqlParameter("fischanged", 1, (Object)"1"), new SqlParameter("fisnew", 1, (Object)"1"), new SqlParameter("fisdel", 1, (Object)"1")};
        return this.readEntryTableData(sql, params);
    }

    private List<TableData> readChangedTableData(String entryKey, EntryQueryParser parser) {
        String sql = String.format("SELECT fentryid, fseq, fdata, fisbatch1, fischanged, fisnew, fisdel  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fischanged = ?  ORDER BY fseq asc", this.getTableName());
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 1, (Object)"0"), new SqlParameter("fischanged", 1, (Object)"1")};
        return this.readEntryTableData(sql, params);
    }

    private List<TableData> readEntryTableData(String sql, SqlParameter[] params) {
        return (List)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<TableData>>(){

            public List<TableData> handle(ResultSet resultSet) throws Exception {
                ArrayList<TableData> list = new ArrayList<TableData>(10);
                while (resultSet.next()) {
                    Object entryId = ModelDataTable.this.isStrPK() ? resultSet.getString(1) : Long.valueOf(resultSet.getLong(1));
                    int seq = resultSet.getInt("fseq");
                    String data = resultSet.getString("fdata");
                    boolean isBatch1 = resultSet.getBoolean("fisbatch1");
                    boolean isChanged = resultSet.getBoolean("fischanged");
                    boolean isNew = resultSet.getBoolean("fisnew");
                    boolean isDel = resultSet.getBoolean("fisdel");
                    list.add(new TableData(entryId, seq, data, isBatch1, isChanged, isNew, isDel));
                }
                return list;
            }
        });
    }

    private int readFilterSeq(String entryKey, int rowIndex) {
        String selectSql = String.format("SELECT ffilterseq  FROM %s  WHERE fpageid = ? and fentrykey = ? and fisdel = ? and fseq = ? ", this.getTableName());
        Object[] selectParams = new SqlParameter[]{new SqlParameter("fpageid", 12, (Object)this.pageId), new SqlParameter("fentrykey", 12, (Object)entryKey), new SqlParameter("fisdel", 12, (Object)"0"), new SqlParameter("ffilterseq", 4, (Object)(rowIndex + 1))};
        return (Integer)DB.query((DBRoute)new DBRoute(this.dt.getDBRouteKey()), (String)selectSql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getInt(1);
                }
                return 0;
            }
        });
    }

    private Object getPKValue(DynamicObject dataEntity, IDataEntityProperty pkProp, boolean pkIsStr) {
        Object pkValue = dataEntity.getPkValue();
        if (this.isEmptyPK(pkValue)) {
            if (pkProp == null) {
                if (pkIsStr) {
                    return String.valueOf(dataEntity.getDataEntityState().getInstanceId());
                }
                return dataEntity.getDataEntityState().getInstanceId();
            }
            pkValue = pkIsStr ? DB.genStringId((String)"") : Long.valueOf(DB.genGlobalLongId());
            pkProp.setValue((Object)dataEntity, pkValue);
            return pkValue;
        }
        return pkValue;
    }

    private boolean isEmptyPK(Object pkValue) {
        if (pkValue == null) {
            return true;
        }
        String str = pkValue.toString();
        return StringUtils.isBlank((CharSequence)str) || "0".equals(str);
    }

    protected static boolean isEntryRowChanged(DynamicObject rowDataEntity, IDataEntityProperty seqProp) {
        if (rowDataEntity.getLastDirty().length() > 0) {
            if (seqProp == null) {
                return true;
            }
            BitSet set = rowDataEntity.getLastDirty();
            set.set(seqProp.getOrdinal(), false);
            if (set.length() > 0) {
                return true;
            }
        }
        if (rowDataEntity.getDataEntityState().getRemovedItems() != null && rowDataEntity.getDataEntityState().getRemovedItems().booleanValue()) {
            return true;
        }
        IDataEntityType entryType = rowDataEntity.getDataEntityType();
        for (ICollectionProperty prop : entryType.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)rowDataEntity);
            for (DynamicObject row : cols) {
                if (!ModelDataTable.isEntryRowChanged(row, null)) continue;
                return true;
            }
        }
        return false;
    }

    protected static ArrayList<int[]> getRemoveItems(List<Integer> rowIndices) {
        int[] rows = new int[rowIndices.size()];
        for (int i = 0; i < rowIndices.size(); ++i) {
            rows[i] = rowIndices.get(i);
        }
        return ModelDataTable.getRemoveItems(rows);
    }

    protected static ArrayList<int[]> getRemoveItems(int[] rowIndices) {
        if (rowIndices == null || rowIndices.length == 0) {
            return new ArrayList<int[]>(0);
        }
        int[] sortedrows = Arrays.copyOf(rowIndices, rowIndices.length);
        ArrayList<int[]> ret = new ArrayList<int[]>();
        Arrays.sort(sortedrows);
        int index = 0;
        do {
            int first;
            int[] removeitem = new int[2];
            removeitem[0] = sortedrows[index];
            int count = 0;
            do {
                ++count;
                first = sortedrows[index];
            } while (++index < sortedrows.length && sortedrows[index] <= first + 1);
            removeitem[1] = count;
            ret.add(removeitem);
        } while (index < sortedrows.length);
        return ret;
    }

    static boolean isSplitPage(DynamicObject root, String entryKey) {
        EntryInfo entryInfo = root.getDataEntityState().getEntryInfo(entryKey);
        if (entryInfo == null) {
            return false;
        }
        if (entryInfo.getRowCount() == null) {
            return false;
        }
        return entryInfo.getRowCount() > entryInfo.getPageSize();
    }

    private boolean isStrPK() {
        if (this.pkIsStr == null) {
            this.pkIsStr = this.dt.getPrimaryKey() instanceof VarcharProp;
        }
        return this.pkIsStr;
    }

    private DataEntitySerializerOption getRootOption() {
        if (this.rootOption == null) {
            this.rootOption = new DataEntitySerializerOption();
            this.rootOption.setIncludeComplexProperty(false);
            this.rootOption.setIncludeCollectionProperty(false);
            this.rootOption.setIncludeDataEntityState(true);
            this.rootOption.setDataEntityBinder(new IDataEntityBinder(){

                public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                    if (prop instanceof DynamicLocaleProperty) {
                        return true;
                    }
                    if (prop instanceof MulBasedataProp) {
                        return true;
                    }
                    return super.isSerializProperty(prop, option);
                }
            });
        }
        return this.rootOption;
    }

    private DataEntitySerializerOption getEntryOption() {
        if (this.entryOption == null) {
            this.entryOption = new DataEntitySerializerOption();
            this.entryOption.setIncludeComplexProperty(false);
            this.entryOption.setIncludeCollectionProperty(true);
            this.entryOption.setIncludeDataEntityState(true);
        }
        return this.entryOption;
    }

    private String serializerEntryRow(DynamicObject entryRow) {
        ArrayList<DynamicObject> cols = new ArrayList<DynamicObject>(1);
        cols.add(entryRow);
        return DataEntitySerializer.serializerToListString((IDataEntityType)entryRow.getDataEntityType(), cols, (DataEntitySerializerOption)this.getEntryOption())[0];
    }

    public static class EntryQueryParser {
        private MainEntityType dt;
        private EntryQueryParam entryQueryParam;
        private int top = 100000;
        private List<TCacheSortField> sortFields = new ArrayList<TCacheSortField>(1);
        private QFilter qFilter;
        private String formula;

        public EntryQueryParser(MainEntityType dt, EntryQueryParam entryQueryParam) {
            this.dt = dt;
            this.entryQueryParam = entryQueryParam;
        }

        public void parse() {
            List entrySortItems;
            if (this.dt == null || this.entryQueryParam == null) {
                return;
            }
            FilterBuilder builder = new FilterBuilder(this.dt, this.entryQueryParam.buildFilterCondition());
            String[] filterScripts = builder.buildFilterScript();
            this.formula = filterScripts[0];
            if (StringUtils.isNotBlank((CharSequence)this.formula)) {
                builder.buildFilter();
                this.qFilter = builder.getQFilter();
            }
            if (!CollectionUtils.isEmpty((Collection)(entrySortItems = this.entryQueryParam.getSortItems()))) {
                for (int i = 0; i < 3 && i < entrySortItems.size(); ++i) {
                    EntrySortItemInfo sortItemInfo = (EntrySortItemInfo)entrySortItems.get(i);
                    String fieldKey = sortItemInfo.getSortColumnName();
                    if (StringUtils.isNotBlank((CharSequence)sortItemInfo.getRealFieldName())) {
                        fieldKey = sortItemInfo.getRealFieldName();
                    } else if (sortItemInfo.getDisplayProps() != null && sortItemInfo.getDisplayProps().length > 0) {
                        fieldKey = fieldKey + "." + sortItemInfo.getDisplayProps()[0];
                    }
                    TCacheSortField sortField = TCacheSortField.create(this.dt, fieldKey);
                    sortField.setSeq(i + 1);
                    boolean isAsc = sortItemInfo.getSortStyle() == 1;
                    sortField.setOrder(isAsc ? "ASC" : "DESC");
                    this.sortFields.add(sortField);
                }
            }
        }

        public QFilter getQFilter() {
            return this.qFilter;
        }

        public String getFormula() {
            return this.formula;
        }

        public List<TCacheSortField> getSortFields() {
            return this.sortFields;
        }

        public String getOrderByDbTable() {
            if (this.sortFields.isEmpty()) {
                return "";
            }
            ArrayList<String> fields = new ArrayList<String>(this.sortFields.size());
            for (TCacheSortField sortField : this.sortFields) {
                fields.add(sortField.getFullFieldKey() + " " + sortField.getOrder());
            }
            return StringUtils.join((Object[])fields.toArray(), (String)", ");
        }

        public String getOrderByTampTable() {
            if (this.sortFields.isEmpty()) {
                return "";
            }
            ArrayList<String> fields = new ArrayList<String>(this.sortFields.size());
            for (TCacheSortField sortField : this.sortFields) {
                fields.add(sortField.getFieldName() + " " + sortField.getOrder());
            }
            return StringUtils.join((Object[])fields.toArray(), (String)", ");
        }

        public String getOrderFields() {
            if (this.sortFields.isEmpty()) {
                return "";
            }
            ArrayList<String> fields = new ArrayList<String>(this.sortFields.size());
            for (TCacheSortField sortField : this.sortFields) {
                fields.add(sortField.getFullFieldKey());
            }
            return StringUtils.join((Object[])fields.toArray(), (String)", ");
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int getTop() {
            return this.top;
        }
    }

    public static class SqlAndParams {
        private String sql;
        private SqlParameter[] executeParams;
        private List<Object[]> batchExecuteParams;

        public SqlAndParams(String sql, SqlParameter[] executeParams) {
            this.sql = sql;
            this.executeParams = executeParams;
        }

        public SqlAndParams(String sql, List<Object[]> batchExecuteParams, boolean isBatch) {
            if (!isBatch) {
                throw new IllegalArgumentException("is batch must be true");
            }
            this.sql = sql;
            this.batchExecuteParams = batchExecuteParams;
        }

        public String getSql() {
            return this.sql;
        }

        public SqlParameter[] getExecuteParams() {
            return this.executeParams;
        }

        public List<Object[]> getBatchExecuteParams() {
            return this.batchExecuteParams;
        }

        public void execute(DBRoute dbRoute) {
            if (this.batchExecuteParams == null) {
                if (StringUtils.isNotBlank((CharSequence)this.sql)) {
                    DB.execute((DBRoute)dbRoute, (String)this.sql, (Object[])this.executeParams);
                }
            } else {
                DB.executeBatch((DBRoute)dbRoute, (String)this.sql, this.batchExecuteParams);
            }
        }

        public String toString() {
            return this.sql;
        }
    }

    public static class TableData {
        private Object entryId;
        private int seq;
        private String data;
        private boolean batch1;
        private boolean changed;
        private boolean deleted;
        private boolean added;

        public TableData(Object entryId, int seq, String data, boolean batch1, boolean changed, boolean added, boolean deleted) {
            this.entryId = entryId;
            this.seq = seq;
            this.data = data;
            this.batch1 = batch1;
            this.changed = changed;
            this.added = added;
            this.deleted = deleted;
        }

        public Object getEntryId() {
            return this.entryId;
        }

        public int getSeq() {
            return this.seq;
        }

        public void insertRows(int startSeq, int len) {
            if (this.seq >= startSeq) {
                this.seq += len;
            }
        }

        public void delRows(int startSeq, int len) {
            if (this.seq >= startSeq) {
                this.seq -= len;
            }
        }

        public String getData() {
            return this.data;
        }

        public boolean isBatch1() {
            return this.batch1;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isAdded() {
            return this.added;
        }
    }
}

